/**
 *	@file e:\my-projects\UberLame_src\gpgpu\kernels\\SegScanReduceSrc.h
 *	@brief file in header, generated from 'e:\my-projects\UberLame_src\gpgpu\kernels\SegScanReduce.c'
 *		using BWT / RLE / Huff / Base85 pipe
 *	@date 2016-07-19 07:41:51
 *	@author FileToHeader v2.03 (built Jun 30 2016)
 */

#pragma once
#ifndef __E__MY_PROJECTS_UBERLAME_SRC_GPGPU_KERNELS_SEGSCANREDUCE_C_FILE_IN_HEADER_INCLUDED
#define __E__MY_PROJECTS_UBERLAME_SRC_GPGPU_KERNELS_SEGSCANREDUCE_C_FILE_IN_HEADER_INCLUDED

/**
 *	@brief file in header, generated from 'e:\my-projects\UberLame_src\gpgpu\kernels\SegScanReduce.c'
 */
class CSegScanReduce {
public:
	/**
	 *	@brief gets size of the data
	 *	@return Returns size of the data, in bytes, not including the terminating zero.
	 */
	static inline size_t n_Size()
	{
		return 138070; // original file 304073 B
	}

	/**
	 *	@brief determines whether the stored string is dynamically allocated
	 *	@return Returns true if the caller of p_Data() needs to free the memory.
	 */
	static inline bool b_Dynamic()
	{
		return true;
	}

	/**
	 *	@brief gets CRC
	 *	@return Returns CRC32 of the stored data.
	 *	@note The stored CRC may differ from the original file if data processing was enabled.
	 */
	static inline uint32_t n_CRC32()
	{
		return 0x4ab3ff30; // original file 0x95b3dcb3
	}

	/**
	 *	@brief gets data
	 *
	 *	@return Returns data of the file on success, 0 on failure (not enough memory).
	 *
	 *	@note The data (despite it may be binary), is additionally null terminated to make
	 *		it easier to use (the terminating null is not counted in n_Size()).
	 *	@note See also b_Dynamic().
	 */
	static inline char *p_Data()
	{
		const char *p_s_base85 = "0RR91~0RR910RR910{{R31ONa41^@s63;+NC4*&oF3;+NC5C8xGA^-pY8~^|S6aWA"
			"K5&!@I3;+NC009C81Oo{M2M7%d3K0(s{|*%s7Z4c|B@,VS7B3$yAs8AbDKR-UBOEIt9y1^$H$6KhLnuc<OHoBX"
			"EKM*;DpyZcE>mrJS#@)7GFz9aUuAufcRoB_afO>_V,-m2I%}guID0gi(Ncf0)nSXL#X_^,$xJqZxkgTdRGrzYN"
			"Rzd<UcI4@eo%PVt>v%xSlx-|mF@4x%gt6=XmE1lbar}tzwz_+js0x9!(7vDYTM!8rTP1><lFh||4f.|QziY$W|"
			"Kye=,vKE>XU19gqzt*s=A%Di66N.a(UH>wa4rb&cy0gCi5CHmR2XR%YqVQ&MLZ<C!NNj6N8LGPR4jA%BxQiRww"
			"N*6V$#Fol<$#Q|qdxiu{SSRWxpp(r;JZnky6ZTfXcnSeshH^YvAn.lF^CiLqFp13gLWSE_AmXx%oeIbv*d#6&W"
			"j%96^&>R10MwOP#@q9oqW^>xo5#=jKtFSlB<u{)cnjWV9KehK.3(qyhO%FlL1dDV%Mw3{2GB=M{L,fZBpR_V2#"
			"B3PfW&Zbh;qjqrHHX7tj>)LCRjLK1_)#|3jRI>Dza@2^aW|GU=V<${Vkv15}uTrl*HovbL&+ItfD)OxDs.oOTH"
			"fOx9;#ivr%+DgSD{FLRDz}qDZzlCp(;{R{ipZSGsb+e{EKL=O<8GM2ix{yyjbc@GH&qh1lg9GYrp(x4CXD6P&h"
			"3zpiT4$(-mFhrzxB_w<8$.*,aH3$FBLH.OFy|Hv5JiFVm8%T7>bM9*p{kZ*4kpq+ii-@Wczujk(c->i4h,eT3D"
			"WvS<.|dSy;01Svq2AO8fQlm11O15jK-)@^5*$YTR*(RE%QP(}posCA|u~;7*3Pi_cQ3c.@Jtj+qLSo+4RNZ6}P"
			"M)p3&%Q+YYpiM@O)da7Aca}y$Ld1uO17=+kO.<^vsp*;.,jnt&cSeh*<Imyh@YDCdedfxSwN>UV5TCDhG.!skh"
			"c)g2CwCr-#s!B|WVrcD<<8};Kn-vzH2_i&7M97&Hky#ayJm>EICmqHOe|gicpXa*-,c5{UcC{aKr-QfaC-pw(J"
			"$*L%y8ZS0zUP},JUH{&.@Hf_nB~d0j>_46n%RET(Z_R~m9_R_b5$gAro=Gio%Y5}XDuzUSe8}slcy4r62$Q}%^"
			"2@r5@h&fBtnfz-p,x0HaBpbBZZr(IAbk,F2(q#F<V,{P1I2|XHi-;sFktX6sc5,$Z_CIl_x=c>XVtB63r$}(z^"
			"Ne$H-^EmL~^nL};qz-gqqC{#;Z3N%#-)SexCwY>sU5NzBiI%fQ8)x)GYJTgFVD*i=sT7)$Ip{ss0,_m$~+sS>4"
			"KQdh=f_7%;4)i1ooiQ^}znKirn3b9!eu*Xp{UpfB0<la}vPYE<@a;1%JFOwe,t(UL&>*8m)o$Tzi=vH&{7vi5g"
			"kHYXf+}3gMFv*>awwY+wFviyyNS(^W*w(8G=s9d(!b=mv*7Rb=Ihx@r|7le+Yf!5**xOr7aBIghwx9byD4wGE6"
			"3q0&9R*m$iM6c~Z7al8iK976$gaY&d3>=*w7wN$wkl)BPGV$Cp8Sc767eGWFLd6n+51K~FB59,SCO2FW^q-pt1"
			"8|MnZs.IcTCx;%igAiS*;|#MtT)v9),PDRh|r(#F%1frHj~,7tM|iIB2BFx+F~(k!fa<t!o&_$Dp.{JKL%fY+l"
			"K<nHb(*BKbTRa;GbnoF$({((BUkW~xe7!&.<%SjNXL40iFXd}aF#Shmu#CQRdvwiV=5#hJ=Y3BZ{uTf|Og=%X1"
			"GXO^+1.Kf,EH%zW)gN-xAb=4C>XitG$^LfXeyF@C.@y4-ZTN7!Wm5pra!pj$#FMfLT7O^bt!!$;d8w=UsnXXGB"
			"+|P.+V,F0M+jKW8YWGjPsXNt_,{nG<2VI%NhD~J.Vx-_p6D4AH6Czoi63UZ;_+rfHnlCC.uHtx=Cqks^XE2#Fq"
			"O8t}(3V~$oN!dC$yF.I{AMyL#dw*@i%iKo%KDAg@I8&zal,ntrh8uZ!uh^q,iCETPuc(9U;5ww7A23>vhg~MZG"
			"V=WC+Ykx$.&_r_uW@_zg{W5KkJ1@!+mj_cKt,U{#|!pT,MbJEAFj)ZaEuC%uWRACy<;T4d-.q)||1za-l@tWAV"
			"7c8Dy;IknQoEoeh63MCVk#_O!3f#*&REzL1e3M|OEDqZTEZ$5hE*l,N.;ZrR&ercC+MXXl@1Bfqg&t2txye=$s"
			"CP46%MrQZLA_!&Mgi%H<a_8*<y#L+exa3=-!,!;QS*={A6Gi+0a*1uWH{,dR;_%T^%&gqX)Ior8gy=&O%=6u#F"
			"AGz$<(m2&fwPfSUeveyS4ci>LB;&=72R_DdmTRgi#(P=vw%;QbEu(iT7|@nq3~+IpD6gejODid3K4NV%-dCKSh"
			"V0iZVp)C(&Rfo7(p8t@n_dkXWT$~jv8KX#+2mHztgKc=SeZ9qrEDic^X%}+QhJ%l@Y!8{%QNhI-cJjTc+Nby^c"
			"vZCy@_MH#8(5)*iXPu6F8H-yUb>*Glb}84;7;P<~S0{<ENnP(SQC4;a;CLkAEdrIhof7PD}j@Syg<O*4kOE.pD"
			"R=EKX-Fo12=;7_pU$+3#f-!ZpRMf5MGydVfIIdi(YJzO#Nu{{9T;oaI.n.&x{AV+P~y_&Qs=a#gWsEQz)&VJvy"
			"<yjQKuayCp^TV<NbhnCNZ.Oh)%m|IoUY2h)Vs{9+dd*3x~@wL(5Y_VB4XoTS72uzM!I(<K-yK&h1GBMuQ9|=}e"
			"nKi,~*v.|6$4o}bRP0w|{iW=-N70h^PR6.2-_F-Jq4staky$EbW%R__y!s,LEKLfsq{&kjRF+#CT{b2cV#YWtb"
			"-9Y_Es;Eq-YHg6_Gv$;WV<!kFv2jxjMXlYhB0+y-KLB!>vhVp6(y-MRGSIh*9<FRSrujTR@3g;dP^%zS.|K~Qt"
			"K{pvaO9C_Gz)dRgl$EtWD(ae{)=B!jdkCy<JPL!uQQ>9$959g_B0SRK1zuop5K1JpQ*Hv)oUxuPV~Vip5#2Q8H"
			"^DCRR3Nt9iDa**N}D)l6AmH1#h}i<tB8CdRy9GT)-(p,mLzafwaR,7al<JH*J{V-_b-rj2rmI+d<Ixm*owzr5Y"
			"ly*&Hb.RhPd{5E,6d8;NJICxaomxB0W%k}c(gLk20ZJfO<w>LLgo*kNOU$r@#qdIG2j*c|T6xPN3iqdRru}a.K"
			".TuKR3)trWGOBwCz|SWv)T2y}YZG}p3C!)gueQc!>lW~vye7UC^5x@WUZZC+{8q@ujyxsIyL=|ODyEC,ro&~P4"
			"K#L;&21OWGHV!Bj$1FLS=qZ)vr8+NKBl*,J+.L2V@A3{aBEkUHZ$!fx!20&fAZYEb!KyOWsc3},!nKc@~@M1ju"
			"|-M++VQI*ki=KmF_F*xZ)-snUg&^r1w3&u_7Ww(<Z!pyLM@2ab31nn&j)*n.np=se7}s@qS|-m$#jKf9(8p>2R"
			"qy.Ov6mY%M7)yiJEMLp^zB-s2q3HFgtAJ9.C&%X8UWdF=V4<|k.VIbq^Yp)<)-eTmN2wW%#tC90&gXC+HLx~i5"
			">d5Vc=ZISO!Wm!LYo-ZcD$7bqt%x96Uiu#S%.A2Lz8RWgw@><yYcF^nay5jl1jLQ4wxfroOMX#FpTPH8@Z&9{n"
			"Yw2~{QoYk$v*$7J8TelfW{D1%m%92hg.w(G+0%=p<>tzM5+u5mh=_#It^CPv8v19BdQJs-8>,Rm-8b!LpKDEp^"
			"n3iMe.2-(L|S}F>^7gQ,4T^!CQewJ)UB(;$.ta_W0jq*u.s@eaw1u2(ujnz@m5~=y{qDimrAu=buO(7Xtd1}BK"
			"=Fm.0Ih}iJCLWztk&%eg%Cbv04*@TiQzJG0fM>^D@b;qD>sOjSS|CP1ul,6VSA=EUBf5+,W@)I!R}iB_SnAV-{"
			";FCQHmTo@!E5Dn(g(Ri;lgLa).&3drc}JibC%e3fNMV,lQSanBcX+2onpRMDJA33Qr0,4VS.SVZ~W49i0Qboh6"
			"={rygqX{UPnro+XdH.,Y>,,7qq+3GqhzrOhFYvXI~)=KdzrqxvT6Y^T*^0..t6|!wrbA0Er#.HpN@YR0Cd#P;="
			"o)d3{RbQmz9tjhA@iJ=>@cIl,^8ZPn{0GDO2eafQmy1}>YW;27%=eotzSaLxy9n>kLce)fT5Tpo{w8pr,4{F.o"
			"y6Msx_ol_%FdxFdCiVxURe75i^jbN4x^UK_OIbD&|j#YvaC-TSu6foqW&z_tkr3vu~|GAHtZzE,M}S@&&;aY-N"
			")K^t0i9gJ+dTI%M%P_yiS7_UM7xTG=#=9Ya&dU$gLkVSH$SfrM6*v)VkI)vh.v<Z82jObjFT{yv9zSf+8fdw@p"
			";78nI>X=I*iaS.#|=O2yp$%a+mic9Bk1l+k7swVK.M<5ZnbHl$MvSuMexiOx$eo$X^5GuqDaZlfMWO0iqb+ex)"
			"jZ!wWFFU;0jZp$Z48ZtOou5%j>orLtY+YR2bSepyzR,VNMr&kiZMDJ@GQqO+u-6~QpwXE}LEVRzAiqB.$8ElE+"
			"Cy=*<+hVjQoS!+17_&Q>SjLUks#@6<w3|w.RwapIY$b_i=!EQUq$guLVU>wx.wlNFT~z$5XudHvwar=L#cVUPS"
			"Y2!@X}cnN-Fm-;qa4qRdCz07xW4jO<*{7H9tO)Dy@$<_=I<}#UfI_L_Bdo$VdCs2!qz55ZzsrOnOl4r6=NAQ;F"
			"ai<n;PO4^%>d5<R=1bRw~5U*BFwvo9s@fZPL<Sv(FZu;@;x^wda;_IPfO|c@_3~cbZwQlT_eN4E)Tm*yDE$EuW"
			"2@ti6e6Z4{!<CWgxxvi{e8hITvbyjIq+O3=@t*K<<D(aR0WS8}AXr1l)X<yC%~w&T)POUdzgU3l>(wKn@FiLZ!"
			"~#M-TEV)tkD9,)f>6pZFqTEw!X.<Un+wyT>P*RprBhr{^_m-$s,,D)gGXvLcIT%I<*7QFjDp{Fs,!OM}S8ciA9"
			"CdW)6P8,mjlw$Rs+>J6-r$arZS)D6Sjo,!RELkViF=A+2c|MkQ#I5hch5jhQMJkmdO065B6GIkfDUGFMPQ_y%J"
			"3CUoq4Q+j9}mo~#&r2@W_H8L%;~4a%Jcf<{nC4tCqr2HU-H.UNoA)LLr;L&kvJ2X#~eOeH}rU#+8FLSI5Y4&=Q"
			"+D!jEU4&_LsW<OFrX|z;tjY)F%Z_UZQ<2Fok60s6xN0S9xD(nG.L3D,ezyIUJ7lfBetdFaGDZ@S*M@4to,oI8V"
			"f>K5}g*={U%Q{et-~qQ7vf6DEF-XLioUc&uO2zTKPcUi+F.%jW2#Pp|JBHj,qeELTCE_4g)=#L)JAB=29qzQ-+"
			"PnY}E&sqi@czsvP{i|jJm_<!TohO7Kvg.v6LuEl38){NzzY(of,iCfo+!LR.BMW#=O!La,ZvZUqZh|.#%xu^WO"
			"b3<k2R68;>$-0a6<0lzdVJyyP,rSGk_$qXI6,bch-@4r.qJ9HS=U>2cdXA3u^G~$APq5N.$<#{{#Io@$)*@J&4"
			"J^Lg>d$@|BUs9gY<NueuUoOOo)+uY;;iNPQyNCLIN6@!-&x..Sn#$QWWKFC9k-s{^<NcM{(P0|-K1-5,fA%<Gp"
			"1!@_%d;hlvalfju|&y*7IeP,F!4O{Vu=P*^Eo#,{{&vc$7;s_({}b@vn}0=WfSKrERS0m1i2HiSm;ovMpkEJ.#"
			"tHT2ZCm1^W0FvtJi~RK=IVWW6TUVziyKWjm>R)tdEKt2$&M-#3=D<A;,t;7<~_Yt-rby%FQg&uKOjdycIb$F{~"
			"SV#L^Q>UnO$F-kh@W5(U9B516wk$)MM^-A{|S)56{.Xy0*b@#lsQ#C5NdH%<Ror,@fcpIzGV.t=o6PbEXyu40="
			"Z72VCg9_!tyCWIoTb<yGD3K<QHN5@_;5^d^woaU@RHW9<I@S@()al$*nzhM%{94%4fjuuZ;i42z22S4*<~O4G7"
			"Ra|U^qkJP_qpbhH+^GE8rYjz,&w&a)+)wUYa(MOTy=P&7U+CEhGuCU<,Tv%Y0l0.ye)b6%kSXb(@pIC4mp^OJc"
			"n(IS;r+UmGqq,Lm0BVairpgFw$zw^L.jJUz&@rEamRiO>$at.Ug&FV@lWgC)fR*HZ!!m$yb>^jN=*CelmPlX{E"
			"HjG27&LI(1Ek<)539u{=&Q=c1hRd#4*~pSrE=teWC6Eb{K3MXKC$VUI1IYu8f$QZ($=OmsSIgm%,}w6xC6Z1OR"
			"amxnh,ZaPxe<;C5t-hFaz_=~o9%h<L>Z(mjH*Xo+$&n(AxRUgiH72_qE,01RovHUtbwLJ$zw>%ihoF+x=PKTON"
			"Rd3,)aN(1USJ,J>c2-qqo14JZ;Azg0ou2m|IlM@w=LW4bv)ld!HXg4Ids!>FSx+I~XCE5IQ<<F-#M;j6W6-_TW"
			"_;c+W_lUzI9gfP!j~<(JnZ{0_w,dQD^2vRDTTI|@UNphi&=e+t2bH1pChkYhI2HtmMOQ4WgT1{yE>L+rB=mNSk"
			"lU=%wu}-vc$=+(IQ!%EWZWj>a#u3jt;oK)_x;QpUKLEQlEvYBv%guVmizw.XPX_lYxdXdp.tP$8S#F4XD@e)s@"
			"rR;Z<KJ&AjtF-q&*t.DouZ,iYXYu44HfYa8|zlD(I)Y.tX.%f#4YB3P>x)Tu0IX1hJT{$|L=PTl-I<*m4t&yuI"
			"jwSR><jCU5Z-nFZ*b+>1qE||u3i86dJh>I<+P4U;1x=TBF9eREkldrJ7iM;dV_VhYl).6M4*DAAKpD}I>@Yjbi"
			"j_2LiCJb7%oH0<7IXRz3MKfr93ipqTG_K>tqh7*m.lEOn%RTAZQoD..a$goa_Gh,<=H@qWIPf@h9,.faHQIb!&"
			"YmrtWmM*|S~bQMYcsJlbi|1hg1#xe(-4H%*T0vB.rj^e-e+UW;cJrE=g89|P3MBnU;VYO0=MMdMPohctMxZ^+T"
			"9BAHRj@YJY}rUX>6Cvhb~O-iMuDabMmoT#h+K)(|wz,Skiqe*,1ow,qoP0pM_S&OX{1=d6%-e+_5|pMA}=Nod&"
			"rX*{=Vf&d)ad,C~h%q_U*5+amHKWWhKSBP%Oz%.tS6-f5RVpGR}V$IZ8Ab3XwxS3L1ArK^KJCV4N#H<+,Qo,W3"
			"wH@ao|<@~1~rPJ2g*Csdlx{Ykz=H_bQ%xPuoIg.n5vildZ^qMn~Ea~_eH%E)bX6,;GiMq.-&ymK.zcJvCVV;gP"
			"JCxnj&W_!T.{)SSVpzWgNuya9mS-C>*si%}n}1wxOtaWY<96X_nY3r2_W2wa,!61adYSpj{bk~K*NL@Kaz3H_z"
			"o1V+Ihx2#>)k&<$9X^6&zqhtJgDGtHWMR#n$.N!C7JOtwdJNIx1.!O%;8x$(XhpwWzJWc#q7_t-)8NxcZ)*agK"
			"kZ4UR8RRi+7W#.cis.t_=O9,i.dxM;)u_CW.zpj-BUEv94{a^%%&X<2G<M.N*)oJ}<+=O;5Ue-uC}yEwb&Mi{q"
			"c>_zJSBa8}*Dj<}qyT)ZcRS.=CV3DoV|vbJMR(>m&W*&h3A!M}mg5guDJkuoKhjVxNtd<n0=qmNP4Y4RNwJR44"
			"539nI~GhSA%9R+kN*{(+~Vye7t+N^EtGwM~QM%{*;hYXjd>owet9uqqnWLsjU&8yQK.RPe|S-Wx@.07pD)1s,-"
			"N0+gzsH+nrOpQ5@HHo~wMRYaLwsxJQnz,JoS)USjDyNXIarwQ5.4L$Dcf)H(UVE74CUs)m>gmRe@OI=)is#P6."
			"|3b+<smm{O{H1o)$eLZ(3&%dwDOW9VACAy-8Zv@(3U2Somx>zyzb<D4c;d;PbQAKqAYCQO{MI3dKdHQG-n~CvZ"
			"S+&gi9(kkNv+.wVMCO<NZFJ+!@vHZlkX!mge_fJ2)8Kr0we0)B1H-#P_eG,6e*EmaAQBn3%-9lG0Wy7_MK.GqZ"
			"N.zin3D^4nSetnJ,VXTP&|Nz%q$IT+6_!mLX=bjB#r$0HWkiJkP%J_Wx4r}a(!2S3$1,VaDSI_&Uy52LF0^)rO"
			"AJY.{bVLk$FKZD44If-Ju#c(Tw->W~vA|uH2yX@(^3.gJ=&Oh>PE}1X(Q-eRcX=VP)(W3uZ_%wC.2E;v%AM+dh"
			"gvsW!_1!F(JSxeaM*R(&SHt)|!|d)O3lSnM)6R3)oEM4YHuoDnYx6g7D}!9qDQ0%6=k++pb85Gkv9D2C6Vz8bT"
			"0VNoofg_wPP!r(pLuzuY*r_GJVMgs{A!aUqr98dt+$nv%i86qOPNtNHOczVhbP6Wn9bm5@E1j7&r)o5-8#_2E#"
			"_Pq;MXIgCxV)~ilZ!.wbvbF^)u!<,kZn)%(7.HbLhSux;J#VmeAeQu6dz*DoYc_*N+py@HcazeI{z-k2%$%rR>"
			"k_lEr;xRLGhW$V,c%{K>&pG+#CMuSw9>M3z+Fz@D{N^)z0UVz.bPXGi(;Ika}yt<uv9bm-TiOl0Zs6U>UqpE1k"
			"W&w+azvTLhXgGZaqq>c,UF~fF_+e(U+wJf|&NBjnQGqYa39&M}.UFFrk#!Zdi53wG5JhXU>605~*ZFJE^8|i)q"
			"eTT)onlI<_V${aNFR;IvELD!}<+&fAd)7JqWU)U3Uo*8^4=zTTGxHr<H*^&D_&zO7i#@M=-1ei(qmOa4#>bo5;"
			"OD6kO4zEOX,cvbGcdGcW0o{zX,=bF(Z-Rr!z16(uCHqrIN6<>dUAF0wzF_$zk,h0;B@3;M_*ebR@.B(zh$~N^{"
			"XR(PCO1%rzdX4)H%!f*}{E;mnM9sdKk%,#_49dGF6@q4Ng}EOtNcCD,U4e2CfcP+>G*T!5GoomdeT(CiZ!n<m;"
			"^r+~m>Q)zuzqliPm>rN_UkzDmbIdp)~fN9$eASx0vBFTB4)!L_.Hd!I*_pyxUWTWdb&4vSAiT|BhDi{r(vkBU*"
			"b-u9fXCau{&mqV3C-P_Lc%$RbwBTSEOjPoleE)3Z_bZ*7hV.(P&;%MEGn;A5X+Z(r=T{${=)X9e%HK=sx&y>r0"
			"^uAArmCEUEIG8lqq|cU4ZH.54&1p%aNxMevI&#teescx+To*Vl+~88~(,uZjTL#>lvNUP2dUX2FkAXj,>GnkQQ"
			"#^JR&b)lx2cLUCNi6d7F-P2l-CNvob^pV8kvZD)rg*Vk.R%rLdk=0){9eD0CVLB6u11}9G4~a^ZEMO)S*-1wrc"
			"C_@O,dCLu3Ir7ooMh>ZcMeJ_9dNtDTFuAl=!kIGq)pgtkH,+xJ_YLS-Q@>#b-*BX,h6i6JBQ-%c~EL#r%fb6R~"
			"@yjy(LTHrUy{twWAP*!S}zX.lgzCr$WFHkY%OAroVaa-yu)6K(3xe,LI<ku+(0*;7rc#M(^_Y|jxkJ}7oqMpoH"
			"!lK9UWHU1k^nkr2dCf8rkZfAvGM}nlwgPntSGp9,7&)bgz|6JE=cFjpLF}&f}PNG=7jAU1gzsk.zCPc}vGkVz^"
			"-3L{f=eAzV,HnVK_}N=6<8kHd-H9{cYm)V%(}9*slWAEM+-1DSV~%oQs},|-!x=A<d}_~!F,s$D&D+*3%{OpHd"
			"E~s)eocC>;G21kH<sQ@IOm~BXYj_1Wr.NjW$d>s%2cRlFU<}UuQ,lJRat!THk@qTMR1m9yvIR5B%Y^FYu9wfxY"
			"*^bs9ss5%#&%,XBh~^iK9JmuM6J9Vzg5XaZ^1qR<nYn$=8KLM8=A}a~*jaZ9WSV)N8fIL.wy5nG.9_$=AzWrOf"
			"#0HQ=)OIcc%E#@<7-f$#7$;OWq-aEx^q$j>5Vf0wB7ZC)qnuM;O2h.Z2G%f!f>.lBQEC*>3BI^rS|k@XL&k^M^"
			"_TE;f2r^@T3eaK>Y7l~qQC%}D+6Y;lMa&RZoS9@Bbth,U!UY5w4%UR1240_k6,uHF6S>~pwh_$9WpA5o9B8ZsL"
			"c%PO{tl_Rq.y0fUh,OU0FIcWbRZsd.z42ok7mMW1_^D;.oy}_WzvL5vRxx6~D91rEUMBW%pOC&UT#EHi_>Yt77"
			"|5<-XuM3B!fjqA*BFSIFB9^~y}A)QiOBg(b{&6czXpH7_EXNhd)XZ}bjLB)ejOjLcZ|W_QKL77_R;8k3RXwk$o"
			"lqYW9R!vhQ{7UQut5HZrG25{FW>6lEm~AB4kg2<@cVp6n&HZf7UN$_@#-.sW~6MO{DB6k!eZrEjb@.UT!urv3="
			"$F9F9l$%X2ILjL4ji=s%a%R>I%9-Et=Oe5rrN-F45ak;kE*Nj92#OnS@jJlzM~v&&ELlcDW<UR;Tjbab7$IeSk"
			"tRLQ%%.^aCujWl0ZR>f&Qc$.YLw.{3TPAhadd=4hYKLNJO$5n~)FYzWvyUx6LY)y>z@hvR#Oq54)y~fM..yU;3"
			";>qRhLe94GXwR(6Bez4pVL2R*M|!wdBa!,;;&M9~^&jWwUzL2FIy5|,xgTAhLG^#s<I;4US{Z(N{ZH5Y!m.-Zr"
			"#8bcLp|!RA-2YRkFHL_-R1kqk*4x}<LC4hqgfT5jz8>P$+X|<XGHx{|51OIV,{vUpwH(r,s(scrF@FS|6$dl{Z"
			"B4VH0X1yM;kfbW|=SLU-I7mM}XX6qsrmEyPS@G!=L{%f8;k|4gTZ7-f5!wGx^U2l~&Nw#cwupKKVY<q_H$6MEe"
			"Bvll51L=U2UZ74fs9A4!al2EyK^aPoQ.{N^lwHzV(>=A0GFKQU5%TRJAwpL(SK(AJ,-GdUH(RbDkoyr1(tz9*R"
			"SIaWNHIQSh7_g0MI=Fxt4AJu1(%gFzUf2yC1o,Ph(+}(y+9Xl0oZ+Y<OPR6rwuOsi6*iV%AvOoCx8qz1mW6oRS"
			"Zrt{tMT>fi>.in*K69hOcli!q8Siu%@;~=AyP1wh*H!v.A6)6N{ml&WG_jw.a{i$_XI+jylKc%aE%^qXLmh,tk"
			"yW$tv%&riis4^S)6!1G.KRrZGhbQk*mG}Z#lPa-W7e$n-g&HW_ce.*^cDK0.C@EGjcAU$H)=+nC2PmMS.jf0XW"
			"VIGe_2{-=Vuqo(tfw%J9Ihhe7hUG9TGl,4{nZMgz-Dx+@BU73Ba)q*2QS^d@PNnjn9WdWZjV+8XY{3uGd#8WZf"
			"Szx8y!;g#StJXlMUA,aQm)y-r+>3j4nS_kVQzIuq8<rKJ4ByJ7coC-{v!)${u_l$tnCb128gta<$Ae=7S|$oah"
			",epzi7=}#J,lSAg@e|X2KQ_qn+YN_>(T.+XP{~_1&v$^qliTj2&9.y)o>K&gsyJ6R3KkJ@-g})PDKV7-jn*F&("
			"Q(BZ|IMk$zPBkc&*myb@@Li;0$6ki-,ON(%O,7(&x&Op.y+*u,&@bUDBTv*O^Ik_Ik;ve6|LA9eWLv3!DtQ^gS"
			"<4@U;+s$KSibgn<6QnSc@A$ns(8uVcsU<j>)vCL^tHlot1EAtp}PtvdszwnV*W!L7sI;7I}ZN|zRUSn{*zBpuO"
			"sWT*L#oEJAWXZ3-~%}%U4sb6Y!|6N7huuo1qM*q.O3}%k5X{tEXj|@HX}xK9i4Ps&HQF>MN1.C2S|kyieX<CnM"
			"=U4.&hrUw@iU8IFUe&,gQc&J)&8$v1ilW&Ek>R<n,%CjX4x<6oVQ;<^tOMC5<mS9<ZLMC5&S<gW.U=T+^nol3R"
			"2A85y6kFd,|WT{@,8Wm$19Uetqy-JqoFTBU4Q%sf9rcG.Rta+.y^@{k(>s9OZ7o_p88T@MJ;iB}KFB3*^t>=Qq"
			"G-u{Z,3$z3e{7tNN8}ZeJBr#)Mn{WjkFc%24o4%A|54!YF_B-YRz}.k{i7a|zd.B0Vq|mVtn1}p!+Gg(l=hw38"
			"SgXXe;Hj1;m>2c&UWOkGitcs&SmUXv$D0z{)5M2-gW<9qJ3h1nSF--W%}0iFU32L^4R|8QQxq(^8S{%$7>#guO"
			"@o*_tlRzjC&XFPtPs!lm2Dy$Kqc%E{gD0#&l0f-DP|A_YA!!E=2D#^_BZaXCwQ.{7&8I%1.Zrh2nZiqW$c78RH"
			"51j#)gCqc6xk.@.|H@nwBQ<xG_;YNc9wPW+XP-A6y9==jRye;KdiJ+.W#=WiqWOnzfqXlKylt;$ct&cytZXuMz"
			"XE6MisJ-.vNiu4l1$e9@AbUJ)Z(h_*pmm3%7Uutb}+0za6<0{11zw_4n6Vgt{7(#Gygh}~j{;PGVWaw*(RLGl2"
			"=~gSoUdzPTO$zZm6A=ocvU13TpO{}_uURi-+Pq@Un!Hl4jfO0D<X6ULkzb9+obzr^Lal2nqrqai9F9jKFND#1C"
			"j*}&xAC*1Z|pZ(DR1#F9}S8247=5)wmcSR)^GHl-bd&f<f{3+XYz7C&~$i..S%E6T}1fLpJ6m-%6Plk-0bKl_6"
			"p!*#.BJYE*~}.,95#psikt1MBZb@tYdoE-AqO~iIdwBq9PJm$1|XwcJBkLz.;r(gz>Y4-p{C-Goq~HQn4Kz%i%"
			"pmy=Q;pUkhldf27mnEy(=.vc,N1_7n3JFUbD!e+!OX<V_ceW#VMKO|0Q8si)&F{VUVn|6z+wi~G$#QOkoxnr|h"
			"EVpyBWp*(7s$k%zV{RhKh_A&9R8hTz08ta*bs=rXK^No!<iIKbP8#Gogy;rvOxhowS8u-sOjB-D${vYJ<{kV8*"
			"3,JuP&8&PFx%t1FPiG_VoxO)HN87XB<vb9OkdyhnFT2XuWaY*q5UgO8^I2TozZ(7zF76YhCu@|RGJ6W_XRz0yy"
			"ZMph_H-UD3+mhMXSA&i-bLi@_ZRy|!)AIto_(t2*Rh-.*6BG)+E1!Ys;RYK!#0(%%ZODf#dA4gLQ5)7;%nnaU6"
			"sbYEBKSbRhOw;kK<KLnf(VZr0n@w^p)%_|4CcQ*uS;y^{T7JdpR7AM<aoz#eN-,Gx(l=<gtAU=3ft|*ya9rl}2"
			",J_DQExTl))m+0wP%W3inTlRR0BoMcO-m%{cnv5xk1X,!bBc7{ITe2qQDdQ9>sGp^;Csh6bE#Pq696W_,,xS34"
			"}i58c$U4{Okm6f_=XOlcxt&J>V#rlin<&v4Ty_dTdRyOFr!krA^JuX;.PwJ{qTBPKAn,ib_C(67},j7MZ4ZcPD"
			"T()ufK9XZA7wA{b%aZ)HSu@d(x3+en5>i.1--SXLf055-wPdY};-!kRyD_4_C%2f^%FE>DE#hv=!I8$s&Vt^z="
			"FMuG)ri6}Y$I~s8!Gnq7v4_h@3#AYZ#!^u+ZbBgZN1CN(A9ezdKvDwE}0gyr=MoH(4TJ0^z+tE+%V.jrTSZ}>B"
			"~9N>EE82FO!#;<L*{9@siB()4JI_wXUt(wcgEI*_>.QX6,+^DoZMJWb5!kqOn$5Yl%%Pd2&7PLzm_~UZcO%Zm~"
			"9!#O8T_3VR+>EVjaEdHilZx4z9;Gtin9p;mOle}$_|ncS9t*P4^f8Jd4n64Zy.ide>Vd@qRdrcAVXvnfUQJumS"
			"7<36(c+<qsEN7.yzoV^X(y@;7Jkt|LRnq=umy_EJ|l~}uvt*^YNU5;BH6^gSx{I0y5y1vRrein639(8%A2JB&s"
			"S2FwmTaQxttz*acnd3RL(5Wo&M@#C}+{D_vaIxs}8gw)3k9).>{Z1Jjwmkfgu5$ia!,7~=dX>xK.^NTW_gm22W"
			"6<c(>B;kcyP0w<MqXcY-mMDfZjlnq;n(_)o6_goipwg+maG=5c+9e2p)9J$Bl||aM!p10iLn0$^{su{>(srR_H"
			"N#2p0c_M*iH-lj($hiD<c{&l%B@0lhC|R87#EWpDNOm@iU3XsO,|16T(jtwb_wtGx&YK50fk1d28CZV>_I@kI7"
			"o~WwCoVWV~.R&OF<EC&OlaZko}.A|,~fHmY*%He^j1#L~rNdu(**f9bI~$zo_;%k)i|EjJLE6D8*vk&khv(ri8"
			"JH$prXSF@XW*}<G.e>pkTC61p-e3$wX%<bXDWj-r>ce--U+tt^r-o5,~x&JrmI(i(t5gpTc&$U(E_>G%d^.XOo"
			"<2ikY59_OrG%@fQbFbdpqWgZubvtO=M#Ir(gFE*TN|lnTv~tLhnG^04LU2,ALpmjy)K=E-G-9#$)mXEpl@PCiQ"
			"%.)7l~R~Z36VChO7OL)m1kTj2,tW{d<@}UGISHXpGjU4b~jN<vs#H>w(6C9c3I,~#J4Gvt+#2Fr7h<<egmS!@v"
			"C+I1y48PIQZGfoQxg$6Y87!o3(_W^p^3n&$o,cV_~J5)kxtkO&5uimh$qYPg~1UrAn7N.PHsJ-=4>@.0Xn<^rz"
			"wd!@vKdI82GP;QTQnsHvm2RH8lSZ;jWRGlS2~+w50<xhhSh+P_.,1nyoZ*d~hKZ%VwqzBT(@9>YHww~_R}gC6^"
			"5u=8#7,}gbeRqydz(XN_jrkKy}^&MF+6TF)Vy{w5k9$17zPd4(mv!Y~8<!>dP2}r0!$d+dcu,JG!X{seyt&L.#"
			"Ub1tOp;CN=+H&nYdkvdiJ204!4(+XZT{qIlpUzLd&gANAP.{6xHL;5l#Of<~e{n3o*-m5a_Zz)Nos9D)!g^bx6"
			"YU>&u%9VCg.P#Mi+v{kV*KS<x))bbUCNU}Xjfr8ikWvW.Dk*Kc>Y3uo0leJn|hat%)Cts<}3ZAvbC!!ODm2nO$"
			"lZ2$N1NY;xS@amM8n0q{a7a|FGNPS8etiKC!ySzC(8N9z)%*#>TiqY|&C##!NQU+FHf*F=w_SB0.pJ&R=.})+^"
			"3S7qa(XBHIbvTlN)t_9~^B#Az(f6R4IapsfwQlHL-(zF%QBHO1{Rw9gvj7Ip2FBQtM>yE3soYLoMc-edBNzwIm"
			"1zH.lQcNejy(!Iyq{qp}<*2TZ!FUaU8GdNH5llPbAb6Beuv3;&PGP*C3EMCqyR82RQv1>1cvs{#)l)O!aSe9C7"
			"-6)^W!Md<XW_hMKFM5,1B21Mpp<d#)LrIeIV,Ix0i>iyw8pxB}sX2*aY-ffu$i7B)EuyM(t2x}xiDu}LHmXgEw"
			"6Trs.q4F-CQe&siHY9n%(>FXF~jqT=,Z9m{i1&2^wZYennci.6(&v65,2Wnn;F7*l@^&3MzE7&q{&iw36WhzdY"
			"ip7ftH4x#kq<8f^s%GaW#)zZ_u6Usnn.~Rh(qRq_H{,R><&JnG<O;E9x_%f8I@u_8W31+9vW.xBcb09FF&witW"
			")#rE.e9>xEKNmc}e,v5g)IUM6f7vpXuRzIV^U&p7ANQ%swyLifnMiRmSbS)MS)$4pd9D}gdG(9RXe=ryxjVke}"
			"viDgM+I~rK48f2->-cNBhlW9E;-e{hQ_i<RR1.*2E_)p1IP70~eR,)EVBGTyJ3rbdu=$i@5<5-n^R!iYI$!9In"
			"lB<DMei<oDE~VIB*u||T+*Mmfa}uohysTc<tJxyfy,}w3_8U2l9L82BF)UYcEMIA}fy.ACkuqm;y9@6pVUD94%"
			"HCH|Rw~Nj!%1@4GxC@FMDAK>PIXDJmL~FZ6Z<64oaFB(g~lAD<aZeGlbD^v@slEKH*I,6GMXw!4fJ7YwVl.#gt"
			"ygSZ(g=kuZ^7+va*(OghrETEZq>6EB_LD+2u)*JK9Sx6Xzv~!FZopt=TIhUF~Mnn@MKqMA3NLVs{zY#>k5CGt8"
			"DHl~wW@eoH=cm(*8rjz@^ku;#M7)Bhs573G|dQ$41;ReJUr*wbnBed2OC&HvXuHYX#I{-xq_KkjatZYI+HqW{@"
			"C,5qHr#=km${;w1IO5}1s@Mq-vzwz.^diHYiIu+vOviqN#y!XHDFWhu@FB59<KjK$iS-bO4$1<d,K0_^}{=sj_"
			"Ci59Dc0Fb}9wqFYkKZ,@4gBl>QKzWq-g!A6@T&fPgJwrhahF2ADaho0qPNfHG1T3,+x)5d=N*lAHZ5ZQm2%JXD"
			"|G+tsXR*Wu1DlAUA)|n{{~!(8QA0eM;=F@^71>CvzNJE3D8cXv*}-_kDJ(5(}!XCwkIP(Se%Wf>ov1Atb4YdyV"
			"dF2,b_wFf9v|zJiW^JZ<BZ5icV&+>P_Wn-EEX&%EZvE>Z<USyzBn)%i&hDn9q@8#bsN^(0rQ<f6#pvJM30Q.q+"
			"$K>.bo=&3iSCUM>oox(dmD^ynv3j4*gT1z70rUlW&+$liW$BmD=>{$g04q)+B2{^EUNe=)n5,,gKpEUB}|OC6d"
			"ko^~ovkeeH!62$Yjb(F8,6=HWQbo04zvnwV<$e9z7,wHKSIOzOQGy6;Lf9bL9,-|D1rF|W|#eQ);WmujjbW0M%"
			"@U^Nc#PE~SOB38prafxoJxj-KN}D<jGAI3u#O5c+PrOcrahfyhRr(!tl}Uy@MC5Wm,IGla^-20,*S}wq<2z1Tn"
			"J*.RRg3=FZen,L*khp1%9ZRf>~i$yh6&_n3F&7E,6~9;Ba!(^(;SZ@I=dP#8f,Ji|NAfflO4u9.C@iQS%v31_)"
			"9PU9dYDxK0.+%Uc~xW+~e51ZS^a5I}B*PPYsE%obEA{q_I4N^r}l0_z%hCZEMo^(#|msxn~%VoE6W@&S}W#C;c"
			"SYZ2cl~FV.J${-XTr-TKxw,i.YM+3Ps+IUn&e!dLgqZ*J<!MDA3dT<}.4IP<HU.dWsbQrzm@EKjscGn}gCRi,<"
			"RV!n#etT9_viDhEGt9DTLPn4~M,o=uuvv!w;y9vCu()-o$&%R~YU*}%h-|!jwoNF7h&0jjNkDa>aYTB%0CUj$C"
			"S+u{5&mvjoxe<biz.)olrWK8bEbw9>OqE*<Y%7AZolZ3wlErvisioJ+t(aeV;.TE|o)Kupi)5.T^V,r%FMDZcz"
			"lxZOiJ>a{O)PHE*J)mI-_<hFo(uTQXk#LCDoupQ-Dgc2BwJ~vm3d<JHuy~WjQoZ&C6DmrPGVV}xRXWow6d!oN~"
			"(7%X^}qC@i&#Q-MyU^V!H~+oC)4f{7LwV<|T}}3dvWS3whhMSlglVe%buLh^_}uBa!)J<bT{x(mxJGdChn$.EA"
			"e(PR6+(HGOmVIt@0Q{EkQO6TPjeI{OZL82L$~ITfKhi}Sl@+ae*9+>9rX$NzGEQ8p7{Hj{xYPWEt{S;Be={)Tp"
			"aoWApRI6,Q=Pyh0GN&RwuV)A%wX~^V#QomIDzwi@z$My|&6XR#A+sE|P$Hk%S.^kX53i%b{o,wD8WK5MOI,KEE"
			"OpToE,HuS&.-TxGm+Kq!C-~XX!;#4P&2DqfV,Y_E*!aFh.AyrK(s$+c&7R}C<T~uFoIbJdax72JG}uiQ%h#~-b"
			"T6~3t0hbG6OrpP@h_h=^qKED|2+RL!>_,>yyo+&d8~Wf&c80GiPzw<v;K32hClN({.YC8pRJ);9lxZ{#8ySW)U"
			"JJa9QqyJGoz8Aw|V99mG+776Jb75bCd8B,zO((I8EfpniK!2IhFF.<30W5dXKZtV|zSeHq6Oi8+W6intgLGk$l"
			"<gYa%q6IK)KBUmVz}m-kIO7qj2,O}vl3SL7SLME&Du=@XI2{x,PIh9M3nG&ud,V*lw@Hve.LsI,^o&%%86H+al"
			"wW5TJ^u$_i9CPd~XiLjaznAz@eh6(=SbCY>*L4VFXoy6v6V*jvL=@#,E;8w+R&PK&)ZG,<JFOi;R-}.@{jQ^z1"
			"<1NVKe=+s.4&H,-Lr)7hli)MtazF4i_}BL*Vek6SFYmLMS0nNlrhJY^<(KiCeQK<B9&HN#g5Q))4xgywt{EBfI"
			"T$ne4}V5{=RSt-L0rVL@i&;*PwO*;|7xV(Oq{#Yi9i1d-m0yI_%n=Gol<(qW$9m4RXu8xMgEQY@;pbb%==2ScV"
			"{n=d-ok4v#<9,|L|ji{eM<.RWJSX9E%<Nhh|3$FA~J,G@3ZVMCU!foNu()OB0c0NwBZqJHB(#@GobVk;whxZEM"
			"5(p8CH%f0^+1GuL{3gZO.jzq-Aed<A{u7H2j)cANGSnSEbJVSd8ClU_$bZHFJUWAha!c{h{LPZ>V>KLO;iUr~O"
			"xxi.;kKEpqt=l!!RkAG=BMEw$eCE{pT0&iX.,H7P_sr*f9ME)XJmQ<Ytu|3Pg$e9(qu422%;%g$NPlu+WlA<cN"
			"Re9AXxl(OZpW0qbT3L9T9BxAyPF4tCNwJ)XvGhe!A&H2jF==Jua4},3k9wjb2~ibZOp4yFj~52+7F|A-N%hHP_"
			"_}Oc<tHQl^-i4*ACOzH^ZE,NGla>XVdMEp,zrn)Z~sRf=a)6TCU!jBkK1wfHzUQ+uX{^1vx0RxeqvIU!JH+R=~"
			"hK,HJd&8Sr)Nv<#In^eO$g1&-zAxBRVF-+xZ61l-cP#-llaXUNU$|,6Xmmz-{oD{Sz;+PygkA$*0m*(pg+S4dy"
			"qKfjNm{e1@Az>@~.<So.)|$<EFg,mNZ_9UK){^%lsV-ZuW}k0Q043v5>meqyxG;A=2m#rqXiqdStyzaOes);yn"
			"_PDkex!cIr_$;_(Z,R5NwpCkPZcH@H{hVJug!D4yU^iR,XC-+Tw8EAa}h|9dr#_oq5<cXrX>dfjUj|4|q5vO|p"
			"&e^p2zR}V9YwUFY,j^R4z5=~RU$E)^@yp2dEAx4>I&v}OIdVK6rE=xHew*$2%k&b;s{YyF{,on~zR{l}{u7ra>"
			"6Mjxd<v6#r0yk&qWwwhC(cesBavq6gr0(b;7_Pek$w(e=_,@Yuai3)xHE.y1hHNccOMOjwOn>{lc2BTJ}VQ_*Q"
			"njYX+3T_zg}!jrhLY^IK^x==O-hP^-f%w!rjMKj-2x$JGu(waycGDze3#v(4M0!6UN;~Dt^(Al~~42(34(uVzO"
			"2xnZkWlRy1o$lkgQ{yybsXpIKEsW-L$jAO7A&.$;w8l5-QBore2Mq}r)6S{9kQWXWk|@STP%>%@QRVv<.q#9@U"
			"lR,pWTYVkNUnJo)Wlcl=-D,;EmGm*z4zTu6IFo}yV6C+y^#d=J0wUkd|TK1K^tr_C;9nM@B!F,0tt1oqTFB2xQ"
			"O5VO3x);6{mN8;%C5f=FNji%9i_)@Zp<RsXJF;FX#ImIKFPd1>B~@BzO@zpq8QIHJNmsF5MDdfzP7LHvIXy(kn"
			"HbtuM6p&Y)MJ^fCY.oXRwprg6~R,WM9F+f=_|xfNi0h$Pq<^Lc$*2~E5uK<*2tDIVzwBuR$eO4Z6YCrVp*KRtn"
			"0#K2}-nVv7L!xSg#9oUNK_5C1lPR$hC>c;HytzTMd6Gzw;V)HJ2wkqSL6>#Qa5e82HIz-AC)#uESnpZ*H;^{l&"
			"d&*^c8DC&ptV9PH{RjaZuvY~vJ|oklE8jNv#FLl$0(Oqu9uk&a^><@yQESFE0e;#qi}mcOkMbv5N-(,J0T8#Fd"
			"{7x@b3G5ZRV#w<.>EWRDzc*i5oS0kqgT*ulcoScu)Ukd&s(UFTEFP*Pilaa{%B7BCwp1z(Adl^}+kv}<}57yvM"
			"klnDy.U%^cYWcYIFB$)Azt|@uk@_U$ayTDu#&$o+W^uZI^DB8j@l>3T_Op>JPYF7T$*m<;OT_PA#GH@NUMKGr)"
			"MLn3aW|E)uJb=pKcLh13;T)4<Z.1=NZn;.=lX,thwJS<.nfa%u20=n_WF#zLuU4Q63pQ;C5gQ4u{JMC;Hh5cEJ"
			"kLX4B;$JW8n3fbT8y.,wQWZ.U=E%k^KgphTZG=8su)sx7aVp<Zxd-{}<RX>pty{KC{!@aqzS1+@I+y#.P$X$mT"
			"bF!}vF=.al@)ykqS*eih8UO5-eWvD45,O7Yi,@@*%G<>ok8)6{bQ$&b!5=T~idNs;NXe}Mfwov{yn)#mr{{U%)"
			"Ic5Z}Es!Wf)!0*V%VULWP&h7;D9T^k%)zv@pFJj%z-H|1CGs||>qaJc(d|ii&)P3&5PQ&Qudu#A9YL#l2Cqvr^"
			"w3>3FTX}sK&S%h8#<hxH!e_j{)_s{068A(T&dFVcy@c#1xSm4%#O^2DC)_d4SCG$Xe&TmEi{fNW3|PgP(Ob#fR"
			"gCl}ouuVRMQFXtOpD}JM6o.(dW-ZsX-LAAWksX2(oY*$iLjO.M6otJ*eat^8Q9OLw$<Yt6>74jwwTze#f<WC#W"
			"N;PZjED81S=wNEzE0TSgRQRf>_gGHkjuo(r<Cl%*BjYmR=@>>,mm@;|OKg>8vkumaZ}MDW>*%m1E1yZukk@cy^"
			"v%N8c}FUl~1w_Y>S@.kB9ba=uTu_m}Z,_2hch!_m-xEtmAK_!|5hdsX{Q*v7+~v0Q%_LEG}1dKc)|e}v,z!yj0"
			"m{Z&)e-SP6mbrV8xCwV=@;7=m>Uy-3d%u5sTDqli=*~f!Fu1|rSCjw+&#;f0{ofFQgoecd1<bC7C=r73TJs-4s"
			"zLs<4ckN&8v$5^@%|7C_oa)kWX9<y)BmSm*36bXBzO8aI(S9l3PDkY{mrV|BrFjbc#eXh5WpY1>pGI|V1o#YaC"
			"%{%j+RhWHc<%kPESl.+WZrl=7Cv1M5B&.vbp3^O&8D9@U%sz.zd+^aJU,nq{S(dmCcKVEBE,Q%pO$C-B7SoEr-"
			"hyg$p0GhZRl>no#*VC{-chEjoZ5>b5&Tj(_D$pR)p$jCbGuv!gyUcOFGHUR|a@Vp<5k!7(C,ISH{l-(3U6WGoy"
			"A!@9Y)Oymt4qyGiFZ^D~N_O1!bRLUS3|mS>TcMQC3_x{BvC<|nCKv&g)@%S~D(T4tsA9|reqKE^t=;,kPe,Wf*"
			"pW6QmMk1Y8K.km,H_{ozxCnNg.|LvVV62Af0*k8t1$f>1|clS>gMfn_#@^DtR+Nm}*kjF8diPX-H-@d6i9E},e"
			"B(CzTPGVS}0,Wi6tJlh@(fj88rT%lbM(>orKZBUPrqXD<W%ZTIIUoLto.jC7y|=GP&{c,p&tX~>.p3X#@r{N%$"
			"&oZAm89k,)Md!@D{T6QJ(ZnU+0f;Xg@1jzI.qN+()<aLvdwz>qf0Ax+ZDll_|L3qVsB.rSrf3&db72gsuFEE.9"
			"Ptf3Yg%}6xYJnOz^ddqqloV=}~-|-5Plp$&VYZGdD2H{sSAz>St)jIc$mgEa5CmH%n5bmx<U<(<j_imM4goC+8"
			"E$Pva$tv3Q>1SeprvGAFHAuR^L=o#fun1!VA2sUk&LSHGp5VP1k*oR7{cxt+{ps@u.dypIL6S)53%=5}j>_va^"
			"ZjpgiPCbAO5@hckS-ML&@<Zke<hToBUt6,@(HY(N7w9bt<63VP-siyYpL|(=;CQde,i).3d{zkP5=Wf;-.b19J"
			"HRN(Wa~,L^c,H&)#4_qD+,Z+#p^F#qG3qt4_GRZhUjfUJmctqsv8{>hRxxJj7h@xbsINNouj{W)U90N8#=CS$p"
			"*EU$PB|~=TfE1>t80.+H>ymWVngWIb9onxeC9igWKIWFmB$(xWa-^W8>+UgSsZ&6!hGw*|EZiO;9e)WoG0j=Kc"
			"02>7vz0*zJg=9TzYyL!fjUhV!p8~Ps&wK6Rw-i9Qi9@r}3QLqo>ky*qI&-im@zX;A@N}@+X9!_P1^~wC6sH9p1"
			"Kio*joTF|Q+$g=^c$.m6sZk=(pb.wkIpHk~$J$^Y3_pPp^9_h)5g&-l)N2|3r1X__X4,-eV94.&9<$$v7mD.)S"
			"|ea2R24c!G;t1E4K4VE_WH-7n#=sEuJ;L!K_4==dewCCh}hVFuLKKbS3fBh@#&Ua75=kml)_8WfTEKbEr-d06f"
			"ogCcc(5)4U-n}ug%S9r6LmD%L(Nc66(8fkAaoTSF,Lp*)p*}P0bQ6*Kg=A0TUMJ_c!V@BS%I-URjAYi@IcwCuU"
			"w*$J_<oh,TYl2^SE+hSGo..iS7TVEeI<1h(n}M<O$qapB}&@P9loPZ1pSkvYQBm4>+EacS1;7DpXV>qztvyB$2"
			"ly%Y;r&0Iyfr-V$0RB=~UzDIAmwyRj0td6Z+=g=qKMd*wZ4ri~U7-Cyi4URLAri{bc{0SDXxXGsP=mIvLSkhPg"
			"1S7}!.@Z<aFfuS)paqROr0$eJ$,Cg_nY.S%O-qZv-c=~gR6X)-Iw&J(DfMd@9}oke;KZEF~RbJkZgIwh4hY%TQ"
			"-eg*8)<5qnZExmZ^vtE.HKSNw8+sOY@JD22t,;+*I$oi_wf8JNw,7C9T-N^m5b.)@96C!XWiSd)^Ck08h#t@%i"
			"niGRKP3y$<6U0o3.k6Kdo4sEhb1F^^(FyUjh@8hy0(|BC>XVW8)hD4+az0XUFOgn,baUBI";
		return (char*)p_Decode_BWT_MTF_RLE_Huff_Base85(p_s_base85, 138070, 33184, 18046);
	}

protected:
	/**
	 *	@brief decompression routine
	 *
	 *	@param[in] p_s_base85 is null-terminated string containing Base-85 encoded compressed data
	 *	@param[in] n_data_size is size of the decompressed data
	 *	@param[in] n_huff_stage_size is size of the compressed data before Huffman encoding
	 *	@param[in] n_bwt_primary_index is primary index for the BWT algorithm
	 *
	 *	@return Returns pointer to the decompressed data on success, 0 on failure.
	 *
	 *	@note The data (although it may be binary), is additionally null terminated.
	 */
	static uint8_t *p_Decode_BWT_MTF_RLE_Huff_Base85(const char *p_s_base85,
		size_t n_data_size, size_t n_huff_stage_size, uint32_t n_bwt_primary_index)
	{
		size_t n_base85_length = strlen(p_s_base85), n_base85_size = 0;
		int p_b85_ic_tab[128] = {0};
		{
			for(int i = 0, j = -10, k = 55, l = -62; i < 85; ++ i, ++ j, ++ k, ++ l)
				p_b85_ic_tab[(j < 0)? k - 7 : (l < 0)? k + j / 26 * 6 : "!#$%&()*+-;<=>.@^_,{|}~"[l]] = i;
			const char *p_s_src = p_s_base85, *p_s_end = p_s_base85 + n_base85_length;
			for(size_t n_diff, n_rem = n_base85_length; p_s_src < p_s_end;
			   p_s_src += n_diff * 4 + 1, n_rem -= n_diff * 4 + 1)
				n_base85_size += (n_diff = (p_b85_ic_tab[*p_s_src] == 84))? 4 : min(n_rem, size_t(5)) - 1;
		}
		size_t n_prehuff_size = max(n_base85_size, n_data_size);
		size_t n_temp_buffer_size = max(n_prehuff_size + n_huff_stage_size,
			n_data_size * (1 + sizeof(uint32_t)));

		uint8_t *p_temp_buffer, *p_data;
		if(!(p_temp_buffer = new(std::nothrow) uint8_t[n_temp_buffer_size]) ||
		   !(p_data = new(std::nothrow) uint8_t[n_data_size + 1])) {
			if(p_temp_buffer)
				delete[] p_temp_buffer;
			return 0;
		}
		p_data[n_data_size] = 0; // null-terminate the data

		{
			uint8_t *p_dst = p_temp_buffer - 1;
			const char *p_s_src = p_s_base85, *p_s_end = p_s_base85 + n_base85_length;
			for(size_t n_rem = n_base85_length; p_s_src != p_s_end; -- n_rem, ++ p_s_src) {
				if(p_b85_ic_tab[*p_s_src] != 84) {
					uint32_t n_block = uint32_t(min(n_rem, size_t(5))), n_code = 0;
					_ASSERTE(n_block >= 2);
					for(unsigned int i = 0; i < 5; p_s_src += ((++ i < n_block)? 1 : 0))
						n_code = n_code * 85 + ((i < n_block)? p_b85_ic_tab[*p_s_src] : 84);
					for(unsigned int i = 1; i < n_block; ++ i, -- n_rem)
						*(++ p_dst) = n_code >> (8 * (4 - i));
				} else
					*(uint32_t*)((p_dst += 4) - 3) = 0;
			}
		}
		{
			const uint8_t *p_huff_src = p_temp_buffer, *p_huff_end = p_huff_src + n_base85_size;
			_ASSERTE(p_huff_src + 16 * sizeof(int32_t) <= p_huff_end);
			const int32_t *p_code_num = (const int32_t*)p_huff_src;
			int p_max_code[16], p_table_off[16], n_code_num = 0;
			for(int i = 0, n_code_word = 0; i < 16; ++ i, n_code_word <<= 1) {
				p_table_off[i] = (n_code_num += p_code_num[i]) - (n_code_word += p_code_num[i]);
				p_max_code[i] = n_code_word;
			}
			const uint8_t *p_symbol = (p_huff_src += 16 * sizeof(int32_t));
			_ASSERTE(p_huff_src + n_code_num <= p_huff_end);
			p_huff_src += n_code_num - 1;
			uint8_t *p_dest = p_temp_buffer + n_prehuff_size, *p_end = p_dest + n_huff_stage_size;
			for(uint8_t n_byte = 0, n_bit_num = 7; p_dest != p_end; ++ p_dest, n_byte <<= 1) {
				for(int i = 0, n_code = 0;; ++ i, n_byte <<= 1) {
					_ASSERTE(i < 16);
					if(!((++ n_bit_num) & 7)) { // every 8
						_ASSERTE(p_huff_src < p_huff_end);
						n_byte = *(++ p_huff_src);
					}
					n_code = (n_code << 1) | (n_byte >> 7);
					if(n_code < p_max_code[i]) {
						_ASSERTE(n_code >= p_max_code[i] - p_code_num[i]); // n_code >= p_min_code[i]
						*p_dest = p_symbol[n_code + p_table_off[i]];
						break;
					}
				}
			}
		}
		{
			const uint8_t *p_rle_src = p_temp_buffer + n_prehuff_size,
				*p_src_end = p_rle_src + n_huff_stage_size;
			for(uint8_t *p_rle_dest = p_temp_buffer; p_rle_src != p_src_end;) {
				uint8_t n_code = *p_rle_src;
				bool b_compressed = n_code & 1;
				int n_run_length = (n_code >> 1) + 2;
				_ASSERTE(p_rle_src + ((b_compressed)? 2 : n_run_length) <= p_src_end);
				for(; -- n_run_length; ++ p_rle_dest)
					*p_rle_dest = (b_compressed)? p_rle_src[1] : *(++ p_rle_src);
				p_rle_src += int(1 << ((b_compressed)? 1 : 0)); // fix an x64 warning here
			}
		}
		{
			uint8_t p_buckets[256] = {0}; // each bucket value encoded as offset to its index
			uint8_t *p_data = p_temp_buffer, *p_end = p_temp_buffer + n_data_size;
			for(; p_data != p_end; ++ p_data) {
				uint8_t n_index = *p_data;
				*p_data = p_buckets[n_index] + n_index;
				for(int i = n_index; i != 0; -- i)
					p_buckets[i] = p_buckets[i - 1] - 1;
				if(n_index)
					p_buckets[0] = *p_data;
			}
		}
		{
			uint32_t p_buckets[257] = {0}, *p_index_list = (uint32_t*)(p_temp_buffer + n_data_size);
			const uint8_t *p_src = p_temp_buffer, *p_end = p_temp_buffer + n_data_size;
			for(uint32_t *p_dest_idx = p_index_list; p_src != p_end; ++ p_src, ++ p_dest_idx)
				*p_dest_idx = (++ p_buckets[*p_src + 1]) - 1; // start accumulating in bucket 1
 			for(int i = 1; i < 255; ++ i) // exclusive prefix sum
				p_buckets[i + 1] += p_buckets[i];
			uint8_t *p_dest = p_data + n_data_size - 1, *p_begin_1 = p_data - 1;
			for(uint32_t i = n_bwt_primary_index; p_dest != p_begin_1; -- p_dest,
			   i = p_index_list[i] + p_buckets[p_temp_buffer[i]])
				*p_dest = p_temp_buffer[i];
		}
		_ASSERTE(!p_data[n_data_size]); // make sure the terminating null was not overwritten

		delete[] p_temp_buffer;
		
		return p_data;
	}
};

#endif // !__E__MY_PROJECTS_UBERLAME_SRC_GPGPU_KERNELS_SEGSCANREDUCE_C_FILE_IN_HEADER_INCLUDED
