#pragma once
#include "DWTScheme.h"

template <typename Type>
struct SchemesContainer {

    // CDF 5/3
    Type      CDF5_3Sweldens;
    Type      CDF5_3Sweldens4tex;
    Type      CDF5_3Iwahashi;
    Type      CDF5_3Iwahashi4tex;
    Type      CDF5_3IwahashiStar;
    Type      CDF5_3IwahashiStar4tex;
    Type      CDF5_3Explosive;
    Type      CDF5_3Explosive4tex;
    Type      CDF5_3ExplosiveStar;
    Type      CDF5_3ExplosiveStar4tex;
    Type      CDF5_3Monolithic;
    Type      CDF5_3Monolithic4tex;
    Type      CDF5_3MonolithicStar;
    Type      CDF5_3MonolithicStar4tex;
    Type      CDF5_3Polyphase;
    Type      CDF5_3Polyphase4tex;
    Type      CDF5_3PolyphaseStar;
    Type      CDF5_3PolyphaseStar4tex;
    Type      CDF5_3PolyphaseSeparable;
    Type      CDF5_3PolyphaseSeparable4tex;
    Type      CDF5_3PolyphaseSeparableStar;
    Type      CDF5_3PolyphaseSeparableStar4tex;

    // CDF 9/7
    Type      CDF9_7Sweldens;
    Type      CDF9_7Sweldens4tex;
    Type      CDF9_7Iwahashi;
    Type      CDF9_7Iwahashi4tex;
    Type      CDF9_7IwahashiStar;
    Type      CDF9_7IwahashiStar4tex;
    Type      CDF9_7IwahashiStarMM;
    Type      CDF9_7IwahashiStarMM4tex;
    Type      CDF9_7Explosive;
    Type      CDF9_7Explosive4tex;
    Type      CDF9_7ExplosiveStar;
    Type      CDF9_7ExplosiveStar4tex;
    Type      CDF9_7ExplosiveStarMM;
    Type      CDF9_7ExplosiveStarMM4tex;
    Type      CDF9_7Monolithic;
    Type      CDF9_7Monolithic4tex;
    Type      CDF9_7MonolithicStar;
    Type      CDF9_7MonolithicStar4tex;
    Type      CDF9_7Polyphase;
    Type      CDF9_7Polyphase4tex;
    Type      CDF9_7PolyphaseSeparable;
    Type      CDF9_7PolyphaseSeparable4tex;
    Type      CDF9_7PolyphaseStar;
    Type      CDF9_7PolyphaseStar4tex;
    Type      CDF9_7PolyphaseSeparableStar;
    Type      CDF9_7PolyphaseSeparableStar4tex;
    Type      CDF9_7Convolution;
    Type      CDF9_7Convolution4tex;
    Type      CDF9_7ConvolutionStar;
    Type      CDF9_7ConvolutionStar4tex;
    Type      CDF9_7ConvolutionSeparable;
    Type      CDF9_7ConvolutionSeparable4tex;
    Type      CDF9_7ConvolutionSeparableStar;
    Type      CDF9_7ConvolutionSeparableStar4tex;

    // CDF 13/7
    Type      DD13_7Sweldens;
    Type      DD13_7Sweldens4tex;
    Type      DD13_7Iwahashi;
    Type      DD13_7Iwahashi4tex;
    Type      DD13_7IwahashiStar;
    Type      DD13_7IwahashiStar4tex;
    Type      DD13_7Explosive;
    Type      DD13_7Explosive4tex;
    Type      DD13_7ExplosiveStar;
    Type      DD13_7ExplosiveStar4tex;
    Type      DD13_7Monolithic;
    Type      DD13_7Monolithic4tex;
    Type      DD13_7MonolithicStar;
    Type      DD13_7MonolithicStar4tex;
    Type      DD13_7Polyphase;
    Type      DD13_7Polyphase4tex;
    Type      DD13_7PolyphaseStar;
    Type      DD13_7PolyphaseStar4tex;
    Type      DD13_7PolyphaseSeparable;
    Type      DD13_7PolyphaseSeparable4tex;
    Type      DD13_7PolyphaseSeparableStar;
    Type      DD13_7PolyphaseSeparableStar4tex;

    // Schemes count
    const unsigned int count = ( sizeof( SchemesContainer ) - ( sizeof( unsigned int ) ) ) / sizeof( Type );

    // Overloaded [] operator
    inline Type & operator[]( unsigned int index ) {
        if ( index >= count ) {
            throw;
        }
        return reinterpret_cast< Type* >( this )[ index ];
    }
};

template <typename Type>
inline Type InitCheck( Type scheme ) {
    std::wcout << "\t" << scheme->GetName() << std::endl;
    return scheme;
}

template <typename Type, typename ContainerType>
void InitializeContainter( SchemesContainer<ContainerType>& container, std::wstring schemes53File, std::wstring schemes97File, std::wstring schemes137File ) {
    // Render target flags for schemes
    RENDER_TARGET_FLAG rtfSweldens[ 4 ] = {
        G | A, R | B, B | A, R | G,
    };
    RENDER_TARGET_FLAG rtfSweldens97[ 8 ] = {
        G | A, B | A, R | B, R | G,
        G | A, B | A, R | B, R | G,
    };
    RENDER_TARGET_FLAG rtfIwahashi[ 3 ] = {
        A, G | B, R,
    };
    RENDER_TARGET_FLAG rtfIwahashi97[ 6 ] = {
        A, G | B, R,
        A, G | B, R,
    };
    RENDER_TARGET_FLAG rtfIwahashiStar[ 3 ] = {
        A, G | B, R | G | B,
    };
    RENDER_TARGET_FLAG rtfIwahashiStar97[ 6 ] = {
        A, G | B, R | G | B | A,
        A, G | B, R | G | B,
    };
    RENDER_TARGET_FLAG rtfIwahashiStarMM97[ 6 ] = {
        A, G | B, R | G | B,
        A, G | B, R | G | B,
    };
    RENDER_TARGET_FLAG rtfExplosive[ 3 ] = {
        G | B | A, R | A, R | G | B,
    };
    RENDER_TARGET_FLAG rtfExplosive97[ 6 ] = {
        G | B | A, R | A, R | G | B,
        G | B | A, R | A, R | G | B,
    };
    RENDER_TARGET_FLAG rtfExplosiveStarMM97[ 6 ] = {
        G | B | A, R | A, R | G | B,
        G | B | A, R | A, R | G | B,
    };
    RENDER_TARGET_FLAG rtfExplosiveStar97[ 6 ] = {
        G | B | A, R | A, R | G | B | A,
        G | B | A, R | A, R | G | B,
    };
    RENDER_TARGET_FLAG rtfMonolithic[ 2 ] = {
        G | B | A, R | G | B,
    };
    RENDER_TARGET_FLAG rtfMonolithic97[ 4 ] = {
        G | B | A, R | G | B,
        G | B | A, R | G | B,
    };
    RENDER_TARGET_FLAG rtfPolyphase[ 1 ] = {
        R | G | B | A,
    };
    RENDER_TARGET_FLAG rtfPolyphaseSeparable[ 2 ] = {
        R | G | B | A,
        R | G | B | A,
    };
    RENDER_TARGET_FLAG rtfPolyphase97[ 2 ] = {
        R | G | B | A,
        R | G | B | A,
    };
    RENDER_TARGET_FLAG rtfPolyphaseSeparable97[ 4 ] = {
        R | G | B | A,
        R | G | B | A,
        R | G | B | A,
        R | G | B | A,
    };
    RENDER_TARGET_FLAG rtfConvolution97[ 2 ] = {
        R | G | B | A,
        R | G | B | A,
    };
    
    // CDF 5/3
    container.CDF5_3Sweldens.reset( InitCheck( new Type( L"CDF5_3Sweldens", 4, schemes53File ) ) );
    container.CDF5_3Iwahashi.reset( InitCheck( new Type( L"CDF5_3Iwahashi", 3, schemes53File ) ) );
    container.CDF5_3IwahashiStar.reset( InitCheck( new Type( L"CDF5_3IwahashiStar", 3, schemes53File ) ) );
    container.CDF5_3Explosive.reset( InitCheck( new Type( L"CDF5_3Explosive", 3, schemes53File ) ) );
    container.CDF5_3ExplosiveStar.reset( InitCheck( new Type( L"CDF5_3ExplosiveStar", 3, schemes53File ) ) );
    container.CDF5_3Monolithic.reset( InitCheck( new Type( L"CDF5_3Monolithic", 2, schemes53File ) ) );
    container.CDF5_3MonolithicStar.reset( InitCheck( new Type( L"CDF5_3MonolithicStar", 2, schemes53File ) ) );
    container.CDF5_3Polyphase.reset( InitCheck( new Type( L"CDF5_3Polyphase", 1, schemes53File ) ) );
    container.CDF5_3PolyphaseSeparable.reset( InitCheck( new Type( L"CDF5_3PolyphaseSeparable", 2, schemes53File ) ) );
    container.CDF5_3PolyphaseSeparableStar.reset( InitCheck( new Type( L"CDF5_3PolyphaseSeparableStar", 2, schemes53File ) ) );
    container.CDF5_3PolyphaseStar.reset( InitCheck( new Type( L"CDF5_3PolyphaseStar", 1, schemes53File ) ) );
    
    container.CDF5_3Sweldens4tex.reset( InitCheck( new Type( L"CDF5_3Sweldens4tex", 4, schemes53File, rtfSweldens ) ) );
    container.CDF5_3Iwahashi4tex.reset( InitCheck( new Type( L"CDF5_3Iwahashi4tex", 3, schemes53File, rtfIwahashi ) ) );
    container.CDF5_3IwahashiStar4tex.reset( InitCheck( new Type( L"CDF5_3IwahashiStar4tex", 3, schemes53File, rtfIwahashiStar ) ) );
    container.CDF5_3Explosive4tex.reset( InitCheck( new Type( L"CDF5_3Explosive4tex", 3, schemes53File, rtfExplosive ) ) );
    container.CDF5_3ExplosiveStar4tex.reset( InitCheck( new Type( L"CDF5_3ExplosiveStar4tex", 3, schemes53File, rtfExplosive ) ) );
    container.CDF5_3Monolithic4tex.reset( InitCheck( new Type( L"CDF5_3Monolithic4tex", 2, schemes53File, rtfMonolithic ) ) );
    container.CDF5_3MonolithicStar4tex.reset( InitCheck( new Type( L"CDF5_3MonolithicStar4tex", 2, schemes53File, rtfMonolithic ) ) );
    container.CDF5_3Polyphase4tex.reset( InitCheck( new Type( L"CDF5_3Polyphase4tex", 1, schemes53File, rtfPolyphase ) ) );
    container.CDF5_3PolyphaseSeparable4tex.reset( InitCheck( new Type( L"CDF5_3PolyphaseSeparable4tex", 2, schemes53File, rtfPolyphaseSeparable ) ) );
    container.CDF5_3PolyphaseSeparableStar4tex.reset( InitCheck( new Type( L"CDF5_3PolyphaseSeparableStar4tex", 2, schemes53File, rtfPolyphaseSeparable ) ) );
    container.CDF5_3PolyphaseStar4tex.reset( InitCheck( new Type( L"CDF5_3PolyphaseStar4tex", 1, schemes53File, rtfPolyphase ) ) );
    
    // CDF 9/7
    container.CDF9_7Sweldens.reset( InitCheck( new Type( L"CDF9_7Sweldens", 8, schemes97File ) ) );
    container.CDF9_7Iwahashi.reset( InitCheck( new Type( L"CDF9_7Iwahashi", 6, schemes97File ) ) );
    container.CDF9_7IwahashiStar.reset( InitCheck( new Type( L"CDF9_7IwahashiStar", 6, schemes97File ) ) );
    container.CDF9_7IwahashiStarMM.reset( InitCheck( new Type( L"CDF9_7IwahashiStarMM", 6, schemes97File ) ) );
    container.CDF9_7Explosive.reset( InitCheck( new Type( L"CDF9_7Explosive", 6, schemes97File ) ) );
    container.CDF9_7ExplosiveStar.reset( InitCheck( new Type( L"CDF9_7ExplosiveStar", 6, schemes97File ) ) );
    container.CDF9_7ExplosiveStarMM.reset( InitCheck( new Type( L"CDF9_7ExplosiveStarMM", 6, schemes97File ) ) );
    container.CDF9_7Monolithic.reset( InitCheck( new Type( L"CDF9_7Monolithic", 4, schemes97File ) ) );
    container.CDF9_7MonolithicStar.reset( InitCheck( new Type( L"CDF9_7MonolithicStar", 4, schemes97File ) ) );
    container.CDF9_7Polyphase.reset( InitCheck( new Type( L"CDF9_7Polyphase", 2, schemes97File ) ) );
    container.CDF9_7PolyphaseSeparable.reset( InitCheck( new Type( L"CDF9_7PolyphaseSeparable", 4, schemes97File ) ) );
    container.CDF9_7PolyphaseSeparableStar.reset( InitCheck( new Type( L"CDF9_7PolyphaseSeparableStar", 4, schemes97File ) ) );
    container.CDF9_7PolyphaseStar.reset( InitCheck( new Type( L"CDF9_7PolyphaseStar", 2, schemes97File ) ) );
    container.CDF9_7Convolution.reset( InitCheck( new Type( L"CDF9_7Convolution", 1, schemes97File ) ) );
    container.CDF9_7ConvolutionStar.reset( InitCheck( new Type( L"CDF9_7ConvolutionStar", 1, schemes97File ) ) );
    container.CDF9_7ConvolutionSeparable.reset( InitCheck( new Type( L"CDF9_7ConvolutionSeparable", 2, schemes97File ) ) );
    container.CDF9_7ConvolutionSeparableStar.reset( InitCheck( new Type( L"CDF9_7ConvolutionSeparableStar", 2, schemes97File ) ) );

    container.CDF9_7Sweldens4tex.reset( InitCheck( new Type( L"CDF9_7Sweldens4tex", 8, schemes97File, rtfSweldens97 ) ) );
    container.CDF9_7Iwahashi4tex.reset( InitCheck( new Type( L"CDF9_7Iwahashi4tex", 6, schemes97File, rtfIwahashi97 ) ) );
    container.CDF9_7IwahashiStar4tex.reset( InitCheck( new Type( L"CDF9_7IwahashiStar4tex", 6, schemes97File, rtfIwahashiStar97 ) ) );
    container.CDF9_7IwahashiStarMM4tex.reset( InitCheck( new Type( L"CDF9_7IwahashiStarMM4tex", 6, schemes97File, rtfIwahashiStarMM97 ) ) );
    container.CDF9_7Explosive4tex.reset( InitCheck( new Type( L"CDF9_7Explosive4tex", 6, schemes97File, rtfExplosive97 ) ) );
    container.CDF9_7ExplosiveStar4tex.reset( InitCheck( new Type( L"CDF9_7ExplosiveStar4tex", 6, schemes97File, rtfExplosiveStar97 ) ) );
    container.CDF9_7ExplosiveStarMM4tex.reset( InitCheck( new Type( L"CDF9_7ExplosiveStarMM4tex", 6, schemes97File, rtfExplosiveStarMM97 ) ) );
    container.CDF9_7Monolithic4tex.reset( InitCheck( new Type( L"CDF9_7Monolithic4tex", 4, schemes97File, rtfMonolithic97 ) ) );
    container.CDF9_7MonolithicStar4tex.reset( InitCheck( new Type( L"CDF9_7MonolithicStar4tex", 4, schemes97File, rtfMonolithic97 ) ) );
    container.CDF9_7Polyphase4tex.reset( InitCheck( new Type( L"CDF9_7Polyphase4tex", 2, schemes97File, rtfPolyphase97 ) ) );
    container.CDF9_7PolyphaseSeparable4tex.reset( InitCheck( new Type( L"CDF9_7PolyphaseSeparable4tex", 4, schemes97File, rtfPolyphaseSeparable97 ) ) );
    container.CDF9_7PolyphaseSeparableStar4tex.reset( InitCheck( new Type( L"CDF9_7PolyphaseSeparableStar4tex", 4, schemes97File, rtfPolyphaseSeparable97 ) ) );
    container.CDF9_7PolyphaseStar4tex.reset( InitCheck( new Type( L"CDF9_7PolyphaseStar4tex", 2, schemes97File, rtfPolyphase97 ) ) );
    container.CDF9_7Convolution4tex.reset( InitCheck( new Type( L"CDF9_7Convolution4tex", 1, schemes97File, rtfConvolution97 ) ) );
    container.CDF9_7ConvolutionStar4tex.reset( InitCheck( new Type( L"CDF9_7ConvolutionStar4tex", 1, schemes97File, rtfConvolution97 ) ) );
    container.CDF9_7ConvolutionSeparable4tex.reset( InitCheck( new Type( L"CDF9_7ConvolutionSeparable4tex", 2, schemes97File, rtfPolyphase97 ) ) );
    container.CDF9_7ConvolutionSeparableStar4tex.reset( InitCheck( new Type( L"CDF9_7ConvolutionSeparableStar4tex", 2, schemes97File, rtfPolyphase97 ) ) );

    // CDF 13/7
    container.DD13_7Sweldens.reset( InitCheck( new Type( L"DD13_7Sweldens", 4, schemes137File ) ) );
    container.DD13_7Iwahashi.reset( InitCheck( new Type( L"DD13_7Iwahashi", 3, schemes137File ) ) );
    container.DD13_7IwahashiStar.reset( InitCheck( new Type( L"DD13_7IwahashiStar", 3, schemes137File ) ) );
    container.DD13_7Explosive.reset( InitCheck( new Type( L"DD13_7Explosive", 3, schemes137File ) ) );
    container.DD13_7ExplosiveStar.reset( InitCheck( new Type( L"DD13_7ExplosiveStar", 3, schemes137File ) ) );
    container.DD13_7Monolithic.reset( InitCheck( new Type( L"DD13_7Monolithic", 2, schemes137File ) ) );
    container.DD13_7MonolithicStar.reset( InitCheck( new Type( L"DD13_7MonolithicStar", 2, schemes137File ) ) );
    container.DD13_7Polyphase.reset( InitCheck( new Type( L"DD13_7Polyphase", 1, schemes137File ) ) );
    container.DD13_7PolyphaseStar.reset( InitCheck( new Type( L"DD13_7PolyphaseStar", 1, schemes137File ) ) );
    container.DD13_7PolyphaseSeparable.reset( InitCheck( new Type( L"DD13_7PolyphaseSeparable", 2, schemes137File ) ) );
    container.DD13_7PolyphaseSeparableStar.reset( InitCheck( new Type( L"DD13_7PolyphaseSeparableStar", 2, schemes137File ) ) );

    container.DD13_7Sweldens4tex.reset( InitCheck( new Type( L"DD13_7Sweldens4tex", 4, schemes137File, rtfSweldens ) ) );
    container.DD13_7Iwahashi4tex.reset( InitCheck( new Type( L"DD13_7Iwahashi4tex", 3, schemes137File, rtfIwahashi ) ) );
    container.DD13_7IwahashiStar4tex.reset( InitCheck( new Type( L"DD13_7IwahashiStar4tex", 3, schemes137File, rtfIwahashiStar ) ) );
    container.DD13_7Explosive4tex.reset( InitCheck( new Type( L"DD13_7Explosive4tex", 3, schemes137File, rtfExplosive ) ) );
    container.DD13_7ExplosiveStar4tex.reset( InitCheck( new Type( L"DD13_7ExplosiveStar4tex", 3, schemes137File, rtfExplosive ) ) );
    container.DD13_7Monolithic4tex.reset( InitCheck( new Type( L"DD13_7Monolithic4tex", 2, schemes137File, rtfMonolithic ) ) );
    container.DD13_7MonolithicStar4tex.reset( InitCheck( new Type( L"DD13_7MonolithicStar4tex", 2, schemes137File, rtfMonolithic ) ) );
    container.DD13_7Polyphase4tex.reset( InitCheck( new Type( L"DD13_7Polyphase4tex", 1, schemes137File, rtfPolyphase ) ) );
    container.DD13_7PolyphaseStar4tex.reset( InitCheck( new Type( L"DD13_7PolyphaseStar4tex", 1, schemes137File, rtfPolyphase ) ) );
    container.DD13_7PolyphaseSeparable4tex.reset( InitCheck( new Type( L"DD13_7PolyphaseSeparable4tex", 2, schemes137File, rtfPolyphaseSeparable ) ) );
    container.DD13_7PolyphaseSeparableStar4tex.reset( InitCheck( new Type( L"DD13_7PolyphaseSeparableStar4tex", 2, schemes137File, rtfPolyphaseSeparable ) ) );
};