// Constant buffer
cbuffer ConstantBuffer {
    float4 textureResolution;
}

// VS to PS texture coordinates
struct v2f {
    float4 pos : SV_POSITION;
    float2 uv0  : TEXCOORD0;
};

// PS outputs for multiple render targets
struct psOut1 {
    float target0 : SV_Target0;
};

struct psOut2 {
    float target0 : SV_Target0;
    float target1 : SV_Target1;
};

struct psOut3 {
    float target0 : SV_Target0;
    float target1 : SV_Target1;
    float target2 : SV_Target2;
};

struct psOut4 {
    float target0 : SV_Target0;
    float target1 : SV_Target1;
    float target2 : SV_Target2;
    float target3 : SV_Target3;
};

// 1x float4 texture input
Texture2D<float4> texRGBA : register( t0 );

// 4x float texture input
Texture2D<float> texR : register( t0 );
Texture2D<float> texG : register( t1 );
Texture2D<float> texB : register( t2 );
Texture2D<float> texA : register( t3 );

// Texture sampler
SamplerState samp;

// Vertex shader computing texture coordinates
v2f VS( uint VertexID : SV_VertexID ) {
    v2f o;
    o.uv0 = float2( ( VertexID << 1 ) & 2, VertexID & 2 );
    o.pos = float4( o.uv0 * float2( 2.0f, -2.0f ) + float2( -1.0f, 1.0f ), 0.0f, 1.0f );
    return o;
}

// Vertex shader for copying float4 texture
float4 CopyFloat4( v2f i ) : SV_Target{
    return texRGBA.Sample(samp, i.uv0);
}

// Vertex shader for copying 4x float texture
float4 Copy4Tex( v2f i ) : SV_Target{
    float d0r = texR.Sample( samp, i.uv0 );
    float d0g = texG.Sample( samp, i.uv0 );
    float d0b = texB.Sample( samp, i.uv0 );
    float d0a = texA.Sample( samp, i.uv0 );
    return float4(d0r, d0g, d0b, d0a);
}

// Get pseudo random value
float rand( float2 co ) {
    return frac( sin( dot( co.xy, float2( 12.9898, 78.233 ) ) ) * 43758.5453 );
}

// Vertex shader - pseudorandom float4 texture filling
float4 RandomFloat4( v2f i ) : SV_Target{
    return float4( rand( i.uv0 + float2( 1.489, 3.154 ) ),
                   rand( i.uv0 - float2( 7.19, -2.154 ) ),
                   rand( i.uv0 * 1.415 ),
                   rand( i.uv0  * 57.1 - float2( -1.87, -1.47 ) ) );
}

// Vertex shader - pseudorandom 4x float texture filling
psOut4 Random4Tex( v2f i ) {
    psOut4 output;
    output.target0 = rand( i.uv0 + float2( 1.489, 3.154 ) );
    output.target1 = rand( i.uv0 - float2( 7.19, -2.154 ) );
    output.target2 = rand( i.uv0 * 1.415 );
    output.target3 = rand( i.uv0  * 57.1 - float2( -1.87, -1.47 ) );
    return output;
}