#include "base.hlsl"

// DD 13/7 Sweldens
float4 DD13_7SweldensStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    return float4( d0.r, d0.g + 0.0625f * d17.r - 0.5625f * d5.r - 0.5625f * d0.r + 0.0625f * d4.r, d0.b, d0.a + 0.0625f * d17.b - 0.5625f * d5.b - 0.5625f * d0.b + 0.0625f * d4.b );
}

float4 DD13_7SweldensStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    return float4( d0.r - 0.03125f * d5.g + 0.28125f * d0.g + 0.28125f * d4.g - 0.03125f * d16.g, d0.g, d0.b - 0.03125f * d5.a + 0.28125f * d0.a + 0.28125f * d4.a - 0.03125f * d16.a, d0.a );
}

float4 DD13_7SweldensStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    return float4( d0.r, d0.g, d0.b + 0.0625f * d22.r - 0.5625f * d7.r - 0.5625f * d0.r + 0.0625f * d2.r, d0.a + 0.0625f * d22.g - 0.5625f * d7.g - 0.5625f * d0.g + 0.0625f * d2.g );
}

float4 DD13_7SweldensStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    return float4( d0.r - 0.03125f * d7.b + 0.28125f * d0.b + 0.28125f * d2.b - 0.03125f * d11.b, d0.g - 0.03125f * d7.a + 0.28125f * d0.a + 0.28125f * d2.a - 0.03125f * d11.a, d0.b, d0.a );
}

// DD 13/7 Sweldens4tex
psOut2 DD13_7Sweldens4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d4r = texR.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    psOut2 output;
    output.target0 = d0g + 0.0625f * d17r - 0.5625f * d5r - 0.5625f * d0r + 0.0625f * d4r; // g
    output.target1 = d0a + 0.0625f * d17b - 0.5625f * d5b - 0.5625f * d0b + 0.0625f * d4b; // a
    return output;
}

psOut2 DD13_7Sweldens4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );
    float d5g = texG.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );
    float d16g = texG.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    psOut2 output;
    output.target0 = d0r - 0.03125f * d5g + 0.28125f * d0g + 0.28125f * d4g - 0.03125f * d16g; // r
    output.target1 = d0b - 0.03125f * d5a + 0.28125f * d0a + 0.28125f * d4a - 0.03125f * d16a; // b
    return output;
}

psOut2 DD13_7Sweldens4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    psOut2 output;
    output.target0 = d0b + 0.0625f * d22r - 0.5625f * d7r - 0.5625f * d0r + 0.0625f * d2r; // b
    output.target1 = d0a + 0.0625f * d22g - 0.5625f * d7g - 0.5625f * d0g + 0.0625f * d2g; // a
    return output;
}

psOut2 DD13_7Sweldens4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    psOut2 output;
    output.target0 = d0r - 0.03125f * d7b + 0.28125f * d0b + 0.28125f * d2b - 0.03125f * d11b; // r
    output.target1 = d0g - 0.03125f * d7a + 0.28125f * d0a + 0.28125f * d2a - 0.03125f * d11a; // g
    return output;
}

// Iwahashi
float4 DD13_7IwahashiStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    return float4( d0.r, d0.g, d0.b,
        d0.a +
        // PP*
        d24.r * 0.00390625f + d23.r * -0.0351562f + d22.r * -0.0351562f + d21.r * 0.00390625f +
        d19.r * -0.0351562f + d8.r * 0.316406f + d7.r * 0.316406f + d6.r * -0.0351562f +
        d17.r * -0.0351562f + d5.r * 0.316406f + d0.r * 0.316406f + d4.r * -0.0351562f +
        d15.r * 0.00390625f + d3.r * -0.0351562f + d2.r * -0.0351562f + d1.r * 0.00390625f +
        // P*
        d22.g * 0.0625f + d7.g * -0.5625f + d0.g * -0.5625f + d2.g * 0.0625f +
        // P
        d17.b * 0.0625f + d5.b * -0.5625f + d0.b * -0.5625f + d4.b * 0.0625f );
}

float4 DD13_7IwahashiStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    return float4( d0.r, 

        // P
        d17.r * 0.0625f + d5.r * -0.5625f + d0.r * -0.5625f + d4.r * 0.0625f + 

        d0.g +
        // U*
        d7.a * -0.03125f + d0.a * 0.28125f + d2.a * 0.28125f + d11.a * -0.03125f,
        // P*
        d22.r * 0.0625f + d7.r * -0.5625f + d0.r * -0.5625f + d2.r * 0.0625f +

        d0.b +
        // U
        d5.a * -0.03125f + d0.a * 0.28125f + d4.a * 0.28125f + d16.a * -0.03125f,
        
        d0.a );
}

float4 DD13_7IwahashiStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d18 = texRGBA.Sample( samp, uv18 );

    return float4( d0.r +
        // U
        d16.g * -0.03125f + d4.g * 0.28125f + d0.g * 0.28125f + d5.g * -0.03125f +
        // U*
        d7.b * -0.03125f + d0.b * 0.28125f + d2.b * 0.28125f + d11.b * -0.03125f +
        // -UU*
        d8.a * -0.000976562f + d7.a * 0.00878906f + d6.a * 0.00878906f + d18.a * -0.000976562f +
        d5.a * 0.00878906f + d0.a * -0.0791016f + d4.a * -0.0791016f + d16.a * 0.00878906f +
        d3.a * 0.00878906f + d2.a * -0.0791016f + d1.a * -0.0791016f + d14.a * 0.00878906f +
        d12.a * -0.000976562f + d11.a * 0.00878906f + d10.a * 0.00878906f + d9.a * -0.000976562f,

        d0.g, d0.b, d0.a );
}

// Iwahashi4tex
psOut1 DD13_7Iwahashi4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float d15r = texR.Sample( samp, uv15 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d19r = texR.Sample( samp, uv19 );

    float d21r = texR.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    float4 result = float4( 0, 0, 0,
        d0a +
        // PP*
        d24r * 0.00390625f + d23r * -0.0351562f + d22r * -0.0351562f + d21r * 0.00390625f +
        d19r * -0.0351562f + d8r * 0.316406f + d7r * 0.316406f + d6r * -0.0351562f +
        d17r * -0.0351562f + d5r * 0.316406f + d0r * 0.316406f + d4r * -0.0351562f +
        d15r * 0.00390625f + d3r * -0.0351562f + d2r * -0.0351562f + d1r * 0.00390625f +
        // P*
        d22g * 0.0625f + d7g * -0.5625f + d0g * -0.5625f + d2g * 0.0625f +
        // P
        d17b * 0.0625f + d5b * -0.5625f + d0b * -0.5625f + d4b * 0.0625f );

    psOut1 output;
    output.target0 = result.a; // a
    return output;
}

psOut2 DD13_7Iwahashi4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d2a = texA.Sample( samp, uv2 );
    float d2r = texR.Sample( samp, uv2 );

    float d4r = texR.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d7r = texR.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d11a = texA.Sample( samp, uv11 );

    float d16a = texA.Sample( samp, uv16 );

    float d17r = texR.Sample( samp, uv17 );

    float d22r = texR.Sample( samp, uv22 );

    float4 result = float4( 0,

        // P
        d17r * 0.0625f + d5r * -0.5625f + d0r * -0.5625f + d4r * 0.0625f +

        d0g +
        // U*
        d7a * -0.03125f + d0a * 0.28125f + d2a * 0.28125f + d11a * -0.03125f,
        // P*
        d22r * 0.0625f + d7r * -0.5625f + d0r * -0.5625f + d2r * 0.0625f +

        d0b +
        // U
        d5a * -0.03125f + d0a * 0.28125f + d4a * 0.28125f + d16a * -0.03125f,

        0 );

    psOut2 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    return output;
}

psOut1 DD13_7Iwahashi4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3a = texA.Sample( samp, uv3 );

    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5g = texG.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6a = texA.Sample( samp, uv6 );

    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8a = texA.Sample( samp, uv8 );

    float d9a = texA.Sample( samp, uv9 );

    float d10a = texA.Sample( samp, uv10 );

    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12a = texA.Sample( samp, uv12 );

    float d14a = texA.Sample( samp, uv14 );

    float d16g = texG.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d18a = texA.Sample( samp, uv18 );

    float4 result = float4( d0r +
        // U
        d16g * -0.03125f + d4g * 0.28125f + d0g * 0.28125f + d5g * -0.03125f +
        // U*
        d7b * -0.03125f + d0b * 0.28125f + d2b * 0.28125f + d11b * -0.03125f +
        // -UU*
        d8a * -0.000976562f + d7a * 0.00878906f + d6a * 0.00878906f + d18a * -0.000976562f +
        d5a * 0.00878906f + d0a * -0.0791016f + d4a * -0.0791016f + d16a * 0.00878906f +
        d3a * 0.00878906f + d2a * -0.0791016f + d1a * -0.0791016f + d14a * 0.00878906f +
        d12a * -0.000976562f + d11a * 0.00878906f + d10a * 0.00878906f + d9a * -0.000976562f,

        0, 0, 0 );

    psOut1 output;
    output.target0 = result.r; // r
    return output;
}

// IwahashiStar
float4 DD13_7IwahashiStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    return float4( d0.r, d0.g, d0.b,
        d0.a +
        // PP*
        d24.r * 0.00390625f + d23.r * -0.0351562f + d22.r * -0.0351562f + d21.r * 0.00390625f +
        d19.r * -0.0351562f + d8.r * 0.316406f + d7.r * 0.316406f + d6.r * -0.0351562f +
        d17.r * -0.0351562f + d5.r * 0.316406f + d0.r * 0.316406f + d4.r * -0.0351562f +
        d15.r * 0.00390625f + d3.r * -0.0351562f + d2.r * -0.0351562f + d1.r * 0.00390625f +
        // P*
        d22.g * 0.0625f + d7.g * -0.5625f + d0.g * -0.5625f + d2.g * 0.0625f +
        // P
        d17.b * 0.0625f + d5.b * -0.5625f + d0.b * -0.5625f + d4.b * 0.0625f );
}

float4 DD13_7IwahashiStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    return float4( d0.r,

        // P
        d17.r * 0.0625f + d5.r * -0.5625f + d0.r * -0.5625f + d4.r * 0.0625f +

        d0.g +
        // U1*
        d7.a * -0.03125f + d2.a * 0.28125f + d11.a * -0.03125f,
        // P*
        d22.r * 0.0625f + d7.r * -0.5625f + d0.r * -0.5625f + d2.r * 0.0625f +

        d0.b +
        // U1
        d5.a * -0.03125f + d4.a * 0.28125f + d16.a * -0.03125f,

        d0.a );
}

float4 DD13_7IwahashiStarStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d18 = texRGBA.Sample( samp, uv18 );

    float4 result = float4( d0.r +
        // U1
        d16.g * -0.03125f + d4.g * 0.28125f + d5.g * -0.03125f +
        // U1*
        d7.b * -0.03125f + d2.b * 0.28125f + d11.b * -0.03125f +
        // -UU1*
        d8.a * -0.000976562f + d6.a * 0.00878906f + d18.a * -0.000976562f +
        d3.a * 0.00878906f + d1.a * -0.0791016f + d14.a * 0.00878906f +
        d12.a * -0.000976562f + d10.a * 0.00878906f + d9.a * -0.000976562f,

        d0.g, d0.b, d0.a );

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    return result;
}

// IwahashiStar4tex
psOut1 DD13_7IwahashiStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float d15r = texR.Sample( samp, uv15 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d19r = texR.Sample( samp, uv19 );

    float d21r = texR.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    psOut1 output;
    output.target0 = d0a +
        // PP*
        d24r * 0.00390625f + d23r * -0.0351562f + d22r * -0.0351562f + d21r * 0.00390625f +
        d19r * -0.0351562f + d8r * 0.316406f + d7r * 0.316406f + d6r * -0.0351562f +
        d17r * -0.0351562f + d5r * 0.316406f + d0r * 0.316406f + d4r * -0.0351562f +
        d15r * 0.00390625f + d3r * -0.0351562f + d2r * -0.0351562f + d1r * 0.00390625f +
        // P*
        d22g * 0.0625f + d7g * -0.5625f + d0g * -0.5625f + d2g * 0.0625f +
        // P
        d17b * 0.0625f + d5b * -0.5625f + d0b * -0.5625f + d4b * 0.0625f; // a
    return output;
}

psOut2 DD13_7IwahashiStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d2a = texA.Sample( samp, uv2 );
    float d2r = texR.Sample( samp, uv2 );

    float d4r = texR.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d7r = texR.Sample( samp, uv7 );
	float d7a = texA.Sample(samp, uv7);

    float d11a = texA.Sample( samp, uv11 );

    float d16a = texA.Sample( samp, uv16 );

    float d17r = texR.Sample( samp, uv17 );

    float d22r = texR.Sample( samp, uv22 );

    psOut2 output;
    output.target0 =
        // P
        d17r * 0.0625f + d5r * -0.5625f + d0r * -0.5625f + d4r * 0.0625f +

        d0g +
        // U1*
        d7a * -0.03125f + d2a * 0.28125f + d11a * -0.03125f; // g

    output.target1 =
        // P*
        d22r * 0.0625f + d7r * -0.5625f + d0r * -0.5625f + d2r * 0.0625f +

        d0b +
        // U1
        d5a * -0.03125f + d4a * 0.28125f + d16a * -0.03125f; // b
    return output;
}

psOut3 DD13_7IwahashiStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2b = texB.Sample( samp, uv2 );

    float d3a = texA.Sample( samp, uv3 );

    float d4g = texG.Sample( samp, uv4 );

    float d5g = texG.Sample( samp, uv5 );

    float d6a = texA.Sample( samp, uv6 );

    float d7b = texB.Sample( samp, uv7 );

    float d8a = texA.Sample( samp, uv8 );

    float d9a = texA.Sample( samp, uv9 );

    float d10a = texA.Sample( samp, uv10 );

    float d11b = texB.Sample( samp, uv11 );

    float d12a = texA.Sample( samp, uv12 );

    float d14a = texA.Sample( samp, uv14 );

    float d16g = texG.Sample( samp, uv16 );

    float d18a = texA.Sample( samp, uv18 );

    float4 result = float4( d0r +
        // U1
        d16g * -0.03125f + d4g * 0.28125f + d5g * -0.03125f +
        // U1*
        d7b * -0.03125f + d2b * 0.28125f + d11b * -0.03125f +
        // -UU1*
        d8a * -0.000976562f + d6a * 0.00878906f + d18a * -0.000976562f +
        d3a * 0.00878906f + d1a * -0.0791016f + d14a * 0.00878906f +
        d12a * -0.000976562f + d10a * 0.00878906f + d9a * -0.000976562f,

        d0g, d0b, d0a );

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// Explosive
float4 DD13_7ExplosiveStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    return float4( d0.r,
        // P
        d17.r * 0.0625f + d5.r * -0.5625f + d0.r * -0.5625f + d4.r * 0.0625f +

        d0.g,
        // P*
        d22.r * 0.0625f + d7.r * -0.5625f + d0.r * -0.5625f + d2.r * 0.0625f +

        d0.b,
        // -PP*
        d24.r * -0.00390625f + d23.r * 0.0351562f + d22.r * 0.0351562f + d21.r * -0.00390625f +
        d19.r * 0.0351562f + d8.r * -0.316406f + d7.r * -0.316406f + d6.r * 0.0351562f +
        d17.r * 0.0351562f + d5.r * -0.316406f + d0.r * -0.316406f + d4.r * 0.0351562f +
        d15.r * -0.00390625f + d3.r * 0.0351562f + d2.r * 0.0351562f + d1.r * -0.00390625f +

        d0.a );
}

float4 DD13_7ExplosiveStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d22 = texRGBA.Sample( samp, uv22 );

    return float4( d0.r +
        // U
        d16.g * -0.03125f + d4.g * 0.28125f + d0.g * 0.28125f + d5.g * -0.03125f +
        // U*
        d7.b * -0.03125f + d0.b * 0.28125f + d2.b * 0.28125f + d11.b * -0.03125f,
        
        d0.g,
        d0.b,

        // P*
        d22.g * 0.0625f + d7.g * -0.5625f + d0.g * -0.5625f + d2.g * 0.0625f +
        // P
        d17.b * 0.0625f + d5.b * -0.5625f + d0.b * -0.5625f + d4.b * 0.0625f +

        d0.a );
}

float4 DD13_7ExplosiveStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d18 = texRGBA.Sample( samp, uv18 );

    return float4( d0.r +
        // UU*
        d8.a * 0.000976562f + d7.a * -0.00878906f + d6.a * -0.00878906f + d18.a * 0.000976562f +
        d5.a * -0.00878906f + d0.a * 0.0791016f + d4.a * 0.0791016f + d16.a * -0.00878906f +
        d3.a * -0.00878906f + d2.a * 0.0791016f + d1.a * 0.0791016f + d14.a * -0.00878906f +
        d12.a * 0.000976562f + d11.a * -0.00878906f + d10.a * -0.00878906f + d9.a * 0.000976562f,

        d0.g +
        // U*
        d7.a * -0.03125f + d0.a * 0.28125f + d2.a * 0.28125f + d11.a * -0.03125f,

        d0.b +
        // U
        d16.a * -0.03125f + d4.a * 0.28125f + d0.a * 0.28125f + d5.a * -0.03125f,

        d0.a );
}

// Explosive4tex
psOut3 DD13_7Explosive4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float d15r = texR.Sample( samp, uv15 );

    float d17r = texR.Sample( samp, uv17 );

    float d19r = texR.Sample( samp, uv19 );

    float d21r = texR.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    float4 result = float4( 0,
        // P
        d17r * 0.0625f + d5r * -0.5625f + d0r * -0.5625f + d4r * 0.0625f +

        d0g,
        // P*
        d22r * 0.0625f + d7r * -0.5625f + d0r * -0.5625f + d2r * 0.0625f +

        d0b,
        // -PP*
        d24r * -0.00390625f + d23r * 0.0351562f + d22r * 0.0351562f + d21r * -0.00390625f +
        d19r * 0.0351562f + d8r * -0.316406f + d7r * -0.316406f + d6r * 0.0351562f +
        d17r * 0.0351562f + d5r * -0.316406f + d0r * -0.316406f + d4r * 0.0351562f +
        d15r * -0.00390625f + d3r * 0.0351562f + d2r * 0.0351562f + d1r * -0.00390625f +

        d0a );

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;
}

psOut2 DD13_7Explosive4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d2b = texB.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );

    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );

    float d5g = texG.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d7g = texG.Sample( samp, uv7 );
    float d7b = texB.Sample( samp, uv7 );

    float d11b = texB.Sample( samp, uv11 );

    float d16g = texG.Sample( samp, uv16 );

    float d17b = texB.Sample( samp, uv17 );

    float d22g = texG.Sample( samp, uv22 );

    float4 result =  float4( d0r +
        // U
        d16g * -0.03125f + d4g * 0.28125f + d0g * 0.28125f + d5g * -0.03125f +
        // U*
        d7b * -0.03125f + d0b * 0.28125f + d2b * 0.28125f + d11b * -0.03125f,

        0,
        0,

        // P*
        d22g * 0.0625f + d7g * -0.5625f + d0g * -0.5625f + d2g * 0.0625f +
        // P
        d17b * 0.0625f + d5b * -0.5625f + d0b * -0.5625f + d4b * 0.0625f +

        d0a );

    psOut2 output;
    output.target0 = result.r; // r
    output.target1 = result.a; // a
    return output;
}

psOut3 DD13_7Explosive4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2a = texA.Sample( samp, uv2 );

    float d3a = texA.Sample( samp, uv3 );

    float d4a = texA.Sample( samp, uv4 );

    float d5a = texA.Sample( samp, uv5 );

    float d6a = texA.Sample( samp, uv6 );

    float d7a = texA.Sample( samp, uv7 );

    float d8a = texA.Sample( samp, uv8 );

    float d9a = texA.Sample( samp, uv9 );

    float d10a = texA.Sample( samp, uv10 );

    float d11a = texA.Sample( samp, uv11 );

    float d12a = texA.Sample( samp, uv12 );

    float d14a = texA.Sample( samp, uv14 );

    float d16a = texA.Sample( samp, uv16 );

    float d18a = texA.Sample( samp, uv18 );

    float4 result =  float4( d0r +
        // UU*
        d8a * 0.000976562f + d7a * -0.00878906f + d6a * -0.00878906f + d18a * 0.000976562f +
        d5a * -0.00878906f + d0a * 0.0791016f + d4a * 0.0791016f + d16a * -0.00878906f +
        d3a * -0.00878906f + d2a * 0.0791016f + d1a * 0.0791016f + d14a * -0.00878906f +
        d12a * 0.000976562f + d11a * -0.00878906f + d10a * -0.00878906f + d9a * 0.000976562f,

        d0g +
        // U*
        d7a * -0.03125f + d0a * 0.28125f + d2a * 0.28125f + d11a * -0.03125f,

        d0b +
        // U
        d16a * -0.03125f + d4a * 0.28125f + d0a * 0.28125f + d5a * -0.03125f,

        0 );

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// ExplosiveStar
float4 DD13_7ExplosiveStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    return float4(
        // 1
        d0.r,

        // P
        d17.r * 0.0625f + d5.r * -0.5625f + d0.r * -0.5625f + d4.r * 0.0625f +
        // 1
        d0.g,

        // P*
        d22.r * 0.0625f + d7.r * -0.5625f + d0.r * -0.5625f + d2.r * 0.0625f +
        // 1
        d0.b,

        // P0P0*
        d0.r * 0.316406f +
        // - P1P1*
        - (
        d24.r * 0.00390625f + d23.r * -0.0351562f + d21.r * 0.00390625f +
        d19.r * -0.0351562 + d8.r * 0.316406f + d6.r * -0.0351562f +
        d15.r * 0.00390625 + d3.r * -0.0351562f + d1.r * 0.00390625f
        ) +
        // P0*
        d0.g * -0.5625f +
        // P0
        d0.b * -0.5625f +
        // 1
        d0.a );
}

float4 DD13_7ExplosiveStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d22 = texRGBA.Sample( samp, uv22 );

    return float4(
        // 1
        d0.r +
        // U1
        d5.g * -0.03125f + d4.g * 0.28125f + d16.g * -0.03125f +
        // U1*
        d7.b * -0.03125f + d2.b * 0.28125f + d11.b * -0.03125f,

        // 1
        d0.g,

        // 1
        d0.b,

        // P1*
        d22.g * 0.0625f + d7.g * -0.5625f + d2.g * 0.0625f +
        // P1
        d17.b * 0.0625f + d5.b * -0.5625f + d4.b * 0.0625f +
        // 1
        d0.a );
}

float4 DD13_7ExplosiveStarStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d18 = texRGBA.Sample( samp, uv18 );

    float4 result = float4(
        // 1
        d0.r +
        // U1U1*
        d8.a * 0.000976562f + d6.a * -0.00878906f + d18.a * 0.000976562f +
        d3.a * -0.00878906f + d1.a * 0.0791016f + d14.a * -0.00878906f +
        d12.a * 0.000976562f + d10.a * -0.00878906f + d9.a * 0.000976562f,

        // 1
        d0.g +
        // U1*
        d7.a * -0.03125f + d2.a * 0.28125f + d11.a * -0.03125f,

        d0.b +
        // U1
        d5.a * -0.03125f + d4.a * 0.28125f + d16.a * -0.03125f,

        // 1
        d0.a );

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    return result;
}


// ExplosiveStar4tex
psOut3 DD13_7ExplosiveStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float d15r = texR.Sample( samp, uv15 );

    float d17r = texR.Sample( samp, uv17 );

    float d19r = texR.Sample( samp, uv19 );

    float d21r = texR.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    float4 result = float4(
        // 1
        d0r,

        // P
        d17r * 0.0625f + d5r * -0.5625f + d0r * -0.5625f + d4r * 0.0625f +
        // 1
        d0g,

        // P*
        d22r * 0.0625f + d7r * -0.5625f + d0r * -0.5625f + d2r * 0.0625f +
        // 1
        d0b,

        // P0P0*
        d0r * 0.316406f +
        // - P1P1*
        - (
        d24r * 0.00390625f + d23r * -0.0351562f + d21r * 0.00390625f +
        d19r * -0.0351562 + d8r * 0.316406f + d6r * -0.0351562f +
        d15r * 0.00390625 + d3r * -0.0351562f + d1r * 0.00390625f
        ) +
        // P0*
        d0g * -0.5625f +
        // P0
        d0b * -0.5625f +
        // 1
        d0a );

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;
}

psOut2 DD13_7ExplosiveStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d2b = texB.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );

    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );

    float d5g = texG.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d7g = texG.Sample( samp, uv7 );
    float d7b = texB.Sample( samp, uv7 );

    float d11b = texB.Sample( samp, uv11 );

    float d16g = texG.Sample( samp, uv16 );

    float d17b = texB.Sample( samp, uv17 );

    float d22g = texG.Sample( samp, uv22 );

    float4 result = float4(
        // 1
        d0r +
        // U1
        d5g * -0.03125f + d4g * 0.28125f + d16g * -0.03125f +
        // U1*
        d7b * -0.03125f + d2b * 0.28125f + d11b * -0.03125f,

        0,

        0,

        // P1*
        d22g * 0.0625f + d7g * -0.5625f + d2g * 0.0625f +
        // P1
        d17b * 0.0625f + d5b * -0.5625f + d4b * 0.0625f +
        // 1
        d0a );

    psOut2 output;
    output.target0 = result.r; // r
    output.target1 = result.a; // a
    return output;
}

psOut3 DD13_7ExplosiveStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2a = texA.Sample( samp, uv2 );

    float d3a = texA.Sample( samp, uv3 );

    float d4a = texA.Sample( samp, uv4 );

    float d5a = texA.Sample( samp, uv5 );

    float d6a = texA.Sample( samp, uv6 );

    float d7a = texA.Sample( samp, uv7 );

    float d8a = texA.Sample( samp, uv8 );

    float d9a = texA.Sample( samp, uv9 );

    float d10a = texA.Sample( samp, uv10 );

    float d11a = texA.Sample( samp, uv11 );

    float d12a = texA.Sample( samp, uv12 );

    float d14a = texA.Sample( samp, uv14 );

    float d16a = texA.Sample( samp, uv16 );

    float d18a = texA.Sample( samp, uv18 );

    float4 result =  float4(
        // 1
        d0r +
        // U1U1*
        d8a * 0.000976562f + d6a * -0.00878906f + d18a * 0.000976562f +
        d3a * -0.00878906f + d1a * 0.0791016f + d14a * -0.00878906f +
        d12a * 0.000976562f + d10a * -0.00878906f + d9a * 0.000976562f,

        // 1
        d0g +
        // U1*
        d7a * -0.03125f + d2a * 0.28125f + d11a * -0.03125f,

        d0b +
        // U1
        d5a * -0.03125f + d4a * 0.28125f + d16a * -0.03125f,

        // 1
        d0a );

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// DD 13/7 Monolithic
float4 DD13_7MonolithicStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    float4 result;
    result.r = d0.r;
    result.g = d0.g + d0.r * -0.5625f + d4.r * 0.0625f + d5.r * -0.5625f + d17.r * 0.0625f;
    result.b = d0.b + d0.r * -0.5625f + d2.r * 0.0625f + d7.r * -0.5625f + d22.r * 0.0625f;
    result.a = d0.a +

        d0.r * 0.316406f + d1.r * 0.00390625f + d2.r * -0.0351562f + d3.r * -0.0351562f +
        d4.r * -0.0351562f + d5.r * 0.316406f + d6.r * -0.0351562f + d7.r * 0.316406f +
        d8.r * 0.316406f + d15.r * 0.00390625f + d17.r * -0.0351562f + d19.r * -0.0351562f +
        d21.r * 0.00390625f + d22.r * -0.0351562f + d23.r * -0.0351562f + d24.r * 0.00390625f +

        d0.g * -0.5625f + d2.g * 0.0625f + d7.g * -0.5625f + d22.g * 0.0625f +

        d0.b * -0.5625f + d4.b * 0.0625f + d5.b * -0.5625f + d17.b * 0.0625f;
    return result;
}

float4 DD13_7MonolithicStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d18 = texRGBA.Sample( samp, uv18 );

    float4 result;
    result.r = d0.r +

        d0.g * 0.28125f + d4.g * 0.28125f + d5.g * -0.03125f + d16.g * -0.03125f +

        d0.b * 0.28125f + d2.b * 0.28125f + d7.b * -0.03125f + d11.b * -0.03125f +

        d0.a * 0.0791016f + d1.a * 0.0791016f + d2.a * 0.0791016f + d3.a * -0.00878906f +
        d4.a * 0.0791016f + d5.a * -0.00878906f + d6.a * -0.00878906f + d7.a * -0.00878906f +
        d8.a * 0.000976562f + d9.a * 0.000976562f + d10.a * -0.00878906f + d11.a * -0.00878906f +
        d12.a * 0.000976562f + d14.a * -0.00878906f + d16.a * -0.00878906f + d18.a * 0.000976562f;
    result.g = d0.g + d0.a * 0.28125f + d2.a * 0.28125f + d7.a * -0.03125f + d11.a * -0.03125f;
    result.b = d0.b + d0.a * 0.28125f + d4.a * 0.28125f + d5.a * -0.03125f + d16.a * -0.03125f;
    result.a = d0.a;
    return result;
}

// DD 13/7 Monolithic4tex
psOut3 DD13_7Monolithic4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float d15r = texR.Sample( samp, uv15 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d19r = texR.Sample( samp, uv19 );

    float d21r = texR.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    float4 result;
    result.g = d0g + d0r * -0.5625f + d4r * 0.0625f + d5r * -0.5625f + d17r * 0.0625f;
    result.b = d0b + d0r * -0.5625f + d2r * 0.0625f + d7r * -0.5625f + d22r * 0.0625f;
    result.a = d0a +

        d0r * 0.316406f + d1r * 0.00390625f + d2r * -0.0351562f + d3r * -0.0351562f +
        d4r * -0.0351562f + d5r * 0.316406f + d6r * -0.0351562f + d7r * 0.316406f +
        d8r * 0.316406f + d15r * 0.00390625f + d17r * -0.0351562f + d19r * -0.0351562f +
        d21r * 0.00390625f + d22r * -0.0351562f + d23r * -0.0351562f + d24r * 0.00390625f +

        d0g * -0.5625f + d2g * 0.0625f + d7g * -0.5625f + d22g * 0.0625f +

        d0b * -0.5625f + d4b * 0.0625f + d5b * -0.5625f + d17b * 0.0625f;

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;

}

psOut3 DD13_7Monolithic4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2a = texA.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );

    float d3a = texA.Sample( samp, uv3 );

    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5g = texG.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6a = texA.Sample( samp, uv6 );

    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8a = texA.Sample( samp, uv8 );

    float d9a = texA.Sample( samp, uv9 );

    float d10a = texA.Sample( samp, uv10 );

    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12a = texA.Sample( samp, uv12 );


    float d14a = texA.Sample( samp, uv14 );

    float d16g = texG.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d18a = texA.Sample( samp, uv18 );

    float4 result;
    result.r = d0r +

        d0g * 0.28125f + d4g * 0.28125f + d5g * -0.03125f + d16g * -0.03125f +

        d0b * 0.28125f + d2b * 0.28125f + d7b * -0.03125f + d11b * -0.03125f +

        d0a * 0.0791016f + d1a * 0.0791016f + d2a * 0.0791016f + d3a * -0.00878906f +
        d4a * 0.0791016f + d5a * -0.00878906f + d6a * -0.00878906f + d7a * -0.00878906f +
        d8a * 0.000976562f + d9a * 0.000976562f + d10a * -0.00878906f + d11a * -0.00878906f +
        d12a * 0.000976562f + d14a * -0.00878906f + d16a * -0.00878906f + d18a * 0.000976562f;
    result.g = d0g + d0a * 0.28125f + d2a * 0.28125f + d7a * -0.03125f + d11a * -0.03125f;
    result.b = d0b + d0a * 0.28125f + d4a * 0.28125f + d5a * -0.03125f + d16a * -0.03125f;


    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// DD 13/7 MonolithicStar
float4 DD13_7MonolithicStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    float4 result = float4( 
        // 1
        d0.r,

        // P1
        d4.r * 0.0625f + d5.r * -0.5625f + d17.r * 0.0625f
        // 1
        + d0.g,

        // P1*
        d2.r * 0.0625f + d7.r * -0.5625f + d22.r * 0.0625f
        // 1
        +d0.b,

        //P1P1*
        d24.r * 0.00390625f + d23.r * -0.0351562f + d21.r * 0.00390625f +
        d19.r * -0.0351562 + d8.r * 0.316406f + d6.r * -0.0351562f +
        d15.r * 0.00390625 + d3.r * -0.0351562f + d1.r * 0.00390625f +
        // P1*
        d2.g * 0.0625f + d7.g * -0.5625f + d22.g * 0.0625f +
        // P1
        d4.b * 0.0625f + d5.b * -0.5625f + d17.b * 0.0625f +
        // 1
        d0.a );

    result.ga += result.rb * -0.5625f;
    result.ba += result.rg * -0.5625f;

    return result;
}

float4 DD13_7MonolithicStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d18 = texRGBA.Sample( samp, uv18 );


    float4 result = float4(
        // 1
        d0.r +
        // U1
        d5.g * -0.03125f + d4.g * 0.28125f + d16.g * -0.03125f +
        // U1*
        d7.b * -0.03125f + d2.b * 0.28125f + d11.b * -0.03125f +
        // U1U1*
        d8.a * 0.000976562f + d6.a * -0.00878906f + d18.a * 0.000976562f +
        d3.a * -0.00878906f + d1.a * 0.0791016f + d14.a * -0.00878906f +
        d12.a * 0.000976562f + d10.a * -0.00878906f + d9.a * 0.000976562f,

        // 1
        d0.g +
        // U1*
        d7.a * -0.03125f + d2.a * 0.28125f + d11.a * -0.03125f,

        // 1
        d0.b +
        // U1
        d5.a * -0.03125f + d4.a * 0.28125f + d16.a * -0.03125f,

        // 1
        d0.a );

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    return result;
}

// DD 13/7 MonolithicStar4tex
psOut3 DD13_7MonolithicStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float d15r = texR.Sample( samp, uv15 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d19r = texR.Sample( samp, uv19 );

    float d21r = texR.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );


    float4 result = float4(
        // 1
        d0r,

        // P1
        d4r * 0.0625f + d5r * -0.5625f + d17r * 0.0625f
        // 1
        + d0g,

        // P1*
        d2r * 0.0625f + d7r * -0.5625f + d22r * 0.0625f
        // 1
        + d0b,

        //P1P1*
        d24r * 0.00390625f + d23r * -0.0351562f + d21r * 0.00390625f +
        d19r * -0.0351562 + d8r * 0.316406f + d6r * -0.0351562f +
        d15r * 0.00390625 + d3r * -0.0351562f + d1r * 0.00390625f +
        // P1*
        d2g * 0.0625f + d7g * -0.5625f + d22g * 0.0625f +
        // P1
        d4b * 0.0625f + d5b * -0.5625f + d17b * 0.0625f +
        // 1
        d0a );

    result.ga += result.rb * -0.5625f;
    result.ba += result.rg * -0.5625f;

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;

}

psOut3 DD13_7MonolithicStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2a = texA.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );

    float d3a = texA.Sample( samp, uv3 );

    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5g = texG.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6a = texA.Sample( samp, uv6 );

    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8a = texA.Sample( samp, uv8 );

    float d9a = texA.Sample( samp, uv9 );

    float d10a = texA.Sample( samp, uv10 );

    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12a = texA.Sample( samp, uv12 );

    float d14a = texA.Sample( samp, uv14 );

    float d16g = texG.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d18a = texA.Sample( samp, uv18 );

    float4 result = float4(
        // 1
        d0r +
        // U1
        d5g * -0.03125f + d4g * 0.28125f + d16g * -0.03125f +
        // U1*
        d7b * -0.03125f + d2b * 0.28125f + d11b * -0.03125f +
        // U1U1*
        d8a * 0.000976562f + d6a * -0.00878906f + d18a * 0.000976562f +
        d3a * -0.00878906f + d1a * 0.0791016f + d14a * -0.00878906f +
        d12a * 0.000976562f + d10a * -0.00878906f + d9a * 0.000976562f,

        // 1
        d0g +
        // U1*
        d7a * -0.03125f + d2a * 0.28125f + d11a * -0.03125f,

        // 1
        d0b +
        // U1
        d5a * -0.03125f + d4a * 0.28125f + d16a * -0.03125f,

        // 1
        d0a );

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// DD 13/7 Polyphase
float4 DD13_7PolyphaseStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );
    float2 uv25 = i.uv0 + float2( -textureResolution.w, textureResolution.w );
    float2 uv26 = i.uv0 + float2( -textureResolution.z, textureResolution.w );
    float2 uv27 = i.uv0 + float2( -textureResolution.y, textureResolution.w );
    float2 uv28 = i.uv0 + float2( 0.0f, textureResolution.w );
    float2 uv29 = i.uv0 + float2( textureResolution.y, textureResolution.w );
    float2 uv30 = i.uv0 + float2( textureResolution.z, textureResolution.w );
    float2 uv31 = i.uv0 + float2( textureResolution.w, textureResolution.w );
    float2 uv32 = i.uv0 + float2( -textureResolution.w, textureResolution.z );
    float2 uv33 = i.uv0 + float2( textureResolution.w, textureResolution.z );
    float2 uv34 = i.uv0 + float2( -textureResolution.w, textureResolution.y );
    float2 uv35 = i.uv0 + float2( textureResolution.w, textureResolution.y );
    float2 uv36 = i.uv0 + float2( -textureResolution.w, 0.0f );
    float2 uv37 = i.uv0 + float2( textureResolution.w, 0.0f );
    float2 uv38 = i.uv0 + float2( -textureResolution.w, -textureResolution.y );
    float2 uv39 = i.uv0 + float2( textureResolution.w, -textureResolution.y );
    float2 uv40 = i.uv0 + float2( -textureResolution.w, -textureResolution.z );
    float2 uv41 = i.uv0 + float2( textureResolution.w, -textureResolution.z );
    float2 uv42 = i.uv0 + float2( -textureResolution.w, -textureResolution.w );
    float2 uv43 = i.uv0 + float2( -textureResolution.z, -textureResolution.w );
    float2 uv44 = i.uv0 + float2( -textureResolution.y, -textureResolution.w );
    float2 uv45 = i.uv0 + float2( 0.0f, -textureResolution.w );
    float2 uv46 = i.uv0 + float2( textureResolution.y, -textureResolution.w );
    float2 uv47 = i.uv0 + float2( textureResolution.z, -textureResolution.w );
    float2 uv48 = i.uv0 + float2( textureResolution.w, -textureResolution.w );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d13 = texRGBA.Sample( samp, uv13 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d18 = texRGBA.Sample( samp, uv18 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d20 = texRGBA.Sample( samp, uv20 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );
    float4 d25 = texRGBA.Sample( samp, uv25 );
    float4 d26 = texRGBA.Sample( samp, uv26 );
    float4 d27 = texRGBA.Sample( samp, uv27 );
    float4 d28 = texRGBA.Sample( samp, uv28 );
    float4 d29 = texRGBA.Sample( samp, uv29 );
    float4 d30 = texRGBA.Sample( samp, uv30 );
    float4 d31 = texRGBA.Sample( samp, uv31 );
    float4 d32 = texRGBA.Sample( samp, uv32 );
    float4 d33 = texRGBA.Sample( samp, uv33 );
    float4 d34 = texRGBA.Sample( samp, uv34 );
    float4 d35 = texRGBA.Sample( samp, uv35 );
    float4 d36 = texRGBA.Sample( samp, uv36 );
    float4 d37 = texRGBA.Sample( samp, uv37 );
    float4 d38 = texRGBA.Sample( samp, uv38 );
    float4 d39 = texRGBA.Sample( samp, uv39 );
    float4 d40 = texRGBA.Sample( samp, uv40 );
    float4 d41 = texRGBA.Sample( samp, uv41 );
    float4 d42 = texRGBA.Sample( samp, uv42 );
    float4 d43 = texRGBA.Sample( samp, uv43 );
    float4 d44 = texRGBA.Sample( samp, uv44 );
    float4 d45 = texRGBA.Sample( samp, uv45 );
    float4 d46 = texRGBA.Sample( samp, uv46 );
    float4 d47 = texRGBA.Sample( samp, uv47 );
    float4 d48 = texRGBA.Sample( samp, uv48 );

    float4 result;
    result.r =
        // V*V
        d25.r *  3.8147e-6f + d26.r * -6.86646e-5f + d27.r *  0.000240326f + d28.r * -0.00132751f + d29.r *  0.000240326f + d30.r * -6.86646e-5f + d31.r *  3.8147e-6f +
        d32.r * -6.86646e-5f + d9.r *  0.00123596f + d10.r * -0.00432587f + d11.r *  0.0238953f + d12.r * -0.00432587f + d13.r *  0.00123596f + d33.r * -6.86646e-5f +
        d34.r *  0.000240326f + d14.r * -0.00432587f + d1.r *  0.0151405f + d2.r * -0.0836334f + d3.r *  0.0151405f + d15.r * -0.00432587f + d35.r *  0.000240326f +
        d36.r * -0.00132751f + d16.r *  0.0238953f + d4.r * -0.0836334f + d0.r *  0.461975f + d5.r * -0.0836334f + d17.r *  0.0238953f + d37.r * -0.00132751f +
        d38.r *  0.000240326f + d18.r * -0.00432587f + d6.r *  0.0151405f + d7.r * -0.0836334f + d8.r *  0.0151405f + d19.r * -0.00432587f + d39.r *  0.000240326f +
        d40.r * -6.86646e-5f + d20.r *  0.00123596f + d21.r * -0.00432587f + d22.r *  0.0238953f + d23.r * -0.00432587f + d24.r *  0.00123596f + d41.r * -6.86646e-5f +
        d42.r *  3.8147e-6f + d43.r * -6.86646e-5f + d44.r *  0.000240326f + d45.r * -0.00132751f + d46.r *  0.000240326f + d47.r * -6.86646e-5f + d48.r *  3.8147e-6f +

        // V*U
        d26.g *  6.10352e-5f + d27.g * -0.000549316f + d28.g * -0.000549316f + d29.g *  6.10352e-5f +
        d9.g * -0.00109863f + d10.g *  0.0098877f + d11.g *  0.0098877f + d12.g * -0.00109863f +
        d14.g *  0.00384521f + d1.g * -0.0346069f + d2.g * -0.0346069f + d3.g *  0.00384521f +
        d16.g * -0.0212402f + d4.g *  0.191162f + d0.g *  0.191162f + d5.g * -0.0212402f +
        d18.g *  0.00384521f + d6.g * -0.0346069f + d7.g * -0.0346069f + d8.g *  0.00384521f +
        d20.g * -0.00109863f + d21.g *  0.0098877f + d22.g *  0.0098877f + d23.g * -0.00109863f +
        d43.g *  6.10352e-5f + d44.g * -0.000549316f + d45.g * -0.000549316f + d46.g *  6.10352e-5f +

        // U*V
        d32.b *  6.10352e-5f + d9.b * -0.00109863f + d10.b *  0.00384521f + d11.b * -0.0212402f + d12.b *  0.00384521f + d13.b * -0.00109863f + d33.b *  6.10352e-5f +
        d34.b * -0.000549316f + d14.b *  0.0098877f + d1.b * -0.0346069f + d2.b *  0.191162f + d3.b * -0.0346069f + d15.b *  0.0098877f + d35.b * -0.000549316f +
        d36.b * -0.000549316f + d16.b *  0.0098877f + d4.b * -0.0346069f + d0.b *  0.191162f + d5.b * -0.0346069f + d17.b *  0.0098877f + d37.b * -0.000549316f +
        d38.b *  6.10352e-5f + d18.b * -0.00109863f + d6.b *  0.00384521f + d7.b * -0.0212402f + d8.b *  0.00384521f + d19.b * -0.00109863f + d39.b *  6.10352e-5f +

        // U*U
        d9.a *  0.000976562f + d10.a * -0.00878906f + d11.a * -0.00878906f + d12.a *  0.000976562f +
        d14.a * -0.00878906f + d1.a *  0.0791016f + d2.a *  0.0791016f + d3.a * -0.00878906f +
        d16.a * -0.00878906f + d4.a *  0.0791016f + d0.a *  0.0791016f + d5.a * -0.00878906f +
        d18.a *  0.000976562f + d6.a * -0.00878906f + d7.a * -0.00878906f + d8.a *  0.000976562f;

    result.g =
        // V*P
        d27.r * -0.00012207f + d28.r *  0.00109863f + d29.r *  0.00109863f + d30.r * -0.00012207f +
        d10.r *  0.00219727f + d11.r * -0.0197754f + d12.r * -0.0197754f + d13.r *  0.00219727f +
        d1.r * -0.00769043f + d2.r *  0.0692139f + d3.r *  0.0692139f + d15.r * -0.00769043f +
        d4.r *  0.0424805f + d0.r * -0.382324f + d5.r * -0.382324f + d17.r *  0.0424805f +
        d6.r * -0.00769043f + d7.r *  0.0692139f + d8.r *  0.0692139f + d19.r * -0.00769043f +
        d21.r *  0.00219727f + d22.r * -0.0197754f + d23.r * -0.0197754f + d24.r *  0.00123596f +
        d44.r * -0.00012207f + d45.r *  0.00109863f + d46.r *  0.00109863f + d47.r * -0.00012207f +

        // V*
        d28.g * -0.00195312f +
        d11.g *  0.0351562f +
        d2.g * -0.123047f +
        d0.g *  0.679688f +
        d7.g * -0.123047f +
        d22.g *  0.0351562f +
        d45.g * -0.00195312f +

        // U*P
        d10.b * -0.00195312f + d11.b *  0.0175781f + d12.b *  0.0175781f + d13.b * -0.00195312f +
        d1.b *  0.0175781f + d2.b * -0.158203f + d3.b * -0.158203f + d15.b *  0.0175781f +
        d4.b *  0.0175781f + d0.b * -0.158203f + d5.b * -0.158203f + d17.b *  0.0175781f +
        d6.b * -0.00195312f + d7.b *  0.0175781f + d8.b *  0.0175781f + d19.b * -0.00195312f +

        // U*
        d11.a * -0.03125f +
        d2.a *  0.28125f +
        d0.a *  0.28125f +
        d7.a * -0.03125f;
    result.b =
        // P*V
        d34.r * -0.00012207f + d14.r *  0.00219727f + d1.r * -0.00769043f + d2.r *  0.0424805f + d3.r * -0.00769043f + d15.r *  0.00219727f + d35.r * -0.00012207f +
        d36.r *  0.00109863f + d16.r * -0.0197754f + d4.r *  0.0692139f + d0.r * -0.382324f + d5.r *  0.0692139f + d17.r * -0.0197754f + d37.r *  0.00109863f +
        d38.r *  0.00109863f + d18.r * -0.0197754f + d6.r *  0.0692139f + d7.r * -0.382324f + d8.r *  0.0692139f + d19.r * -0.0197754f + d39.r *  0.00109863f +
        d40.r * -0.00012207f + d20.r *  0.00219727f + d21.r * -0.00769043f + d22.r *  0.0424805f + d23.r * -0.00769043f + d24.r *  0.00219727f + d41.r * -0.00012207f +

        // P*U
        d14.g * -0.00195312f + d1.g *  0.0175781f + d2.g *  0.0175781f + d3.g * -0.00195312f +
        d16.g *  0.0175781f + d4.g * -0.158203f + d0.g * -0.158203f + d5.g *  0.0175781f +
        d18.g * 0.0175781f + d6.g * -0.158203f + d7.g * -0.158203f + d8.g *  0.0175781f +
        d20.g * -0.00195312f + d21.g *  0.0175781f + d22.g *  0.0175781f + d23.g * -0.00195312f +

        // V
        d36.b * -0.00195312f + d16.b *  0.0351562f + d4.b * -0.123047f + d0.b *  0.679688f + d5.b * -0.123047f + d17.b *  0.0351562f + d37.b * -0.00195312f +

        // U
        d16.a * -0.03125f + d4.a *  0.28125f + d0.a *  0.28125f + d5.a * -0.03125f;

    result.a =
        // P*P
        d1.r *  0.00390625f + d2.r * -0.0351562f + d3.r * -0.0351562f + d15.r *  0.00390625f +
        d4.r * -0.0351562f + d0.r *  0.316406f + d5.r *  0.316406f + d17.r * -0.0351562f +
        d6.r * -0.0351562f + d7.r *  0.316406f + d8.r *  0.316406f + d19.r * -0.0351562f +
        d21.r *  0.00390625f + d22.r * -0.0351562f + d23.r * -0.0351562f + d24.r *  0.00390625f +

        // P*
        d2.g *  0.0625f +
        d0.g * -0.5625f +
        d7.g * -0.5625f +
        d22.g *  0.0625f +

        // P
        d4.b *  0.0625f + d0.b * -0.5625f + d5.b * -0.5625f + d17.b *  0.0625f +

        // 1
        d0.a;
    return result;
}

// DD 13/7 Polyphase4tex
psOut4 DD13_7Polyphase4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );
    float2 uv25 = i.uv0 + float2( -textureResolution.w, textureResolution.w );
    float2 uv26 = i.uv0 + float2( -textureResolution.z, textureResolution.w );
    float2 uv27 = i.uv0 + float2( -textureResolution.y, textureResolution.w );
    float2 uv28 = i.uv0 + float2( 0.0f, textureResolution.w );
    float2 uv29 = i.uv0 + float2( textureResolution.y, textureResolution.w );
    float2 uv30 = i.uv0 + float2( textureResolution.z, textureResolution.w );
    float2 uv31 = i.uv0 + float2( textureResolution.w, textureResolution.w );
    float2 uv32 = i.uv0 + float2( -textureResolution.w, textureResolution.z );
    float2 uv33 = i.uv0 + float2( textureResolution.w, textureResolution.z );
    float2 uv34 = i.uv0 + float2( -textureResolution.w, textureResolution.y );
    float2 uv35 = i.uv0 + float2( textureResolution.w, textureResolution.y );
    float2 uv36 = i.uv0 + float2( -textureResolution.w, 0.0f );
    float2 uv37 = i.uv0 + float2( textureResolution.w, 0.0f );
    float2 uv38 = i.uv0 + float2( -textureResolution.w, -textureResolution.y );
    float2 uv39 = i.uv0 + float2( textureResolution.w, -textureResolution.y );
    float2 uv40 = i.uv0 + float2( -textureResolution.w, -textureResolution.z );
    float2 uv41 = i.uv0 + float2( textureResolution.w, -textureResolution.z );
    float2 uv42 = i.uv0 + float2( -textureResolution.w, -textureResolution.w );
    float2 uv43 = i.uv0 + float2( -textureResolution.z, -textureResolution.w );
    float2 uv44 = i.uv0 + float2( -textureResolution.y, -textureResolution.w );
    float2 uv45 = i.uv0 + float2( 0.0f, -textureResolution.w );
    float2 uv46 = i.uv0 + float2( textureResolution.y, -textureResolution.w );
    float2 uv47 = i.uv0 + float2( textureResolution.z, -textureResolution.w );
    float2 uv48 = i.uv0 + float2( textureResolution.w, -textureResolution.w );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3g = texG.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );
    float d3a = texA.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5g = texG.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );
    float d6b = texB.Sample( samp, uv6 );
    float d6a = texA.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );
    float d8g = texG.Sample( samp, uv8 );
    float d8b = texB.Sample( samp, uv8 );
    float d8a = texA.Sample( samp, uv8 );

    float d9r = texR.Sample( samp, uv9 );
    float d9g = texG.Sample( samp, uv9 );
    float d9b = texB.Sample( samp, uv9 );
    float d9a = texA.Sample( samp, uv9 );

    float d10r = texR.Sample( samp, uv10 );
    float d10g = texG.Sample( samp, uv10 );
    float d10b = texB.Sample( samp, uv10 );
    float d10a = texA.Sample( samp, uv10 );

    float d11r = texR.Sample( samp, uv11 );
    float d11g = texG.Sample( samp, uv11 );
    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12r = texR.Sample( samp, uv12 );
    float d12g = texG.Sample( samp, uv12 );
    float d12b = texB.Sample( samp, uv12 );
    float d12a = texA.Sample( samp, uv12 );

    float d13r = texR.Sample( samp, uv13 );
    float d13b = texB.Sample( samp, uv13 );

    float d14r = texR.Sample( samp, uv14 );
    float d14g = texG.Sample( samp, uv14 );
    float d14b = texB.Sample( samp, uv14 );
    float d14a = texA.Sample( samp, uv14 );

    float d15r = texR.Sample( samp, uv15 );
    float d15b = texB.Sample( samp, uv15 );

    float d16r = texR.Sample( samp, uv16 );
    float d16g = texG.Sample( samp, uv16 );
    float d16b = texB.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d18r = texR.Sample( samp, uv18 );
    float d18g = texG.Sample( samp, uv18 );
    float d18b = texB.Sample( samp, uv18 );
    float d18a = texA.Sample( samp, uv18 );

    float d19r = texR.Sample( samp, uv19 );
    float d19b = texB.Sample( samp, uv19 );

    float d20r = texR.Sample( samp, uv20 );
    float d20g = texG.Sample( samp, uv20 );

    float d21r = texR.Sample( samp, uv21 );
    float d21g = texG.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );
    float d23g = texG.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    float d25r = texR.Sample( samp, uv25 );

    float d26r = texR.Sample( samp, uv26 );
    float d26g = texG.Sample( samp, uv26 );

    float d27r = texR.Sample( samp, uv27 );
    float d27g = texG.Sample( samp, uv27 );

    float d28r = texR.Sample( samp, uv28 );
    float d28g = texG.Sample( samp, uv28 );

    float d29r = texR.Sample( samp, uv29 );
    float d29g = texG.Sample( samp, uv29 );

    float d30r = texR.Sample( samp, uv30 );

    float d31r = texR.Sample( samp, uv31 );

    float d32r = texR.Sample( samp, uv32 );
    float d32b = texB.Sample( samp, uv32 );

    float d33r = texR.Sample( samp, uv33 );
    float d33b = texB.Sample( samp, uv33 );

    float d34r = texR.Sample( samp, uv34 );
    float d34b = texB.Sample( samp, uv34 );

    float d35r = texR.Sample( samp, uv35 );
    float d35b = texB.Sample( samp, uv35 );

    float d36r = texR.Sample( samp, uv36 );
    float d36b = texB.Sample( samp, uv36 );

    float d37r = texR.Sample( samp, uv37 );
    float d37b = texB.Sample( samp, uv37 );

    float d38r = texR.Sample( samp, uv38 );
    float d38b = texB.Sample( samp, uv38 );

    float d39r = texR.Sample( samp, uv39 );
    float d39b = texB.Sample( samp, uv39 );

    float d40r = texR.Sample( samp, uv40 );

    float d41r = texR.Sample( samp, uv41 );

    float d42r = texR.Sample( samp, uv42 );

    float d43r = texR.Sample( samp, uv43 );
    float d43g = texG.Sample( samp, uv43 );

    float d44r = texR.Sample( samp, uv44 );
    float d44g = texG.Sample( samp, uv44 );

    float d45r = texR.Sample( samp, uv45 );
    float d45g = texG.Sample( samp, uv45 );

    float d46r = texR.Sample( samp, uv46 );
    float d46g = texG.Sample( samp, uv46 );

    float d47r = texR.Sample( samp, uv47 );

    float d48r = texR.Sample( samp, uv48 );

    float4 result;
    result.r =
        // V*V
        d25r *  3.8147e-6f + d26r * -6.86646e-5f + d27r *  0.000240326f + d28r * -0.00132751f + d29r *  0.000240326f + d30r * -6.86646e-5f + d31r *  3.8147e-6f +
        d32r * -6.86646e-5f + d9r *  0.00123596f + d10r * -0.00432587f + d11r *  0.0238953f + d12r * -0.00432587f + d13r *  0.00123596f + d33r * -6.86646e-5f +
        d34r *  0.000240326f + d14r * -0.00432587f + d1r *  0.0151405f + d2r * -0.0836334f + d3r *  0.0151405f + d15r * -0.00432587f + d35r *  0.000240326f +
        d36r * -0.00132751f + d16r *  0.0238953f + d4r * -0.0836334f + d0r *  0.461975f + d5r * -0.0836334f + d17r *  0.0238953f + d37r * -0.00132751f +
        d38r *  0.000240326f + d18r * -0.00432587f + d6r *  0.0151405f + d7r * -0.0836334f + d8r *  0.0151405f + d19r * -0.00432587f + d39r *  0.000240326f +
        d40r * -6.86646e-5f + d20r *  0.00123596f + d21r * -0.00432587f + d22r *  0.0238953f + d23r * -0.00432587f + d24r *  0.00123596f + d41r * -6.86646e-5f +
        d42r *  3.8147e-6f + d43r * -6.86646e-5f + d44r *  0.000240326f + d45r * -0.00132751f + d46r *  0.000240326f + d47r * -6.86646e-5f + d48r *  3.8147e-6f +

        // V*U
        d26g *  6.10352e-5f + d27g * -0.000549316f + d28g * -0.000549316f + d29g *  6.10352e-5f +
        d9g * -0.00109863f + d10g *  0.0098877f + d11g *  0.0098877f + d12g * -0.00109863f +
        d14g *  0.00384521f + d1g * -0.0346069f + d2g * -0.0346069f + d3g *  0.00384521f +
        d16g * -0.0212402f + d4g *  0.191162f + d0g *  0.191162f + d5g * -0.0212402f +
        d18g *  0.00384521f + d6g * -0.0346069f + d7g * -0.0346069f + d8g *  0.00384521f +
        d20g * -0.00109863f + d21g *  0.0098877f + d22g *  0.0098877f + d23g * -0.00109863f +
        d43g *  6.10352e-5f + d44g * -0.000549316f + d45g * -0.000549316f + d46g *  6.10352e-5f +

        // U*V
        d32b *  6.10352e-5f + d9b * -0.00109863f + d10b *  0.00384521f + d11b * -0.0212402f + d12b *  0.00384521f + d13b * -0.00109863f + d33b *  6.10352e-5f +
        d34b * -0.000549316f + d14b *  0.0098877f + d1b * -0.0346069f + d2b *  0.191162f + d3b * -0.0346069f + d15b *  0.0098877f + d35b * -0.000549316f +
        d36b * -0.000549316f + d16b *  0.0098877f + d4b * -0.0346069f + d0b *  0.191162f + d5b * -0.0346069f + d17b *  0.0098877f + d37b * -0.000549316f +
        d38b *  6.10352e-5f + d18b * -0.00109863f + d6b *  0.00384521f + d7b * -0.0212402f + d8b *  0.00384521f + d19b * -0.00109863f + d39b *  6.10352e-5f +

        // U*U
        d9a *  0.000976562f + d10a * -0.00878906f + d11a * -0.00878906f + d12a *  0.000976562f +
        d14a * -0.00878906f + d1a *  0.0791016f + d2a *  0.0791016f + d3a * -0.00878906f +
        d16a * -0.00878906f + d4a *  0.0791016f + d0a *  0.0791016f + d5a * -0.00878906f +
        d18a *  0.000976562f + d6a * -0.00878906f + d7a * -0.00878906f + d8a *  0.000976562f;

    result.g =
        // V*P
        d27r * -0.00012207f + d28r *  0.00109863f + d29r *  0.00109863f + d30r * -0.00012207f +
        d10r *  0.00219727f + d11r * -0.0197754f + d12r * -0.0197754f + d13r *  0.00219727f +
        d1r * -0.00769043f + d2r *  0.0692139f + d3r *  0.0692139f + d15r * -0.00769043f +
        d4r *  0.0424805f + d0r * -0.382324f + d5r * -0.382324f + d17r *  0.0424805f +
        d6r * -0.00769043f + d7r *  0.0692139f + d8r *  0.0692139f + d19r * -0.00769043f +
        d21r *  0.00219727f + d22r * -0.0197754f + d23r * -0.0197754f + d24r *  0.00123596f +
        d44r * -0.00012207f + d45r *  0.00109863f + d46r *  0.00109863f + d47r * -0.00012207f +

        // V*
        d28g * -0.00195312f +
        d11g *  0.0351562f +
        d2g * -0.123047f +
        d0g *  0.679688f +
        d7g * -0.123047f +
        d22g *  0.0351562f +
        d45g * -0.00195312f +

        // U*P
        d10b * -0.00195312f + d11b *  0.0175781f + d12b *  0.0175781f + d13b * -0.00195312f +
        d1b *  0.0175781f + d2b * -0.158203f + d3b * -0.158203f + d15b *  0.0175781f +
        d4b *  0.0175781f + d0b * -0.158203f + d5b * -0.158203f + d17b *  0.0175781f +
        d6b * -0.00195312f + d7b *  0.0175781f + d8b *  0.0175781f + d19b * -0.00195312f +

        // U*
        d11a * -0.03125f +
        d2a *  0.28125f +
        d0a *  0.28125f +
        d7a * -0.03125f;
    result.b =
        // P*V
        d34r * -0.00012207f + d14r *  0.00219727f + d1r * -0.00769043f + d2r *  0.0424805f + d3r * -0.00769043f + d15r *  0.00219727f + d35r * -0.00012207f +
        d36r *  0.00109863f + d16r * -0.0197754f + d4r *  0.0692139f + d0r * -0.382324f + d5r *  0.0692139f + d17r * -0.0197754f + d37r *  0.00109863f +
        d38r *  0.00109863f + d18r * -0.0197754f + d6r *  0.0692139f + d7r * -0.382324f + d8r *  0.0692139f + d19r * -0.0197754f + d39r *  0.00109863f +
        d40r * -0.00012207f + d20r *  0.00219727f + d21r * -0.00769043f + d22r *  0.0424805f + d23r * -0.00769043f + d24r *  0.00219727f + d41r * -0.00012207f +

        // P*U
        d14g * -0.00195312f + d1g *  0.0175781f + d2g *  0.0175781f + d3g * -0.00195312f +
        d16g *  0.0175781f + d4g * -0.158203f + d0g * -0.158203f + d5g *  0.0175781f +
        d18g * 0.0175781f + d6g * -0.158203f + d7g * -0.158203f + d8g *  0.0175781f +
        d20g * -0.00195312f + d21g *  0.0175781f + d22g *  0.0175781f + d23g * -0.00195312f +

        // V
        d36b * -0.00195312f + d16b *  0.0351562f + d4b * -0.123047f + d0b *  0.679688f + d5b * -0.123047f + d17b *  0.0351562f + d37b * -0.00195312f +

        // U
        d16a * -0.03125f + d4a *  0.28125f + d0a *  0.28125f + d5a * -0.03125f;

    result.a =
        // P*P
        d1r *  0.00390625f + d2r * -0.0351562f + d3r * -0.0351562f + d15r *  0.00390625f +
        d4r * -0.0351562f + d0r *  0.316406f + d5r *  0.316406f + d17r * -0.0351562f +
        d6r * -0.0351562f + d7r *  0.316406f + d8r *  0.316406f + d19r * -0.0351562f +
        d21r *  0.00390625f + d22r * -0.0351562f + d23r * -0.0351562f + d24r *  0.00390625f +

        // P*
        d2g *  0.0625f +
        d0g * -0.5625f +
        d7g * -0.5625f +
        d22g *  0.0625f +

        // P
        d4b *  0.0625f + d0b * -0.5625f + d5b * -0.5625f + d17b *  0.0625f +

        // 1
        d0a;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

// PolyphaseStar
float4 DD13_7PolyphaseStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );
    float2 uv25 = i.uv0 + float2( -textureResolution.w, textureResolution.w );
    float2 uv26 = i.uv0 + float2( -textureResolution.z, textureResolution.w );
    float2 uv27 = i.uv0 + float2( -textureResolution.y, textureResolution.w );
    float2 uv28 = i.uv0 + float2( 0.0f, textureResolution.w );
    float2 uv29 = i.uv0 + float2( textureResolution.y, textureResolution.w );
    float2 uv30 = i.uv0 + float2( textureResolution.z, textureResolution.w );
    float2 uv31 = i.uv0 + float2( textureResolution.w, textureResolution.w );
    float2 uv32 = i.uv0 + float2( -textureResolution.w, textureResolution.z );
    float2 uv33 = i.uv0 + float2( textureResolution.w, textureResolution.z );
    float2 uv34 = i.uv0 + float2( -textureResolution.w, textureResolution.y );
    float2 uv35 = i.uv0 + float2( textureResolution.w, textureResolution.y );
    float2 uv36 = i.uv0 + float2( -textureResolution.w, 0.0f );
    float2 uv37 = i.uv0 + float2( textureResolution.w, 0.0f );
    float2 uv38 = i.uv0 + float2( -textureResolution.w, -textureResolution.y );
    float2 uv39 = i.uv0 + float2( textureResolution.w, -textureResolution.y );
    float2 uv40 = i.uv0 + float2( -textureResolution.w, -textureResolution.z );
    float2 uv41 = i.uv0 + float2( textureResolution.w, -textureResolution.z );
    float2 uv42 = i.uv0 + float2( -textureResolution.w, -textureResolution.w );
    float2 uv43 = i.uv0 + float2( -textureResolution.z, -textureResolution.w );
    float2 uv44 = i.uv0 + float2( -textureResolution.y, -textureResolution.w );
    float2 uv45 = i.uv0 + float2( 0.0f, -textureResolution.w );
    float2 uv46 = i.uv0 + float2( textureResolution.y, -textureResolution.w );
    float2 uv47 = i.uv0 + float2( textureResolution.z, -textureResolution.w );
    float2 uv48 = i.uv0 + float2( textureResolution.w, -textureResolution.w );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d13 = texRGBA.Sample( samp, uv13 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d18 = texRGBA.Sample( samp, uv18 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d20 = texRGBA.Sample( samp, uv20 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );
    float4 d25 = texRGBA.Sample( samp, uv25 );
    float4 d26 = texRGBA.Sample( samp, uv26 );
    float4 d27 = texRGBA.Sample( samp, uv27 );
    float4 d28 = texRGBA.Sample( samp, uv28 );
    float4 d29 = texRGBA.Sample( samp, uv29 );
    float4 d30 = texRGBA.Sample( samp, uv30 );
    float4 d31 = texRGBA.Sample( samp, uv31 );
    float4 d32 = texRGBA.Sample( samp, uv32 );
    float4 d33 = texRGBA.Sample( samp, uv33 );
    float4 d34 = texRGBA.Sample( samp, uv34 );
    float4 d35 = texRGBA.Sample( samp, uv35 );
    float4 d36 = texRGBA.Sample( samp, uv36 );
    float4 d37 = texRGBA.Sample( samp, uv37 );
    float4 d38 = texRGBA.Sample( samp, uv38 );
    float4 d39 = texRGBA.Sample( samp, uv39 );
    float4 d40 = texRGBA.Sample( samp, uv40 );
    float4 d41 = texRGBA.Sample( samp, uv41 );
    float4 d42 = texRGBA.Sample( samp, uv42 );
    float4 d43 = texRGBA.Sample( samp, uv43 );
    float4 d44 = texRGBA.Sample( samp, uv44 );
    float4 d45 = texRGBA.Sample( samp, uv45 );
    float4 d46 = texRGBA.Sample( samp, uv46 );
    float4 d47 = texRGBA.Sample( samp, uv47 );
    float4 d48 = texRGBA.Sample( samp, uv48 );

    float4 result;
    result.r = 
        // V@*V@
        + 3.8147e-6f * d48.r
        + -3.43323e-5f * d41.r
        + -6.86646e-5f * d39.r
        + -0.00163651f * d37.r
        + 0.000274658f * d35.r
        + -6.86646e-5f * d33.r
        + 3.8147e-6f * d31.r
        + -3.43323e-5f * d47.r
        + 0.00030899f * d24.r
        + 0.000617981f * d19.r
        + 0.0147285f * d17.r
        + -0.00247192f * d15.r
        + 0.000617981f * d13.r
        + -3.43323e-5f * d30.r
        + -6.86646e-5f * d46.r
        + 0.000617981f * d23.r
        + 0.00123596f * d8.r
        + 0.0294571f * d5.r
        + -0.00494385f * d3.r
        + 0.00123596f * d12.r
        + -6.86646e-5f * d29.r
        + -0.00163651f * d45.r
        + 0.0147285f * d22.r
        + 0.0294571f * d7.r
        + 0.702061f * d0.r
        + -0.117828f * d2.r
        + 0.0294571f * d11.r
        + -0.00163651f * d28.r
        + 0.000274658f * d44.r
        + -0.00247192f * d21.r
        + -0.00494385f * d6.r
        + -0.117828f * d4.r
        + 0.0197754f * d1.r
        + -0.00494385f * d10.r
        + 0.000274658f * d27.r
        + -6.86646e-5f * d43.r
        + 0.000617981f * d20.r
        + 0.00123596f * d18.r
        + 0.0294571f * d16.r
        + -0.00494385f * d14.r
        + 0.00123596f * d9.r
        + -6.86646e-5f * d26.r
        + 3.8147e-6f * d42.r
        + -3.43323e-5f * d40.r
        + -6.86646e-5f * d38.r
        + -0.00163651f * d36.r
        + 0.000274658f * d34.r
        + -6.86646e-5f * d32.r
        + 3.8147e-6f * d25.r

        // V@*U1
        + 6.10352e-5f * d46.g
        + -0.000549316f * d23.g
        + -0.00109863f * d8.g
        + -0.0261841f * d5.g
        + 0.00439453f * d3.g
        + -0.00109863f * d12.g
        + 6.10352e-5f * d29.g
        + -0.000549316f * d44.g
        + 0.00494385f * d21.g
        + 0.0098877f * d6.g
        + 0.235657f * d4.g
        + -0.0395508f * d1.g
        + 0.0098877f * d10.g
        + -0.000549316f * d27.g
        + 6.10352e-5f * d43.g
        + -0.000549316f * d20.g
        + -0.00109863f * d18.g
        + -0.0261841f * d16.g
        + 0.00439453f * d14.g
        + -0.00109863f * d7.g
        + 6.10352e-5f * d26.g

        // U1*V@
        + 6.10352e-5f * d39.b
        + -0.000549316f * d35.b
        + 6.10352e-5f * d33.b
        + -0.000549316f * d19.b
        + 0.00494385f * d15.b
        + -0.000549316f * d13.b
        + -0.00109863f * d8.b
        + 0.0098877f * d3.b
        + -0.00109863f * d12.b
        + -0.0261841f * d7.b
        + 0.235657f * d2.b
        + -0.0261841f * d11.b
        + 0.00439453f * d6.b
        + -0.0395508f * d1.b
        + 0.00439453f * d10.b
        + -0.00109863f * d18.b
        + 0.0098877f * d14.b
        + -0.00109863f * d9.b
        + 6.10352e-5f * d38.b
        + -0.000549316f * d34.b
        + 6.10352e-5f * d32.b

        // U1*U1!
        + 0.000976562f * d8.a
        + -0.00878906f * d6.a
        + 0.000976562f * d18.a
        + -0.00878906f * d3.a
        + 0.0791016f * d1.a
        + -0.00878906f * d14.a
        + 0.000976562f * d12.a
        + -0.00878906f * d10.a
        + 0.000976562f * d9.a;


    result.g =
        // V@*P
        +-0.00012207f * d47.r
        + 0.00109863f * d24.r
        + 0.00219727f * d19.r
        + 0.0523682f * d17.r
        + -0.00878906f * d15.r
        + 0.00219727f * d13.r
        + -0.00012207f * d30.r
        + 0.00109863f * d46.r
        + -0.0098877f * d23.r
        + -0.0197754f * d8.r
        + -0.471313f * d5.r
        + 0.0791016f * d3.r
        + -0.0197754f * d12.r
        + 0.00109863f * d29.r
        + 0.00109863f * d45.r
        + -0.0098877f * d22.r
        + -0.0197754f * d7.r
        + -0.471313f * d0.r
        + 0.0791016f * d2.r
        + -0.0197754f * d11.r
        + 0.00109863f * d28.r
        + -0.00012207f * d44.r
        + 0.00109863f * d21.r
        + 0.00219727f * d6.r
        + 0.0523682f * d4.r
        + -0.00878906f * d1.r
        + 0.00219727f * d10.r
        + -0.00012207f * d27.r

        // V@*
        + -0.00195312f * d45.g
        + 0.0175781f * d22.g
        + 0.0351562f * d7.g
        + 0.837891f * d0.g
        + -0.140625f * d2.g
        + 0.0351562f * d11.g
        + -0.00195312f * d28.g

        // U1*P
        + -0.00195312f * d19.b
        + 0.0175781f * d15.b
        + -0.00195312f * d13.b
        + 0.0175781f * d8.b
        + -0.158203f * d3.b
        + 0.0175781f * d12.b
        + 0.0175781f * d7.b
        + -0.158203f * d2.b
        + 0.0175781f * d11.b
        + -0.00195312f * d6.b
        + 0.0175781f * d1.b
        + -0.00195312f * d10.b

        // U1*
        + -0.03125f * d7.a
        + 0.28125f * d2.a
        + -0.03125f * d11.a;

    result.b =
        // P*V@
        +-0.00012207f * d41.r
        + 0.00109863f * d39.r
        + 0.00109863f * d37.r
        + -0.00012207f * d35.r
        + 0.00109863f * d24.r
        + -0.0098877f * d19.r
        + -0.0098877f * d17.r
        + 0.00109863f * d15.r
        + 0.00219727f * d23.r
        + -0.0197754f * d8.r
        + -0.0197754f * d5.r
        + 0.00219727f * d3.r
        + 0.0523682f * d22.r
        + -0.471313f * d7.r
        + -0.471313f * d0.r
        + 0.0523682f * d2.r
        + -0.00878906f * d21.r
        + 0.0791016f * d6.r
        + 0.0791016f * d4.r
        + -0.00878906f * d1.r
        + 0.00219727f * d20.r
        + -0.0197754f * d18.r
        + -0.0197754f * d16.r
        + 0.00219727f * d14.r
        + -0.00012207f * d40.r
        + 0.00109863f * d38.r
        + 0.00109863f * d36.r
        + -0.00012207f * d34.r

        // P*U1
        + -0.00195312f * d23.g
        + 0.0175781f * d8.g
        + 0.0175781f * d5.g
        + -0.00195312f * d3.g
        + 0.0175781f * d21.g
        + -0.158203f * d6.g
        + -0.158203f * d4.g
        + 0.0175781f * d1.g
        + -0.00195312f * d20.g
        + 0.0175781f * d18.g
        + 0.0175781f * d16.g
        + -0.00195312f * d14.g

        // V@ = (PU1 + 1)
        + -0.00195312f * d37.b
        + 0.0175781f * d17.b
        + 0.0351562f * d5.b
        + 0.837891f * d0.b
        + -0.140625f * d4.b
        + 0.0351562f * d16.b
        + 0.00195312f * d36.b
        
        // U1
        + -0.03125f * d5.a
        + 0.28125f * d4.a
        + -0.03125f * d16.a;

    result.a =
        // P*P
        + 0.00390625f * d24.r
        + -0.0351562f * d23.r
        + -0.0351562f * d22.r
        + 0.00390625f * d21.r
        + -0.0351562f * d19.r
        + 0.316406f * d8.r
        + 0.316406f * d7.r
        + -0.0351562f * d6.r
        + -0.0351562f * d17.r
        + 0.316406f * d5.r
        + 0.316406f * d0.r
        + -0.0351562f * d4.r
        + 0.00390625f * d15.r
        + -0.0351562f * d3.r
        + -0.0351562f * d2.r
        + 0.00390625f * d1.r

        // P*
        + 0.0625f * d22.g
        + -0.5625f * d7.g
        + -0.5625f * d0.g
        + 0.0625f * d2.g

        // P
        + 0.0625f * d17.b
        + -0.5625f * d5.b
        + -0.5625f * d0.b
        + 0.0625f * d4.b

        // 1
        + d0.a;

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    return result;
}

// PolyphaseStar4tex
psOut4 DD13_7PolyphaseStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );
    float2 uv25 = i.uv0 + float2( -textureResolution.w, textureResolution.w );
    float2 uv26 = i.uv0 + float2( -textureResolution.z, textureResolution.w );
    float2 uv27 = i.uv0 + float2( -textureResolution.y, textureResolution.w );
    float2 uv28 = i.uv0 + float2( 0.0f, textureResolution.w );
    float2 uv29 = i.uv0 + float2( textureResolution.y, textureResolution.w );
    float2 uv30 = i.uv0 + float2( textureResolution.z, textureResolution.w );
    float2 uv31 = i.uv0 + float2( textureResolution.w, textureResolution.w );
    float2 uv32 = i.uv0 + float2( -textureResolution.w, textureResolution.z );
    float2 uv33 = i.uv0 + float2( textureResolution.w, textureResolution.z );
    float2 uv34 = i.uv0 + float2( -textureResolution.w, textureResolution.y );
    float2 uv35 = i.uv0 + float2( textureResolution.w, textureResolution.y );
    float2 uv36 = i.uv0 + float2( -textureResolution.w, 0.0f );
    float2 uv37 = i.uv0 + float2( textureResolution.w, 0.0f );
    float2 uv38 = i.uv0 + float2( -textureResolution.w, -textureResolution.y );
    float2 uv39 = i.uv0 + float2( textureResolution.w, -textureResolution.y );
    float2 uv40 = i.uv0 + float2( -textureResolution.w, -textureResolution.z );
    float2 uv41 = i.uv0 + float2( textureResolution.w, -textureResolution.z );
    float2 uv42 = i.uv0 + float2( -textureResolution.w, -textureResolution.w );
    float2 uv43 = i.uv0 + float2( -textureResolution.z, -textureResolution.w );
    float2 uv44 = i.uv0 + float2( -textureResolution.y, -textureResolution.w );
    float2 uv45 = i.uv0 + float2( 0.0f, -textureResolution.w );
    float2 uv46 = i.uv0 + float2( textureResolution.y, -textureResolution.w );
    float2 uv47 = i.uv0 + float2( textureResolution.z, -textureResolution.w );
    float2 uv48 = i.uv0 + float2( textureResolution.w, -textureResolution.w );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3g = texG.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );
    float d3a = texA.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5g = texG.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );
    float d6b = texB.Sample( samp, uv6 );
    float d6a = texA.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );
    float d8g = texG.Sample( samp, uv8 );
    float d8b = texB.Sample( samp, uv8 );
    float d8a = texA.Sample( samp, uv8 );

    float d9r = texR.Sample( samp, uv9 );
    float d9b = texB.Sample( samp, uv9 );
    float d9a = texA.Sample( samp, uv9 );

    float d10r = texR.Sample( samp, uv10 );
    float d10g = texG.Sample( samp, uv10 );
    float d10b = texB.Sample( samp, uv10 );
    float d10a = texA.Sample( samp, uv10 );

    float d11r = texR.Sample( samp, uv11 );
    float d11g = texG.Sample( samp, uv11 );
    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12r = texR.Sample( samp, uv12 );
    float d12g = texG.Sample( samp, uv12 );
    float d12b = texB.Sample( samp, uv12 );
    float d12a = texA.Sample( samp, uv12 );

    float d13r = texR.Sample( samp, uv13 );
    float d13b = texB.Sample( samp, uv13 );

    float d14r = texR.Sample( samp, uv14 );
    float d14g = texG.Sample( samp, uv14 );
    float d14b = texB.Sample( samp, uv14 );
    float d14a = texA.Sample( samp, uv14 );

    float d15r = texR.Sample( samp, uv15 );
    float d15b = texB.Sample( samp, uv15 );

    float d16r = texR.Sample( samp, uv16 );
    float d16g = texG.Sample( samp, uv16 );
    float d16b = texB.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d18r = texR.Sample( samp, uv18 );
    float d18g = texG.Sample( samp, uv18 );
    float d18b = texB.Sample( samp, uv18 );
    float d18a = texA.Sample( samp, uv18 );

    float d19r = texR.Sample( samp, uv19 );
    float d19b = texB.Sample( samp, uv19 );

    float d20r = texR.Sample( samp, uv20 );
    float d20g = texG.Sample( samp, uv20 );

    float d21r = texR.Sample( samp, uv21 );
    float d21g = texG.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );
    float d23g = texG.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    float d25r = texR.Sample( samp, uv25 );

    float d26r = texR.Sample( samp, uv26 );
    float d26g = texG.Sample( samp, uv26 );

    float d27r = texR.Sample( samp, uv27 );
    float d27g = texG.Sample( samp, uv27 );

    float d28r = texR.Sample( samp, uv28 );
    float d28g = texG.Sample( samp, uv28 );

    float d29r = texR.Sample( samp, uv29 );
    float d29g = texG.Sample( samp, uv29 );

    float d30r = texR.Sample( samp, uv30 );

    float d31r = texR.Sample( samp, uv31 );

    float d32r = texR.Sample( samp, uv32 );
    float d32b = texB.Sample( samp, uv32 );

    float d33r = texR.Sample( samp, uv33 );
    float d33b = texB.Sample( samp, uv33 );

    float d34r = texR.Sample( samp, uv34 );
    float d34b = texB.Sample( samp, uv34 );

    float d35r = texR.Sample( samp, uv35 );
    float d35b = texB.Sample( samp, uv35 );

    float d36r = texR.Sample( samp, uv36 );
    float d36b = texB.Sample( samp, uv36 );

    float d37r = texR.Sample( samp, uv37 );
    float d37b = texB.Sample( samp, uv37 );

    float d38r = texR.Sample( samp, uv38 );
    float d38b = texB.Sample( samp, uv38 );

    float d39r = texR.Sample( samp, uv39 );
    float d39b = texB.Sample( samp, uv39 );

    float d40r = texR.Sample( samp, uv40 );

    float d41r = texR.Sample( samp, uv41 );

    float d42r = texR.Sample( samp, uv42 );

    float d43r = texR.Sample( samp, uv43 );
    float d43g = texG.Sample( samp, uv43 );

    float d44r = texR.Sample( samp, uv44 );
    float d44g = texG.Sample( samp, uv44 );

    float d45r = texR.Sample( samp, uv45 );
    float d45g = texG.Sample( samp, uv45 );

    float d46r = texR.Sample( samp, uv46 );
    float d46g = texG.Sample( samp, uv46 );

    float d47r = texR.Sample( samp, uv47 );

    float d48r = texR.Sample( samp, uv48 );
    
    float4 result;
    result.r = 
        // V@*V@
        + 3.8147e-6f * d48r
        + -3.43323e-5f * d41r
        + -6.86646e-5f * d39r
        + -0.00163651f * d37r
        + 0.000274658f * d35r
        + -6.86646e-5f * d33r
        + 3.8147e-6f * d31r
        + -3.43323e-5f * d47r
        + 0.00030899f * d24r
        + 0.000617981f * d19r
        + 0.0147285f * d17r
        + -0.00247192f * d15r
        + 0.000617981f * d13r
        + -3.43323e-5f * d30r
        + -6.86646e-5f * d46r
        + 0.000617981f * d23r
        + 0.00123596f * d8r
        + 0.0294571f * d5r
        + -0.00494385f * d3r
        + 0.00123596f * d12r
        + -6.86646e-5f * d29r
        + -0.00163651f * d45r
        + 0.0147285f * d22r
        + 0.0294571f * d7r
        + 0.702061f * d0r
        + -0.117828f * d2r
        + 0.0294571f * d11r
        + -0.00163651f * d28r
        + 0.000274658f * d44r
        + -0.00247192f * d21r
        + -0.00494385f * d6r
        + -0.117828f * d4r
        + 0.0197754f * d1r
        + -0.00494385f * d10r
        + 0.000274658f * d27r
        + -6.86646e-5f * d43r
        + 0.000617981f * d20r
        + 0.00123596f * d18r
        + 0.0294571f * d16r
        + -0.00494385f * d14r
        + 0.00123596f * d9r
        + -6.86646e-5f * d26r
        + 3.8147e-6f * d42r
        + -3.43323e-5f * d40r
        + -6.86646e-5f * d38r
        + -0.00163651f * d36r
        + 0.000274658f * d34r
        + -6.86646e-5f * d32r
        + 3.8147e-6f * d25r

        // V@*U1
        + 6.10352e-5f * d46g
        + -0.000549316f * d23g
        + -0.00109863f * d8g
        + -0.0261841f * d5g
        + 0.00439453f * d3g
        + -0.00109863f * d12g
        + 6.10352e-5f * d29g
        + -0.000549316f * d44g
        + 0.00494385f * d21g
        + 0.0098877f * d6g
        + 0.235657f * d4g
        + -0.0395508f * d1g
        + 0.0098877f * d10g
        + -0.000549316f * d27g
        + 6.10352e-5f * d43g
        + -0.000549316f * d20g
        + -0.00109863f * d18g
        + -0.0261841f * d16g
        + 0.00439453f * d14g
        + -0.00109863f * d7g
        + 6.10352e-5f * d26g

        // U1*V@
        + 6.10352e-5f * d39b
        + -0.000549316f * d35b
        + 6.10352e-5f * d33b
        + -0.000549316f * d19b
        + 0.00494385f * d15b
        + -0.000549316f * d13b
        + -0.00109863f * d8b
        + 0.0098877f * d3b
        + -0.00109863f * d12b
        + -0.0261841f * d7b
        + 0.235657f * d2b
        + -0.0261841f * d11b
        + 0.00439453f * d6b
        + -0.0395508f * d1b
        + 0.00439453f * d10b
        + -0.00109863f * d18b
        + 0.0098877f * d14b
        + -0.00109863f * d9b
        + 6.10352e-5f * d38b
        + -0.000549316f * d34b
        + 6.10352e-5f * d32b

        // U1*U1!
        + 0.000976562f * d8a
        + -0.00878906f * d6a
        + 0.000976562f * d18a
        + -0.00878906f * d3a
        + 0.0791016f * d1a
        + -0.00878906f * d14a
        + 0.000976562f * d12a
        + -0.00878906f * d10a
        + 0.000976562f * d9a;


    result.g =
        // V@*P
        +-0.00012207f * d47r
        + 0.00109863f * d24r
        + 0.00219727f * d19r
        + 0.0523682f * d17r
        + -0.00878906f * d15r
        + 0.00219727f * d13r
        + -0.00012207f * d30r
        + 0.00109863f * d46r
        + -0.0098877f * d23r
        + -0.0197754f * d8r
        + -0.471313f * d5r
        + 0.0791016f * d3r
        + -0.0197754f * d12r
        + 0.00109863f * d29r
        + 0.00109863f * d45r
        + -0.0098877f * d22r
        + -0.0197754f * d7r
        + -0.471313f * d0r
        + 0.0791016f * d2r
        + -0.0197754f * d11r
        + 0.00109863f * d28r
        + -0.00012207f * d44r
        + 0.00109863f * d21r
        + 0.00219727f * d6r
        + 0.0523682f * d4r
        + -0.00878906f * d1r
        + 0.00219727f * d10r
        + -0.00012207f * d27r

        // V@*
        + -0.00195312f * d45g
        + 0.0175781f * d22g
        + 0.0351562f * d7g
        + 0.837891f * d0g
        + -0.140625f * d2g
        + 0.0351562f * d11g
        + -0.00195312f * d28g

        // U1*P
        + -0.00195312f * d19b
        + 0.0175781f * d15b
        + -0.00195312f * d13b
        + 0.0175781f * d8b
        + -0.158203f * d3b
        + 0.0175781f * d12b
        + 0.0175781f * d7b
        + -0.158203f * d2b
        + 0.0175781f * d11b
        + -0.00195312f * d6b
        + 0.0175781f * d1b
        + -0.00195312f * d10b

        // U1*
        + -0.03125f * d7a
        + 0.28125f * d2a
        + -0.03125f * d11a;

    result.b =
        // P*V@
        +-0.00012207f * d41r
        + 0.00109863f * d39r
        + 0.00109863f * d37r
        + -0.00012207f * d35r
        + 0.00109863f * d24r
        + -0.0098877f * d19r
        + -0.0098877f * d17r
        + 0.00109863f * d15r
        + 0.00219727f * d23r
        + -0.0197754f * d8r
        + -0.0197754f * d5r
        + 0.00219727f * d3r
        + 0.0523682f * d22r
        + -0.471313f * d7r
        + -0.471313f * d0r
        + 0.0523682f * d2r
        + -0.00878906f * d21r
        + 0.0791016f * d6r
        + 0.0791016f * d4r
        + -0.00878906f * d1r
        + 0.00219727f * d20r
        + -0.0197754f * d18r
        + -0.0197754f * d16r
        + 0.00219727f * d14r
        + -0.00012207f * d40r
        + 0.00109863f * d38r
        + 0.00109863f * d36r
        + -0.00012207f * d34r

        // P*U1
        + -0.00195312f * d23g
        + 0.0175781f * d8g
        + 0.0175781f * d5g
        + -0.00195312f * d3g
        + 0.0175781f * d21g
        + -0.158203f * d6g
        + -0.158203f * d4g
        + 0.0175781f * d1g
        + -0.00195312f * d20g
        + 0.0175781f * d18g
        + 0.0175781f * d16g
        + -0.00195312f * d14g

        // V@ = (PU1 + 1)
        + -0.00195312f * d37b
        + 0.0175781f * d17b
        + 0.0351562f * d5b
        + 0.837891f * d0b
        + -0.140625f * d4b
        + 0.0351562f * d16b
        + 0.00195312f * d36b
        
        // U1
        + -0.03125f * d5a
        + 0.28125f * d4a
        + -0.03125f * d16a;

    result.a =
        // P*P
        + 0.00390625f * d24r
        + -0.0351562f * d23r
        + -0.0351562f * d22r
        + 0.00390625f * d21r
        + -0.0351562f * d19r
        + 0.316406f * d8r
        + 0.316406f * d7r
        + -0.0351562f * d6r
        + -0.0351562f * d17r
        + 0.316406f * d5r
        + 0.316406f * d0r
        + -0.0351562f * d4r
        + 0.00390625f * d15r
        + -0.0351562f * d3r
        + -0.0351562f * d2r
        + 0.00390625f * d1r

        // P*
        + 0.0625f * d22g
        + -0.5625f * d7g
        + -0.5625f * d0g
        + 0.0625f * d2g

        // P
        + 0.0625f * d17b
        + -0.5625f * d5b
        + -0.5625f * d0b
        + 0.0625f * d4b

        // 1
        + d0a;

    result.rb += result.ga * 0.28125f;
    result.rg += result.ba * 0.28125f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

// PolyphaseSeparable
float4  DD13_7PolyphaseSeparableStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = i.uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);
    float2 uv28 = i.uv0 + float2(0.0f, textureResolution.w);
    float2 uv45 = i.uv0 + float2(0.0f, -textureResolution.w);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);
    float4 d11 = texRGBA.Sample(samp, uv11);
    float4 d22 = texRGBA.Sample(samp, uv22);
    float4 d28 = texRGBA.Sample(samp, uv28);
    float4 d45 = texRGBA.Sample(samp, uv45);

    float4 result;
    result.r =
        // V*
        d28.r * -0.00195312f +
        d11.r * 0.0351562f +
        d2.r * -0.123047f +
        d0.r * 0.679688f +
        d7.r * -0.123047f +
        d22.r * 0.0351562f +
        d45.r * -0.00195312f +
    
        // U*
        d11.b * -0.03125f +
        d2.b * 0.28125f +
        d0.b * 0.28125f +
        d7.b * -0.03125f;

    result.g =
        // V*
        d28.g * -0.00195312f +
        d11.g * 0.0351562f +
        d2.g * -0.123047f +
        d0.g * 0.679688f +
        d7.g * -0.123047f +
        d22.g * 0.0351562f +
        d45.g * -0.00195312f +
    
        // U*
        d11.a * -0.03125f +
        d2.a * 0.28125f +
        d0.a * 0.28125f +
        d7.a * -0.03125f;

    result.b = 
        // P*
        d2.r * 0.0625f +
        d0.r * -0.5625f +
        d7.r * -0.5625f +
        d22.r * 0.0625f +

        // 1
        + d0.b;

    result.a =
        // P*
        d2.g * 0.0625f +
        d0.g * -0.5625f +
        d7.g * -0.5625f +
        d22.g * 0.0625f +

        // 1
        + d0.a;
    return result;
}

float4  DD13_7PolyphaseSeparableStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = i.uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);
    float2 uv36 = i.uv0 + float2(-textureResolution.w, 0.0f);
    float2 uv37 = i.uv0 + float2(textureResolution.w, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);
    float4 d16 = texRGBA.Sample(samp, uv16);
    float4 d17 = texRGBA.Sample(samp, uv17);
    float4 d36 = texRGBA.Sample(samp, uv36);
    float4 d37 = texRGBA.Sample(samp, uv37);

    float4 result;
    result.r =
        // V
        d36.r * -0.00195312f + 
        d16.r * 0.0351562f + 
        d4.r * -0.123047f + 
        d0.r * 0.679688f + 
        d5.r * -0.123047f + 
        d17.r * 0.0351562f + 
        d37.r * -0.00195312f +

        // U
        d16.g * -0.03125f +
        d4.g * 0.28125f +
        d0.g * 0.28125f +
        d5.g * -0.03125f;

    result.g =
        // P
        d4.r * 0.0625f + 
        d0.r * -0.5625f + 
        d5.r * -0.5625f + 
        d17.r * 0.0625f +

        + d0.g;

    result.b =
        // V
        d36.b * -0.00195312f +
        d16.b * 0.0351562f +
        d4.b * -0.123047f +
        d0.b * 0.679688f +
        d5.b * -0.123047f +
        d17.b * 0.0351562f +
        d37.b * -0.00195312f +

        // U
        d16.a * -0.03125f +
        d4.a * 0.28125f +
        d0.a * 0.28125f +
        d5.a * -0.03125f;


    result.a =
        // P
        d4.b * 0.0625f +
        d0.b * -0.5625f +
        d5.b * -0.5625f +
        d17.b * 0.0625f +

        + d0.a;
    return result;
}

// PolyphaseSeparable4tex
psOut4  DD13_7PolyphaseSeparable4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = i.uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);
    float2 uv28 = i.uv0 + float2(0.0f, textureResolution.w);
    float2 uv45 = i.uv0 + float2(0.0f, -textureResolution.w);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);
    float d7b = texB.Sample(samp, uv7);
    float d7a = texA.Sample(samp, uv7);

    float d11r = texR.Sample(samp, uv11);
    float d11g = texG.Sample(samp, uv11);
    float d11b = texB.Sample(samp, uv11);
    float d11a = texA.Sample(samp, uv11);

    float d22r = texR.Sample(samp, uv22);
    float d22g = texG.Sample(samp, uv22);

    float d28r = texR.Sample(samp, uv28);
    float d28g = texG.Sample(samp, uv28);

    float d45r = texR.Sample(samp, uv45);
    float d45g = texG.Sample(samp, uv45);

    psOut4 result;
    result.target0 =
        // V*
        d28r * -0.00195312f +
        d11r * 0.0351562f +
        d2r * -0.123047f +
        d0r * 0.679688f +
        d7r * -0.123047f +
        d22r * 0.0351562f +
        d45r * -0.00195312f +
    
        // U*
        d11b * -0.03125f +
        d2b * 0.28125f +
        d0b * 0.28125f +
        d7b * -0.03125f;

    result.target1 =
        // V*
        d28g * -0.00195312f +
        d11g * 0.0351562f +
        d2g * -0.123047f +
        d0g * 0.679688f +
        d7g * -0.123047f +
        d22g * 0.0351562f +
        d45g * -0.00195312f +
    
        // U*
        d11a * -0.03125f +
        d2a * 0.28125f +
        d0a * 0.28125f +
        d7a * -0.03125f;

    result.target2 =
        // P*
        d2r * 0.0625f +
        d0r * -0.5625f +
        d7r * -0.5625f +
        d22r * 0.0625f +

        // 1
        +d0b;

    result.target3 =
        // P*
        d2g * 0.0625f +
        d0g * -0.5625f +
        d7g * -0.5625f +
        d22g * 0.0625f +

        // 1
        +d0a;
    return result;
}

psOut4  DD13_7PolyphaseSeparable4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = i.uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);
    float2 uv36 = i.uv0 + float2(-textureResolution.w, 0.0f);
    float2 uv37 = i.uv0 + float2(textureResolution.w, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5g = texG.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);
    float d5a = texA.Sample(samp, uv5);

    float d16r = texR.Sample(samp, uv16);
    float d16g = texG.Sample(samp, uv16);
    float d16b = texB.Sample(samp, uv16);
    float d16a = texA.Sample(samp, uv16);

    float d17r = texR.Sample(samp, uv17);
    float d17b = texB.Sample(samp, uv17);

    float d36r = texR.Sample(samp, uv36);
    float d36b = texB.Sample(samp, uv36);

    float d37r = texR.Sample(samp, uv37);
    float d37b = texB.Sample(samp, uv37);

    psOut4 result;
    result.target0 =
        // V
        d36r * -0.00195312f +
        d16r * 0.0351562f +
        d4r * -0.123047f +
        d0r * 0.679688f +
        d5r * -0.123047f +
        d17r * 0.0351562f +
        d37r * -0.00195312f +

        // U
        d16g * -0.03125f +
        d4g * 0.28125f +
        d0g * 0.28125f +
        d5g * -0.03125f;

    result.target1 =
        // P
        d4r * 0.0625f +
        d0r * -0.5625f +
        d5r * -0.5625f +
        d17r * 0.0625f +

        +d0g;

    result.target2 =
        // V
        d36b * -0.00195312f +
        d16b * 0.0351562f +
        d4b * -0.123047f +
        d0b * 0.679688f +
        d5b * -0.123047f +
        d17b * 0.0351562f +
        d37b * -0.00195312f +

        // U
        d16a * -0.03125f +
        d4a * 0.28125f +
        d0a * 0.28125f +
        d5a * -0.03125f;

    result.target3 =
        // P
        d4b * 0.0625f +
        d0b * -0.5625f +
        d5b * -0.5625f +
        d17b * 0.0625f +

        +d0a;
    return result;
}

// PolyphaseSeparableStar
float4 DD13_7PolyphaseSeparableStarStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = i.uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);
    float2 uv36 = i.uv0 + float2(-textureResolution.w, 0.0f);
    float2 uv37 = i.uv0 + float2(textureResolution.w, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);
    float4 d16 = texRGBA.Sample(samp, uv16);
    float4 d17 = texRGBA.Sample(samp, uv17);
    float4 d36 = texRGBA.Sample(samp, uv36);
    float4 d37 = texRGBA.Sample(samp, uv37);

    float4 result;
    result.r =
        // V
        d36.r * -0.00195312f +
        d16.r * 0.0351562f +
        d4.r * -0.140625f +
        d0.r * 0.837891f +
        d5.r * 0.0351562f +
        d17.r * 0.0175781f +
        d37.r * -0.00195312f +

        // U1
        d16.g * -0.03125f +
        d4.g * 0.28125f +
        d5.g * -0.03125f;

    result.g =
        // P
        d4.r * 0.0625f +
        d0.r * -0.5625f +
        d5.r * -0.5625f +
        d17.r * 0.0625f +

        +d0.g;

    result.b =
        // V
        d36.b * -0.00195312f +
        d16.b * 0.0351562f +
        d4.b * -0.140625f +
        d0.b * 0.837891f +
        d5.b * 0.0351562f +
        d17.b * 0.0175781f +
        d37.b * -0.00195312f +

        // U1
        d16.a * -0.03125f +
        d4.a * 0.28125f +
        d5.a * -0.03125f;


    result.a =
        // P
        d4.b * 0.0625f +
        d0.b * -0.5625f +
        d5.b * -0.5625f +
        d17.b * 0.0625f +

        +d0.a;

    result.rb += result.ga * 0.28125f;
    result.ba += result.rg * -0.5625f;

    return result;
}

float4 DD13_7PolyphaseSeparableStarStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = i.uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);
    float2 uv28 = i.uv0 + float2(0.0f, textureResolution.w);
    float2 uv45 = i.uv0 + float2(0.0f, -textureResolution.w);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);
    float4 d11 = texRGBA.Sample(samp, uv11);
    float4 d22 = texRGBA.Sample(samp, uv22);
    float4 d28 = texRGBA.Sample(samp, uv28);
    float4 d45 = texRGBA.Sample(samp, uv45);

    float4 result;
    result.r =
        // V*
        d28.r * -0.00195312f +
        d11.r * 0.0175781f +
        d2.r * 0.0175781f +
        d0.r * 0.837891f +
        d7.r * 0.0175781f +
        d22.r * 0.0175781f +
        d45.r * -0.00195312f +

        // U1*
        d11.b * -0.03125f +
        d2.b * 0.28125f +
        d7.b * -0.03125f;

    result.g =
        // V*
        d28.g * -0.00195312f +
        d11.g * 0.0175781f +
        d2.g * 0.0175781f +
        d0.g * 0.837891f +
        d7.g * 0.0175781f +
        d22.g * 0.0175781f +
        d45.g * -0.00195312f +
    
        // U1*
        d11.a * -0.03125f +
        d2.a * 0.28125f +
        d7.a * -0.03125f;

    result.b =
        // P1*
        d2.r * 0.0625f +
        d7.r * -0.5625f +
        d22.r * 0.0625f +

        // 1
        +d0.b;

    result.a =
        // P1*
        d2.g * 0.0625f +
        d7.g * -0.5625f +
        d22.g * 0.0625f +

        // 1
        +d0.a;

    result.rg += result.ba * 0.28125f;

    return result;
}

// PolyphaseSeparableStar4tex
psOut4 DD13_7PolyphaseSeparableStar4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = i.uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = i.uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);
    float2 uv36 = i.uv0 + float2(-textureResolution.w, 0.0f);
    float2 uv37 = i.uv0 + float2(textureResolution.w, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5g = texG.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);
    float d5a = texA.Sample(samp, uv5);

    float d16r = texR.Sample(samp, uv16);
    float d16g = texG.Sample(samp, uv16);
    float d16b = texB.Sample(samp, uv16);
    float d16a = texA.Sample(samp, uv16);

    float d17r = texR.Sample(samp, uv17);
    float d17b = texB.Sample(samp, uv17);

    float d36r = texR.Sample(samp, uv36);
    float d36b = texB.Sample(samp, uv36);

    float d37r = texR.Sample(samp, uv37);
    float d37b = texB.Sample(samp, uv37);

    float4 result;
    result.r =
        // V
        d36r * -0.00195312f +
        d16r * 0.0351562f +
        d4r * -0.140625f +
        d0r * 0.837891f +
        d5r * 0.0351562f +
        d17r * 0.0175781f +
        d37r * -0.00195312f +

        // U1
        d16g * -0.03125f +
        d4g * 0.28125f +
        d5g * -0.03125f;

    result.g =
        // P
        d4r * 0.0625f +
        d0r * -0.5625f +
        d5r * -0.5625f +
        d17r * 0.0625f +

        +d0g;

    result.b =
        // V
        d36b * -0.00195312f +
        d16b * 0.0351562f +
        d4b * -0.140625f +
        d0b * 0.837891f +
        d5b * 0.0351562f +
        d17b * 0.0175781f +
        d37b * -0.00195312f +

        // U1
        d16a * -0.03125f +
        d4a * 0.28125f +
        d5a * -0.03125f;

    result.a =
        // P
        d4b * 0.0625f +
        d0b * -0.5625f +
        d5b * -0.5625f +
        d17b * 0.0625f +

        +d0a;

    result.rb += result.ga * 0.28125f;
    result.ba += result.rg * -0.5625f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

psOut4 DD13_7PolyphaseSeparableStar4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = i.uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = i.uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);
    float2 uv28 = i.uv0 + float2(0.0f, textureResolution.w);
    float2 uv45 = i.uv0 + float2(0.0f, -textureResolution.w);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);
    float d7b = texB.Sample(samp, uv7);
    float d7a = texA.Sample(samp, uv7);

    float d11r = texR.Sample(samp, uv11);
    float d11g = texG.Sample(samp, uv11);
    float d11b = texB.Sample(samp, uv11);
    float d11a = texA.Sample(samp, uv11);

    float d22r = texR.Sample(samp, uv22);
    float d22g = texG.Sample(samp, uv22);

    float d28r = texR.Sample(samp, uv28);
    float d28g = texG.Sample(samp, uv28);

    float d45r = texR.Sample(samp, uv45);
    float d45g = texG.Sample(samp, uv45);

    float4 result;
    result.r =
        // V*
        d28r * -0.00195312f +
        d11r * 0.0175781f +
        d2r * 0.0175781f +
        d0r * 0.837891f +
        d7r * 0.0175781f +
        d22r * 0.0175781f +
        d45r * -0.00195312f +
    
        // U1*
        d11b * -0.03125f +
        d2b * 0.28125f +
        d7b * -0.03125f;

    result.g =
        // V*
        d28g * -0.00195312f +
        d11g * 0.0175781f +
        d2g * 0.0175781f +
        d0g * 0.837891f +
        d7g * 0.0175781f +
        d22g * 0.0175781f +
        d45g * -0.00195312f +
    
        // U1*
        d11a * -0.03125f +
        d2a * 0.28125f +
        d7a * -0.03125f;

    result.b =
        // P1*
        d2r * 0.0625f +
        d7r * -0.5625f +
        d22r * 0.0625f +

        // 1
        +d0b;

    result.a =
        // P1*
        d2g * 0.0625f +
        d7g * -0.5625f +
        d22g * 0.0625f +

        // 1
        +d0a;

    result.rg += result.ba * 0.28125f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}
