#include "CDF53.hlsl"

// CDF 9/7 Sweldens
float4 CDF9_7SweldensStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    return float4(d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f , d0.b, d0.a + d0.b * -1.58613f + d5.b * -1.58613f);
}

float4 CDF9_7SweldensStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4(d0.r, d0.g, d0.b + d0.r * -1.58613f + d7.r * -1.58613f, d0.a + d0.g * -1.58613f + d7.g * -1.58613f);
}

float4 CDF9_7SweldensStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4(d0.r + d0.g * -0.0529801f + d4.g * -0.0529801f, d0.g, d0.b + d0.a * -0.0529801f + d4.a * -0.0529801f, d0.a);
}

float4 CDF9_7SweldensStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    return float4(d0.r + d0.b * -0.0529801f + d2.b * -0.0529801f, d0.g + d0.a * -0.0529801f + d2.a * -0.0529801f, d0.b, d0.a);
}

float4 CDF9_7SweldensStep5( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    return float4(d0.r, d0.g + d0.r * 0.882911f + d5.r * 0.882911f , d0.b, d0.a + d0.b * 0.882911f + d5.b * 0.882911f);
}

float4 CDF9_7SweldensStep6( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4(d0.r, d0.g, d0.b + d0.r * 0.882911f + d7.r * 0.882911f, d0.a + d0.g * 0.882911f + d7.g * 0.882911f);
}

float4 CDF9_7SweldensStep7( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4(d0.r + d0.g * 0.443507f + d4.g * 0.443507f, d0.g, d0.b + d0.a * 0.443507f + d4.a * 0.443507f, d0.a);
}

float4 CDF9_7SweldensStep8( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    return float4(d0.r + d0.b * 0.443507f + d2.b * 0.443507f, d0.g + d0.a * 0.443507f + d2.a * 0.443507f, d0.b, d0.a);
}

// Sweldens4tex
psOut2 CDF9_7Sweldens4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    psOut2 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f; // g
    output.target1 = d0a + d0b * -1.58613f + d5b * -1.58613f; // a
    return output;
}

psOut2 CDF9_7Sweldens4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0b + d0r * -1.58613f + d7r * -1.58613f; // b
    output.target1 = d0a + d0g * -1.58613f + d7g * -1.58613f; // a
    return output;
}

psOut2 CDF9_7Sweldens4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    psOut2 output;
    output.target0 = d0r + d0g * -0.0529801f + d4g * -0.0529801f; // r
    output.target1 = d0b + d0a * -0.0529801f + d4a * -0.0529801f; // b
    return output;
}

psOut2 CDF9_7Sweldens4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    psOut2 output;
    output.target0 = d0r + d0b * -0.0529801f + d2b * -0.0529801f; // r
    output.target1 = d0g + d0a * -0.0529801f + d2a * -0.0529801f; // g
    return output;
}

psOut2 CDF9_7Sweldens4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    psOut2 output;
    output.target0 = d0g + d0r * 0.882911f + d5r * 0.882911f; // g
    output.target1 = d0a + d0b * 0.882911f + d5b * 0.882911f; // a
    return output;
}

psOut2 CDF9_7Sweldens4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0b + d0r * 0.882911f + d7r * 0.882911f; // b
    output.target1 = d0a + d0g * 0.882911f + d7g * 0.882911f; // a
    return output;
}

psOut2 CDF9_7Sweldens4texStep7( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    psOut2 output;
    output.target0 = d0r + d0g * 0.443507f + d4g * 0.443507f; // r
    output.target1 = d0b + d0a * 0.443507f + d4a * 0.443507f; // b
    return output;
}

psOut2 CDF9_7Sweldens4texStep8( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    psOut2 output;
    output.target0 = d0r + d0b * 0.443507f + d2b * 0.443507f; // r
    output.target1 = d0g + d0a * 0.443507f + d2a * 0.443507f; // g
    return output;
}

// Iwahashi
float4 CDF9_7IwahashiStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * -1.58613f + d5.b * -1.58613f + d0.g * -1.58613f + d7.g * -1.58613f + d0.r * 2.51582f + d5.r * 2.51582f + d7.r * 2.51582f + d8.r * 2.51582f );
}

float4 CDF9_7IwahashiStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f + d0.a * -0.0529801f + d2.a * -0.0529801f, d0.b + d0.a * -0.0529801f + d4.a * -0.0529801f + d0.r  * -1.58613f + d7.r * -1.58613f, d0.a );
}

float4 CDF9_7IwahashiStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * -0.00280689f + d1.a * -0.00280689f + d2.a* -0.00280689f + d4.a * -0.00280689f + d0.g * -0.0529801f + d4.g * -0.0529801f + d0.b  * -0.0529801f + d2.b * -0.0529801f, d0.g, d0.b, d0.a );

}

float4 CDF9_7IwahashiStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * 0.882911f + d5.b * 0.882911f + d0.g * 0.882911f + d7.g * 0.882911f + d0.r *  0.779532f + d5.r *  0.779532f + d7.r *  0.779532f + d8.r *  0.779532f );
}

float4 CDF9_7IwahashiStep5( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * 0.882911f + d5.r * 0.882911f + d0.a *  0.443507f + d2.a *  0.443507f, d0.b + d0.a *  0.443507f + d4.a *  0.443507f + d0.r  * 0.882911f + d7.r * 0.882911f, d0.a );
}

float4 CDF9_7IwahashiStep6( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * -0.196698f + d1.a * -0.196698f + d2.a* -0.196698f + d4.a * -0.196698f + d0.g *  0.443507f + d4.g *  0.443507f + d0.b  *  0.443507f + d2.b *  0.443507f, d0.g, d0.b, d0.a );
}

// Iwahashi4tex
psOut1 CDF9_7Iwahashi4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * -1.58613f + d5b * -1.58613f + d0g * -1.58613f + d7g * -1.58613f + d0r  * 2.51582f + d5r  * 2.51582f + d7r * 2.51582f + d8r * 2.51582f; // a
    return output;
}

psOut2 CDF9_7Iwahashi4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f + d0a * -0.0529801f + d2a * -0.0529801f; // g
    output.target1 = d0b + d0a * -0.0529801f + d4a * -0.0529801f + d0r * -1.58613f + d7r * -1.58613f; // b
    return output;
}

psOut1 CDF9_7Iwahashi4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    psOut1 output;
    output.target0 = d0r + d0a * -0.00280689f + d1a * -0.00280689f + d2a * -0.00280689f + d4a * -0.00280689f + d0g * -0.0529801f + d4g * -0.0529801f + d0b * -0.0529801f + d2b * -0.0529801f; // r
    return output;
}

psOut1 CDF9_7Iwahashi4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * 0.882911f + d5b * 0.882911f + d0g * 0.882911f + d7g * 0.882911f + d0r  *  0.779532f  + d5r  *  0.779532f  + d7r *  0.779532f  + d8r *  0.779532f ; // a
    return output;
}

psOut2 CDF9_7Iwahashi4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * 0.882911f + d5r * 0.882911f + d0a * 0.443507f + d2a * 0.443507f; // g
    output.target1 = d0b + d0a * 0.443507f + d4a * 0.443507f + d0r * 0.882911f + d7r * 0.882911f; // b
    return output;
}

psOut1 CDF9_7Iwahashi4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    psOut1 output;
    output.target0 = d0r + d0a * -0.196698f + d1a * -0.196698f + d2a * -0.196698f + d4a * -0.196698f + d0g * 0.443507f + d4g * 0.443507f + d0b * 0.443507f + d2b * 0.443507f; // r
    return output;
}

// IwahashiStar
float4 CDF9_7IwahashiStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * -1.58613f + d5.b * -1.58613f + d0.g * -1.58613f + d7.g * -1.58613f + d0.r * 2.51582f + d5.r * 2.51582f + d7.r * 2.51582f + d8.r * 2.51582f );
}

float4 CDF9_7IwahashiStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f + d2.a * -0.0529801f, d0.b + d4.a * -0.0529801f + d0.r  * -1.58613f + d7.r * -1.58613f, d0.a );
}

float4 CDF9_7IwahashiStarStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * -0.00280689f + d2.b * -0.0529801f + d4.g * -0.0529801f, d0.g, d0.b, d0.a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    return result;
}

float4 CDF9_7IwahashiStarStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d5.b * 0.882911f + d7.g * 0.882911f + d8.r * 0.779532f );
}

float4 CDF9_7IwahashiStarStep5( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d5.r * 0.882911f + d2.a * 0.443507f, d0.b + d4.a * 0.443507f + d7.r * 0.882911f, d0.a );
}

float4 CDF9_7IwahashiStarStep6( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * -0.196698f + d2.b * 0.443507f + d4.g * 0.443507f, d0.g, d0.b, d0.a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// IwahashiStar4tex
psOut1 CDF9_7IwahashiStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * -1.58613f + d5b * -1.58613f + d0g * -1.58613f + d7g * -1.58613f + d0r * 2.51582f + d5r * 2.51582f + d7r * 2.51582f + d8r * 2.51582f; // a
    return output;
}

psOut2 CDF9_7IwahashiStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f + d2a * -0.0529801f; // g
    output.target1 = d0b + d4a * -0.0529801f + d0r  * -1.58613f + d7r * -1.58613f, d0a; // b
    return output;
}

psOut4 CDF9_7IwahashiStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * -0.00280689f + d2b * -0.0529801f + d4g * -0.0529801f, d0g, d0b, d0a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    psOut4 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    output.target3 = result.a; // a
    return output;
}

psOut1 CDF9_7IwahashiStar4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0a = texA.Sample( samp, uv0 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d5b * 0.882911f + d7g * 0.882911f + d8r * 0.779532f; // a
    return output;
}

psOut2 CDF9_7IwahashiStar4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d5r * 0.882911f + d2a * 0.443507f; // g
    output.target1 = d0b + d4a * 0.443507f + d7r * 0.882911f; // b
    return output;
}

psOut3 CDF9_7IwahashiStar4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * -0.196698f + d2b * 0.443507f + d4g * 0.443507f, d0g, d0b, d0a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// IwahashiStarMM
float4 CDF9_7IwahashiStarMMStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * -1.58613f + d5.b * -1.58613f + d0.g * -1.58613f + d7.g * -1.58613f + d0.r * 2.51582f + d5.r * 2.51582f + d7.r * 2.51582f + d8.r * 2.51582f );
}

float4 CDF9_7IwahashiStarMMStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f + d2.a * -0.0529801f, d0.b + d4.a * -0.0529801f + d0.r  * -1.58613f + d7.r * -1.58613f, d0.a );
}

float4 CDF9_7IwahashiStarMMStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * -0.00280689f + d2.b * -0.0529801f + d4.g * -0.0529801f, d0.g, d0.b, d0.a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    return result;
}

float4 CDF9_7IwahashiStarMMStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * 0.882911f + d5.b * 0.882911f + d0.g * 0.882911f + d7.g * 0.882911f + d0.r * 0.779532f + d5.r * 0.779532f + d7.r * 0.779532f + d8.r * 0.779532f );
}

float4 CDF9_7IwahashiStarMMStep5( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * 0.882911f + d5.r * 0.882911f + d2.a * 0.443507f, d0.b + d4.a * 0.443507f + d0.r  * 0.882911f + d7.r * 0.882911f, d0.a );
}

float4 CDF9_7IwahashiStarMMStep6( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * -0.196698f + d2.b * 0.443507f + d4.g * 0.443507f, d0.g, d0.b, d0.a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// IwahashiStarMM4tex
psOut1 CDF9_7IwahashiStarMM4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * -1.58613f + d5b * -1.58613f + d0g * -1.58613f + d7g * -1.58613f + d0r * 2.51582f + d5r * 2.51582f + d7r * 2.51582f + d8r * 2.51582f; // a
    return output;
}

psOut2 CDF9_7IwahashiStarMM4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f + d2a * -0.0529801f; // g
    output.target1 = d0b + d4a * -0.0529801f + d0r  * -1.58613f + d7r * -1.58613f, d0a; // b
    return output;
}

psOut3 CDF9_7IwahashiStarMM4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * -0.00280689f + d2b * -0.0529801f + d4g * -0.0529801f, d0g, d0b, d0a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

psOut1 CDF9_7IwahashiStarMM4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * 0.882911f + d5b * 0.882911f + d0g * 0.882911f + d7g * 0.882911f + d0r * 0.779532f + d5r * 0.779532f + d7r * 0.779532f + d8r * 0.779532f; // a
    return output;
}

psOut2 CDF9_7IwahashiStarMM4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * 0.882911f + d5r * 0.882911f + d2a * 0.443507f; // g
    output.target1 = d0b + d4a * 0.443507f + d0r  * 0.882911f + d7r * 0.882911f; // b
    return output;
}

psOut3 CDF9_7IwahashiStarMM4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * -0.196698f + d2b * 0.443507f + d4g * 0.443507f, d0g, d0b, d0a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// CDF 9/7 Explosive
float4 CDF9_7ExplosiveStep1( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f, d0.b + d0.r * -1.58613f + d7.r * -1.58613f, d0.a + d0.r * -2.51582f + d5.r * -2.51582f + d7.r * -2.51582f + d8.r * -2.51582f );
}

float4 CDF9_7ExplosiveStep2( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d0.b * -0.0529801f + d2.b * -0.0529801f + d0.g * -0.0529801f + d4.g * -0.0529801f, d0.g, d0.b, d0.a + d0.b * -1.58613f + d5.b * -1.58613f + d0.g * -1.58613f + d7.g * -1.58613f );
}

float4 CDF9_7ExplosiveStep3( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * 0.00280689f + d1.a * 0.00280689f + d2.a * 0.00280689f + d4.a * 0.00280689f, d0.g + d0.a * -0.0529801f + d2.a * -0.0529801f, d0.b + d0.a * -0.0529801f + d4.a * -0.0529801f, d0.a );
}

float4 CDF9_7ExplosiveStep4( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * 0.882911f + d5.r * 0.882911f, d0.b + d0.r * 0.882911f + d7.r * 0.882911f, d0.a + d0.r * -0.779532f + d5.r * -0.779532f + d7.r * -0.779532f + d8.r * -0.779532f );
}

float4 CDF9_7ExplosiveStep5( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d0.b * 0.443507f + d2.b * 0.443507f + d0.g * 0.443507f + d4.g * 0.443507f, d0.g, d0.b, d0.a + d0.b * 0.882911f + d5.b * 0.882911f + d0.g * 0.882911f + d7.g * 0.882911f );
}

float4 CDF9_7ExplosiveStep6( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * 0.196698f + d1.a * 0.196698f + d2.a * 0.196698f + d4.a * 0.196698f, d0.g + d0.a * 0.443507f + d2.a * 0.443507f, d0.b + d0.a * 0.443507f + d4.a * 0.443507f, d0.a );
}

// Explosive4tex
psOut3 CDF9_7Explosive4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f; // g
    output.target1 = d0b + d0r * -1.58613f + d7r * -1.58613f; // b
    output.target2 = d0a + d0r * -2.51582f + d5r  * -2.51582f + d7r  * -2.51582f + d8r * -2.51582f; // a
    return output;
}

psOut2 CDF9_7Explosive4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d0b * -0.0529801f + d2b * -0.0529801f + d0g * -0.0529801f + d4g * -0.0529801f; // r
    output.target1 = d0a + d0b * -1.58613f + d5b * -1.58613f + d0g * -1.58613f + d7g * -1.58613f; // a
    return output;
}

psOut3 CDF9_7Explosive4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    psOut3 output;
    output.target0 = d0r + d0a * 0.00280689f + d1a * 0.00280689f + d2a * 0.00280689f + d4a * 0.00280689f; // r
    output.target1 = d0g + d0a * -0.0529801f + d2a * -0.0529801f; // g
    output.target2 = d0b + d0a * -0.0529801f + d4a * -0.0529801f; // b
    return output;
}

psOut3 CDF9_7Explosive4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * 0.882911f + d5r * 0.882911f; // g
    output.target1 = d0b + d0r * 0.882911f + d7r * 0.882911f; // b
    output.target2 = d0a + d0r * -0.779532f + d5r  * -0.779532f + d7r  * -0.779532f + d8r * -0.779532f; // a
    return output;
}

psOut2 CDF9_7Explosive4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d0b * 0.443507f + d2b * 0.443507f + d0g * 0.443507f + d4g * 0.443507f; // r
    output.target1 = d0a + d0b * 0.882911f + d5b * 0.882911f + d0g * 0.882911f + d7g * 0.882911f; // a
    return output;
}

psOut3 CDF9_7Explosive4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    psOut3 output;
    output.target0 = d0r + d0a * 0.196698f + d1a * 0.196698f + d2a * 0.196698f + d4a * 0.196698f; // r
    output.target1 = d0g + d0a * 0.443507f + d2a * 0.443507f; // g
    output.target2 = d0b + d0a * 0.443507f + d4a * 0.443507f; // b
    return output;
}


// ExplosiveStar
float4 CDF9_7ExplosiveStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f, d0.b + d0.r * -1.58613f + d7.r * -1.58613f, d0.a + d0.r * 2.51582f + d8.r * -2.51582f + d0.g * -1.58613f + d0.b * -1.58613f );
}

float4 CDF9_7ExplosiveStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d2.b * -0.0529801f + d4.g * -0.0529801f, d0.g, d0.b, d0.a + d5.b * -1.58613f + d7.g * -1.58613f );
}

float4 CDF9_7ExplosiveStarStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * 0.00280689f, d0.g + d2.a * -0.0529801f, d0.b + d4.a * -0.0529801f, d0.a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    return result;
}

float4 CDF9_7ExplosiveStarStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d5.r * 0.882911f, d0.b + d7.r * 0.882911f, d0.a + d8.r * -0.779532f );
}

float4 CDF9_7ExplosiveStarStep5( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d2.b * 0.443507f + d4.g * 0.443507f, d0.g, d0.b, d0.a + d5.b * 0.882911f + d7.g * 0.882911f );
}

float4 CDF9_7ExplosiveStarStep6( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * 0.196698, d0.g + d2.a * 0.443507f, d0.b + d4.a * 0.443507f, d0.a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// ExplosiveStar4tex
psOut3 CDF9_7ExplosiveStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f; // r
    output.target1 = d0b + d0r * -1.58613f + d7r * -1.58613f; // g
    output.target2 = d0a + d0r * 2.51582f + d8r * -2.51582f + d0g * -1.58613f + d0b * -1.58613f; // b
    return output;
}

psOut2 CDF9_7ExplosiveStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d2b * -0.0529801f + d4g * -0.0529801f; // r
    output.target1 = d0a + d5b * -1.58613f + d7g * -1.58613f; // a
    return output;
}

psOut4 CDF9_7ExplosiveStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * 0.00280689f, d0g + d2a * -0.0529801f, d0b + d4a * -0.0529801f, d0a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    psOut4 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    output.target3 = result.a; // a
    return output;
}

psOut3 CDF9_7ExplosiveStar4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d5r * 0.882911f; // r
    output.target1 = d0b + d7r * 0.882911f; // g
    output.target2 = d0a + d8r * -0.779532f; // b
    return output;
}

psOut2 CDF9_7ExplosiveStar4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d2b * 0.443507f + d4g * 0.443507f; // r
    output.target1 = d0a + d5b * 0.882911f + d7g * 0.882911f; // a
    return output;
}

psOut3 CDF9_7ExplosiveStar4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * 0.196698, d0g + d2a * 0.443507f, d0b + d4a * 0.443507f, d0a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}


// ExplosiveStarMM
float4 CDF9_7ExplosiveStarMMStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * -1.58613f + d5.r * -1.58613f, d0.b + d0.r * -1.58613f + d7.r * -1.58613f, d0.a + d0.r * 2.51582f + d8.r * -2.51582f + d0.g * -1.58613f + d0.b * -1.58613f );
}

float4 CDF9_7ExplosiveStarMMStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d2.b * -0.0529801f + d4.g * -0.0529801f, d0.g, d0.b, d0.a + d5.b * -1.58613f + d7.g * -1.58613f );
}

float4 CDF9_7ExplosiveStarMMStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * 0.00280689f, d0.g + d2.a * -0.0529801f, d0.b + d4.a * -0.0529801f, d0.a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    return result;
}

float4 CDF9_7ExplosiveStarMMStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * 0.882911f + d5.r * 0.882911f, d0.b + d0.r * 0.882911f + d7.r * 0.882911f, d0.a + d0.r * 0.779532f + d8.r * -0.779532f + d0.g * 0.882911f + d0.b * 0.882911f );
}

float4 CDF9_7ExplosiveStarMMStep5( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d2.b * 0.443507f + d4.g * 0.443507f, d0.g, d0.b, d0.a + d5.b * 0.882911f + d7.g * 0.882911f );
}

float4 CDF9_7ExplosiveStarMMStep6( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * 0.196698, d0.g + d2.a * 0.443507f, d0.b + d4.a * 0.443507f, d0.a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// ExplosiveStarMM4tex
psOut3 CDF9_7ExplosiveStarMM4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f; // r
    output.target1 = d0b + d0r * -1.58613f + d7r * -1.58613f; // g
    output.target2 = d0a + d0r * 2.51582f + d8r * -2.51582f + d0g * -1.58613f + d0b * -1.58613f; // b
    return output;
}

psOut2 CDF9_7ExplosiveStarMM4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d2b * -0.0529801f + d4g * -0.0529801f; // r
    output.target1 = d0a + d5b * -1.58613f + d7g * -1.58613f; // a
    return output;
}

psOut3 CDF9_7ExplosiveStarMM4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * 0.00280689f, d0g + d2a * -0.0529801f, d0b + d4a * -0.0529801f, d0a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

psOut3 CDF9_7ExplosiveStarMM4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * 0.882911f + d5r * 0.882911f; // r
    output.target1 = d0b + d0r * 0.882911f + d7r * 0.882911f; // g
    output.target2 = d0a + d0r * 0.779532f + d8r * -0.779532f + d0g * 0.882911f + d0b * 0.882911f; // b
    return output;
}

psOut2 CDF9_7ExplosiveStarMM4texStep5( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d2b * 0.443507f + d4g * 0.443507f; // r
    output.target1 = d0a + d5b * 0.882911f + d7g * 0.882911f; // a
    return output;
}

psOut3 CDF9_7ExplosiveStarMM4texStep6( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * 0.196698, d0g + d2a * 0.443507f, d0b + d4a * 0.443507f, d0a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// CDF 9/7 Monolithic
float4 CDF9_7MonolithicStep1( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r* -1.58613f + d5.r* -1.58613f, d0.b + d0.r* -1.58613f + d7.r * -1.58613f, d0.a + d0.r * 2.51582f + d5.r * 2.51582f + d7.r * 2.51582f + d8.r * 2.51582f + d0.g * -1.58613f + d7.g * -1.58613f + d0.b * -1.58613f + d5.b * -1.58613f );
}

float4 CDF9_7MonolithicStep2( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * 0.00280689f + d1.a * 0.00280689f + d2.a * 0.00280689f + d4.a * 0.00280689f + d0.g * -0.0529801f + d4.g * -0.0529801f + d0.b * -0.0529801f + d2.b * -0.0529801f, d0.g + d0.a * -0.0529801f + d2.a * -0.0529801f, d0.b + d0.a * -0.0529801f + d4.a * -0.0529801f, d0.a );
}

float4 CDF9_7MonolithicStep3( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r* 0.882911f + d5.r* 0.882911f, d0.b + d0.r* 0.882911f + d7.r * 0.882911f, d0.a + d0.r * 0.779532f + d5.r * 0.779532f + d7.r * 0.779532f + d8.r * 0.779532f + d0.g * 0.882911f + d7.g * 0.882911f + d0.b * 0.882911f + d5.b * 0.882911f );
}

float4 CDF9_7MonolithicStep4( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * 0.196698f + d1.a * 0.196698f + d2.a * 0.196698f + d4.a * 0.196698f + d0.g * 0.443507f + d4.g * 0.443507f + d0.b * 0.443507f + d2.b * 0.443507f, d0.g + d0.a * 0.443507f + d2.a * 0.443507f, d0.b + d0.a * 0.443507f + d4.a * 0.443507f, d0.a );
}

// CDF 9/7 Monolithic4tex
psOut3 CDF9_7Monolithic4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );
    psOut3 output;
    output.target0 = d0g + d0r * -1.58613f + d5r * -1.58613f; // g
    output.target1 = d0b + d0r * -1.58613f + d7r * -1.58613f; // b
    output.target2 = d0a + d0r * 2.51582f + d5r * 2.51582f + d7r * 2.51582f + d8r * 2.51582f + d0g * -1.58613f + d7g * -1.58613f + d0b * -1.58613f + d5b * -1.58613f; // a
    return output;

}

psOut3 CDF9_7Monolithic4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d1a = texA.Sample( samp, uv1 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );
    psOut3 output;
    output.target0 = d0r + d0a * 0.00280689f + d1a * 0.00280689f + d2a * 0.00280689f + d4a * 0.00280689f + d0g * -0.0529801f + d4g * -0.0529801f + d0b * -0.0529801f + d2b * -0.0529801f; // r
    output.target1 = d0g + d0a * -0.0529801f + d2a * -0.0529801f; // g
    output.target2 = d0b + d0a * -0.0529801f + d4a * -0.0529801f; // b
    return output;
}

psOut3 CDF9_7Monolithic4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );
    psOut3 output;
    output.target0 = d0g + d0r * 0.882911f + d5r * 0.882911f; // g
    output.target1 = d0b + d0r * 0.882911f + d7r * 0.882911f; // b
    output.target2 = d0a + d0r * 0.779532f + d5r * 0.779532f + d7r * 0.779532f + d8r * 0.779532f + d0g * 0.882911f + d7g * 0.882911f + d0b * 0.882911f + d5b * 0.882911f; // a
    return output;

}

psOut3 CDF9_7Monolithic4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d1a = texA.Sample( samp, uv1 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );
    psOut3 output;
    output.target0 = d0r + d0a * 0.196698f + d1a * 0.196698f + d2a * 0.196698f + d4a * 0.196698f + d0g * 0.443507f + d4g * 0.443507f + d0b * 0.443507f + d2b * 0.443507f; // r
    output.target1 = d0g + d0a * 0.443507f + d2a * 0.443507f; // g
    output.target2 = d0b + d0a * 0.443507f + d4a * 0.443507f; // b
    return output;
}

// MonolithicStar
float4 CDF9_7MonolithicStarStep1( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result = float4( d0.r, d0.g + d5.r * -1.58613f, d0.b + d7.r * -1.58613f, d0.a + d8.r * 2.51582f + d7.g * -1.58613f + d5.b * -1.58613f );

    result.ga += result.rb * -1.58613f;
    result.ba += result.rg * -1.58613f;

    return result;
}

float4 CDF9_7MonolithicStarStep2( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d2.b * -0.0529801f + d4.g * -0.0529801f + d1.a * 0.00280689f, d0.g + d2.a * -0.0529801f, d0.b + d4.a * -0.0529801f, d0.a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    return result;
}

float4 CDF9_7MonolithicStarStep3( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result = float4( d0.r, d0.g + d5.r * 0.882911f, d0.b + d7.r * 0.882911f, d0.a + d8.r * 0.779532f + d7.g * 0.882911f + d5.b * 0.882911f );

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    return result;
}

float4 CDF9_7MonolithicStarStep4( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d2.b * 0.443507f + d4.g * 0.443507f + d1.a * 0.196698f, d0.g + d2.a * 0.443507f, d0.b + d4.a * 0.443507f, d0.a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// MonolithicStar4tex
psOut3 CDF9_7MonolithicStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    float4 result = float4( d0r, d0g + d5r * -1.58613f, d0b + d7r * -1.58613f, d0a + d8r * 2.51582f + d7g * -1.58613f + d5b * -1.58613f );

    result.ga += result.rb * -1.58613f;
    result.ba += result.rg * -1.58613f;

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;
}

psOut3 CDF9_7MonolithicStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d1a = texA.Sample( samp, uv1 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d2b * -0.0529801f + d4g * -0.0529801f + d1a * 0.00280689f, d0g + d2a * -0.0529801f, d0b + d4a * -0.0529801f, d0a );

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

psOut3 CDF9_7MonolithicStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    float4 result = float4( d0r, d0g + d5r * 0.882911f, d0b + d7r * 0.882911f, d0a + d8r * 0.779532f + d7g * 0.882911f + d5b * 0.882911f );

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;
}

psOut3 CDF9_7MonolithicStar4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d1a = texA.Sample( samp, uv1 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d2b * 0.443507f + d4g * 0.443507f + d1a * 0.196698f, d0g + d2a * 0.443507f, d0b + d4a * 0.443507f, d0a );

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// CDF 9/7 Polyphase
float4 CDF9_7PolyphaseStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result;
    result.r = d0.r * 1.36438f + d1.r * 0.00706164f + d2.r * 0.0981569f + d3.r * 0.00706164f + d4.r * 0.0981569f + d5.r * 0.0981569f + d6.r * 0.00706164f + d7.r * 0.0981569f + d8.r * 0.00706164f
        + d0.g * -0.0618843f + d1.g * -0.00445211f + d2.g * -0.00445211f + d4.g * -0.0618843f + d6.g * -0.00445211f + d7.g * -0.00445211f
        + d0.b * -0.0618843f + d1.b * -0.00445211f + d2.b * -0.0618843f + d3.b * -0.00445211f + d4.b * -0.00445211f + d5.b * -0.00445211f
        + d0.a * 0.00280689f + d1.a * 0.00280689f + d2.a * 0.00280689f + d4.a * 0.00280689f;

    result.g = d0.r * -1.85271f + d2.r * -0.133289f + d3.r * -0.133289f + d5.r * -1.85271f + d7.r * -0.133289f + d8.r * -0.133289f
        + d0.g * 1.16807f + d2.g * 0.0840336f + d7.g * 0.0840336f
        + d0.b * 0.0840336f + d2.b * 0.0840336f + d3.b * 0.0840336f + d5.b * 0.0840336f
        + d0.a * -0.0529801f + d2.a * -0.0529801f;

    result.b = d0.r * -1.85271f + d4.r * -0.133289f + d5.r * -0.133289f + d6.r * -0.133289f + d7.r * -1.85271f + d8.r * -0.133289f
        + d0.g * 0.0840336f + d4.g * 0.0840336f + d6.g * 0.0840336f + d7.g * 0.0840336f
        + d0.b * 1.16807f + d4.b * 0.0840336f + d5.b * 0.0840336f
        + d0.a * -0.0529801 + d4.a * -0.0529801f;

    result.a = d0.r * 2.51582f + d5.r * 2.51582f + d7.r * 2.51582f + d8.r * 2.51582f
        + d0.g * -1.58613f + d7.g * -1.58613f
        + d0.b * -1.58613f + d5.b * -1.58613f
        + d0.a;
    return result;
}

float4 CDF9_7PolyphaseStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result;
    result.r = d0.r * 3.17964f + d1.r * 0.153333f + d2.r * 0.698242f + d3.r * 0.153333f + d4.r * 0.698242f + d5.r * 0.698242f + d6.r * 0.153333f + d7.r * 0.698242f + d8.r * 0.153333f
        + d0.g * 0.790841f + d1.g * 0.173667f + d2.g * 0.173667f + d4.g * 0.790841f + d6.g * 0.173667f + d7.g * 0.173667f
        + d0.b * 0.790841f + d1.b * 0.173667f + d2.b * 0.790841f + d3.b * 0.173667f + d4.b * 0.173667f + d5.b * 0.173667f
        + d0.a * 0.196698f + d1.a * 0.196698f + d2.a * 0.196698f + d4.a * 0.196698f;

    result.g = d0.r * 1.57437f + d2.r * 0.345728f + d3.r * 0.345728f + d5.r * 1.57437f + d7.r * 0.345728f + d8.r * 0.345728f
        + d0.g * 1.78315f + d2.g * 0.391577f + d7.g * 0.391577f
        + d0.b * 0.391577f + d2.b * 0.391577f + d3.b * 0.391577f + d5.b * 0.391577f
        + d0.a * 0.443507f + d2.a * 0.443507f;

    result.b = d0.r * 1.57437f + d4.r * 0.345728f + d5.r * 0.345728f + d6.r * 0.345728f + d7.r * 1.57437f + d8.r * 0.345728f
        + d0.g * 0.391577f + d4.g * 0.391577f + d6.g * 0.391577f + d7.g * 0.391577f
        + d0.b * 1.78315f + d4.b * 0.391577f + d5.b * 0.391577f
        + d0.a * 0.443507f + d4.a * 0.443507f;

    result.a = d0.r * 0.779532f + d5.r * 0.779532f + d7.r * 0.779532f + d8.r * 0.779532f
        + d0.g * 0.882911f + d7.g * 0.882911f
        + d0.b * 0.882911f + d5.b * 0.882911f
        + d0.a;
    return result;
}

// CDF 9/7 Polyphase4tex
psOut4 CDF9_7Polyphase4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    psOut4 output;
    output.target0 = d0r * 1.36438f + d1r * 0.00706164f + d2r * 0.0981569f + d3r * 0.00706164f + d4r * 0.0981569f + d5r * 0.0981569f + d6r * 0.00706164f + d7r * 0.0981569f + d8r * 0.00706164f
        + d0g * -0.0618843f + d1g * -0.00445211f + d2g * -0.00445211f + d4g * -0.0618843f + d6g * -0.00445211f + d7g * -0.00445211f
        + d0b * -0.0618843f + d1b * -0.00445211f + d2b * -0.0618843f + d3b * -0.00445211f + d4b * -0.00445211f + d5b * -0.00445211f
        + d0a * 0.00280689f + d1a * 0.00280689f + d2a * 0.00280689f + d4a * 0.00280689f;

    output.target1 = d0r * -1.85271f + d2r * -0.133289f + d3r * -0.133289f + d5r * -1.85271f + d7r * -0.133289f + d8r * -0.133289f
        + d0g * 1.16807f + d2g * 0.0840336f + d7g * 0.0840336f
        + d0b * 0.0840336f + d2b * 0.0840336f + d3b * 0.0840336f + d5b * 0.0840336f
        + d0a * -0.0529801f + d2a * -0.0529801f;

    output.target2 = d0r * -1.85271f + d4r * -0.133289f + d5r * -0.133289f + d6r * -0.133289f + d7r * -1.85271f + d8r * -0.133289f
        + d0g * 0.0840336f + d4g * 0.0840336f + d6g * 0.0840336f + d7g * 0.0840336f
        + d0b * 1.16807f + d4b * 0.0840336f + d5b * 0.0840336f
        + d0a * -0.0529801 + d4a * -0.0529801f;

    output.target3 = d0r * 2.51582f + d5r * 2.51582f + d7r * 2.51582f + d8r * 2.51582f
        + d0g * -1.58613f + d7g * -1.58613f
        + d0b * -1.58613f + d5b * -1.58613f
        + d0a;
    return output;
}

psOut4 CDF9_7Polyphase4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );


    psOut4 output;
    output.target0 = d0r * 3.17964f + d1r * 0.153333f + d2r * 0.698242f + d3r * 0.153333f + d4r * 0.698242f + d5r * 0.698242f + d6r * 0.153333f + d7r * 0.698242f + d8r * 0.153333f
        + d0g * 0.790841f + d1g * 0.173667f + d2g * 0.173667f + d4g * 0.790841f + d6g * 0.173667f + d7g * 0.173667f
        + d0b * 0.790841f + d1b * 0.173667f + d2b * 0.790841f + d3b * 0.173667f + d4b * 0.173667f + d5b * 0.173667f
        + d0a * 0.196698f + d1a * 0.196698f + d2a * 0.196698f + d4a * 0.196698f;

    output.target1 = d0r * 1.57437f + d2r * 0.345728f + d3r * 0.345728f + d5r * 1.57437f + d7r * 0.345728f + d8r * 0.345728f
        + d0g * 1.78315f + d2g * 0.391577f + d7g * 0.391577f
        + d0b * 0.391577f + d2b * 0.391577f + d3b * 0.391577f + d5b * 0.391577f
        + d0a * 0.443507f + d2a * 0.443507f;

    output.target2 = d0r * 1.57437f + d4r * 0.345728f + d5r * 0.345728f + d6r * 0.345728f + d7r * 1.57437f + d8r * 0.345728f
        + d0g * 0.391577f + d4g * 0.391577f + d6g * 0.391577f + d7g * 0.391577f
        + d0b * 1.78315f + d4b * 0.391577f + d5b * 0.391577f
        + d0a * 0.443507f + d4a * 0.443507f;

    output.target3 = d0r * 0.779532f + d5r * 0.779532f + d7r * 0.779532f + d8r * 0.779532f
        + d0g * 0.882911f + d7g * 0.882911f
        + d0b * 0.882911f + d5b * 0.882911f
        + d0a;
    return output;
}





// PolyphaseSeparable
float4 CDF9_7PolyphaseSeparableStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);

    float4 result;
    result.r =
        +d0.r * 1.16807f + d2.r * 0.0840336f + d7.r * 0.0840336f
        + d0.b * -0.0529801 + d2.b * -0.0529801;

    result.g =
        +d0.g * 1.16807f + d2.g * 0.0840336f + d7.g * 0.0840336f
        + d0.a * -0.0529801 + d2.a * -0.0529801;

    result.b =
        +d0.r * -1.58613f + d7.r * -1.58613f
        + d0.b;

    result.a =
        +d0.g * -1.58613f + d7.g * -1.58613f
        + d0.a;
    return result;
}

float4 CDF9_7PolyphaseSeparableStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);

    float4 result;
    result.r =
        +d0.r * 1.16807f + d4.r * 0.0840336f + d5.r * 0.0840336f
        + d0.g * -0.0529801 + d4.g * -0.0529801;

    result.g =
        +d0.r * -1.58613f + d5.r * -1.58613f
        + d0.g;

    result.b =
        +d0.b * 1.16807f + d4.b * 0.0840336f + d5.b * 0.0840336f
        + d0.a * -0.0529801 + d4.a * -0.0529801;

    result.a =
        +d0.b * -1.58613f + d5.b * -1.58613f
        + d0.a;
    return result;
}

float4 CDF9_7PolyphaseSeparableStep3(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);

    float4 result;
    result.r =
        +d0.r * 1.78315f + d2.r * 0.391577f + d7.r * 0.391577f
        + d0.b * 0.443507f + d2.b * 0.443507f;

    result.g =
        +d0.g * 1.78315f + d2.g * 0.391577f + d7.g * 0.391577f
        + d0.a * 0.443507f + d2.a * 0.443507f;

    result.b =
        +d0.r * 0.882911f + d7.r * 0.882911f
        + d0.b;

    result.a =
        +d0.g * 0.882911f + d7.g * 0.882911f
        + d0.a;
    return result;
}

float4 CDF9_7PolyphaseSeparableStep4(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);

    float4 result;
    result.r =
        +d0.r * 1.78315f + d4.r * 0.391577f + d5.r * 0.391577f
        + d0.g * 0.443507f + d4.g * 0.443507f;

    result.g =
        +d0.r * 0.882911f + d5.r * 0.882911f
        + d0.g;

    result.b =
        +d0.b * 1.78315f + d4.b * 0.391577f + d5.b * 0.391577f
        + d0.a * 0.443507f + d4.a * 0.443507f;

    result.a =
        +d0.b * 0.882911f + d5.b * 0.882911f
        + d0.a;
    return result;
}

// PolyphaseSeparable4tex
psOut4 CDF9_7PolyphaseSeparable4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);


    psOut4 result;
    result.target0 =
        +d0r * 1.16807f + d2r * 0.0840336f + d7r * 0.0840336f
        + d0b * -0.0529801 + d2b * -0.0529801;

    result.target1 =
        +d0g * 1.16807f + d2g * 0.0840336f + d7g * 0.0840336f
        + d0a * -0.0529801 + d2a * -0.0529801;

    result.target2 =
        +d0r * -1.58613f + d7r * -1.58613f
        + d0b;

    result.target3 =
        +d0g * -1.58613f + d7g * -1.58613f
        + d0a;
    return result;
}

psOut4 CDF9_7PolyphaseSeparable4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);

    psOut4 result;
    result.target0 =
        +d0r * 1.16807f + d4r * 0.0840336f + d5r * 0.0840336f
        + d0g * -0.0529801 + d4g * -0.0529801;

    result.target1 =
        +d0r * -1.58613f + d5r * -1.58613f
        + d0g;

    result.target2 =
        +d0b * 1.16807f + d4b * 0.0840336f + d5b * 0.0840336f
        + d0a * -0.0529801 + d4a * -0.0529801;

    result.target3 =
        +d0b * -1.58613f + d5b * -1.58613f
        + d0a;
    return result;
}

psOut4 CDF9_7PolyphaseSeparable4texStep3(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);


    psOut4 result;
    result.target0 =
        +d0r * 1.78315f + d2r * 0.391577f + d7r * 0.391577f
        + d0b * 0.443507f + d2b * 0.443507f;

    result.target1 =
        +d0g * 1.78315f + d2g * 0.391577f + d7g * 0.391577f
        + d0a * 0.443507f + d2a * 0.443507f;

    result.target2 =
        +d0r * 0.882911f + d7r * 0.882911f
        + d0b;

    result.target3 =
        +d0g * 0.882911f + d7g * 0.882911f
        + d0a;
    return result;
}

psOut4 CDF9_7PolyphaseSeparable4texStep4(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);

    psOut4 result;
    result.target0 =
        +d0r * 1.78315f + d4r * 0.391577f + d5r * 0.391577f
        + d0g * 0.443507f + d4g * 0.443507f;

    result.target1 =
        +d0r * 0.882911f + d5r * 0.882911f
        + d0g;

    result.target2 =
        +d0b * 1.78315f + d4b * 0.391577f + d5b * 0.391577f
        + d0a * 0.443507f + d4a * 0.443507f;

    result.target3 =
        +d0b * 0.882911f + d5b * 0.882911f
        + d0a;
    return result;
}



// PolyphaseSeparableStar
float4 CDF9_7PolyphaseSeparableStarStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0.r * 1.08403f + d4.r * 0.0840336f
        + d4.g * -0.0529801f;

    result.g =
        + d0.r * -1.58613f + d5.r * -1.58613f
        + d0.g;

    result.b =
        + d0.b * 1.08403f + d4.b * 0.0840336f
        + d4.a * -0.0529801f;

    result.a =
        + d0.b * -1.58613f + d5.b * -1.58613f
        + d0.a;

    result.rb += result.ga * -0.0529801f;
    result.ba += result.rg * -1.58613f;

    return result;
}

float4 CDF9_7PolyphaseSeparableStarStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);

    float4 result;
    result.r =
        + d0.r * 1.08403f
        + d2.b * -0.0529801f;

    result.g =
        + d0.g * 1.08403f
        + d2.a * -0.0529801f;

    result.b =
        + d7.r * -1.58613f
        + d0.b;

    result.a =
        + d7.g * -1.58613f
        + d0.a;

    result.rg += result.ba * -0.0529801f;
    result.ga += result.rb * 0.882911f;

    return result;
}

float4 CDF9_7PolyphaseSeparableStarStep3(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0.r * 1.39158f
        + d4.g * 0.443507f;

    result.g =
        + d5.r * 0.882911f
        + d0.g;

    result.b =
        + d0.b * 1.39158f
        + d4.a * 0.443507f;

    result.a =
        + d5.b * 0.882911f
        + d0.a;

    result.rb += result.ga * 0.443507f;
    result.ba += result.rg * 0.882911f;

    return result;
}

float4 CDF9_7PolyphaseSeparableStarStep4(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);

    float4 result;
    result.r =
        + d0.r * 1.39158f
        + d2.b * 0.443507f;

    result.g =
        + d0.g * 1.39158f
        + d2.a * 0.443507f;

    result.b =
        + d7.r * 0.882911f
        + d0.b;

    result.a =
        + d7.g * 0.882911f
        + d0.a;

    result.rg += result.ba * 0.443507f;

    return result;
}

// PolyphaseSeparableStar4tex
psOut4 CDF9_7PolyphaseSeparableStar4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0r * 1.08403f + d4r * 0.0840336f
        + d4g * -0.0529801f;

    result.g =
        + d0r * -1.58613f + d5r * -1.58613f
        + d0g;

    result.b =
        + d0b * 1.08403f + d4b * 0.0840336f
        + d4a * -0.0529801f;

    result.a =
        + d0b * -1.58613f + d5b * -1.58613f
        + d0a;

    result.rb += result.ga * -0.0529801f;
    result.ba += result.rg * -1.58613f;
    
    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

psOut4 CDF9_7PolyphaseSeparableStar4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);


    float4 result;
    result.r =
        + d0r * 1.08403f
        + d2b * -0.0529801f;

    result.g =
        + d0g * 1.08403f
        + d2a * -0.0529801f;

    result.b =
        + d7r * -1.58613f
        + d0b;

    result.a =
        + d7g * -1.58613f
        + d0a;

    result.rg += result.ba * -0.0529801f;
    result.ga += result.rb * 0.882911f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

psOut4 CDF9_7PolyphaseSeparableStar4texStep3(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0r * 1.39158f
        + d4g * 0.443507f;

    result.g =
        + d5r * 0.882911f
        + d0g;

    result.b =
        + d0b * 1.39158f
        + d4a * 0.443507f;

    result.a =
        + d5b * 0.882911f
        + d0a;

    result.rb += result.ga * 0.443507f;
    result.ba += result.rg * 0.882911f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

psOut4 CDF9_7PolyphaseSeparableStar4texStep4(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);

    
    float4 result;
    result.r =
        + d0r * 1.39158f
        + d2b * 0.443507f;

    result.g =
        + d0g * 1.39158f
        + d2a * 0.443507f;

    result.b =
        + d7r * 0.882911f
        + d0b;

    result.a =
        + d7g * 0.882911f
        + d0a;

    result.rg += result.ba * 0.443507f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

// CDF 9/7 PolyphaseStar
float4 CDF9_7PolyphaseStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result;
    result.r = 
        + d0.r * 1.17513f + d2.r * 0.0910952f + d4.r * 0.0910952f + d1.r * 0.00706164f
        + d4.g * -0.0574322f + d1.g * -0.00445211f
        + d2.b * -0.0574322f + d1.b * -0.00445211f
        + d1.a * 0.00280689f;

    result.g = 
        + d5.r * -1.71942f + d3.r * -0.133289f + d0.r * -1.71942f + d2.r * -0.133289f
        + d0.g * 1.08403f + d2.g * 0.0840336f
        + d3.b * 0.084033326f + d2.b * 0.084033326f
        + d2.a * -0.0529801f;

    result.b = 
        + d7.r * -1.71942f + d0.r * -1.71942f + d6.r * -0.133289f + d4.r * -0.133289f
        + d6.g * 0.084033326f + d4.g * 0.084033326f
        + d0.b * 1.08403f + d4.b * 0.0840336f
        + d4.a * -0.0529801f;

    result.a = 
        + d0.r * 2.51582f + d5.r * 2.51582f + d7.r * 2.51582f + d8.r * 2.51582f
        + d0.g * -1.58613f + d7.g * -1.58613f
        + d0.b * -1.58613f + d5.b * -1.58613f
        + d0.a;

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    return result;
}

float4 CDF9_7PolyphaseStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result;

    result.r = 
        + d0.r * 1.93649f
        + d4.g * 0.617174f
        + d2.b * 0.617174f
        + d1.a * 0.196698f;

    result.g =
        + d5.r * 1.22864f
        + d0.g * 1.39158f
        + d3.b * 0.391577f
        + d2.a * 0.443507f;

    result.b =
        + d7.r * 1.22864f
        + d6.g * 0.391577f
        + d0.b * 1.39158f
        + d4.a * 0.443507f;

    result.a =
        + d8.r * 0.779532f
        + d7.g * 0.882911f
        + d5.b * 0.882911f
        + d0.a;

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// CDF 9/7 PolyphaseStar4tex
psOut4 CDF9_7PolyphaseStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float4 result;
    result.r =
        + d0r * 1.17513f + d2r * 0.0910952f + d4r * 0.0910952f + d1r * 0.00706164f
        + d4g * -0.0574322f + d1g * -0.00445211f
        + d2b * -0.0574322f + d1b * -0.00445211f
        + d1a * 0.00280689f;

    result.g =
        + d5r * -1.71942f + d3r * -0.133289f + d0r * -1.71942f + d2r * -0.133289f
        + d0g * 1.08403f + d2g * 0.0840336f
        + d3b * 0.084033326f + d2b * 0.084033326f
        + d2a * -0.0529801f;

    result.b =
        + d7r * -1.71942f + d0r * -1.71942f + d6r * -0.133289f + d4r * -0.133289f
        + d6g * 0.084033326f + d4g * 0.084033326f
        + d0b * 1.08403f + d4b * 0.0840336f
        + d4a * -0.0529801f;

    result.a =
        + d0r * 2.51582f + d5r * 2.51582f + d7r * 2.51582f + d8r * 2.51582f
        + d0g * -1.58613f + d7g * -1.58613f
        + d0b * -1.58613f + d5b * -1.58613f
        + d0a;

    result.rb += result.ga * -0.0529801f;
    result.rg += result.ba * -0.0529801f;

    result.ga += result.rb * 0.882911f;
    result.ba += result.rg * 0.882911f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

psOut4 CDF9_7PolyphaseStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1a = texA.Sample( samp, uv1 );

    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3b = texB.Sample( samp, uv3 );

    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6g = texG.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float4 result;

    result.r =
        + d0r * 1.93649f
        + d4g * 0.617174f
        + d2b * 0.617174f
        + d1a * 0.196698f;

    result.g =
        + d5r * 1.22864f
        + d0g * 1.39158f
        + d3b * 0.391577f
        + d2a * 0.443507f;

    result.b =
        + d7r * 1.22864f
        + d6g * 0.391577f
        + d0b * 1.39158f
        + d4a * 0.443507f;

    result.a =
        + d8r * 0.779532f
        + d7g * 0.882911f
        + d5b * 0.882911f
        + d0a;

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

// CDF 9/7 Convolution
float4 CDF9_7ConvolutionStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d13 = texRGBA.Sample( samp, uv13 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d18 = texRGBA.Sample( samp, uv18 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d20 = texRGBA.Sample( samp, uv20 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    float4 result;
    result.r =
    +0.00108278f*d24.r - 0.00316645f*d19.r + 0.0244072f*d17.r - 0.00316645f*d15.r + 0.00108278f*d13.r - 0.00316645f*d23.r + 0.00925991f*d8.r - 0.0713755f*d5.r + 0.00925991f*d3.r - 0.00316645f*d12.r + 0.0244072f*d22.r - 0.0713755f*d7.r + 0.550168f*d0.r - 0.0713754f*d2.r + 0.0244072f*d11.r - 0.00316645f*d21.r + 0.00925988f*d6.r - 0.0713754f*d4.r + 0.00925988f*d1.r - 0.00316645f*d10.r + 0.00108278f*d20.r - 0.00316645f*d18.r + 0.0244072f*d16.r - 0.00316645f*d14.r + 0.00108278f*d9.r
    - 0.000682654f*d23.g + 0.00199633f*d8.g - 0.0153878f*d5.g + 0.00199633f*d3.g - 0.000682654f*d12.g + 0.0108026f*d22.g - 0.0315907f*d7.g + 0.243503f*d0.g - 0.0315907f*d2.g + 0.0108026f*d11.g + 0.0108026f*d21.g - 0.0315907f*d6.g + 0.243503f*d4.g - 0.0315907f*d1.g + 0.0108026f*d10.g - 0.000682654f*d20.g + 0.00199633f*d18.g - 0.0153878f*d16.g + 0.00199633f*d14.g - 0.000682654f*d9.g
    - 0.000682654f*d19.b + 0.0108026f*d17.b + 0.0108026f*d15.b - 0.000682654f*d13.b + 0.00199633f*d8.b - 0.0315907f*d5.b - 0.0315907f*d3.b + 0.00199633f*d12.b - 0.0153878f*d7.b + 0.243503f*d0.b + 0.243503f*d2.b - 0.0153878f*d11.b + 0.00199633f*d6.b - 0.0315907f*d4.b - 0.0315907f*d1.b + 0.00199633f*d10.b - 0.000682654f*d18.b + 0.0108026f*d16.b + 0.0108026f*d14.b - 0.000682654f*d9.b
    + 0.000430388f*d8.a - 0.00681063f*d5.a - 0.00681063f*d3.a + 0.000430388f*d12.a - 0.00681063f*d7.a + 0.107774f*d0.a + 0.107774f*d2.a - 0.00681063f*d11.a - 0.00681063f*d6.a + 0.107774f*d4.a + 0.107774f*d1.a - 0.00681063f*d10.a + 0.000430388f*d18.a - 0.00681063f*d16.a - 0.00681063f*d14.a + 0.000430388f*d9.a;

    result.g =
    +0.00244141f*d24.r - 0.00713958f*d19.r + 0.0550322f*d17.r - 0.00713958f*d15.r + 0.00244141f*d13.r - 0.0158158f*d23.r + 0.0462513f*d8.r - 0.356506f*d5.r + 0.0462513f*d3.r - 0.0158158f*d12.r - 0.0158158f*d22.r + 0.0462513f*d7.r - 0.356506f*d0.r + 0.0462513f*d2.r - 0.0158158f*d11.r + 0.00244141f*d21.r - 0.00713958f*d6.r + 0.0550322f*d4.r - 0.00713958f*d1.r + 0.00244141f*d10.r
    - 0.00153922f*d23.g + 0.00450124f*d8.g - 0.0346958f*d5.g + 0.00450124f*d3.g - 0.00153922f*d12.g + 0.0298272f*d22.g - 0.0872257f*d7.g + 0.672341f*d0.g - 0.0872257f*d2.g + 0.0298272f*d11.g - 0.00153922f*d21.g + 0.00450124f*d6.g - 0.0346958f*d4.g + 0.00450124f*d1.g - 0.00153922f*d10.g
    - 0.00153922f*d19.b + 0.0243572f*d17.b + 0.0243572f*d15.b - 0.00153922f*d13.b + 0.00997127f*d8.b - 0.157789f*d5.b - 0.157789f*d3.b + 0.00997127f*d12.b + 0.00997127f*d7.b - 0.157789f*d0.b - 0.157789f*d2.b + 0.00997127f*d11.b - 0.00153922f*d6.b + 0.0243572f*d4.b + 0.0243572f*d1.b - 0.00153922f*d10.b
    + 0.000970421f*d8.a - 0.0153563f*d5.a - 0.0153563f*d3.a + 0.000970421f*d12.a - 0.018805f*d7.a + 0.297577f*d0.a + 0.297577f*d2.a - 0.018805f*d11.a + 0.000970421f*d6.a - 0.0153563f*d4.a - 0.0153563f*d1.a + 0.000970421f*d10.a;

    result.b =
    +0.00244141f*d24.r - 0.0158158f*d19.r - 0.0158158f*d17.r + 0.00244141f*d15.r - 0.00713958f*d23.r + 0.0462513f*d8.r + 0.0462513f*d5.r - 0.00713958f*d3.r + 0.0550322f*d22.r - 0.356506f*d7.r - 0.356506f*d0.r + 0.0550322f*d2.r - 0.00713958f*d21.r + 0.0462513f*d6.r + 0.0462513f*d4.r - 0.00713958f*d1.r + 0.00244141f*d20.r - 0.0158158f*d18.r - 0.0158158f*d16.r + 0.00244141f*d14.r
    - 0.00153922f*d23.g + 0.00997127f*d8.g + 0.00997127f*d5.g - 0.00153922f*d3.g + 0.0243572f*d22.g - 0.157789f*d7.g - 0.157789f*d0.g + 0.0243572f*d2.g + 0.0243572f*d21.g - 0.157789f*d6.g - 0.157789f*d4.g + 0.0243572f*d1.g - 0.00153922f*d20.g + 0.00997127f*d18.g + 0.00997127f*d16.g - 0.00153922f*d14.g
    - 0.00153922f*d19.b + 0.0298272f*d17.b - 0.00153922f*d15.b + 0.00450124f*d8.b - 0.0872257f*d5.b + 0.00450124f*d3.b - 0.0346958f*d7.b + 0.672341f*d0.b - 0.0346958f*d2.b + 0.00450124f*d6.b - 0.0872257f*d4.b + 0.00450124f*d1.b - 0.00153922f*d18.b + 0.0298272f*d16.b - 0.00153922f*d14.b
    + 0.000970421f*d8.a - 0.018805f*d5.a + 0.000970421f*d3.a - 0.0153563f*d7.a + 0.297577f*d0.a - 0.0153563f*d2.a - 0.0153563f*d6.a + 0.297577f*d4.a - 0.0153563f*d1.a + 0.000970421f*d18.a - 0.018805f*d16.a + 0.000970421f*d14.a;

    result.a =
    +0.00550478f*d24.r - 0.0356607f*d19.r - 0.0356607f*d17.r + 0.00550478f*d15.r - 0.0356607f*d23.r + 0.231015f*d8.r + 0.231015f*d5.r - 0.0356607f*d3.r - 0.0356607f*d22.r + 0.231015f*d7.r + 0.231015f*d0.r - 0.0356607f*d2.r + 0.00550478f*d21.r - 0.0356607f*d6.r - 0.0356607f*d4.r + 0.00550478f*d1.r
    - 0.00347056f*d23.g + 0.0224828f*d8.g + 0.0224828f*d5.g - 0.00347056f*d3.g + 0.0672531f*d22.g - 0.435675f*d7.g - 0.435675f*d0.g + 0.0672531f*d2.g - 0.00347056f*d21.g + 0.0224828f*d6.g + 0.0224828f*d4.g - 0.00347056f*d1.g
    - 0.00347056f*d19.b + 0.0672531f*d17.b - 0.00347056f*d15.b + 0.0224828f*d8.b - 0.435675f*d5.b + 0.0224828f*d3.b + 0.0224828f*d7.b - 0.435675f*d0.b + 0.0224828f*d2.b - 0.00347056f*d6.b + 0.0672531f*d4.b - 0.00347056f*d1.b
    + 0.00218806f*d8.a - 0.0424006f*d5.a + 0.00218806f*d3.a - 0.0424006f*d7.a + 0.821645f*d0.a - 0.0424006f*d2.a + 0.00218806f*d6.a - 0.0424006f*d4.a + 0.00218806f*d1.a;
    return result;
}

// CDF 9/7 Convolution4tex
psOut4 CDF9_7Convolution4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3g = texG.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );
    float d3a = texA.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5g = texG.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );
    float d6b = texB.Sample( samp, uv6 );
    float d6a = texA.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );
    float d8g = texG.Sample( samp, uv8 );
    float d8b = texB.Sample( samp, uv8 );
    float d8a = texA.Sample( samp, uv8 );

    float d9r = texR.Sample( samp, uv9 );
    float d9g = texG.Sample( samp, uv9 );
    float d9b = texB.Sample( samp, uv9 );
    float d9a = texA.Sample( samp, uv9 );

    float d10r = texR.Sample( samp, uv10 );
    float d10g = texG.Sample( samp, uv10 );
    float d10b = texB.Sample( samp, uv10 );
    float d10a = texA.Sample( samp, uv10 );

    float d11r = texR.Sample( samp, uv11 );
    float d11g = texG.Sample( samp, uv11 );
    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12r = texR.Sample( samp, uv12 );
    float d12g = texG.Sample( samp, uv12 );
    float d12b = texB.Sample( samp, uv12 );
    float d12a = texA.Sample( samp, uv12 );

    float d13r = texR.Sample( samp, uv13 );
    float d13b = texB.Sample( samp, uv13 );

    float d14r = texR.Sample( samp, uv14 );
    float d14g = texG.Sample( samp, uv14 );
    float d14b = texB.Sample( samp, uv14 );
    float d14a = texA.Sample( samp, uv14 );

    float d15r = texR.Sample( samp, uv15 );
    float d15b = texB.Sample( samp, uv15 );

    float d16r = texR.Sample( samp, uv16 );
    float d16g = texG.Sample( samp, uv16 );
    float d16b = texB.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d18r = texR.Sample( samp, uv18 );
    float d18g = texG.Sample( samp, uv18 );
    float d18b = texB.Sample( samp, uv18 );
    float d18a = texA.Sample( samp, uv18 );

    float d19r = texR.Sample( samp, uv19 );
    float d19b = texB.Sample( samp, uv19 );

    float d20r = texR.Sample( samp, uv20 );
    float d20g = texG.Sample( samp, uv20 );

    float d21r = texR.Sample( samp, uv21 );
    float d21g = texG.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );
    float d23g = texG.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );

    psOut4 output;
    output.target0 =
    +0.00108278f*d24r - 0.00316645f*d19r + 0.0244072f*d17r - 0.00316645f*d15r + 0.00108278f*d13r - 0.00316645f*d23r + 0.00925991f*d8r - 0.0713755f*d5r + 0.00925991f*d3r - 0.00316645f*d12r + 0.0244072f*d22r - 0.0713755f*d7r + 0.550168f*d0r - 0.0713754f*d2r + 0.0244072f*d11r - 0.00316645f*d21r + 0.00925988f*d6r - 0.0713754f*d4r + 0.00925988f*d1r - 0.00316645f*d10r + 0.00108278f*d20r - 0.00316645f*d18r + 0.0244072f*d16r - 0.00316645f*d14r + 0.00108278f*d9r
    - 0.000682654f*d23g + 0.00199633f*d8g - 0.0153878f*d5g + 0.00199633f*d3g - 0.000682654f*d12g + 0.0108026f*d22g - 0.0315907f*d7g + 0.243503f*d0g - 0.0315907f*d2g + 0.0108026f*d11g + 0.0108026f*d21g - 0.0315907f*d6g + 0.243503f*d4g - 0.0315907f*d1g + 0.0108026f*d10g - 0.000682654f*d20g + 0.00199633f*d18g - 0.0153878f*d16g + 0.00199633f*d14g - 0.000682654f*d9g
    - 0.000682654f*d19b + 0.0108026f*d17b + 0.0108026f*d15b - 0.000682654f*d13b + 0.00199633f*d8b - 0.0315907f*d5b - 0.0315907f*d3b + 0.00199633f*d12b - 0.0153878f*d7b + 0.243503f*d0b + 0.243503f*d2b - 0.0153878f*d11b + 0.00199633f*d6b - 0.0315907f*d4b - 0.0315907f*d1b + 0.00199633f*d10b - 0.000682654f*d18b + 0.0108026f*d16b + 0.0108026f*d14b - 0.000682654f*d9b
    + 0.000430388f*d8a - 0.00681063f*d5a - 0.00681063f*d3a + 0.000430388f*d12a - 0.00681063f*d7a + 0.107774f*d0a + 0.107774f*d2a - 0.00681063f*d11a - 0.00681063f*d6a + 0.107774f*d4a + 0.107774f*d1a - 0.00681063f*d10a + 0.000430388f*d18a - 0.00681063f*d16a - 0.00681063f*d14a + 0.000430388f*d9a;

    output.target1 =
    +0.00244141f*d24r - 0.00713958f*d19r + 0.0550322f*d17r - 0.00713958f*d15r + 0.00244141f*d13r - 0.0158158f*d23r + 0.0462513f*d8r - 0.356506f*d5r + 0.0462513f*d3r - 0.0158158f*d12r - 0.0158158f*d22r + 0.0462513f*d7r - 0.356506f*d0r + 0.0462513f*d2r - 0.0158158f*d11r + 0.00244141f*d21r - 0.00713958f*d6r + 0.0550322f*d4r - 0.00713958f*d1r + 0.00244141f*d10r
    - 0.00153922f*d23g + 0.00450124f*d8g - 0.0346958f*d5g + 0.00450124f*d3g - 0.00153922f*d12g + 0.0298272f*d22g - 0.0872257f*d7g + 0.672341f*d0g - 0.0872257f*d2g + 0.0298272f*d11g - 0.00153922f*d21g + 0.00450124f*d6g - 0.0346958f*d4g + 0.00450124f*d1g - 0.00153922f*d10g
    - 0.00153922f*d19b + 0.0243572f*d17b + 0.0243572f*d15b - 0.00153922f*d13b + 0.00997127f*d8b - 0.157789f*d5b - 0.157789f*d3b + 0.00997127f*d12b + 0.00997127f*d7b - 0.157789f*d0b - 0.157789f*d2b + 0.00997127f*d11b - 0.00153922f*d6b + 0.0243572f*d4b + 0.0243572f*d1b - 0.00153922f*d10b
    + 0.000970421f*d8a - 0.0153563f*d5a - 0.0153563f*d3a + 0.000970421f*d12a - 0.018805f*d7a + 0.297577f*d0a + 0.297577f*d2a - 0.018805f*d11a + 0.000970421f*d6a - 0.0153563f*d4a - 0.0153563f*d1a + 0.000970421f*d10a;

    output.target2 =
    +0.00244141f*d24r - 0.0158158f*d19r - 0.0158158f*d17r + 0.00244141f*d15r - 0.00713958f*d23r + 0.0462513f*d8r + 0.0462513f*d5r - 0.00713958f*d3r + 0.0550322f*d22r - 0.356506f*d7r - 0.356506f*d0r + 0.0550322f*d2r - 0.00713958f*d21r + 0.0462513f*d6r + 0.0462513f*d4r - 0.00713958f*d1r + 0.00244141f*d20r - 0.0158158f*d18r - 0.0158158f*d16r + 0.00244141f*d14r
    - 0.00153922f*d23g + 0.00997127f*d8g + 0.00997127f*d5g - 0.00153922f*d3g + 0.0243572f*d22g - 0.157789f*d7g - 0.157789f*d0g + 0.0243572f*d2g + 0.0243572f*d21g - 0.157789f*d6g - 0.157789f*d4g + 0.0243572f*d1g - 0.00153922f*d20g + 0.00997127f*d18g + 0.00997127f*d16g - 0.00153922f*d14g
    - 0.00153922f*d19b + 0.0298272f*d17b - 0.00153922f*d15b + 0.00450124f*d8b - 0.0872257f*d5b + 0.00450124f*d3b - 0.0346958f*d7b + 0.672341f*d0b - 0.0346958f*d2b + 0.00450124f*d6b - 0.0872257f*d4b + 0.00450124f*d1b - 0.00153922f*d18b + 0.0298272f*d16b - 0.00153922f*d14b
    + 0.000970421f*d8a - 0.018805f*d5a + 0.000970421f*d3a - 0.0153563f*d7a + 0.297577f*d0a - 0.0153563f*d2a - 0.0153563f*d6a + 0.297577f*d4a - 0.0153563f*d1a + 0.000970421f*d18a - 0.018805f*d16a + 0.000970421f*d14a;

    output.target3 =
    +0.00550478f*d24r - 0.0356607f*d19r - 0.0356607f*d17r + 0.00550478f*d15r - 0.0356607f*d23r + 0.231015f*d8r + 0.231015f*d5r - 0.0356607f*d3r - 0.0356607f*d22r + 0.231015f*d7r + 0.231015f*d0r - 0.0356607f*d2r + 0.00550478f*d21r - 0.0356607f*d6r - 0.0356607f*d4r + 0.00550478f*d1r
    - 0.00347056f*d23g + 0.0224828f*d8g + 0.0224828f*d5g - 0.00347056f*d3g + 0.0672531f*d22g - 0.435675f*d7g - 0.435675f*d0g + 0.0672531f*d2g - 0.00347056f*d21g + 0.0224828f*d6g + 0.0224828f*d4g - 0.00347056f*d1g
    - 0.00347056f*d19b + 0.0672531f*d17b - 0.00347056f*d15b + 0.0224828f*d8b - 0.435675f*d5b + 0.0224828f*d3b + 0.0224828f*d7b - 0.435675f*d0b + 0.0224828f*d2b - 0.00347056f*d6b + 0.0672531f*d4b - 0.00347056f*d1b
    + 0.00218806f*d8a - 0.0424006f*d5a + 0.00218806f*d3a - 0.0424006f*d7a + 0.821645f*d0a - 0.0424006f*d2a + 0.00218806f*d6a - 0.0424006f*d4a + 0.00218806f*d1a;
    return output;
}

// CDF 9/7 ConvolutionStar
float4 CDF9_7ConvolutionStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    float4 d9 = texRGBA.Sample( samp, uv9 );
    float4 d10 = texRGBA.Sample( samp, uv10 );
    float4 d11 = texRGBA.Sample( samp, uv11 );
    float4 d12 = texRGBA.Sample( samp, uv12 );
    float4 d13 = texRGBA.Sample( samp, uv13 );
    float4 d14 = texRGBA.Sample( samp, uv14 );
    float4 d15 = texRGBA.Sample( samp, uv15 );
    float4 d16 = texRGBA.Sample( samp, uv16 );
    float4 d17 = texRGBA.Sample( samp, uv17 );
    float4 d18 = texRGBA.Sample( samp, uv18 );
    float4 d19 = texRGBA.Sample( samp, uv19 );
    float4 d20 = texRGBA.Sample( samp, uv20 );
    float4 d21 = texRGBA.Sample( samp, uv21 );
    float4 d22 = texRGBA.Sample( samp, uv22 );
    float4 d23 = texRGBA.Sample( samp, uv23 );
    float4 d24 = texRGBA.Sample( samp, uv24 );

    float4 result;

    result.r =
        + 0.0136748f * d8.r
        + 0.111665f * d5.r
        + -0.0151008f * d3.r
        + 0.00384796f * d12.r
        + 0.111665f * d7.r
        + 0.911834f * d0.r
        + -0.12331f * d2.r
        + 0.0314216f * d11.r
        + -0.0151008f * d6.r
        + -0.12331f * d4.r
        + 0.0166756f * d1.r
        + -0.00424923f * d10.r
        + 0.00384796f * d18.r
        + 0.0314216f * d16.r
        + -0.00424923f * d14.r
        + 0.00108278f * d9.r

        + -0.00862145f * d7.g
        + -0.0704009f * d0.g
        + 0.00952051f * d2.g
        + -0.002426f * d11.g
        + 0.0408159f * d6.g
        + 0.333294f * d4.g
        + -0.0450723f * d1.g
        + 0.0114852f * d10.g
        + -0.002426f * d18.g
        + -0.0198102f * d16.g
        + 0.00267898f * d14.g
        + -0.000682654f * d9.g

        + -0.00862145f * d5.b
        + 0.0408159f * d3.b
        + -0.002426f * d12.b
        + -0.0704009f * d0.b
        + 0.333294f * d2.b
        + -0.0198102f * d11.b
        + 0.00952051f * d4.b
        + -0.0450723f * d1.b
        + 0.00267898f * d10.b
        + -0.002426f * d16.b
        + 0.0114852f * d14.b
        + -0.000682654f * d9.b

        + 0.00543551f * d0.a
        + -0.0257329f * d2.a
        + 0.0015295f * d11.a
        + -0.0257329f * d4.a
        + 0.121826f * d1.a
        + -0.00724101f * d10.a
        + 0.0015295f * d16.a
        + -0.00724101f * d14.a
        + 0.000430388f * d9.a;

    result.g =
        + 0.00867621f * d19.r
        + 0.070848f * d17.r
        + -0.00958098f * d15.r
        + 0.00244141f * d13.r
        + -0.0562057f * d8.r
        + -0.458963f * d5.r
        + 0.062067f * d3.r
        + -0.0158158f * d12.r
        + -0.0562057f * d7.r
        + -0.458963f * d0.r
        + 0.062067f * d2.r
        + -0.0158158f * d11.r
        + 0.00867621f * d6.r
        + 0.070848f * d4.r
        + -0.00958098f * d1.r
        + 0.00244141f * d10.r

        + -0.00547003f * d8.g
        + -0.0446671f * d5.g
        + 0.00604046f * d3.g
        + -0.00153922f * d12.g
        + 0.105999f * d7.g
        + 0.865566f * d0.g
        + -0.117053f * d2.g
        + 0.0298272f * d11.g
        + -0.00547003f * d6.g
        + -0.0446671f * d4.g
        + 0.00604046f * d1.g
        + -0.00153922f * d10.g

        + -0.00547003f * d17.b
        + 0.0258964f * d15.b
        + -0.00153922f * d13.b
        + 0.0354357f * d5.b
        + -0.16776f * d3.b
        + 0.00997127f * d12.b
        + 0.0354357f * d0.b
        + -0.16776f * d2.b
        + 0.00997127f * d11.b
        + -0.00547003f * d4.b
        + 0.0258964f * d1.b
        + -0.00153922f * d10.b

        + 0.00344866f * d5.a
        + -0.0163267f * d3.a
        + 0.000970421f * d12.a
        + -0.0668286f * d0.a
        + 0.316382f * d2.a
        + -0.018805f * d11.a
        + 0.00344866f * d4.a
        + -0.0163267f * d1.a
        + 0.000970421f * d10.a;

    result.b =
        + 0.00867621f * d23.r
        + -0.0562057f * d8.r
        + -0.0562057f * d5.r
        + 0.00867621f * d3.r
        + 0.070848f * d22.r
        + -0.458963f * d7.r
        + -0.458963f * d0.r
        + 0.070848f * d2.r
        + -0.00958098f * d21.r
        + 0.062067f * d6.r
        + 0.062067f * d4.r
        + -0.00958098f * d1.r
        + 0.00244141f * d20.r
        + -0.0158158f * d18.r
        + -0.0158158f * d16.r
        + 0.00244141f * d14.r

        + -0.00547003f * d22.g
        + 0.0354357f * d7.g
        + 0.0354357f * d0.g
        + -0.00547003f * d2.g
        + 0.0258964f * d21.g
        + -0.16776f * d6.g
        + -0.16776f * d4.g
        + 0.0258964f * d1.g
        + -0.00153922f * d20.g
        + 0.00997127f * d18.g
        + 0.00997127f * d16.g
        + -0.00153922f * d14.g

        + -0.00547003f * d8.b
        + 0.105999f * d5.b
        + -0.00547003f * d3.b
        + -0.0446671f * d7.b
        + 0.865566f * d0.b
        + -0.0446671f * d2.b
        + 0.00604046f * d6.b
        + -0.117053f * d4.b
        + 0.00604046f * d1.b
        + -0.00153922f * d18.b
        + 0.0298272f * d16.b
        + -0.00153922f * d14.b

        + 0.00344866f * d7.a
        + -0.0668286f * d0.a
        + 0.00344866f * d2.a
        + -0.0163267f * d6.a
        + 0.316382f * d4.a
        + -0.0163267f * d1.a
        + 0.000970421f * d18.a
        + -0.018805f * d16.a
        + 0.000970421f * d14.a;

    result.a =
        + 0.00550478f * d24.r
        + -0.0356607f * d19.r
        + -0.0356607f * d17.r
        + 0.00550478f * d15.r
        + -0.0356607f * d23.r
        + 0.231015f * d8.r
        + 0.231015f * d5.r
        + -0.0356607f * d3.r
        + -0.0356607f * d22.r
        + 0.231015f * d7.r
        + 0.231015f * d0.r
        + -0.0356607f * d2.r
        + 0.00550478f * d21.r
        + -0.0356607f * d6.r
        + -0.0356607f * d4.r
        + 0.00550478f * d1.r

        + -0.00347056f * d23.g
        + 0.0224828f * d8.g
        + 0.0224828f * d5.g
        + -0.00347056f * d3.g
        + 0.0672531f * d22.g
        + -0.435675f * d7.g
        + -0.435675f * d0.g
        + 0.0672531f * d2.g
        + -0.00347056f * d21.g
        + 0.0224828f * d6.g
        + 0.0224828f * d4.g
        + -0.00347056f * d1.g

        + -0.00347056f * d19.b
        + 0.0672531f * d17.b
        + -0.00347056f * d15.b
        + 0.0224828f * d8.b
        + -0.435675f * d5.b
        + 0.0224828f * d3.b
        + 0.0224828f * d7.b
        + -0.435675f * d0.b
        + 0.0224828f * d2.b
        + -0.00347056f * d6.b
        + 0.0672531f * d4.b
        + -0.00347056f * d1.b

        + 0.00218806f * d8.a
        + -0.0424006f * d5.a
        + 0.00218806f * d3.a
        + -0.0424006f * d7.a
        + 0.821645f * d0.a
        + -0.0424006f * d2.a
        + 0.00218806f * d6.a
        + -0.0424006f * d4.a
        + 0.00218806f * d1.a;

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    return result;
}

// CDF 9/7 ConvolutionStar4tex
psOut4 CDF9_7ConvolutionStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = i.uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = i.uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = i.uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = i.uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = i.uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = i.uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = i.uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = i.uv0 + float2( textureResolution.y, -textureResolution.y );
    float2 uv9 = i.uv0 + float2( -textureResolution.z, textureResolution.z );
    float2 uv10 = i.uv0 + float2( -textureResolution.y, textureResolution.z );
    float2 uv11 = i.uv0 + float2( 0.0f, textureResolution.z );
    float2 uv12 = i.uv0 + float2( textureResolution.y, textureResolution.z );
    float2 uv13 = i.uv0 + float2( textureResolution.z, textureResolution.z );
    float2 uv14 = i.uv0 + float2( -textureResolution.z, textureResolution.y );
    float2 uv15 = i.uv0 + float2( textureResolution.z, textureResolution.y );
    float2 uv16 = i.uv0 + float2( -textureResolution.z, 0.0f );
    float2 uv17 = i.uv0 + float2( textureResolution.z, 0.0f );
    float2 uv18 = i.uv0 + float2( -textureResolution.z, -textureResolution.y );
    float2 uv19 = i.uv0 + float2( textureResolution.z, -textureResolution.y );
    float2 uv20 = i.uv0 + float2( -textureResolution.z, -textureResolution.z );
    float2 uv21 = i.uv0 + float2( -textureResolution.y, -textureResolution.z );
    float2 uv22 = i.uv0 + float2( 0.0f, -textureResolution.z );
    float2 uv23 = i.uv0 + float2( textureResolution.y, -textureResolution.z );
    float2 uv24 = i.uv0 + float2( textureResolution.z, -textureResolution.z );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3g = texG.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );
    float d3a = texA.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5g = texG.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d5a = texA.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );
    float d6b = texB.Sample( samp, uv6 );
    float d6a = texA.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d7b = texB.Sample( samp, uv7 );
    float d7a = texA.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );
    float d8g = texG.Sample( samp, uv8 );
    float d8b = texB.Sample( samp, uv8 );
    float d8a = texA.Sample( samp, uv8 );

    float d9r = texR.Sample( samp, uv9 );
    float d9g = texG.Sample( samp, uv9 );
    float d9b = texB.Sample( samp, uv9 );
    float d9a = texA.Sample( samp, uv9 );

    float d10r = texR.Sample( samp, uv10 );
    float d10g = texG.Sample( samp, uv10 );
    float d10b = texB.Sample( samp, uv10 );
    float d10a = texA.Sample( samp, uv10 );

    float d11r = texR.Sample( samp, uv11 );
    float d11g = texG.Sample( samp, uv11 );
    float d11b = texB.Sample( samp, uv11 );
    float d11a = texA.Sample( samp, uv11 );

    float d12r = texR.Sample( samp, uv12 );
    float d12g = texG.Sample( samp, uv12 );
    float d12b = texB.Sample( samp, uv12 );
    float d12a = texA.Sample( samp, uv12 );

    float d13r = texR.Sample( samp, uv13 );
    float d13b = texB.Sample( samp, uv13 );

    float d14r = texR.Sample( samp, uv14 );
    float d14g = texG.Sample( samp, uv14 );
    float d14b = texB.Sample( samp, uv14 );
    float d14a = texA.Sample( samp, uv14 );

    float d15r = texR.Sample( samp, uv15 );
    float d15b = texB.Sample( samp, uv15 );

    float d16r = texR.Sample( samp, uv16 );
    float d16g = texG.Sample( samp, uv16 );
    float d16b = texB.Sample( samp, uv16 );
    float d16a = texA.Sample( samp, uv16 );

    float d17r = texR.Sample( samp, uv17 );
    float d17b = texB.Sample( samp, uv17 );

    float d18r = texR.Sample( samp, uv18 );
    float d18g = texG.Sample( samp, uv18 );
    float d18b = texB.Sample( samp, uv18 );
    float d18a = texA.Sample( samp, uv18 );

    float d19r = texR.Sample( samp, uv19 );
    float d19b = texB.Sample( samp, uv19 );

    float d20r = texR.Sample( samp, uv20 );
    float d20g = texG.Sample( samp, uv20 );

    float d21r = texR.Sample( samp, uv21 );
    float d21g = texG.Sample( samp, uv21 );

    float d22r = texR.Sample( samp, uv22 );
    float d22g = texG.Sample( samp, uv22 );

    float d23r = texR.Sample( samp, uv23 );
    float d23g = texG.Sample( samp, uv23 );

    float d24r = texR.Sample( samp, uv24 );


    float4 result;

    result.r =
        +0.0136748f * d8r
        + 0.111665f * d5r
        + -0.0151008f * d3r
        + 0.00384796f * d12r
        + 0.111665f * d7r
        + 0.911834f * d0r
        + -0.12331f * d2r
        + 0.0314216f * d11r
        + -0.0151008f * d6r
        + -0.12331f * d4r
        + 0.0166756f * d1r
        + -0.00424923f * d10r
        + 0.00384796f * d18r
        + 0.0314216f * d16r
        + -0.00424923f * d14r
        + 0.00108278f * d9r

        + -0.00862145f * d7g
        + -0.0704009f * d0g
        + 0.00952051f * d2g
        + -0.002426f * d11g
        + 0.0408159f * d6g
        + 0.333294f * d4g
        + -0.0450723f * d1g
        + 0.0114852f * d10g
        + -0.002426f * d18g
        + -0.0198102f * d16g
        + 0.00267898f * d14g
        + -0.000682654f * d9g

        + -0.00862145f * d5b
        + 0.0408159f * d3b
        + -0.002426f * d12b
        + -0.0704009f * d0b
        + 0.333294f * d2b
        + -0.0198102f * d11b
        + 0.00952051f * d4b
        + -0.0450723f * d1b
        + 0.00267898f * d10b
        + -0.002426f * d16b
        + 0.0114852f * d14b
        + -0.000682654f * d9b

        + 0.00543551f * d0a
        + -0.0257329f * d2a
        + 0.0015295f * d11a
        + -0.0257329f * d4a
        + 0.121826f * d1a
        + -0.00724101f * d10a
        + 0.0015295f * d16a
        + -0.00724101f * d14a
        + 0.000430388f * d9a;

    result.g =
        +0.00867621f * d19r
        + 0.070848f * d17r
        + -0.00958098f * d15r
        + 0.00244141f * d13r
        + -0.0562057f * d8r
        + -0.458963f * d5r
        + 0.062067f * d3r
        + -0.0158158f * d12r
        + -0.0562057f * d7r
        + -0.458963f * d0r
        + 0.062067f * d2r
        + -0.0158158f * d11r
        + 0.00867621f * d6r
        + 0.070848f * d4r
        + -0.00958098f * d1r
        + 0.00244141f * d10r

        + -0.00547003f * d8g
        + -0.0446671f * d5g
        + 0.00604046f * d3g
        + -0.00153922f * d12g
        + 0.105999f * d7g
        + 0.865566f * d0g
        + -0.117053f * d2g
        + 0.0298272f * d11g
        + -0.00547003f * d6g
        + -0.0446671f * d4g
        + 0.00604046f * d1g
        + -0.00153922f * d10g

        + -0.00547003f * d17b
        + 0.0258964f * d15b
        + -0.00153922f * d13b
        + 0.0354357f * d5b
        + -0.16776f * d3b
        + 0.00997127f * d12b
        + 0.0354357f * d0b
        + -0.16776f * d2b
        + 0.00997127f * d11b
        + -0.00547003f * d4b
        + 0.0258964f * d1b
        + -0.00153922f * d10b

        + 0.00344866f * d5a
        + -0.0163267f * d3a
        + 0.000970421f * d12a
        + -0.0668286f * d0a
        + 0.316382f * d2a
        + -0.018805f * d11a
        + 0.00344866f * d4a
        + -0.0163267f * d1a
        + 0.000970421f * d10a;

    result.b =
        +0.00867621f * d23r
        + -0.0562057f * d8r
        + -0.0562057f * d5r
        + 0.00867621f * d3r
        + 0.070848f * d22r
        + -0.458963f * d7r
        + -0.458963f * d0r
        + 0.070848f * d2r
        + -0.00958098f * d21r
        + 0.062067f * d6r
        + 0.062067f * d4r
        + -0.00958098f * d1r
        + 0.00244141f * d20r
        + -0.0158158f * d18r
        + -0.0158158f * d16r
        + 0.00244141f * d14r

        + -0.00547003f * d22g
        + 0.0354357f * d7g
        + 0.0354357f * d0g
        + -0.00547003f * d2g
        + 0.0258964f * d21g
        + -0.16776f * d6g
        + -0.16776f * d4g
        + 0.0258964f * d1g
        + -0.00153922f * d20g
        + 0.00997127f * d18g
        + 0.00997127f * d16g
        + -0.00153922f * d14g

        + -0.00547003f * d8b
        + 0.105999f * d5b
        + -0.00547003f * d3b
        + -0.0446671f * d7b
        + 0.865566f * d0b
        + -0.0446671f * d2b
        + 0.00604046f * d6b
        + -0.117053f * d4b
        + 0.00604046f * d1b
        + -0.00153922f * d18b
        + 0.0298272f * d16b
        + -0.00153922f * d14b

        + 0.00344866f * d7a
        + -0.0668286f * d0a
        + 0.00344866f * d2a
        + -0.0163267f * d6a
        + 0.316382f * d4a
        + -0.0163267f * d1a
        + 0.000970421f * d18a
        + -0.018805f * d16a
        + 0.000970421f * d14a;

    result.a =
        +0.00550478f * d24r
        + -0.0356607f * d19r
        + -0.0356607f * d17r
        + 0.00550478f * d15r
        + -0.0356607f * d23r
        + 0.231015f * d8r
        + 0.231015f * d5r
        + -0.0356607f * d3r
        + -0.0356607f * d22r
        + 0.231015f * d7r
        + 0.231015f * d0r
        + -0.0356607f * d2r
        + 0.00550478f * d21r
        + -0.0356607f * d6r
        + -0.0356607f * d4r
        + 0.00550478f * d1r

        + -0.00347056f * d23g
        + 0.0224828f * d8g
        + 0.0224828f * d5g
        + -0.00347056f * d3g
        + 0.0672531f * d22g
        + -0.435675f * d7g
        + -0.435675f * d0g
        + 0.0672531f * d2g
        + -0.00347056f * d21g
        + 0.0224828f * d6g
        + 0.0224828f * d4g
        + -0.00347056f * d1g

        + -0.00347056f * d19b
        + 0.0672531f * d17b
        + -0.00347056f * d15b
        + 0.0224828f * d8b
        + -0.435675f * d5b
        + 0.0224828f * d3b
        + 0.0224828f * d7b
        + -0.435675f * d0b
        + 0.0224828f * d2b
        + -0.00347056f * d6b
        + 0.0672531f * d4b
        + -0.00347056f * d1b

        + 0.00218806f * d8a
        + -0.0424006f * d5a
        + 0.00218806f * d3a
        + -0.0424006f * d7a
        + 0.821645f * d0a
        + -0.0424006f * d2a
        + 0.00218806f * d6a
        + -0.0424006f * d4a
        + 0.00218806f * d1a;

    result.rb += result.ga * 0.443507f;
    result.rg += result.ba * 0.443507f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

// CDF 9/7 ConvolutionSeparable
float4 CDF9_7ConvolutionSeparableStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);
    float4 d16 = texRGBA.Sample(samp, uv16);
    float4 d17 = texRGBA.Sample(samp, uv17);

    float4 result;
    result.r =
        + d17.r * +0.0329056f
        + d5.r * -0.0962282f
        + d0.r * +0.741732f
        + d4.r * -0.0962282f
        + d16.r * +0.0329056f

        + d5.g * -0.0207458f
        + d0.g * +0.328289f
        + d4.g * +0.328289f
        + d16.g * -0.0207458f;

    result.g =
        + d17.r * +0.0741942f
        + d5.r * -0.480641f
        + d0.r * -0.480641f
        + d4.r * +0.0741942f

        + d5.g * -0.0467767f
        + d0.g * +0.906447f
        + d4.g * -0.0467767f;

    result.b =
        + d17.b * +0.0329056f
        + d5.b * -0.0962282f
        + d0.b * +0.741732f
        + d4.b * -0.0962282f
        + d16.b * +0.0329056f

        + d5.a * -0.0207458f
        + d0.a * +0.328289f
        + d4.a * +0.328289f
        + d16.a * -0.0207458f;

    result.a =
        + d17.b * +0.0741942f
        + d5.b * -0.480641f
        + d0.b * -0.480641f
        + d4.b * +0.0741942f

        + d5.a * -0.0467767f
        + d0.a * +0.906447f
        + d4.a * -0.0467767f;

    return result;
}

float4 CDF9_7ConvolutionSeparableStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);
    float4 d11 = texRGBA.Sample(samp, uv11);
    float4 d22 = texRGBA.Sample(samp, uv22);

    float4 result;
    result.r =
        + d22.r * +0.0329056f
        + d7.r * -0.0962282f
        + d0.r * +0.741732f
        + d2.r * -0.0962282f
        + d11.r * +0.0329056f

        + d7.b * -0.0207458f
        + d0.b * +0.328289f
        + d2.b * +0.328289f
        + d11.b * -0.0207458f;

    result.g =
        + d22.g * +0.0329056f
        + d7.g * -0.0962282f
        + d0.g * +0.741732f
        + d2.g * -0.0962282f
        + d11.g * +0.0329056f

        + d7.a * -0.0207458f
        + d0.a * +0.328289f
        + d2.a * +0.328289f
        + d11.a * -0.0207458f;

    result.b =
        + d22.r * +0.0741942f
        + d7.r * -0.480641f
        + d0.r * -0.480641f
        + d2.r * +0.0741942f
    
        + d7.b * -0.0467767f
        + d0.b * +0.906447f
        + d2.b * -0.0467767f;

    result.a =
        + d22.g * +0.0741942f
        + d7.g * -0.480641f
        + d0.g * -0.480641f
        + d2.g * +0.0741942f

        + d7.a * -0.0467767f
        + d0.a * +0.906447f
        + d2.a * -0.0467767f;

    return result;
}

// CDF 9/7 ConvolutionSeparable4tex
psOut4 CDF9_7ConvolutionSeparable4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5g = texG.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);
    float d5a = texA.Sample(samp, uv5);

    float d16r = texR.Sample(samp, uv16);
    float d16g = texG.Sample(samp, uv16);
    float d16b = texB.Sample(samp, uv16);
    float d16a = texA.Sample(samp, uv16);

    float d17r = texR.Sample(samp, uv17);
    float d17b = texB.Sample(samp, uv17);


    float4 result;
    result.r =
        + d17r * +0.0329056f
        + d5r * -0.0962282f
        + d0r * +0.741732f
        + d4r * -0.0962282f
        + d16r * +0.0329056f

        + d5g * -0.0207458f
        + d0g * +0.328289f
        + d4g * +0.328289f
        + d16g * -0.0207458f;

    result.g =
        + d17r * +0.0741942f
        + d5r * -0.480641f
        + d0r * -0.480641f
        + d4r * +0.0741942f

        + d5g * -0.0467767f
        + d0g * +0.906447f
        + d4g * -0.0467767f;

    result.b =
        + d17b * +0.0329056f
        + d5b * -0.0962282f
        + d0b * +0.741732f
        + d4b * -0.0962282f
        + d16b * +0.0329056f

        + d5a * -0.0207458f
        + d0a * +0.328289f
        + d4a * +0.328289f
        + d16a * -0.0207458f;

    result.a =
        + d17b * +0.0741942f
        + d5b * -0.480641f
        + d0b * -0.480641f
        + d4b * +0.0741942f

        + d5a * -0.0467767f
        + d0a * +0.906447f
        + d4a * -0.0467767f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

psOut4 CDF9_7ConvolutionSeparable4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);
    float d7b = texB.Sample(samp, uv7);
    float d7a = texA.Sample(samp, uv7);

    float d11r = texR.Sample(samp, uv11);
    float d11g = texG.Sample(samp, uv11);
    float d11b = texB.Sample(samp, uv11);
    float d11a = texA.Sample(samp, uv11);

    float d22r = texR.Sample(samp, uv22);
    float d22g = texG.Sample(samp, uv22);

    float4 result;
    result.r =
        +d22r * +0.0329056f
        + d7r * -0.0962282f
        + d0r * +0.741732f
        + d2r * -0.0962282f
        + d11r * +0.0329056f

        + d7b * -0.0207458f
        + d0b * +0.328289f
        + d2b * +0.328289f
        + d11b * -0.0207458f;
    
    result.g =
        + d22g * +0.0329056f
        + d7g * -0.0962282f
        + d0g * +0.741732f
        + d2g * -0.0962282f
        + d11g * +0.0329056f

        + d7a * -0.0207458f
        + d0a * +0.328289f
        + d2a * +0.328289f
        + d11a * -0.0207458f;

    result.b =
        + d22r * +0.0741942f
        + d7r * -0.480641f
        + d0r * -0.480641f
        + d2r * +0.0741942f
    
        + d7b * -0.0467767f
        + d0b * +0.906447f
        + d2b * -0.0467767f;

    result.a =
        + d22g * +0.0741942f
        + d7g * -0.480641f
        + d0g * -0.480641f
        + d2g * +0.0741942f

        + d7a * -0.0467767f
        + d0a * +0.906447f
        + d2a * -0.0467767f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

// CDF 9/7 ConvolutionSeparableStar
float4 CDF9_7ConvolutionSeparableStarStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);
    float4 d16 = texRGBA.Sample(samp, uv16);
    float4 d17 = texRGBA.Sample(samp, uv17);

    float4 result;
    result.r =
        + d5.r * +0.116939f
        + d0.r * +0.9549f
        + d4.r * -0.129134f
        + d16.r * +0.0329056f

        + d0.g * -0.0737259f
        + d4.g * +0.349035f
        + d16.g * -0.0207458f;

    result.g =
        + d17.r * +0.0741942f
        + d5.r * -0.480641f
        + d0.r * -0.480641f
        + d4.r * +0.0741942f

        + d5.g * -0.0467767f
        + d0.g * +0.906447f
        + d4.g * -0.0467767f;

    result.b =
        + d5.b * +0.116939f
        + d0.b * +0.9549f
        + d4.b * -0.129134f
        + d16.b * +0.0329056f

        + d0.a * -0.0737259f
        + d4.a * +0.349035f
        + d16.a * -0.0207458f;

    result.a =
        + d17.b * +0.0741942f
        + d5.b * -0.480641f
        + d0.b * -0.480641f
        + d4.b * +0.0741942f

        + d5.a * -0.0467767f
        + d0.a * +0.906447f
        + d4.a * -0.0467767f;

    result.rb += result.ga * 0.443507f;
    result.ba += result.rg * -1.58613f;

    return result;
}

float4 CDF9_7ConvolutionSeparableStarStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);
    float4 d11 = texRGBA.Sample(samp, uv11);
    float4 d22 = texRGBA.Sample(samp, uv22);

    float4 result;
    result.r =
        + d7.r * +0.116939f
        + d0.r * +0.837961f
        + d2.r * +0.424483f

        + d0.b * -0.0737259f
        + d2.b * +0.349035f
        + d11.b * -0.0207458f;

    result.g =
        + d7.g * +0.116939f
        + d0.g * +0.837961f
        + d2.g * +0.424483f

        + d0.a * -0.0737259f
        + d2.a * +0.349035f
        + d11.a * -0.0207458f;

    result.b =
        + d22.r * +0.0741942f
        + d7.r * -0.554835f
        + d0.r * +0.957105f
    
        + d7.b * -0.0467767f
        + d0.b * +0.906447f
        + d2.b * -0.0467767f;

    result.a =
        + d22.g * +0.0741942f
        + d7.g * -0.554835f
        + d0.g * +0.957105f

        + d7.a * -0.0467767f
        + d0.a * +0.906447f
        + d2.a * -0.0467767f;

    result.rg += result.ba * 0.443507f;

    return result;
}

// CDF 9/7 ConvolutionSeparableStar4tex
psOut4 CDF9_7ConvolutionSeparableStar4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);
    float2 uv16 = i.uv0 + float2(-textureResolution.z, 0.0f);
    float2 uv17 = i.uv0 + float2(textureResolution.z, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5g = texG.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);
    float d5a = texA.Sample(samp, uv5);

    float d16r = texR.Sample(samp, uv16);
    float d16g = texG.Sample(samp, uv16);
    float d16b = texB.Sample(samp, uv16);
    float d16a = texA.Sample(samp, uv16);

    float d17r = texR.Sample(samp, uv17);
    float d17b = texB.Sample(samp, uv17);


    float4 result;
    result.r =
        + d5r * +0.116939f
        + d0r * +0.9549f
        + d4r * -0.129134f
        + d16r * +0.0329056f

        + d0g * -0.0737259f
        + d4g * +0.349035f
        + d16g * -0.0207458f;

    result.g =
        + d17r * +0.0741942f
        + d5r * -0.480641f
        + d0r * -0.480641f
        + d4r * +0.0741942f

        + d5g * -0.0467767f
        + d0g * +0.906447f
        + d4g * -0.0467767f;

    result.b =
        + d5b * +0.116939f
        + d0b * +0.9549f
        + d4b * -0.129134f
        + d16b * +0.0329056f

        + d0a * -0.0737259f
        + d4a * +0.349035f
        + d16a * -0.0207458f;

    result.a =
        + d17b * +0.0741942f
        + d5b * -0.480641f
        + d0b * -0.480641f
        + d4b * +0.0741942f

        + d5a * -0.0467767f
        + d0a * +0.906447f
        + d4a * -0.0467767f;

    result.rb += result.ga * 0.443507f;
    result.ba += result.rg * -1.58613f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}

psOut4 CDF9_7ConvolutionSeparableStar4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);
    float2 uv11 = i.uv0 + float2(0.0f, textureResolution.z);
    float2 uv22 = i.uv0 + float2(0.0f, -textureResolution.z);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);
    float d7b = texB.Sample(samp, uv7);
    float d7a = texA.Sample(samp, uv7);

    float d11b = texB.Sample(samp, uv11);
    float d11a = texA.Sample(samp, uv11);

    float d22r = texR.Sample(samp, uv22);
    float d22g = texG.Sample(samp, uv22);

    float4 result;
    result.r =
        + d7r * +0.116939f
        + d0r * +0.837961f
        + d2r * +0.424483f

        + d0b * -0.0737259f
        + d2b * +0.349035f
        + d11b * -0.0207458f;

    result.g =
        + d7g * +0.116939f
        + d0g * +0.837961f
        + d2g * +0.424483f

        + d0a * -0.0737259f
        + d2a * +0.349035f
        + d11a * -0.0207458f;

    result.b =
        + d22r * +0.0741942f
        + d7r * -0.554835f
        + d0r * +0.957105f

        + d7b * -0.0467767f
        + d0b * +0.906447f
        + d2b * -0.0467767f;

    result.a =
        + d22g * +0.0741942f
        + d7g * -0.554835f
        + d0g * +0.957105f

        + d7a * -0.0467767f
        + d0a * +0.906447f
        + d2a * -0.0467767f;

    result.rg += result.ba * 0.443507f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}