#include "base.hlsl"

// Sweldens
float4 CDF5_3SweldensStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );

    return float4( d0.r, d0.g + d0.r * -0.5f + d5.r * -0.5f , d0.b, d0.a + d0.b * -0.5f + d5.b * -0.5f );
}

float4 CDF5_3SweldensStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d7 = texRGBA.Sample( samp, uv7 );

    return float4( d0.r, d0.g, d0.b + d0.r * -0.5f + d7.r * -0.5f, d0.a + d0.g * -0.5f + d7.g * -0.5f );
}

float4 CDF5_3SweldensStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    return float4( d0.r + d0.g * 0.25f + d4.g * 0.25f, d0.g, d0.b + d0.a * 0.25f + d4.a * 0.25f, d0.a );
}

float4 CDF5_3SweldensStep4( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );

    return float4( d0.r + d0.b * 0.25f + d2.b * 0.25f, d0.g + d0.a * 0.25f + d2.a * 0.25f, d0.b, d0.a );
}

// Sweldens4tex
psOut2 CDF5_3Sweldens4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    psOut2 output;
    output.target0 = d0g + d0r * -0.5f + d5r * -0.5f; // g
    output.target1 = d0a + d0b * -0.5f + d5b * -0.5f; // a
    return output;
}

psOut2 CDF5_3Sweldens4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0b + d0r * -0.5f + d7r * -0.5f; // b
    output.target1 = d0a + d0g * -0.5f + d7g * -0.5f; // a
    return output;
}

psOut2 CDF5_3Sweldens4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    psOut2 output;
    output.target0 = d0r + d0g * 0.25f + d4g * 0.25f; // r
    output.target1 = d0b + d0a * 0.25f + d4a * 0.25f; // b
    return output;
}

psOut2 CDF5_3Sweldens4texStep4( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    psOut2 output;
    output.target0 = d0r + d0b * 0.25f + d2b * 0.25f; // r
    output.target1 = d0g + d0a * 0.25f + d2a * 0.25f; // g
    return output;
}

// Iwahashi
float4 CDF5_3IwahashiStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * -0.5f + d5.b * -0.5f + d0.g * -0.5f + d7.g * -0.5f + d0.r * 0.25f + d5.r * 0.25f + d7.r * 0.25f + d8.r * 0.25f );
}

float4 CDF5_3IwahashiStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * -0.5f + d5.r * -0.5f + d0.a * 0.25f + d2.a * 0.25f, d0.b + d0.a * 0.25f + d4.a * 0.25f + d0.r  * -0.5f + d7.r * -0.5f, d0.a );
}

float4 CDF5_3IwahashiStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * -0.0625f + d1.a * -0.0625f + d2.a* -0.0625f + d4.a * -0.0625f + d0.g * 0.25f + d4.g * 0.25f + d0.b  * 0.25f + d2.b * 0.25f, d0.g, d0.b, d0.a );
}

// Iwahashi4tex
psOut1 CDF5_3Iwahashi4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * -0.5f + d5b * -0.5f + d0g * -0.5f + d7g * -0.5f + d0r  * 0.25f + d5r  * 0.25f + d7r * 0.25f + d8r * 0.25f; // a
    return output;
}

psOut2 CDF5_3Iwahashi4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * -0.5f + d5r * -0.5f + d0a * 0.25f + d2a * 0.25f; // g
    output.target1 = d0b + d0a * 0.25f + d4a * 0.25f + d0r * -0.5f + d7r * -0.5f; // b
    return output;
}

psOut1 CDF5_3Iwahashi4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    psOut1 output;
    output.target0 = d0r + d0a * -0.0625f + d1a * -0.0625f + d2a * -0.0625f + d4a * -0.0625f + d0g * 0.25f + d4g * 0.25f + d0b * 0.25f + d2b * 0.25f; // r
    return output;
}

// IwahashiStar
float4 CDF5_3IwahashiStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g, d0.b, d0.a + d0.b * -0.5f + d5.b * -0.5f + d0.g * -0.5f + d7.g * -0.5f + d0.r * 0.25f + d5.r * 0.25f + d7.r * 0.25f + d8.r * 0.25f );
}

float4 CDF5_3IwahashiStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r, d0.g + d0.r * -0.5f + d5.r * -0.5f + d2.a * 0.25f, d0.b + d4.a * 0.25f + d0.r  * -0.5f + d7.r * -0.5f, d0.a );
}

float4 CDF5_3IwahashiStarStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * -0.0625f + d2.b * 0.25f + d4.g * 0.25f, d0.g, d0.b, d0.a );

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    return result;
}

// IwahashiStar4tex
psOut1 CDF5_3IwahashiStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut1 output;
    output.target0 = d0a + d0b * -0.5f + d5b * -0.5f + d0g * -0.5f + d7g * -0.5f + d0r * 0.25f + d5r * 0.25f + d7r * 0.25f + d8r * 0.25f; // a
    return output;
}

psOut2 CDF5_3IwahashiStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0g + d0r * -0.5f + d5r * -0.5f + d2a * 0.25f; // g
    output.target1 = d0b + d4a * 0.25f + d0r  * -0.5f + d7r * -0.5f; // b
    return output;
}

psOut3 CDF5_3IwahashiStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * -0.0625f + d2b * 0.25f + d4g * 0.25f, d0g, d0b, d0a );

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// Explosive
float4 CDF5_3ExplosiveStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * -0.5f + d5.r * -0.5f, d0.b + d0.r * -0.5f + d7.r * -0.5f, d0.a + d0.r * -0.25f + d5.r * -0.25f + d7.r * -0.25f + d8.r * -0.25f );
}

float4 CDF5_3ExplosiveStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d0.b * 0.25f + d2.b * 0.25f + d0.g * 0.25f + d4.g * 0.25f, d0.g, d0.b, d0.a + d0.b * -0.5f + d5.b * -0.5f + d0.g * -0.5f + d7.g * -0.5f );
}

float4 CDF5_3ExplosiveStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * 0.0625f + d1.a * 0.0625f + d2.a * 0.0625f + d4.a * 0.0625f, d0.g + d0.a * 0.25f + d2.a * 0.25f, d0.b + d0.a * 0.25f + d4.a * 0.25f, d0.a );
}

// Explosive4tex
psOut3 CDF5_3Explosive4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * -0.5f + d5r * -0.5f; // g
    output.target1 = d0b + d0r * -0.5f + d7r * -0.5f; // b
    output.target2 = d0a + d0r * -0.25f + d5r  * -0.25f + d7r  * -0.25f + d8r * -0.25f; // a
    return output;
}

psOut2 CDF5_3Explosive4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d0b * 0.25f + d2b * 0.25f + d0g * 0.25f + d4g * 0.25f; // r
    output.target1 = d0a + d0b * -0.5f + d5b * -0.5f + d0g * -0.5f + d7g * -0.5f; // a
    return output;
}

psOut3 CDF5_3Explosive4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    psOut3 output;
    output.target0 = d0r + d0a * 0.0625f + d1a * 0.0625f + d2a * 0.0625f + d4a * 0.0625f; // r
    output.target1 = d0g + d0a * 0.25f + d2a * 0.25f; // g
    output.target2 = d0b + d0a * 0.25f + d4a * 0.25f; // b
    return output;
}

// ExplosiveStar
float4 CDF5_3ExplosiveStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r * -0.5f + d5.r * -0.5f, d0.b + d0.r * -0.5f + d7.r * -0.5f, d0.a + d0.r * 0.25f + d8.r * -0.25f + d0.g * -0.5f + d0.b * -0.5f );
}

float4 CDF5_3ExplosiveStarStep2( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    return float4( d0.r + d2.b * 0.25f + d4.g * 0.25f, d0.g, d0.b, d0.a + d5.b * -0.5f + d7.g * -0.5f );
}

float4 CDF5_3ExplosiveStarStep3( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d1.a * 0.0625f, d0.g + d2.a * 0.25f, d0.b + d4.a * 0.25f, d0.a );

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    return result;
}

// ExplosiveStar4tex
psOut3 CDF5_3ExplosiveStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    psOut3 output;
    output.target0 = d0g + d0r * -0.5f + d5r * -0.5f; // r
    output.target1 = d0b + d0r * -0.5f + d7r * -0.5f; // g
    output.target2 = d0a + d0r * 0.25f + d8r * -0.25f + d0g * -0.5f + d0b * -0.5f; // b
    return output;
}

psOut2 CDF5_3ExplosiveStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d4g = texG.Sample( samp, uv4 );
    float d5b = texB.Sample( samp, uv5 );
    float d7g = texG.Sample( samp, uv7 );

    psOut2 output;
    output.target0 = d0r + d2b * 0.25f + d4g * 0.25f; // r
    output.target1 = d0a + d5b * -0.5f + d7g * -0.5f; // a
    return output;
}

psOut3 CDF5_3ExplosiveStar4texStep3( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d1a = texA.Sample( samp, uv1 );
    float d2a = texA.Sample( samp, uv2 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d1a * 0.0625f, d0g + d2a * 0.25f, d0b + d4a * 0.25f, d0a );

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// Monolithic
float4 CDF5_3MonolithicStep1( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );
    return float4( d0.r, d0.g + d0.r* -0.5f + d5.r* -0.5f, d0.b + d0.r* -0.5f + d7.r * -0.5f, d0.a + d0.r * 0.25f + d5.r * 0.25f + d7.r * 0.25f + d8.r * 0.25f + d0.g * -0.5f + d7.g * -0.5f + d0.b * -0.5f + d5.b * -0.5f );
}

float4 CDF5_3MonolithicStep2( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    return float4( d0.r + d0.a * 0.0625f + d1.a * 0.0625f + d2.a * 0.0625f + d4.a * 0.0625f + d0.g * 0.25f + d4.g * 0.25f + d0.b * 0.25f + d2.b * 0.25f, d0.g + d0.a * 0.25f + d2.a * 0.25f, d0.b + d0.a * 0.25f + d4.a * 0.25f, d0.a );
}

// Monolithic4tex
psOut3 CDF5_3Monolithic4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );
    psOut3 output;
    output.target0 = d0g + d0r * -0.5f + d5r * -0.5f; // g
    output.target1 = d0b + d0r * -0.5f + d7r * -0.5f; // b
    output.target2 = d0a + d0r * 0.25f + d5r * 0.25f + d7r * 0.25f + d8r * 0.25f + d0g * -0.5f + d7g * -0.5f + d0b * -0.5f + d5b * -0.5f; // a
    return output;
}

psOut3 CDF5_3Monolithic4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d1a = texA.Sample( samp, uv1 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );
    psOut3 output;
    output.target0 = d0r + d0a * 0.0625f + d1a * 0.0625f + d2a * 0.0625f + d4a * 0.0625f + d0g * 0.25f + d4g * 0.25f + d0b * 0.25f + d2b * 0.25f; // r
    output.target1 = d0g + d0a * 0.25f + d2a * 0.25f; // g
    output.target2 = d0b + d0a * 0.25f + d4a * 0.25f; // b
    return output;
}

// MonolithicStar
float4 CDF5_3MonolithicStarStep1( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result = float4( d0.r, d0.g + d5.r * -0.5f, d0.b + d7.r * -0.5f, d0.a + d8.r * 0.25f + d7.g * -0.5f + d5.b * -0.5f ); // T_P1

    result.ga += result.rb * -0.5f; // T_P0^H
    result.ba += result.rg * -0.5f; // T_P0^V

    return result;
}

float4 CDF5_3MonolithicStarStep2( v2f i ) : SV_Target {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d4 = texRGBA.Sample( samp, uv4 );

    float4 result = float4( d0.r + d2.b * 0.25f + d4.g * 0.25f + d1.a * 0.0625f, d0.g + d2.a * 0.25f, d0.b + d4.a * 0.25f, d0.a ); // S_U1

    result.rb += result.ga * 0.25f; // S_U0^H
    result.rg += result.ba * 0.25f; // S_U0^V

    return result;
}


// MonolithicStar4tex
psOut3 CDF5_3MonolithicStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );
    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );
    float d8r = texR.Sample( samp, uv8 );

    float4 result = float4( d0r, d0g + d5r * -0.5f, d0b + d7r * -0.5f, d0a + d8r * 0.25f + d7g * -0.5f + d5b * -0.5f );

    result.ga += result.rb * -0.5f;
    result.ba += result.rg * -0.5f;

    psOut3 output;
    output.target0 = result.g; // g
    output.target1 = result.b; // b
    output.target2 = result.a; // a
    return output;
}

psOut3 CDF5_3MonolithicStar4texStep2( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );
    float d1a = texA.Sample( samp, uv1 );
    float d4g = texG.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float4 result = float4( d0r + d2b * 0.25f + d4g * 0.25f + d1a * 0.0625f, d0g + d2a * 0.25f, d0b + d4a * 0.25f, d0a );

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    psOut3 output;
    output.target0 = result.r; // r
    output.target1 = result.g; // g
    output.target2 = result.b; // b
    return output;
}

// Polyphase
float4 CDF5_3PolyphaseStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result;
    result.r = d0.r * 0.5625f + d1.r * 0.015625f + d2.r * -0.09375f + d3.r * 0.015625f + d4.r * -0.09375f + d5.r * -0.09375f + d6.r * 0.015625f + d7.r * -0.09375f + d8.r * 0.015625f
        + d0.g * 0.1875f + d1.g * -0.03125f + d2.g * -0.03125f + d4.g * 0.1875f + d6.g * -0.03125f + d7.g * -0.03125f
        + d0.b * 0.1875f + d1.b * -0.03125f + d2.b * 0.1875f + d3.b * -0.03125f + d4.b * -0.03125f + d5.b * -0.03125f
        + d0.a * 0.0625f + d1.a * 0.0625f + d2.a * 0.0625f + d4.a * 0.0625f;

    result.g = d0.r * -0.375f + d2.r * 0.0625f + d3.r * 0.0625f + d5.r * -0.375f + d7.r * 0.0625f + d8.r * 0.0625f
        + d0.g * 0.75f + d2.g * -0.125f + d7.g * -0.125f
        + d0.b * -0.125f + d2.b * -0.125f + d3.b * -0.125f + d5.b * -0.125f
        + d0.a * 0.25f + d2.a * 0.25f;

    result.b = d0.r * -0.375f + d4.r * 0.0625f + d5.r * 0.0625f + d6.r * 0.0625f + d7.r * -0.375f + d8.r * 0.0625f
        + d0.g * -0.125f + d4.g * -0.125f + d6.g * -0.125f + d7.g * -0.125f
        + d0.b * 0.75f + d4.b * -0.125f + d5.b * -0.125f
        + d0.a * 0.25f + d4.a * 0.25f;

    result.a = d0.r * 0.25f + d5.r * 0.25f + d7.r * 0.25f + d8.r * 0.25f
        + d0.g * -0.5f + d7.g * -0.5f
        + d0.b * -0.5f + d5.b * -0.5f
        + d0.a;
    return result;
}

// Polyphase4tex
psOut4 CDF5_3Polyphase4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );


    psOut4 output;
    output.target0 = d0r * 0.5625f + d1r * 0.015625f + d2r * -0.09375f + d3r * 0.015625f + d4r * -0.09375f + d5r * -0.09375f + d6r * 0.015625f + d7r * -0.09375f + d8r * 0.015625f
        + d0g * 0.1875f + d1g * -0.03125f + d2g * -0.03125f + d4g * 0.1875f + d6g * -0.03125f + d7g * -0.03125f
        + d0b * 0.1875f + d1b * -0.03125f + d2b * 0.1875f + d3b * -0.03125f + d4b * -0.03125f + d5b * -0.03125f
        + d0a * 0.0625f + d1a * 0.0625f + d2a * 0.0625f + d4a * 0.0625f;

    output.target1 = d0r * -0.375f + d2r * 0.0625f + d3r * 0.0625f + d5r * -0.375f + d7r * 0.0625f + d8r * 0.0625f
        + d0g * 0.75f + d2g * -0.125f + d7g * -0.125f
        + d0b * -0.125f + d2b * -0.125f + d3b * -0.125f + d5b * -0.125f
        + d0a * 0.25f + d2a * 0.25f;

    output.target2 = d0r * -0.375f + d4r * 0.0625f + d5r * 0.0625f + d6r * 0.0625f + d7r * -0.375f + d8r * 0.0625f
        + d0g * -0.125f + d4g * -0.125f + d6g * -0.125f + d7g * -0.125f
        + d0b * 0.75f + d4b * -0.125f + d5b * -0.125f
        + d0a * 0.25f + d4a * 0.25f;

    output.target3 = d0r * 0.25f + d5r * 0.25f + d7r * 0.25f + d8r * 0.25f
        + d0g * -0.5f + d7g * -0.5f
        + d0b * -0.5f + d5b * -0.5f
        + d0a;
    return output;
}

// PolyphaseSeparable
float4 CDF5_3PolyphaseSeparableStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0.r * 0.75f + d4.r * -0.125f + d5.r * -0.125f
        + d0.g * 0.25f + d4.g * 0.25f;

    result.g =
        + d0.r * -0.5f + d5.r * -0.5f
        + d0.g;

    result.b =
        + d0.b * 0.75f + d4.b * -0.125f + d5.b * -0.125f
        + d0.a * 0.25f + d4.a * 0.25f;

    result.a =
        + d0.b * -0.5f + d5.b * -0.5f
        + d0.a;
    return result;
}

float4 CDF5_3PolyphaseSeparableStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);

    float4 result;
    result.r =
        + d0.r * 0.75f + d2.r * -0.125f + d7.r * -0.125f
        + d0.b * 0.25f + d2.b * 0.25f;

    result.g =
        + d0.g * 0.75f + d2.g * -0.125f + d7.g * -0.125f
        + d0.a * 0.25f + d2.a * 0.25f;

    result.b =
        + d0.r * -0.5f + d7.r * -0.5f
        + d0.b;

    result.a =
        + d0.g * -0.5f + d7.g * -0.5f
        + d0.a;
    return result;
}

// PolyphaseSeparable4tex
psOut4 CDF5_3PolyphaseSeparable4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2r = texR.Sample(samp, uv2);
    float d2g = texG.Sample(samp, uv2);
    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);


    psOut4 result;
    result.target0 =
        + d0r * 0.75f + d2r * -0.125f + d7r * -0.125f
        + d0b * 0.25f + d2b * 0.25f;

    result.target1 =
        + d0g * 0.75f + d2g * -0.125f + d7g * -0.125f
        + d0a * 0.25f + d2a * 0.25f;

    result.target2 =
        + d0r * -0.5f + d7r * -0.5f
        + d0b;

    result.target3 =
        + d0g * -0.5f + d7g * -0.5f
        + d0a;
    return result;
}

psOut4 CDF5_3PolyphaseSeparable4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);

    psOut4 result;
    result.target0 =
        + d0r * 0.75f + d4r * -0.125f + d5r * -0.125f
        + d0g * 0.25f + d4g * 0.25f;

    result.target1 =
        + d0r * -0.5f + d5r * -0.5f
        + d0g;

    result.target2 =
        + d0b * 0.75f + d4b * -0.125f + d5b * -0.125f
        + d0a * 0.25f + d4a * 0.25f;

    result.target3 =
        + d0b * -0.5f + d5b * -0.5f
        + d0a;
    return result;
}

// PolyphaseSeparableStar
float4 CDF5_3PolyphaseSeparableStarStep1(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d4 = texRGBA.Sample(samp, uv4);
    float4 d5 = texRGBA.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0.r * 0.875f + d4.r * -0.125f
        + d4.g * 0.25f;

    result.g =
        + d0.r * -0.5f + d5.r * -0.5f
        + d0.g;

    result.b =
        + d0.b * 0.875f + d4.b * -0.125f
        + d4.a * 0.25f;

    result.a =
        + d0.b * -0.5f + d5.b * -0.5f
        + d0.a;
    
    result.rb += result.ga * 0.25f;
    result.ba += result.rg * -0.5f;

    return result;
}

float4 CDF5_3PolyphaseSeparableStarStep2(v2f i) : SV_Target
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float4 d0 = texRGBA.Sample(samp, uv0);
    float4 d2 = texRGBA.Sample(samp, uv2);
    float4 d7 = texRGBA.Sample(samp, uv7);

    float4 result;
    result.r =
        + d0.r * 0.875f
        + d2.b * 0.25f;

    result.g =
        + d0.g * 0.875f
        + d2.a * 0.25f;

    result.b =
        + d7.r * -0.5f
        + d0.b;

    result.a =
        + d7.g * -0.5f
        + d0.a;

    result.rg += result.ba * 0.25f;

    return result;
}

// PolyphaseSeparableStar4tex
psOut4 CDF5_3PolyphaseSeparableStar4texStep1(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv4 = uv0 + float2(-textureResolution.y, 0.0f);
    float2 uv5 = uv0 + float2(textureResolution.y, 0.0f);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d4r = texR.Sample(samp, uv4);
    float d4g = texG.Sample(samp, uv4);
    float d4b = texB.Sample(samp, uv4);
    float d4a = texA.Sample(samp, uv4);

    float d5r = texR.Sample(samp, uv5);
    float d5b = texB.Sample(samp, uv5);

    float4 result;
    result.r =
        + d0r * 0.875f + d4r * -0.125f
        + d4g * 0.25f;

    result.g =
        + d0r * -0.5f + d5r * -0.5f
        + d0g;

    result.b =
        + d0b * 0.875f + d4b * -0.125f
        + d4a * 0.25f;

    result.a =
        + d0b * -0.5f + d5b * -0.5f
        + d0a;

    result.rb += result.ga * 0.25f;
    result.ba += result.rg * -0.5f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

psOut4 CDF5_3PolyphaseSeparableStar4texStep2(v2f i)
{
    float2 uv0 = i.uv0;
    float2 uv2 = uv0 + float2(0.0f, textureResolution.y);
    float2 uv7 = uv0 + float2(0.0f, -textureResolution.y);

    float d0r = texR.Sample(samp, uv0);
    float d0g = texG.Sample(samp, uv0);
    float d0b = texB.Sample(samp, uv0);
    float d0a = texA.Sample(samp, uv0);

    float d2b = texB.Sample(samp, uv2);
    float d2a = texA.Sample(samp, uv2);

    float d7r = texR.Sample(samp, uv7);
    float d7g = texG.Sample(samp, uv7);

    float4 result;
    result.r =
        + d0r * 0.875f
        + d2b * 0.25f;

    result.g =
        + d0g * 0.875f
        + d2a * 0.25f;

    result.b =
        + d7r * -0.5f
        + d0b;

    result.a =
        + d7g * -0.5f
        + d0a;

    result.rg += result.ba * 0.25f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;

    return output;
}

// PolyphaseStar
float4 CDF5_3PolyphaseStarStep1( v2f i ) : SV_Target{
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float4 d0 = texRGBA.Sample( samp, uv0 );
    float4 d1 = texRGBA.Sample( samp, uv1 );
    float4 d2 = texRGBA.Sample( samp, uv2 );
    float4 d3 = texRGBA.Sample( samp, uv3 );
    float4 d4 = texRGBA.Sample( samp, uv4 );
    float4 d5 = texRGBA.Sample( samp, uv5 );
    float4 d6 = texRGBA.Sample( samp, uv6 );
    float4 d7 = texRGBA.Sample( samp, uv7 );
    float4 d8 = texRGBA.Sample( samp, uv8 );

    float4 result;
    result.r = +d0.r * 0.765625f - d2.r * 0.109375f - d4.r * 0.109375f + d1.r * 0.015625f
        + d4.g * 0.21875f - d1.g * 0.03125f
        + d2.b * 0.21875f - d1.b * 0.03125f
        + d1.a * 0.0625f;

    result.g = -d5.r * 0.4375f + d3.r * 0.0625f - d0.r * 0.4375f + d2.r * 0.0625f
        + d0.g * 0.875f - d2.g * 0.125f
        - d3.b * 0.125f - d2.b * 0.125f
        + d2.a * 0.25f;

    result.b = -d7.r * 0.4375f - d0.r * 0.4375f + d6.r * 0.0625f + d4.r * 0.0625f
        - d6.g * 0.125f - d4.g * 0.125f
        + d0.b * 0.875f - d4.b * 0.125f
        + d4.a * 0.25f;

    result.a = d0.r * 0.25f + d5.r * 0.25f + d7.r * 0.25f + d8.r * 0.25f
        + d0.g * -0.5f + d7.g * -0.5f
        + d0.b * -0.5f + d5.b * -0.5f
        + d0.a;

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    return result;
}

// PolyphaseStar4tex
psOut4 CDF5_3PolyphaseStar4texStep1( v2f i ) {
    float2 uv0 = i.uv0;
    float2 uv1 = uv0 + float2( -textureResolution.y, textureResolution.y );
    float2 uv2 = uv0 + float2( 0.0f, textureResolution.y );
    float2 uv3 = uv0 + float2( textureResolution.y, textureResolution.y );
    float2 uv4 = uv0 + float2( -textureResolution.y, 0.0f );
    float2 uv5 = uv0 + float2( textureResolution.y, 0.0f );
    float2 uv6 = uv0 + float2( -textureResolution.y, -textureResolution.y );
    float2 uv7 = uv0 + float2( 0.0f, -textureResolution.y );
    float2 uv8 = uv0 + float2( textureResolution.y, -textureResolution.y );

    float d0r = texR.Sample( samp, uv0 );
    float d0g = texG.Sample( samp, uv0 );
    float d0b = texB.Sample( samp, uv0 );
    float d0a = texA.Sample( samp, uv0 );

    float d1r = texR.Sample( samp, uv1 );
    float d1g = texG.Sample( samp, uv1 );
    float d1b = texB.Sample( samp, uv1 );
    float d1a = texA.Sample( samp, uv1 );

    float d2r = texR.Sample( samp, uv2 );
    float d2g = texG.Sample( samp, uv2 );
    float d2b = texB.Sample( samp, uv2 );
    float d2a = texA.Sample( samp, uv2 );

    float d3r = texR.Sample( samp, uv3 );
    float d3b = texB.Sample( samp, uv3 );

    float d4r = texR.Sample( samp, uv4 );
    float d4g = texG.Sample( samp, uv4 );
    float d4b = texB.Sample( samp, uv4 );
    float d4a = texA.Sample( samp, uv4 );

    float d5r = texR.Sample( samp, uv5 );
    float d5b = texB.Sample( samp, uv5 );

    float d6r = texR.Sample( samp, uv6 );
    float d6g = texG.Sample( samp, uv6 );

    float d7r = texR.Sample( samp, uv7 );
    float d7g = texG.Sample( samp, uv7 );

    float d8r = texR.Sample( samp, uv8 );

    float4 result;
    result.r = +d0r * 0.765625f - d2r * 0.109375f - d4r * 0.109375f + d1r * 0.015625f
        + d4g * 0.21875f - d1g * 0.03125f
        + d2b * 0.21875f - d1b * 0.03125f
        + d1a * 0.0625f;

    result.g = -d5r * 0.4375f + d3r * 0.0625f - d0r * 0.4375f + d2r * 0.0625f
        + d0g * 0.875f - d2g * 0.125f
        - d3b * 0.125f - d2b * 0.125f
        + d2a * 0.25f;

    result.b = -d7r * 0.4375f - d0r * 0.4375f + d6r * 0.0625f + d4r * 0.0625f
        - d6g * 0.125f - d4g * 0.125f
        + d0b * 0.875f - d4b * 0.125f
        + d4a * 0.25f;

    result.a = d0r * 0.25f + d5r * 0.25f + d7r * 0.25f + d8r * 0.25f
        + d0g * -0.5f + d7g * -0.5f
        + d0b * -0.5f + d5b * -0.5f
        + d0a;

    result.rb += result.ga * 0.25f;
    result.rg += result.ba * 0.25f;

    psOut4 output;
    output.target0 = result.r;
    output.target1 = result.g;
    output.target2 = result.b;
    output.target3 = result.a;
    return output;
}