#pragma once

#include <algorithm>
#include <vector>
#include <string>

class Sampler {
public:
    struct Results {
        unsigned int numSamples;
        double sum;
        double min;
        double max;
        double average;
        double median;
        std::vector<double> measurements;
    };

    Sampler();
    void Sample( double value );
    Results GetResults();
    unsigned int NumSamples();
    void Reset();
    ~Sampler();

protected:
    double sum;
    std::vector<double> measurements;
};