#include "Sampler.h"

using namespace std;

Sampler::Sampler() {
}

void Sampler::Sample( double value ) {
    measurements.push_back( value );
    sum += value;
}

Sampler::Results Sampler::GetResults() {
    Results out = {};
    if ( measurements.size() > 0 ) {
        out.measurements = measurements;
        sort( out.measurements.begin(), out.measurements.end() );
        out.min = out.measurements[ 0 ];
        out.max = out.measurements[ out.measurements.size() - 1 ];
        out.average = sum / out.measurements.size();
        if ( out.measurements.size() % 2 ) {
            out.median = out.measurements[ out.measurements.size() / 2 ];
        }
        else {
            out.median = ( out.measurements[ ( out.measurements.size() - 1 ) / 2 ] + out.measurements[ out.measurements.size() / 2 ] ) / 2.0;
        }
        out.sum = sum;
        out.numSamples = out.measurements.size();
        out.measurements = measurements;
    }
    return out;
}

unsigned int Sampler::NumSamples() {
    return measurements.size();
}

void Sampler::Reset() {
    measurements.clear();
    sum = 0;
}

Sampler::~Sampler() {
}