#pragma once
#include <wrl.h>
#include <d3d11.h>
#include <vector>

class ProfilerD3D11 {
public:
    ProfilerD3D11( unsigned int frameLatency, Microsoft::WRL::ComPtr<ID3D11Device>& device, Microsoft::WRL::ComPtr<ID3D11DeviceContext>& context );
    ~ProfilerD3D11();

    // Begin profile block
    void Begin();

    // End profile block and return frame time in seconds
    // - zero or negativ output value represents invalid measurement
    double End();

    // Reset profiler
    void Reset();

protected:
    // Init profiler
    void Init();

    // Struct for queries
    struct PerFrameQueries {
        Microsoft::WRL::ComPtr<ID3D11Query> disjointQuery;
        Microsoft::WRL::ComPtr<ID3D11Query> timestampQueryBegin;
        Microsoft::WRL::ComPtr<ID3D11Query> timestampQueryEnd;
    };

    // Profiler latency
    const unsigned int  frameLatency;

    // Current frame index
    unsigned int currentFrame;

    // Direct3D device and device context
    Microsoft::WRL::ComPtr<ID3D11Device>        device;
    Microsoft::WRL::ComPtr<ID3D11DeviceContext> context;

    // Queries
    std::vector<PerFrameQueries>    perFrameQueries;
};