#pragma once
#include <windows.h>
#include <d3d11.h>
#include <D3Dcompiler.h>

#include <iostream>
#include <string>

inline void ThrowIfFailed( HRESULT hr ) {
    if ( FAILED( hr ) ) {
        throw;
    }
}

inline void ThrowIfFailed( HRESULT hr, std::wstring message ) {
    if ( FAILED( hr ) ) {
        std::wcout << message << std::endl;
        MessageBox( nullptr, message.c_str(), L"Application Error", MB_ICONERROR | MB_ICONERROR );
        throw;
    }
}

inline void ThrowIfFailed( HRESULT hr, std::wstring message, std::wstring info ) {
    if ( FAILED( hr ) ) {
        std::wcout << message << std::endl;
        std::wcout << info << std::endl;
        message.append( L"\n" );
        message.append( info );
        MessageBox( nullptr, message.c_str(), L"Application Error", MB_ICONERROR | MB_ICONERROR );
        throw;
    }
}

// Helper for compiling shaders with D3DX11
void CompileShaderFromFile( LPCWSTR szFileName, LPCSTR szEntryPoint, LPCSTR szShaderModel, ID3DBlob** ppBlobOut );