#include "DXHelper.h"
#include <wrl.h>
#include <string>
#include <iostream>

// Helper for compiling shaders with D3DX11
void CompileShaderFromFile( LPCWSTR szFileName, LPCSTR szEntryPoint, LPCSTR szShaderModel, ID3DBlob** ppBlobOut ) {
    using namespace Microsoft::WRL;
    DWORD dwShaderFlags = D3DCOMPILE_ENABLE_STRICTNESS | D3DCOMPILE_OPTIMIZATION_LEVEL3;

#if defined( DEBUG ) || defined( _DEBUG )
   // dwShaderFlags |= D3DCOMPILE_DEBUG;
#endif

    ComPtr<ID3DBlob> errorBlob;
    std::string errorMessage;
    HRESULT hr = D3DCompileFromFile( szFileName, nullptr, D3D_COMPILE_STANDARD_FILE_INCLUDE, szEntryPoint, szShaderModel, dwShaderFlags, 0, ppBlobOut, errorBlob.GetAddressOf() );
    if ( errorBlob ) {
        errorMessage = static_cast< char* >( errorBlob.Get()->GetBufferPointer() );
        std::wcout << std::wstring( errorMessage.begin(), errorMessage.end() ) << std::endl;
    }
    ThrowIfFailed( hr, L"D3DCompileFromFile error", std::wstring( errorMessage.begin(), errorMessage.end() ) );
}