#pragma once
#include "DWTSchemeD3D11.h"
class DWTSchemeD3D11Deferred :
    public DWTSchemeD3D11 {
public:
    DWTSchemeD3D11Deferred( std::wstring name, int steps, std::wstring shaderFile, RENDER_TARGET_FLAG * renderTargetFlag = nullptr );

    // Prepare scheme for running with specified resolution
    virtual void Init( unsigned int resolution ) override;

    void Init( unsigned int resolution, unsigned int iterations );

    // Run scheme
    virtual void Run( unsigned int iterations ) override;

    // Initialize Direct3D
    static void InitD3D( Microsoft::WRL::ComPtr<ID3D11Device>& device, Microsoft::WRL::ComPtr<ID3D11DeviceContext>& context,
        Microsoft::WRL::ComPtr<ID3D11Buffer>& constantBuffer, Microsoft::WRL::ComPtr<ID3D11VertexShader>& vertexShader,
        Microsoft::WRL::ComPtr<ID3D11SamplerState>& samplerState );

    ~DWTSchemeD3D11Deferred();

protected:
    // Direct3D command list
    static Microsoft::WRL::ComPtr<ID3D11CommandList>          commandList;

    // Static Direct3D resources
    static Microsoft::WRL::ComPtr<ID3D11DeviceContext>        deferredContext;
    static Microsoft::WRL::ComPtr<ID3D11Buffer>               constantBuffer;
    static Microsoft::WRL::ComPtr<ID3D11VertexShader>         vertexShader;
    static Microsoft::WRL::ComPtr<ID3D11SamplerState>         samplerState;
};