#pragma once
#include <string>

class DWTScheme {
public:
    DWTScheme( std::wstring name, int steps );
    virtual ~DWTScheme();

    // Prepare scheme for running with specified resolution
    virtual void Init( unsigned int resolution ) = 0;

    // Run scheme
    virtual void Run( unsigned int iterations = 1 ) = 0;

    // Accessors
    inline std::wstring GetName() const { return name; }
    inline unsigned int GetSteps() const { return steps; }

protected:
    // Scheme properties
    std::wstring name;
    int steps;
};