#pragma once
#include <vector>
#include <memory>
#include "SchemesContainer.h"
#include "Sampler.h"

class Benchmark {
public:
    // Benchmarked resolutions
    static const unsigned int resolutions[];
    static const unsigned int resolutionsCount;

    // Management of benchmarked schemes
    virtual void PreviousScheme() = 0;
    virtual void PreviousResolution() = 0;
    virtual void NextScheme() = 0;
    virtual void NextResolution() = 0;

    // Start automatical benchmark
    virtual void Start() = 0;

    // Run per-frame benchmark
    virtual void Run() = 0;

protected:
    // Shader files
    std::wstring          schemes53File = L"schemes/CDF53.hlsl";
    std::wstring          schemes97File = L"schemes/CDF97.hlsl";
    std::wstring          schemes137File = L"schemes/DD137.hlsl";
};