#include "Application.h"

HWND Application::hWnd = 0;

Application::Application() {
}

Application::~Application() {
}

int Application::Run( AppFrame * applicationFrame, HINSTANCE hInstance, int nCmdShow ) {
    applicationFrame->ConsoleInit();

    if ( !applicationFrame->UseWindow() ) {
        // Don't use window
        RunApplicationFrameWithoutWindow( applicationFrame );
        return 0;
    }

    // Initialize the window class
    WNDCLASSEX windowClass = {};
    windowClass.cbSize = sizeof( WNDCLASSEX );
    windowClass.style = CS_HREDRAW | CS_VREDRAW;
    windowClass.lpfnWndProc = WindowProc;
    windowClass.hInstance = hInstance;
    windowClass.hCursor = LoadCursor( NULL, IDC_ARROW );
    windowClass.lpszClassName = L"DWT-DirectX";
    RegisterClassEx( &windowClass );

    RECT windowRect = { 0, 0,
        static_cast< LONG >( applicationFrame->GetWidth() ),
        static_cast< LONG >( applicationFrame->GetHeight() ) };

    AdjustWindowRect( &windowRect, WS_OVERLAPPEDWINDOW, FALSE );

    // Create the window
    hWnd = CreateWindow(
        windowClass.lpszClassName,
        applicationFrame->GetTitle(),
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        windowRect.right - windowRect.left,
        windowRect.bottom - windowRect.top,
        nullptr,
        nullptr,
        hInstance,
        applicationFrame );

    // Initialize application frame
    applicationFrame->Init();


    ShowWindow( hWnd, nCmdShow );


    // Main sample loop
    MSG msg = {};
    while ( msg.message != WM_QUIT ) {
        // Process any messages in the queue
        if ( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) ) {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
        else {
            // Check if application frame is still running
            if ( !applicationFrame->IsRunning() ) {
                // Otherwise close application
                Application::Close();
            }
            else {
                // Run application frame
                applicationFrame->Run();
            }
        }
    }

    applicationFrame->Destroy();

    // Return wParam of the WM_QUIT message to Windows
    return static_cast< char >( msg.wParam );
}

void Application::RunApplicationFrameWithoutWindow( AppFrame * applicationFrame ) {
    // Initialize application frame
    applicationFrame->Init();

    // Check if application frame is still running
    while ( applicationFrame->IsRunning() ) {
        // Run application frame
        applicationFrame->Run();
    }

    // Destroy application frame
    applicationFrame->Destroy();
}

void Application::Close() {
    PostMessage( hWnd, WM_CLOSE, 0, 0 );
}

// Message handler
LRESULT CALLBACK Application::WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam ) {
    AppFrame* applicationFrame = reinterpret_cast< AppFrame* >( GetWindowLongPtr( hWnd, GWLP_USERDATA ) );

    switch ( message ) {
        case WM_CREATE: {
            // Save the AppFrame* passed in to CreateWindow
            LPCREATESTRUCT createStruct = reinterpret_cast< LPCREATESTRUCT >( lParam );
            SetWindowLongPtr( hWnd, GWLP_USERDATA, reinterpret_cast< LONG_PTR >( createStruct->lpCreateParams ) );
            return 0;
        }

        case WM_KEYDOWN: {
            if ( applicationFrame ) {
                // KeyPress event
                applicationFrame->OnKeyPress( static_cast< unsigned char >( wParam ) );
            }
            return 0;
        }

        case WM_DESTROY: {
            PostQuitMessage( 0 );
            return 0;
        }
    }

    // Handle any messages the switch statement didn't
    return DefWindowProc( hWnd, message, wParam, lParam );
}
