#pragma once
#include "AppFrame.h"
#include "BenchmarkD3D11Schemes.h"
#include "DWTSchemeD3D11.h"
#include "DWTSchemeD3D11Deferred.h"
#include "ProfilerD3D11.h"

#include <string>
#include <memory>
#include <wrl.h>
#include <d3d11.h>
#include <D3Dcompiler.h>

class BenchmarkD3D11Schemes;

class AppFrameD3D11 :
    public AppFrame {
public:
    AppFrameD3D11( std::wstring name, unsigned int width, unsigned int height );
    ~AppFrameD3D11();


    // Inherited via AppFrame
    virtual void Init() override;
    virtual void ConsoleInit() override;
    virtual void Run() override;
    virtual void Destroy() override;

    // KeyPress event
    virtual void OnKeyPress( unsigned char key ) override;

    // Accessors
    DXGI_ADAPTER_DESC GetAdapterDesc() { return adapterDesc; }

protected:
    // Direct3D
    D3D_DRIVER_TYPE                                 driverType = D3D_DRIVER_TYPE_UNKNOWN;
    D3D_FEATURE_LEVEL                               featureLevel = D3D_FEATURE_LEVEL_11_0;

    Microsoft::WRL::ComPtr<ID3D11Device>            device;
    Microsoft::WRL::ComPtr<ID3D11DeviceContext>     context;
    Microsoft::WRL::ComPtr<IDXGISwapChain>          swapChain;

    DXGI_ADAPTER_DESC                               adapterDesc = {};

    // Benchmark
    std::shared_ptr<BenchmarkD3D11Schemes>          benchmark;

    // Initialization functions
    void InitD3D();

};