#pragma once
#include <string>

class AppFrame {
public:
    AppFrame( std::wstring name, unsigned int width, unsigned int height );
    ~AppFrame();

    // Console initialization
    virtual void ConsoleInit() = 0;

    // Application frame initialization
    virtual void Init() = 0;

    // Application frame update/render function (called periodically)
    virtual void Run() = 0;

    // Application frame release
    virtual void Destroy() = 0;

    // Application frame close
    virtual void Close();


    // KeyPress event
    virtual void OnKeyPress( unsigned char key ) = 0;
    // Accessors
    const bool      UseWindow() const { return useWindow; }
    const bool      IsRunning() const { return running; }
    const wchar_t*  GetTitle()  const { return title.c_str(); }
    unsigned int    GetWidth()  const { return width; }
    unsigned int    GetHeight() const { return height; }

protected:
    // Window title
    std::wstring title;
    bool useWindow = true;

    // Viewport dimensions
    unsigned int width;
    unsigned int height;

    // Running flag
    bool running;
};
