#include <stdio.h>
#include <stdlib.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <time.h>
#include <inttypes.h>
#include <flowmonexp/plugin_process.h>
#include "crc/pg_crc.h"
#include <hiredis/hiredis.h>

//#define PRINT(format,args...)
#define PRINT(format,args...) fprintf(stderr,format,##args)
#define PRINTERR(format,args...) fprintf(stderr,format,##args)

#define VERSION "0.1"

/* Set type of plugin - Process */
SET_PLUGIN_TYPE(PLUGIN_TYPE_PROCESS);

/* Structure that holds plugin internal data between functions calls */
typedef struct
{
    int data_offset;    		/* Specific part of record offset value */
    redisContext *c; 
} process_private_t;

/* Specific part of flow record */
typedef struct
{ 
    uint32_t id; 
} process_record_t;

static plugin_desc_t plugin_desc =
{
	"process-nat",
	"Version: " VERSION "\n"
	"Flowmonexp process plugin for correlating NAT traffic.\n"
	"No parameters description:\n",
	sizeof(process_record_t),       
	1
}; 

PLUGIN_PROCESS_DESC
{
    return(&plugin_desc);
}

RECORD_VALID(valid_id)
{
	process_private_t *p = (process_private_t*) self;
	process_record_t *pr = PLUGIN_DATA(r, p->data_offset);

	if (pr->id != 0)
		return (1);
	else
		return (0);
}

RECORD_CURRENT_LENGTH(value_length_32)
{
    return(sizeof(uint32_t));
}

RECORD_FILLER(value_fill_id){
    process_private_t *p = (process_private_t*)self;
    process_record_t *pr = PLUGIN_DATA(record, p->data_offset);
    record_universal_get(dst, &(pr->id), 0, sizeof(uint32_t), len, to_network_byte_order);
}

/* Plugin description for flowmonexp. Displayed with -l switch. TODO */
PLUGIN_PROCESS_INIT
{
	process_private_t *retval;
	retval = malloc (sizeof(process_private_t));
	if (!retval) {
		return(NULL);
	}

    srand ( time(NULL) );
	retval->data_offset = data_offset;

    retval->c = redisConnectUnix("/tmp/redis.sock");
    if (retval->c->err) {
        PRINTERR ("Cannot connect to Redis database: %s\n", retval->c->errstr);
        return(NULL);
    } else {
        PRINT ("Connection Made! \n");
        redisCommand(retval->c, "FLUSHALL");
    }

    getter_add (getter_list, "ID", sizeof(uint32_t), retval, &valid_id, &value_length_32, &value_fill_id);

	return(retval);
}

void print_packet(unsigned char *packet, unsigned int len)
{
    unsigned int x = 0;
    for (x = 0 ; x <= len; x++) {
        fprintf(stderr, "%x ",(*(uint8_t*) (packet + x)));
    }
    fprintf(stderr, "\n");
    return;
}

uint64_t get_hash(unsigned char* buff, unsigned int offset, unsigned int len)
{
    uint64_t hash;
    INIT_CRC64(hash);
    UPDATE_CRC64(hash, buff + offset, len - offset);
    FIN_CRC64(hash);
    return hash;
}

PLUGIN_PROCESS_NEW
{
 //   PRINT ("creating flow\n");
    record_print(1, record);
	process_private_t *p = (process_private_t*) plugin_private;
	process_record_t *pr = PLUGIN_DATA(record, p->data_offset);

    unsigned char *buff;
    unsigned int length;
    unsigned int offset;
    unsigned int ipv4_length;
    uint16_t ethtype;
    struct ethhdr *eth;
    struct ip *ip;
    struct tcphdr *tcp;
    uint64_t hash;
    redisReply *reply;
    unsigned int vlan_length = 0;

    buff = get_packet_data(&length, &offset);
   // print_packet(buff, length);
    
    if (buff != NULL) {
    //    PRINT ("length %d, offset %d\n", length, offset);
        eth = (struct ethhdr*) buff;
        ethtype = ntohs(eth->h_proto);
        
        if (ethtype == ETH_P_8021Q) {
//            PRINT ("VLAN\n");
            ethtype = ntohs(*(uint16_t *)(buff + ETH_HLEN + 2));
            vlan_length += 4;
        }

        if (ethtype == ETH_P_IP) {
        //    PRINT ("IP packet\n");
            ip = (struct ip*) (buff + ETH_HLEN + vlan_length);
            ipv4_length = (ip->ip_hl) * 4;
            
            switch (ip->ip_p) {
                case IPPROTO_UDP: {
          //          PRINT ("UDP\n");
                    hash = get_hash(buff, ETH_HLEN + vlan_length + ipv4_length + 8, length);
                    reply = redisCommand(p->c, "GET %lu", hash);
                    if ( reply->type == REDIS_REPLY_NIL) {
//                        PRINT ("Did not found hash in db, adding.\n");
                        pr->id = rand();
                        redisCommand(p->c, "SET %lu %d", hash, pr->id);
                        PRINT ("UDP %lu %d\n", hash, pr->id);
               //         redisCommand(p->c, "EXPIRE %lu 60", hash);
                    } else if (reply->type == REDIS_REPLY_STRING) {
//                        PRINT ("Found in db, value is %d, deleting\n", atoi(reply->str));
                        PRINT ("UDP %lu %d\n", hash, pr->id);
                        pr->id = atoi(reply->str);
                        redisCommand(p->c, "DEL %lu", hash);
                    }
                    
                    freeReplyObject(reply);
                    break;
                }
                case IPPROTO_TCP: {
            //        PRINT ("TCP\n");
                    tcp = (struct tcphdr*) (buff + ETH_HLEN + vlan_length + ipv4_length);
             //       PRINT ("Sequence number is: %u\n", tcp->seq);
                    reply = redisCommand(p->c, "GET %u", tcp->seq);
                    if ( reply->type == REDIS_REPLY_NIL) {
//                        PRINT ("Did not found hash in db, adding.\n");
                        pr->id = rand();
                        redisCommand(p->c, "SET %u %d", tcp->seq, pr->id);
                        PRINT ("TCP %u %d\n", tcp->seq, pr->id);
             //           reply = redisCommand(p->c, "EXPIRE %u %d", tcp->seq, 60);
             //           PRINT ("redis reply %s", reply->str);
                    } else if (reply->type == REDIS_REPLY_STRING) {
//                        PRINT ("Found in db, value is %d, deleting\n", atoi(reply->str));
                        PRINT ("TCP %u %d\n", tcp->seq, pr->id);
                        pr->id = atoi(reply->str);
                        redisCommand(p->c, "DEL %u", tcp->seq);
                    }

                    freeReplyObject(reply);
                    break;
                }
                case IPPROTO_ICMP: {
//                    PRINT ("ICMP\n");
                    hash = get_hash(buff, ETH_HLEN + vlan_length + ipv4_length, length);                    
//                    PRINT ("Hash %lu\n", hash);
                    
                    reply = redisCommand(p->c, "GET %lu", hash);
                    if ( reply->type == REDIS_REPLY_NIL) {
//                        PRINT ("Did not found hash in db, adding.\n");
                        pr->id = rand();
                        redisCommand(p->c, "SET %lu %d", hash, pr->id);
                        PRINT ("ICMP %lu %d\n", hash, pr->id);
             //           redisCommand(p->c, "EXPIRE %lu 60", hash);
                    } else if (reply->type == REDIS_REPLY_STRING) {
//                        PRINT ("Found in db, value is %d, deleting\n", atoi(reply->str));
                        pr->id = atoi(reply->str);
                        PRINT ("ICMP %lu %d\n", hash, pr->id);
                        redisCommand(p->c, "DEL %lu", hash);
                    }
                    
                    freeReplyObject(reply);
                    break;
                }

                default: {
                    PRINT ("UNKNOWN PROTOCOL\n");
                    return; 
                }
            }

        }
      //  print_packet(buff, length);
    }

}
PLUGIN_PROCESS_UPDATE
{
}

PLUGIN_PROCESS_RELEASE
{
}

PLUGIN_PROCESS_SHUTDOWN
{
    return (0);
}
