#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pcap.h>
#include <string.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <signal.h>
#include <flowmonexp/plugin_input.h>
//#include <flowmonexp/rawnetcap.h>
 
#define SNAPLEN_SIZE 1500
//#define SNAP_SIZE 1000 /* Doesn't work - must be set manually /sys/module/rawnetcap/parameters/packet_size */
//#define RAWNETCAP_TIMEOUT 50 /* RAWNETCAP timeout in microseconds */

#define VERSION "0.1"

#define PRINT(format,args...) fprintf(stderr,format,##args)
#define PRINTERR(format,args...) fprintf(stderr,format,##args)

/* Set type of plugin - Input */
SET_PLUGIN_TYPE(PLUGIN_TYPE_INPUT);


/* Structure that holds plugin internal data between functions calls */
typedef struct 
{
    pcap_t *pcap;        		/* PCAP handler */
	int data_offset;    		/* Specific part of record offset value */
    int offline;         		/* Reading data from live interface or from a file */
//    rawnetcap_t *rawnetcap;
//    int rawnetcap_offset;
} input_private_t;

/* Specific part of flow record */
typedef struct
{
} input_record_t;

/* Plugin description for flowmonexp. Displayed with -l switch. TODO */
static plugin_desc_t plugin_desc =
{
    "nat-input",
    "Version: " VERSION "\n"
    "Flowmonexp input plugin correlating NAT traffic\n"
    "One of input parameters:\n"
    "file  read data from pcap file\n"
    "@if   read data from pcap interface if\n",
	sizeof(input_record_t), 	
	0 
};

/* Return plugin description structure to flowmonexp */
PLUGIN_INPUT_DESC
{
    return(&plugin_desc);
}

PLUGIN_INPUT_INIT
{
    input_private_t *retval;
    char errbuf[PCAP_ERRBUF_SIZE];
    char *filename;

    /* Allocating memory for return structure */
    retval = malloc(sizeof(input_private_t));
    if (!retval) {
        return(NULL);
    }
    retval->pcap = NULL;
//    retval->rawnetcap = NULL;

	retval->offline = 1; 
    if (params[0] == '@') {
        /* live device */
        retval->offline = 0;
        filename = strdup(&params[1]);
    } else {
        /* offline file */
        retval->offline = 1;
        filename = strdup(params);
    }

    if (retval->offline == 1) {
        PRINT ("nat-input plugin opens file %s\n", filename);
        retval->pcap = pcap_open_offline (filename, errbuf);
    } else// if ((retval->rawnetcap = rawnetcap_init(filename, 0, 0, SNAP_SIZE)) == NULL) {
        //PRINT ("Unable to initialize RAWNETCAP, switching to pcap\n");
        if ((retval->pcap = pcap_open_live(filename, SNAPLEN_SIZE, 1, 0, errbuf)) == NULL) {
            PRINTERR ("Unable to init pcap: %s\n", errbuf);
            free(retval);
            return (NULL);
        }
//    }  

//    PRINT ("NAT Input plugin succesfully initialized in %s mode on device %s\n ",
//            retval->rawnetcap ? "RAWNETCAP" : retval->offline ? "PCAP offline" : "PCAP live",
//            filename);
     PRINT ("NAT Input plugin succesfully initialized in %s mode on device %s\n ", retval->offline ? "PCAP offline" : "PCAP live", filename);
  
    free(filename);

	/* Set offset for specific part of the record */
	retval->data_offset = data_offset;
    return(retval);
}

//uint64_t plugin_input_get_flow(void *plugin_private, flow_record_t * record)
//{
//	input_private_t *p = (input_private_t*) plugin_private;
//	struct pcap_pkthdr hdr;
//	unsigned char *buff;
//	uint64_t record_hash = 0;
//
//	/* Get packet in PCAP mode */
//    buff = (unsigned char*) pcap_next (p->pcap, &hdr);
//
//    /* check read buffer */
//    if ((p->offline == 1) && (buff == NULL)) {
//        /* when we read files, NULL always means EOF and we want to stop exporter */
//        sleep (5); /* let the output plugins do what they need - the time should be probably (in)active timeout? */
//        raise (SIGQUIT);
//        sleep (5);
//      return 0;
//    }
//
//	/* Insert time into flow record */
//	record->flow_end = record->flow_start = ((uint64_t) hdr.ts.tv_sec * 1000 * 1000 * 1000) + ((uint64_t) hdr.ts.tv_usec * 1000);
//	/* Set packet count to 1 */	
//	record->flow_packets = 1;
//	/* Set real octets length */
//	record->flow_octets = hdr.len;
//
//	/* Parsing packet to record using exporter internal function */
//	if ((record_hash = record_process_packet (buff, hdr.caplen, record)) == 0) {
//		return 0;
//	}
//
//	/* Hash is used for packet accumulation in record */
//	return(record_hash | FLOW_OK_BIT);		
//}
//

PLUGIN_INPUT_GET_PACKET 
{
    input_private_t *p = (input_private_t*) plugin_private;
    struct pcap_pkthdr hdr;
    unsigned char *buff;

//    packet_head_t *head;

//    if (p->rawnetcap) {
//        /* RAWNETCAP mode */
//        /* get the packet */
//        if ((head = rawnetcap_get_next(p->rawnetcap, RAWNETCAP_TIMEOUT)) == NULL) {
//            return (0);
//        }
//        buff = (unsigned char*) head + sizeof(packet_head_t);
//
//        pkt_info->arrival_time = ((uint64_t) head->tv_sec * 1000 ) + ((uint64_t) head->tv_nsec / 1000000);
//        pkt_info->cap_length = head->data_len;
//        pkt_info->length = head->real_len;
//        pkt_info->input_interface = head->interface_id;
//    } else {
        buff = (unsigned char*) pcap_next (p->pcap, &hdr);

        /* check read buffer */
        if ((p->offline == 1) && (buff == NULL)) {
            /* when we read files, NULL always means EOF and we want to stop exporter */
            sleep (30); /* let the output plugins do what they need - the time should be probably (in)active timeout? */
            raise (SIGQUIT);
            sleep (20);
            return 0;
        }
        
        pkt_info->arrival_time = ((uint64_t) hdr.ts.tv_sec * 1000 * 1000 * 1000) + ((uint64_t) hdr.ts.tv_usec * 1000);
        pkt_info->cap_length = hdr.caplen;
        pkt_info->length = hdr.len;
        //interface numbers are not available in pcap
        pkt_info->input_interface = pkt_info->output_interface = 0;
//    }
    return(buff);
}

PLUGIN_INIT_SHUTDOWN
{
    return (0);
}
