#include <stdio.h>
#include <getopt.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#include <signal.h>
#include <string.h>
#include <netdb.h>
#include <sys/stat.h>
#include <fcntl.h>
//#include <libmnl/libmnl.h>
#include <libnetfilter_conntrack/libnetfilter_conntrack.h>


#define NIPQUAD(addr) \
        ((unsigned char *)&addr)[0], \
        ((unsigned char *)&addr)[1], \
        ((unsigned char *)&addr)[2], \
        ((unsigned char *)&addr)[3]



static struct nfct_handle *cth;

static int event_cb(enum nf_conntrack_msg_type type, struct nf_conntrack *ct, void *data)
{
    char buf[1024];
    unsigned int op_type = NFCT_O_DEFAULT;
    unsigned int op_flags = 0;

    switch (type) {
        case NFCT_T_NEW:
            fprintf(stderr, "type NEW \n");
            break;
        case NFCT_T_UPDATE:
            fprintf(stderr, "type UPDATE \n");
            break;
        case NFCT_T_DESTROY:
            fprintf(stderr, "type DESTROY \n");
            break;
        default:
            break;
    }

    uint32_t ip = nfct_get_attr_u32(ct, ATTR_ORIG_IPV4_SRC);
    //.fprintf(stderr, "src=%d\n ", ip);
    fprintf(stderr, "src %u.%u.%u.%u\n",	NIPQUAD(ip));
    uint32_t ip1 = nfct_get_attr_u32(ct, ATTR_ORIG_IPV4_DST);
    fprintf(stderr, "dst %u.%u.%u.%u\n",	NIPQUAD(ip1));
    uint32_t ip2 = nfct_get_attr_u32(ct, ATTR_REPL_IPV4_SRC);
    fprintf(stderr, "r src %u.%u.%u.%u\n",	NIPQUAD(ip2));
    uint32_t ip3 = nfct_get_attr_u32(ct, ATTR_REPL_IPV4_DST);
    fprintf(stderr, "r dst %u.%u.%u.%u\n",	NIPQUAD(ip3));
    uint32_t ip4 = nfct_get_attr_u32(ct, ATTR_SNAT_IPV4);
    fprintf(stderr, "snat  %u.%u.%u.%u\n",	NIPQUAD(ip4));
    uint32_t srcp = nfct_get_attr_u16(ct, ATTR_ORIG_PORT_SRC);
    fprintf(stderr, "src port  %d\n",	ntohs(srcp));
    uint32_t dstp = nfct_get_attr_u16(ct, ATTR_ORIG_PORT_DST);
    fprintf(stderr, "dst port  %d\n",	ntohs(dstp));
 
//    nfct_snprintf(buf, sizeof(buf), ct, type, op_type, op_flags);
//    printf("%s\n", buf);
//    fflush(stdout);
    return NFCT_CB_CONTINUE;
}

int main(int argc, char *argv[])
{
    struct nf_conntrack *ct;
    int res = 0;

    ct = nfct_new();
    cth = nfct_open(CONNTRACK, NF_NETLINK_CONNTRACK_NEW);
    if (!cth) {
        fprintf(stderr, "Can't open handler!\n");
        return 1;
    }

    nfct_callback_register(cth, NFCT_T_ALL, event_cb, ct);
    res = nfct_catch(cth);
    if (res == -1) {
        if (errno == ENOBUFS) {
            fprintf(stderr,
                "WARNING: We have hit ENOBUFS! We "
                "are losing events.\nThis message "
                "means that the current netlink "
                "socket buffer size is too small.\n"
                "Please, check --buffer-size in "
                "conntrack(8) manpage.\n");
        }
    }
    nfct_close(cth);
    return 0;

}
