/*
								+---------------------------------+
								|                                 |
								|  ***   OpenGL 3.0 shader   ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2009  |
								|                                 |
								|           Shader3.inl           |
								|                                 |
								+---------------------------------+
*/

#pragma once
#ifndef __GL30_SHADER_INLINES_INCLUDED
#define __GL30_SHADER_INLINES_INCLUDED

/**
 *	@file gl3/Shader3.inl
 *	@author -tHE SWINe-
 *	@date 2009
 *	@brief OpenGL 3.0 shaders
 *
 *	@date 2012-06-19
 *
 *	Moved multiple inclusion guard before file documentation comment.
 *
 */

/*
 *								=== CGL3Shader ===
 */

inline void CGL3Shader::SetUniform1fv(int n_location, int n_count, const float *p_value) const
{
	glUniform1fv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform2fv(int n_location, int n_count, const float *p_value) const
{
	glUniform2fv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform3fv(int n_location, int n_count, const float *p_value) const
{
	glUniform3fv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform4fv(int n_location, int n_count, const float *p_value) const
{
	glUniform4fv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform1i(int n_location, int n_value) const
{
	glUniform1i(n_location, n_value);
}

inline void CGL3Shader::SetUniform1iv(int n_location, int n_count, const int *p_value) const
{
	glUniform1iv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform2iv(int n_location, int n_count, const int *p_value) const
{
	glUniform2iv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform3iv(int n_location, int n_count, const int *p_value) const
{
	glUniform3iv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform4iv(int n_location, int n_count, const int *p_value) const
{
	glUniform4iv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniformMatrix2fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix2fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix3fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix3fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix4fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix4fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::Bind() const
{
	glUseProgram(m_n_program_object);
}

inline void CGL3Shader::Release() const
{
	glUseProgram(0);
}

inline void CGL3Shader::SetUniformMatrix2x3fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix2x3fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix3x2fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix3x2fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix2x4fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix2x4fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix4x2fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix4x2fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix3x4fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix3x4fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniformMatrix4x3fv(int n_location,
	int n_count, bool b_transpose, const float *p_value) const
{
	glUniformMatrix4x3fv(n_location, n_count, b_transpose, p_value);
}

inline void CGL3Shader::SetUniform1uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform1uiv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform2uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform2uiv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform3uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform3uiv(n_location, n_count, p_value);
}

inline void CGL3Shader::SetUniform4uiv(int n_location,
	int n_count, const unsigned int *p_value) const
{
	glUniform4uiv(n_location, n_count, p_value);
}

/*
 *								=== ~CGL3Shader ===
 */

#endif // !__GL30_SHADER_INLINES_INCLUDED
