/*
								+----------------------------------+
								|                                  |
								|   ***  Unicode block list  ***   |
								|                                  |
								|   Copyright  -tHE SWINe- 2011   |
								|                                  |
								|          UniBlocks.cpp           |
								|                                  |
								+----------------------------------+
*/

/**
 *	@file UniBlocks.cpp
 *	@date 2011
 *	@author -tHE SWINe-
 *	@brief Unicode block list
 */

#include "NewFix.h"
#include "CallStack.h"
#include <vector>
#include <string.h>
#include <string>
#include <list>
#include <algorithm>
#include <stdio.h>
#include "MinMax.h"
#include "UniBlocks.h"

#if defined(_WIN32) || defined(_WIN64)
#define strncasecmp(a,b,n) _strnicmp((a), (b), (n))
#define strcasecmp(a,b) _stricmp((a), (b))
#endif //_WIN32 || _WIN64

#if defined(_MSC_VER) && !defined(__MWERKS__) && !defined(for) && _MSC_VER <= 1200
#define for if(0) {} else for
#endif // _MSC_VER && !__MWERKS__ && !for && _MSC_VER <= 1200
// msvc 'for' scoping hack

const CUnicodeBlocks::TUnicodeLogBlock CUnicodeBlocks::p_unicode_blocks[] = {
    {{0x0021, 0x007e}, "Basic Latin"}, // !!! skip control characters and space (don't want these here) !!!
    {{0x00a1, 0x00ff}, "Latin-1 Supplement"}, // !!! skip control characters and no-break space (don't want these here) !!!
    {{0x0100, 0x017f}, "Latin Extended-A"},
    {{0x0180, 0x024f}, "Latin Extended-B"},
    {{0x0250, 0x02af}, "IPA Extensions"},
    {{0x02b0, 0x02ff}, "Spacing Modifier Letters"},
    {{0x0300, 0x036f}, "Combining Diacritical Marks"},
    {{0x0370, 0x03ff}, "Greek and Coptic"},
    {{0x0400, 0x04ff}, "Cyrillic"},
    {{0x0500, 0x052f}, "Cyrillic Supplement"},
    {{0x0530, 0x058f}, "Armenian"},
    {{0x0590, 0x05ff}, "Hebrew"},
    {{0x0600, 0x06ff}, "Arabic"},
    {{0x0700, 0x074f}, "Syriac"},
    {{0x0750, 0x077f}, "Arabic Supplement"},
    {{0x0780, 0x07bf}, "Thaana"},
    {{0x07c0, 0x07ff}, "NKo"},
    {{0x0800, 0x083f}, "Samaritan"},
    {{0x0840, 0x085f}, "Mandaic"},
    {{0x0900, 0x097f}, "Devanagari"},
    {{0x0980, 0x09ff}, "Bengali"},
    {{0x0a00, 0x0a7f}, "Gurmukhi"},
    {{0x0a80, 0x0aff}, "Gujarati"},
    {{0x0b00, 0x0b7f}, "Oriya"},
    {{0x0b80, 0x0bff}, "Tamil"},
    {{0x0c00, 0x0c7f}, "Telugu"},
    {{0x0c80, 0x0cff}, "Kannada"},
    {{0x0d00, 0x0d7f}, "Malayalam"},
    {{0x0d80, 0x0dff}, "Sinhala"},
    {{0x0e00, 0x0e7f}, "Thai"},
    {{0x0e80, 0x0eff}, "Lao"},
    {{0x0f00, 0x0fff}, "Tibetan"},
    {{0x1000, 0x109f}, "Myanmar"},
    {{0x10a0, 0x10ff}, "Georgian"},
    {{0x1100, 0x11ff}, "Hangul Jamo"},
    {{0x1200, 0x137f}, "Ethiopic"},
    {{0x1380, 0x139f}, "Ethiopic Supplement"},
    {{0x13a0, 0x13ff}, "Cherokee"},
    {{0x1400, 0x167f}, "Unified Canadian Aboriginal Syllabics"},
    {{0x1680, 0x169f}, "Ogham"},
    {{0x16a0, 0x16ff}, "Runic"},
    {{0x1700, 0x171f}, "Tagalog"},
    {{0x1720, 0x173f}, "Hanunoo"},
    {{0x1740, 0x175f}, "Buhid"},
    {{0x1760, 0x177f}, "Tagbanwa"},
    {{0x1780, 0x17ff}, "Khmer"},
    {{0x1800, 0x18af}, "Mongolian"},
    {{0x18b0, 0x18ff}, "Unified Canadian Aboriginal Syllabics Extended"},
    {{0x1900, 0x194f}, "Limbu"},
    {{0x1950, 0x197f}, "Tai Le"},
    {{0x1980, 0x19df}, "New Tai Lue"},
    {{0x19e0, 0x19ff}, "Khmer Symbols"},
    {{0x1a00, 0x1a1f}, "Buginese"},
    {{0x1a20, 0x1aaf}, "Tai Tham"},
    {{0x1b00, 0x1b7f}, "Balinese"},
    {{0x1b80, 0x1bbf}, "Sundanese"},
    {{0x1bc0, 0x1bff}, "Batak"},
    {{0x1c00, 0x1c4f}, "Lepcha"},
    {{0x1c50, 0x1c7f}, "Ol Chiki"},
    {{0x1cd0, 0x1cff}, "Vedic Extensions"},
    {{0x1d00, 0x1d7f}, "Phonetic Extensions"},
    {{0x1d80, 0x1dbf}, "Phonetic Extensions Supplement"},
    {{0x1dc0, 0x1dff}, "Combining Diacritical Marks Supplement"},
    {{0x1e00, 0x1eff}, "Latin Extended Additional"},
    {{0x1f00, 0x1fff}, "Greek Extended"},
    {{0x2000, 0x206f}, "General Punctuation"},
    {{0x2070, 0x209f}, "Superscripts and Subscripts"},
    {{0x20a0, 0x20cf}, "Currency Symbols"},
    {{0x20d0, 0x20ff}, "Combining Diacritical Marks for Symbols"},
    {{0x2100, 0x214f}, "Letterlike Symbols"},
    {{0x2150, 0x218f}, "Number Forms"},
    {{0x2190, 0x21ff}, "Arrows"},
    {{0x2200, 0x22ff}, "Mathematical Operators"},
    {{0x2300, 0x23ff}, "Miscellaneous Technical"},
    {{0x2400, 0x243f}, "Control Pictures"},
    {{0x2440, 0x245f}, "Optical Character Recognition"},
    {{0x2460, 0x24ff}, "Enclosed Alphanumerics"},
    {{0x2500, 0x257f}, "Box Drawing"},
    {{0x2580, 0x259f}, "Block Elements"},
    {{0x25a0, 0x25ff}, "Geometric Shapes"},
    {{0x2600, 0x26ff}, "Miscellaneous Symbols"},
    {{0x2700, 0x27bf}, "Dingbats"},
    {{0x27c0, 0x27ef}, "Miscellaneous Mathematical Symbols-A"},
    {{0x27f0, 0x27ff}, "Supplemental Arrows-A"},
    {{0x2800, 0x28ff}, "Braille Patterns"},
    {{0x2900, 0x297f}, "Supplemental Arrows-B"},
    {{0x2980, 0x29ff}, "Miscellaneous Mathematical Symbols-B"},
    {{0x2a00, 0x2aff}, "Supplemental Mathematical Operators"},
    {{0x2b00, 0x2bff}, "Miscellaneous Symbols and Arrows"},
    {{0x2c00, 0x2c5f}, "Glagolitic"},
    {{0x2c60, 0x2c7f}, "Latin Extended-C"},
    {{0x2c80, 0x2cff}, "Coptic"},
    {{0x2d00, 0x2d2f}, "Georgian Supplement"},
    {{0x2d30, 0x2d7f}, "Tifinagh"},
    {{0x2d80, 0x2ddf}, "Ethiopic Extended"},
    {{0x2de0, 0x2dff}, "Cyrillic Extended-A"},
    {{0x2e00, 0x2e7f}, "Supplemental Punctuation"},
    {{0x2e80, 0x2eff}, "CJK Radicals Supplement"},
    {{0x2f00, 0x2fdf}, "Kangxi Radicals"},
    {{0x2ff0, 0x2fff}, "Ideographic Description Characters"},
    {{0x3000, 0x303f}, "CJK Symbols and Punctuation"},
    {{0x3040, 0x309f}, "Hiragana"},
    {{0x30a0, 0x30ff}, "Katakana"},
    {{0x3100, 0x312f}, "Bopomofo"},
    {{0x3130, 0x318f}, "Hangul Compatibility Jamo"},
    {{0x3190, 0x319f}, "Kanbun"},
    {{0x31a0, 0x31bf}, "Bopomofo Extended"},
    {{0x31c0, 0x31ef}, "CJK Strokes"},
    {{0x31f0, 0x31ff}, "Katakana Phonetic Extensions"},
    {{0x3200, 0x32ff}, "Enclosed CJK Letters and Months"},
    {{0x3300, 0x33ff}, "CJK Compatibility"},
    {{0x3400, 0x4dbf}, "CJK Unified Ideographs Extension A"},
    {{0x4dc0, 0x4dff}, "Yijing Hexagram Symbols"},
    {{0x4e00, 0x9fff}, "CJK Unified Ideographs"},
    {{0xa000, 0xa48f}, "Yi Syllables"},
    {{0xa490, 0xa4cf}, "Yi Radicals"},
    {{0xa4d0, 0xa4ff}, "Lisu"},
    {{0xa500, 0xa63f}, "Vai"},
    {{0xa640, 0xa69f}, "Cyrillic Extended-B"},
    {{0xa6a0, 0xa6ff}, "Bamum"},
    {{0xa700, 0xa71f}, "Modifier Tone Letters"},
    {{0xa720, 0xa7ff}, "Latin Extended-D"},
    {{0xa800, 0xa82f}, "Syloti Nagri"},
    {{0xa830, 0xa83f}, "Common Indic Number Forms"},
    {{0xa840, 0xa87f}, "Phags-pa"},
    {{0xa880, 0xa8df}, "Saurashtra"},
    {{0xa8e0, 0xa8ff}, "Devanagari Extended"},
    {{0xa900, 0xa92f}, "Kayah Li"},
    {{0xa930, 0xa95f}, "Rejang"},
    {{0xa960, 0xa97f}, "Hangul Jamo Extended-A"},
    {{0xa980, 0xa9df}, "Javanese"},
    {{0xaa00, 0xaa5f}, "Cham"},
    {{0xaa60, 0xaa7f}, "Myanmar Extended-A"},
    {{0xaa80, 0xaadf}, "Tai Viet"},
    {{0xab00, 0xab2f}, "Ethiopic Extended-A"},
    {{0xabc0, 0xabff}, "Meetei Mayek"},
    {{0xac00, 0xd7af}, "Hangul Syllables"},
    {{0xd7b0, 0xd7ff}, "Hangul Jamo Extended-B"},
    {{0xd800, 0xdb7f}, "High Surrogates"},
    {{0xdb80, 0xdbff}, "High Private Use Surrogates"},
    {{0xdc00, 0xdfff}, "Low Surrogates"},
    {{0xe000, 0xf8ff}, "Private Use Area"},
    {{0xf900, 0xfaff}, "CJK Compatibility Ideographs"},
    {{0xfb00, 0xfb4f}, "Alphabetic Presentation Forms"},
    {{0xfb50, 0xfdff}, "Arabic Presentation Forms-A"},
    {{0xfe00, 0xfe0f}, "Variation Selectors"},
    {{0xfe10, 0xfe1f}, "Vertical Forms"},
    {{0xfe20, 0xfe2f}, "Combining Half Marks"},
    {{0xfe30, 0xfe4f}, "CJK Compatibility Forms"},
    {{0xfe50, 0xfe6f}, "Small Form Variants"},
    {{0xfe70, 0xfeff}, "Arabic Presentation Forms-B"},
    {{0xff00, 0xffef}, "Halfwidth and Fullwidth Forms"},
    {{0xfff0, 0xffff}, "Specials"},
    {{0x10000, 0x1007f}, "Linear B Syllabary"},
    {{0x10080, 0x100ff}, "Linear B Ideograms"},
    {{0x10100, 0x1013f}, "Aegean Numbers"},
    {{0x10140, 0x1018f}, "Ancient Greek Numbers"},
    {{0x10190, 0x101cf}, "Ancient Symbols"},
    {{0x101d0, 0x101ff}, "Phaistos Disc"},
    {{0x10280, 0x1029f}, "Lycian"},
    {{0x102a0, 0x102df}, "Carian"},
    {{0x10300, 0x1032f}, "Old Italic"},
    {{0x10330, 0x1034f}, "Gothic"},
    {{0x10380, 0x1039f}, "Ugaritic"},
    {{0x103a0, 0x103df}, "Old Persian"},
    {{0x10400, 0x1044f}, "Deseret"},
    {{0x10450, 0x1047f}, "Shavian"},
    {{0x10480, 0x104af}, "Osmanya"},
    {{0x10800, 0x1083f}, "Cypriot Syllabary"},
    {{0x10840, 0x1085f}, "Imperial Aramaic"},
    {{0x10900, 0x1091f}, "Phoenician"},
    {{0x10920, 0x1093f}, "Lydian"},
    {{0x10a00, 0x10a5f}, "Kharoshthi"},
    {{0x10a60, 0x10a7f}, "Old South Arabian"},
    {{0x10b00, 0x10b3f}, "Avestan"},
    {{0x10b40, 0x10b5f}, "Inscriptional Parthian"},
    {{0x10b60, 0x10b7f}, "Inscriptional Pahlavi"},
    {{0x10c00, 0x10c4f}, "Old Turkic"},
    {{0x10e60, 0x10e7f}, "Rumi Numeral Symbols"},
    {{0x11000, 0x1107f}, "Brahmi"},
    {{0x11080, 0x110cf}, "Kaithi"},
    {{0x12000, 0x123ff}, "Cuneiform"},
    {{0x12400, 0x1247f}, "Cuneiform Numbers and Punctuation"},
    {{0x13000, 0x1342f}, "Egyptian Hieroglyphs"},
    {{0x16800, 0x16a3f}, "Bamum Supplement"},
    {{0x1b000, 0x1b0ff}, "Kana Supplement"},
    {{0x1d000, 0x1d0ff}, "Byzantine Musical Symbols"},
    {{0x1d100, 0x1d1ff}, "Musical Symbols"},
    {{0x1d200, 0x1d24f}, "Ancient Greek Musical Notation"},
    {{0x1d300, 0x1d35f}, "Tai Xuan Jing Symbols"},
    {{0x1d360, 0x1d37f}, "Counting Rod Numerals"},
    {{0x1d400, 0x1d7ff}, "Mathematical Alphanumeric Symbols"},
    {{0x1f000, 0x1f02f}, "Mahjong Tiles"},
    {{0x1f030, 0x1f09f}, "Domino Tiles"},
    {{0x1f0a0, 0x1f0ff}, "Playing Cards"},
    {{0x1f100, 0x1f1ff}, "Enclosed Alphanumeric Supplement"},
    {{0x1f200, 0x1f2ff}, "Enclosed Ideographic Supplement"},
    {{0x1f300, 0x1f5ff}, "Miscellaneous Symbols And Pictographs"},
    {{0x1f600, 0x1f64f}, "Emoticons"},
    {{0x1f680, 0x1f6ff}, "Transport And Map Symbols"},
    {{0x1f700, 0x1f77f}, "Alchemical Symbols"},
    {{0x20000, 0x2a6df}, "CJK Unified Ideographs Extension B"},
    {{0x2a700, 0x2b73f}, "CJK Unified Ideographs Extension C"},
    {{0x2b740, 0x2b81f}, "CJK Unified Ideographs Extension D"},
    {{0x2f800, 0x2fa1f}, "CJK Compatibility Ideographs Supplement"},
    {{0xe0000, 0xe007f}, "Tags"},
    {{0xe0100, 0xe01ef}, "Variation Selectors Supplement"},
    {{0xf0000, 0xfffff}, "Supplementary Private Use Area-A"},
    {{0x100000, 0x10ffff}, "Supplementary Private Use Area-B"},
};

const size_t CUnicodeBlocks::n_unicode_log_block_num = sizeof(CUnicodeBlocks::p_unicode_blocks) /
	sizeof(CUnicodeBlocks::p_unicode_blocks[0]);

const CUnicodeBlocks::TCodeRange CUnicodeBlocks::p_global_range_list[] = {
    {0x0000, 0x01f5}, {0x01fa, 0x0217}, {0x0250, 0x02a8}, {0x02b0, 0x02de}, {0x02e0, 0x02e9}, {0x0300, 0x0345},
    {0x0360, 0x0361}, {0x0374, 0x0375}, {0x037a, 0x037a}, {0x037e, 0x037e}, {0x0384, 0x038a}, {0x038c, 0x038c},
    {0x038e, 0x03a1}, {0x03a3, 0x03ce}, {0x03d0, 0x03d6}, {0x03da, 0x03da}, {0x03dc, 0x03dc}, {0x03de, 0x03de},
    {0x03e0, 0x03e0}, {0x03e2, 0x03f3}, {0x0401, 0x040c}, {0x040e, 0x044f}, {0x0451, 0x045c}, {0x045e, 0x0486},
    {0x0490, 0x04c4}, {0x04c7, 0x04c8}, {0x04cb, 0x04cc}, {0x04d0, 0x04eb}, {0x04ee, 0x04f5}, {0x04f8, 0x04f9},
    {0x0531, 0x0556}, {0x0559, 0x055f}, {0x0561, 0x0587}, {0x0589, 0x0589}, {0x05b0, 0x05b9}, {0x05bb, 0x05c3},
    {0x05d0, 0x05ea}, {0x05f0, 0x05f4}, {0x060c, 0x060c}, {0x061b, 0x061b}, {0x061f, 0x061f}, {0x0621, 0x063a},
    {0x0640, 0x0652}, {0x0660, 0x066d}, {0x0670, 0x06b7}, {0x06ba, 0x06be}, {0x06c0, 0x06ce}, {0x06d0, 0x06ed},
    {0x06f0, 0x06f9}, {0x0901, 0x0903}, {0x0905, 0x0939}, {0x093c, 0x094d}, {0x0950, 0x0954}, {0x0958, 0x0970},
    {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b2, 0x09b2},
    {0x09b6, 0x09b9}, {0x09bc, 0x09bc}, {0x09be, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09cd}, {0x09d7, 0x09d7},
    {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fa}, {0x0a02, 0x0a02}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10},
    {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3c, 0x0a3c},
    {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a5e, 0x0a5e}, {0x0a66, 0x0a74},
    {0x0a81, 0x0a83}, {0x0a85, 0x0a8b}, {0x0a8d, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0},
    {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ad0, 0x0ad0},
    {0x0ae0, 0x0ae0}, {0x0ae6, 0x0aef}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28},
    {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b36, 0x0b39}, {0x0b3c, 0x0b43}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d},
    {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b70}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a},
    {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c}, {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4},
    {0x0ba8, 0x0baa}, {0x0bae, 0x0bb5}, {0x0bb7, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd},
    {0x0bd7, 0x0bd7}, {0x0be7, 0x0bf2}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28},
    {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3e, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56},
    {0x0c60, 0x0c61}, {0x0c66, 0x0c6f}, {0x0c82, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8},
    {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbe, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6},
    {0x0cde, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0ce6, 0x0cef}, {0x0d02, 0x0d03}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10},
    {0x0d12, 0x0d28}, {0x0d2a, 0x0d39}, {0x0d3e, 0x0d43}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4d}, {0x0d57, 0x0d57},
    {0x0d60, 0x0d61}, {0x0d66, 0x0d6f}, {0x0e01, 0x0e3a}, {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e84, 0x0e84},
    {0x0e87, 0x0e88}, {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3},
    {0x0ea5, 0x0ea5}, {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4},
    {0x0ec6, 0x0ec6}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edd}, {0x10a0, 0x10c5}, {0x10d0, 0x10f6},
    {0x10fb, 0x10fb}, {0x1100, 0x1159}, {0x115f, 0x11a2}, {0x11a8, 0x11f9}, {0x1e00, 0x1e9a}, {0x1ea0, 0x1ef9},
    {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
    {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3},
    {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x202e}, {0x2030, 0x2046},
    {0x206a, 0x2070}, {0x2074, 0x208e}, {0x20a0, 0x20aa}, {0x20d0, 0x20e1}, {0x2100, 0x2138}, {0x2153, 0x2182},
    {0x2190, 0x21ea}, {0x2200, 0x22f1}, {0x2300, 0x2300}, {0x2302, 0x237a}, {0x2400, 0x2424}, {0x2440, 0x244a},
    {0x2460, 0x24ea}, {0x2500, 0x2595}, {0x25a0, 0x25ef}, {0x2600, 0x2613}, {0x261a, 0x266f}, {0x2701, 0x2704},
    {0x2706, 0x2709}, {0x270c, 0x2727}, {0x2729, 0x274b}, {0x274d, 0x274d}, {0x274f, 0x2752}, {0x2756, 0x2756},
    {0x2758, 0x275e}, {0x2761, 0x2767}, {0x2776, 0x2794}, {0x2798, 0x27af}, {0x27b1, 0x27be}, {0x3000, 0x3037},
    {0x303f, 0x303f}, {0x3041, 0x3094}, {0x3099, 0x309e}, {0x30a1, 0x30fe}, {0x3105, 0x312c}, {0x3131, 0x318e},
    {0x3190, 0x319f}, {0x3200, 0x321c}, {0x3220, 0x3243}, {0x3260, 0x327b}, {0x327f, 0x32b0}, {0x32c0, 0x32cb},
    {0x32d0, 0x32fe}, {0x3300, 0x3376}, {0x337b, 0x33dd}, {0x33e0, 0x33fe}, {0x3400, 0x4dff},
    {0x4e00, 0x9fa5}, // CJK IDEOGRAPH REPRESENTATIVE
    {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1e, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
    {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3f}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb},
    {0xfe20, 0xfe23}, {0xfe30, 0xfe44}, {0xfe49, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe72},
    {0xfe74, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xff5e}, {0xff61, 0xffbe}, {0xffc2, 0xffc7},
    {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfffd, 0xfffd},

    {0x0000, 0x01f5}, {0x01fa, 0x0217}, {0x0250, 0x02a8}, {0x02b0, 0x02de}, {0x02e0, 0x02e9}, {0x0300, 0x0345},
    {0x0360, 0x0361}, {0x0374, 0x0375}, {0x037a, 0x037a}, {0x037e, 0x037e}, {0x0384, 0x038a}, {0x038c, 0x038c},
    {0x038e, 0x03a1}, {0x03a3, 0x03ce}, {0x03d0, 0x03d6}, {0x03da, 0x03da}, {0x03dc, 0x03dc}, {0x03de, 0x03de},
    {0x03e0, 0x03e0}, {0x03e2, 0x03f3}, {0x0401, 0x040c}, {0x040e, 0x044f}, {0x0451, 0x045c}, {0x045e, 0x0486},
    {0x0490, 0x04c4}, {0x04c7, 0x04c8}, {0x04cb, 0x04cc}, {0x04d0, 0x04eb}, {0x04ee, 0x04f5}, {0x04f8, 0x04f9},
    {0x0531, 0x0556}, {0x0559, 0x055f}, {0x0561, 0x0587}, {0x0589, 0x0589}, {0x0591, 0x05a1}, {0x05a3, 0x05b9},
    {0x05bb, 0x05c4}, {0x05d0, 0x05ea}, {0x05f0, 0x05f4}, {0x060c, 0x060c}, {0x061b, 0x061b}, {0x061f, 0x061f},
    {0x0621, 0x063a}, {0x0640, 0x0652}, {0x0660, 0x066d}, {0x0670, 0x06b7}, {0x06ba, 0x06be}, {0x06c0, 0x06ce},
    {0x06d0, 0x06ed}, {0x06f0, 0x06f9}, {0x0901, 0x0903}, {0x0905, 0x0939}, {0x093c, 0x094d}, {0x0950, 0x0954},
    {0x0958, 0x0970}, {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0},
    {0x09b2, 0x09b2}, {0x09b6, 0x09b9}, {0x09bc, 0x09bc}, {0x09be, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09cd},
    {0x09d7, 0x09d7}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fa}, {0x0a02, 0x0a02}, {0x0a05, 0x0a0a},
    {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39},
    {0x0a3c, 0x0a3c}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a5e, 0x0a5e},
    {0x0a66, 0x0a74}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8b}, {0x0a8d, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8},
    {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd},
    {0x0ad0, 0x0ad0}, {0x0ae0, 0x0ae0}, {0x0ae6, 0x0aef}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10},
    {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b36, 0x0b39}, {0x0b3c, 0x0b43}, {0x0b47, 0x0b48},
    {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b70}, {0x0b82, 0x0b83},
    {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c}, {0x0b9e, 0x0b9f},
    {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb5}, {0x0bb7, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8},
    {0x0bca, 0x0bcd}, {0x0bd7, 0x0bd7}, {0x0be7, 0x0bf2}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10},
    {0x0c12, 0x0c28}, {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3e, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d},
    {0x0c55, 0x0c56}, {0x0c60, 0x0c61}, {0x0c66, 0x0c6f}, {0x0c82, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90},
    {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbe, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd},
    {0x0cd5, 0x0cd6}, {0x0cde, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0ce6, 0x0cef}, {0x0d02, 0x0d03}, {0x0d05, 0x0d0c},
    {0x0d0e, 0x0d10}, {0x0d12, 0x0d28}, {0x0d2a, 0x0d39}, {0x0d3e, 0x0d43}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4d},
    {0x0d57, 0x0d57}, {0x0d60, 0x0d61}, {0x0d66, 0x0d6f}, {0x0e01, 0x0e3a}, {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82},
    {0x0e84, 0x0e84}, {0x0e87, 0x0e88}, {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f},
    {0x0ea1, 0x0ea3}, {0x0ea5, 0x0ea5}, {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd},
    {0x0ec0, 0x0ec4}, {0x0ec6, 0x0ec6}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edd}, {0x0f00, 0x0f47},
    {0x0f49, 0x0f69}, {0x0f71, 0x0f8b}, {0x0f90, 0x0f95}, {0x0f97, 0x0f97}, {0x0f99, 0x0fad}, {0x0fb1, 0x0fb7},
    {0x0fb9, 0x0fb9}, {0x10a0, 0x10c5}, {0x10d0, 0x10f6}, {0x10fb, 0x10fb}, {0x1100, 0x1159}, {0x115f, 0x11a2},
    {0x11a8, 0x11f9}, {0x1e00, 0x1e9b}, {0x1ea0, 0x1ef9}, {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45},
    {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d},
    {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4},
    {0x1ff6, 0x1ffe}, {0x2000, 0x202e}, {0x2030, 0x2046}, {0x206a, 0x2070}, {0x2074, 0x208e}, {0x20a0, 0x20ab},
    {0x20d0, 0x20e1}, {0x2100, 0x2138}, {0x2153, 0x2182}, {0x2190, 0x21ea}, {0x2200, 0x22f1}, {0x2300, 0x2300},
    {0x2302, 0x237a}, {0x2400, 0x2424}, {0x2440, 0x244a}, {0x2460, 0x24ea}, {0x2500, 0x2595}, {0x25a0, 0x25ef},
    {0x2600, 0x2613}, {0x261a, 0x266f}, {0x2701, 0x2704}, {0x2706, 0x2709}, {0x270c, 0x2727}, {0x2729, 0x274b},
    {0x274d, 0x274d}, {0x274f, 0x2752}, {0x2756, 0x2756}, {0x2758, 0x275e}, {0x2761, 0x2767}, {0x2776, 0x2794},
    {0x2798, 0x27af}, {0x27b1, 0x27be}, {0x3000, 0x3037}, {0x303f, 0x303f}, {0x3041, 0x3094}, {0x3099, 0x309e},
    {0x30a1, 0x30fe}, {0x3105, 0x312c}, {0x3131, 0x318e}, {0x3190, 0x319f}, {0x3200, 0x321c}, {0x3220, 0x3243},
    {0x3260, 0x327b}, {0x327f, 0x32b0}, {0x32c0, 0x32cb}, {0x32d0, 0x32fe}, {0x3300, 0x3376}, {0x337b, 0x33dd},
    {0x33e0, 0x33fe},
    {0x4e00, 0x9fa5}, // CJK Ideograph
    {0xac00, 0xd7a3}, // Hangul Syllable
    //{0xd800, 0xdb7f}, // Unassigned High Surrogate
    //{0xdb80, 0xdbff}, // Private Use High Surrogate
    //{0xdc00, 0xdfff}, // Low Surrogate
    //{0xe000, 0xf8ff}, // Private Use
    {0xf900, 0xfa2d}, // CJK Compatibility Ideograph
    {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1e, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
    {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3f}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb},
    {0xfe20, 0xfe23}, {0xfe30, 0xfe44}, {0xfe49, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe72},
    {0xfe74, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xff5e}, {0xff61, 0xffbe}, {0xffc2, 0xffc7},
    {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfffd, 0xfffd},

    {0x0000, 0x021f}, {0x0222, 0x0233}, {0x0250, 0x02ad}, {0x02b0, 0x02ee}, {0x0300, 0x034e}, {0x0360, 0x0362},
    {0x0374, 0x0375}, {0x037a, 0x037a}, {0x037e, 0x037e}, {0x0384, 0x038a}, {0x038c, 0x038c}, {0x038e, 0x03a1},
    {0x03a3, 0x03ce}, {0x03d0, 0x03d7}, {0x03da, 0x03f3}, {0x0400, 0x0486}, {0x0488, 0x0489}, {0x048c, 0x04c4},
    {0x04c7, 0x04c8}, {0x04cb, 0x04cc}, {0x04d0, 0x04f5}, {0x04f8, 0x04f9}, {0x0531, 0x0556}, {0x0559, 0x055f},
    {0x0561, 0x0587}, {0x0589, 0x058a}, {0x0591, 0x05a1}, {0x05a3, 0x05b9}, {0x05bb, 0x05c4}, {0x05d0, 0x05ea},
    {0x05f0, 0x05f4}, {0x060c, 0x060c}, {0x061b, 0x061b}, {0x061f, 0x061f}, {0x0621, 0x063a}, {0x0640, 0x0655},
    {0x0660, 0x066d}, {0x0670, 0x06ed}, {0x06f0, 0x06fe}, {0x0700, 0x070d}, {0x070f, 0x072c}, {0x0730, 0x074a},
    {0x0780, 0x07b0}, {0x0901, 0x0903}, {0x0905, 0x0939}, {0x093c, 0x094d}, {0x0950, 0x0954}, {0x0958, 0x0970},
    {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b2, 0x09b2},
    {0x09b6, 0x09b9}, {0x09bc, 0x09bc}, {0x09be, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09cd}, {0x09d7, 0x09d7},
    {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fa}, {0x0a02, 0x0a02}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10},
    {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3c, 0x0a3c},
    {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a5e, 0x0a5e}, {0x0a66, 0x0a74},
    {0x0a81, 0x0a83}, {0x0a85, 0x0a8b}, {0x0a8d, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0},
    {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ad0, 0x0ad0},
    {0x0ae0, 0x0ae0}, {0x0ae6, 0x0aef}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10}, {0x0b13, 0x0b28},
    {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b36, 0x0b39}, {0x0b3c, 0x0b43}, {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d},
    {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b70}, {0x0b82, 0x0b83}, {0x0b85, 0x0b8a},
    {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c}, {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4},
    {0x0ba8, 0x0baa}, {0x0bae, 0x0bb5}, {0x0bb7, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd},
    {0x0bd7, 0x0bd7}, {0x0be7, 0x0bf2}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28},
    {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3e, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56},
    {0x0c60, 0x0c61}, {0x0c66, 0x0c6f}, {0x0c82, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8},
    {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbe, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6},
    {0x0cde, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0ce6, 0x0cef}, {0x0d02, 0x0d03}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10},
    {0x0d12, 0x0d28}, {0x0d2a, 0x0d39}, {0x0d3e, 0x0d43}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4d}, {0x0d57, 0x0d57},
    {0x0d60, 0x0d61}, {0x0d66, 0x0d6f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb},
    {0x0dbd, 0x0dbd}, {0x0dc0, 0x0dc6}, {0x0dca, 0x0dca}, {0x0dcf, 0x0dd4}, {0x0dd6, 0x0dd6}, {0x0dd8, 0x0ddf},
    {0x0df2, 0x0df4}, {0x0e01, 0x0e3a}, {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e84, 0x0e84}, {0x0e87, 0x0e88},
    {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0ea5, 0x0ea5},
    {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0ec6, 0x0ec6},
    {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edd}, {0x0f00, 0x0f47}, {0x0f49, 0x0f6a}, {0x0f71, 0x0f8b},
    {0x0f90, 0x0f97}, {0x0f99, 0x0fbc}, {0x0fbe, 0x0fcc}, {0x0fcf, 0x0fcf}, {0x1000, 0x1021}, {0x1023, 0x1027},
    {0x1029, 0x102a}, {0x102c, 0x1032}, {0x1036, 0x1039}, {0x1040, 0x1059}, {0x10a0, 0x10c5}, {0x10d0, 0x10f6},
    {0x10fb, 0x10fb}, {0x1100, 0x1159}, {0x115f, 0x11a2}, {0x11a8, 0x11f9}, {0x1200, 0x1206}, {0x1208, 0x1246},
    {0x1248, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1286},
    {0x1288, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12ae}, {0x12b0, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be},
    {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12ce}, {0x12d0, 0x12d6}, {0x12d8, 0x12ee}, {0x12f0, 0x130e},
    {0x1310, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x131e}, {0x1320, 0x1346}, {0x1348, 0x135a}, {0x1361, 0x137c},
    {0x13a0, 0x13f4}, {0x1401, 0x1676}, {0x1680, 0x169c}, {0x16a0, 0x16f0}, {0x1780, 0x17dc}, {0x17e0, 0x17e9},
    {0x1800, 0x180e}, {0x1810, 0x1819}, {0x1820, 0x1877}, {0x1880, 0x18a9}, {0x1e00, 0x1e9b}, {0x1ea0, 0x1ef9},
    {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
    {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3},
    {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x2046}, {0x2048, 0x204d},
    {0x206a, 0x2070}, {0x2074, 0x208e}, {0x20a0, 0x20af}, {0x20d0, 0x20e3}, {0x2100, 0x213a}, {0x2153, 0x2183},
    {0x2190, 0x21f3}, {0x2200, 0x22f1}, {0x2300, 0x237b}, {0x237d, 0x239a}, {0x2400, 0x2426}, {0x2440, 0x244a},
    {0x2460, 0x24ea}, {0x2500, 0x2595}, {0x25a0, 0x25f7}, {0x2600, 0x2613}, {0x2619, 0x2671}, {0x2701, 0x2704},
    {0x2706, 0x2709}, {0x270c, 0x2727}, {0x2729, 0x274b}, {0x274d, 0x274d}, {0x274f, 0x2752}, {0x2756, 0x2756},
    {0x2758, 0x275e}, {0x2761, 0x2767}, {0x2776, 0x2794}, {0x2798, 0x27af}, {0x27b1, 0x27be}, {0x2800, 0x28ff},
    {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x2ff0, 0x2ffb}, {0x3000, 0x303a}, {0x303e, 0x303f},
    {0x3041, 0x3094}, {0x3099, 0x309e}, {0x30a1, 0x30fe}, {0x3105, 0x312c}, {0x3131, 0x318e}, {0x3190, 0x31b7},
    {0x3200, 0x321c}, {0x3220, 0x3243}, {0x3260, 0x327b}, {0x327f, 0x32b0}, {0x32c0, 0x32cb}, {0x32d0, 0x32fe},
    {0x3300, 0x3376}, {0x337b, 0x33dd}, {0x33e0, 0x33fe},
    {0x3400, 0x4db5}, // CJK Ideograph Extension A
    {0x4e00, 0x9fa5}, // CJK Ideograph
    {0xa000, 0xa48c}, {0xa490, 0xa4a1}, {0xa4a4, 0xa4b3}, {0xa4b5, 0xa4c0}, {0xa4c2, 0xa4c4}, {0xa4c6, 0xa4c6},
    {0xac00, 0xd7a3}, // Hangul Syllable
    //{0xd800, 0xdb7f}, // Non Private Use High Surrogate
    //{0xdb80, 0xdbff}, // Private Use High Surrogate
    //{0xdc00, 0xdfff}, // Low Surrogate
    //{0xe000, 0xf8ff}, // Private Use
    {0xf900, 0xfa2d}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e},
    {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3f}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7},
    {0xfdf0, 0xfdfb}, {0xfe20, 0xfe23}, {0xfe30, 0xfe44}, {0xfe49, 0xfe52}, {0xfe54, 0xfe66}, {0xfe68, 0xfe6b},
    {0xfe70, 0xfe72}, {0xfe74, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xff5e}, {0xff61, 0xffbe},
    {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee},
    {0xfff9, 0xfffd},

    {0x0000, 0x0236}, {0x0250, 0x0357}, {0x035d, 0x036f}, {0x0374, 0x0375}, {0x037a, 0x037a}, {0x037e, 0x037e},
    {0x0384, 0x038a}, {0x038c, 0x038c}, {0x038e, 0x03a1}, {0x03a3, 0x03ce}, {0x03d0, 0x03fb}, {0x0400, 0x0486},
    {0x0488, 0x04ce}, {0x04d0, 0x04f5}, {0x04f8, 0x04f9}, {0x0500, 0x050f}, {0x0531, 0x0556}, {0x0559, 0x055f},
    {0x0561, 0x0587}, {0x0589, 0x058a}, {0x0591, 0x05a1}, {0x05a3, 0x05b9}, {0x05bb, 0x05c4}, {0x05d0, 0x05ea},
    {0x05f0, 0x05f4}, {0x0600, 0x0603}, {0x060c, 0x0615}, {0x061b, 0x061b}, {0x061f, 0x061f}, {0x0621, 0x063a},
    {0x0640, 0x0658}, {0x0660, 0x070d}, {0x070f, 0x074a}, {0x074d, 0x074f}, {0x0780, 0x07b1}, {0x0901, 0x0939},
    {0x093c, 0x094d}, {0x0950, 0x0954}, {0x0958, 0x0970}, {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990},
    {0x0993, 0x09a8}, {0x09aa, 0x09b0}, {0x09b2, 0x09b2}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8},
    {0x09cb, 0x09cd}, {0x09d7, 0x09d7}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fa}, {0x0a01, 0x0a03},
    {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36},
    {0x0a38, 0x0a39}, {0x0a3c, 0x0a3c}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c},
    {0x0a5e, 0x0a5e}, {0x0a66, 0x0a74}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8},
    {0x0aaa, 0x0ab0}, {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd},
    {0x0ad0, 0x0ad0}, {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, {0x0af1, 0x0af1}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c},
    {0x0b0f, 0x0b10}, {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b43},
    {0x0b47, 0x0b48}, {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b71},
    {0x0b82, 0x0b83}, {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c},
    {0x0b9e, 0x0b9f}, {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb5}, {0x0bb7, 0x0bb9}, {0x0bbe, 0x0bc2},
    {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd}, {0x0bd7, 0x0bd7}, {0x0be7, 0x0bfa}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c},
    {0x0c0e, 0x0c10}, {0x0c12, 0x0c28}, {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3e, 0x0c44}, {0x0c46, 0x0c48},
    {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56}, {0x0c60, 0x0c61}, {0x0c66, 0x0c6f}, {0x0c82, 0x0c83}, {0x0c85, 0x0c8c},
    {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8},
    {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cde, 0x0cde}, {0x0ce0, 0x0ce1}, {0x0ce6, 0x0cef}, {0x0d02, 0x0d03},
    {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d28}, {0x0d2a, 0x0d39}, {0x0d3e, 0x0d43}, {0x0d46, 0x0d48},
    {0x0d4a, 0x0d4d}, {0x0d57, 0x0d57}, {0x0d60, 0x0d61}, {0x0d66, 0x0d6f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96},
    {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dbd, 0x0dbd}, {0x0dc0, 0x0dc6}, {0x0dca, 0x0dca}, {0x0dcf, 0x0dd4},
    {0x0dd6, 0x0dd6}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df4}, {0x0e01, 0x0e3a}, {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82},
    {0x0e84, 0x0e84}, {0x0e87, 0x0e88}, {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f},
    {0x0ea1, 0x0ea3}, {0x0ea5, 0x0ea5}, {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd},
    {0x0ec0, 0x0ec4}, {0x0ec6, 0x0ec6}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edd}, {0x0f00, 0x0f47},
    {0x0f49, 0x0f6a}, {0x0f71, 0x0f8b}, {0x0f90, 0x0f97}, {0x0f99, 0x0fbc}, {0x0fbe, 0x0fcc}, {0x0fcf, 0x0fcf},
    {0x1000, 0x1021}, {0x1023, 0x1027}, {0x1029, 0x102a}, {0x102c, 0x1032}, {0x1036, 0x1039}, {0x1040, 0x1059},
    {0x10a0, 0x10c5}, {0x10d0, 0x10f8}, {0x10fb, 0x10fb}, {0x1100, 0x1159}, {0x115f, 0x11a2}, {0x11a8, 0x11f9},
    {0x1200, 0x1206}, {0x1208, 0x1246}, {0x1248, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
    {0x125a, 0x125d}, {0x1260, 0x1286}, {0x1288, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12ae}, {0x12b0, 0x12b0},
    {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12ce}, {0x12d0, 0x12d6},
    {0x12d8, 0x12ee}, {0x12f0, 0x130e}, {0x1310, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x131e}, {0x1320, 0x1346},
    {0x1348, 0x135a}, {0x1361, 0x137c}, {0x13a0, 0x13f4}, {0x1401, 0x1676}, {0x1680, 0x169c}, {0x16a0, 0x16f0},
    {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1736}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770},
    {0x1772, 0x1773}, {0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1800, 0x180e}, {0x1810, 0x1819},
    {0x1820, 0x1877}, {0x1880, 0x18a9}, {0x1900, 0x191c}, {0x1920, 0x192b}, {0x1930, 0x193b}, {0x1940, 0x1940},
    {0x1944, 0x196d}, {0x1970, 0x1974}, {0x19e0, 0x19ff}, {0x1d00, 0x1d6b}, {0x1e00, 0x1e9b}, {0x1ea0, 0x1ef9},
    {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59},
    {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3},
    {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x2054}, {0x2057, 0x2057},
    {0x205f, 0x2063}, {0x206a, 0x2071}, {0x2074, 0x208e}, {0x20a0, 0x20b1}, {0x20d0, 0x20ea}, {0x2100, 0x213b},
    {0x213d, 0x214b}, {0x2153, 0x2183}, {0x2190, 0x23d0}, {0x2400, 0x2426}, {0x2440, 0x244a}, {0x2460, 0x2617},
    {0x2619, 0x267d}, {0x2680, 0x2691}, {0x26a0, 0x26a1}, {0x2701, 0x2704}, {0x2706, 0x2709}, {0x270c, 0x2727},
    {0x2729, 0x274b}, {0x274d, 0x274d}, {0x274f, 0x2752}, {0x2756, 0x2756}, {0x2758, 0x275e}, {0x2761, 0x2794},
    {0x2798, 0x27af}, {0x27b1, 0x27be}, {0x27d0, 0x27eb}, {0x27f0, 0x2b0d}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3},
    {0x2f00, 0x2fd5}, {0x2ff0, 0x2ffb}, {0x3000, 0x303f}, {0x3041, 0x3096}, {0x3099, 0x30ff}, {0x3105, 0x312c},
    {0x3131, 0x318e}, {0x3190, 0x31b7}, {0x31f0, 0x321e}, {0x3220, 0x3243}, {0x3250, 0x327d}, {0x327f, 0x32fe},
    {0x3300, 0x33ff},
    {0x3400, 0x4db5}, // CJK Ideograph Extension A
    {0x4dc0, 0x4dff},
    {0x4e00, 0x9fa5}, // CJK Ideograph
    {0xa000, 0xa48c}, {0xa490, 0xa4c6},
    {0xac00, 0xd7a3}, // Hangul Syllable
    //{0xd800, 0xdb7f}, // Non Private Use High Surrogate
    //{0xdb80, 0xdbff}, // Private Use High Surrogate
    //{0xdc00, 0xdfff}, // Low Surrogate
    //{0xe000, 0xf8ff}, // Private Use
    {0xf900, 0xfa2d}, {0xfa30, 0xfa6a}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb36}, {0xfb38, 0xfb3c},
    {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3f}, {0xfd50, 0xfd8f},
    {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, {0xfe00, 0xfe0f}, {0xfe20, 0xfe23}, {0xfe30, 0xfe52}, {0xfe54, 0xfe66},
    {0xfe68, 0xfe6b}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xffbe}, {0xffc2, 0xffc7},
    {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee}, {0xfff9, 0xfffd},
    {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
    {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1013f}, {0x10300, 0x1031e}, {0x10320, 0x10323},
    {0x10330, 0x1034a}, {0x10380, 0x1039d}, {0x1039f, 0x1039f}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x10800, 0x10805},
    {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x1083f}, {0x1d000, 0x1d0f5},
    {0x1d100, 0x1d126}, {0x1d12a, 0x1d1dd}, {0x1d300, 0x1d356}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f},
    {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
    {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e},
    {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a3}, {0x1d6a8, 0x1d7c9}, {0x1d7ce, 0x1d7ff},
    {0x20000, 0x2a6d6}, // CJK Ideograph Extension B
    {0x2f800, 0x2fa1d}, {0xe0001, 0xe0001}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef},
    //{0xf0000, 0xffffd}, // Plane 15 Private Use
    //{0x100000, 0x10fffd}, // Plane 16 Private Use

    {0x0000, 0x036f}, {0x0374, 0x0375}, {0x037a, 0x037e}, {0x0384, 0x038a}, {0x038c, 0x038c}, {0x038e, 0x03a1},
    {0x03a3, 0x03ce}, {0x03d0, 0x0486}, {0x0488, 0x0513}, {0x0531, 0x0556}, {0x0559, 0x055f}, {0x0561, 0x0587},
    {0x0589, 0x058a}, {0x0591, 0x05c7}, {0x05d0, 0x05ea}, {0x05f0, 0x05f4}, {0x0600, 0x0603}, {0x060b, 0x0615},
    {0x061b, 0x061b}, {0x061e, 0x061f}, {0x0621, 0x063a}, {0x0640, 0x065e}, {0x0660, 0x070d}, {0x070f, 0x074a},
    {0x074d, 0x076d}, {0x0780, 0x07b1}, {0x07c0, 0x07fa}, {0x0901, 0x0939}, {0x093c, 0x094d}, {0x0950, 0x0954},
    {0x0958, 0x0970}, {0x097b, 0x097f}, {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8},
    {0x09aa, 0x09b0}, {0x09b2, 0x09b2}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce},
    {0x09d7, 0x09d7}, {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fa}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a},
    {0x0a0f, 0x0a10}, {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39},
    {0x0a3c, 0x0a3c}, {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a59, 0x0a5c}, {0x0a5e, 0x0a5e},
    {0x0a66, 0x0a74}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0},
    {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ad0, 0x0ad0},
    {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, {0x0af1, 0x0af1}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10},
    {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b43}, {0x0b47, 0x0b48},
    {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b61}, {0x0b66, 0x0b71}, {0x0b82, 0x0b83},
    {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c}, {0x0b9e, 0x0b9f},
    {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd},
    {0x0bd7, 0x0bd7}, {0x0be6, 0x0bfa}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10}, {0x0c12, 0x0c28},
    {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3e, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d}, {0x0c55, 0x0c56},
    {0x0c60, 0x0c61}, {0x0c66, 0x0c6f}, {0x0c82, 0x0c83}, {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8},
    {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4}, {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6},
    {0x0cde, 0x0cde}, {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef}, {0x0cf1, 0x0cf2}, {0x0d02, 0x0d03}, {0x0d05, 0x0d0c},
    {0x0d0e, 0x0d10}, {0x0d12, 0x0d28}, {0x0d2a, 0x0d39}, {0x0d3e, 0x0d43}, {0x0d46, 0x0d48}, {0x0d4a, 0x0d4d},
    {0x0d57, 0x0d57}, {0x0d60, 0x0d61}, {0x0d66, 0x0d6f}, {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1},
    {0x0db3, 0x0dbb}, {0x0dbd, 0x0dbd}, {0x0dc0, 0x0dc6}, {0x0dca, 0x0dca}, {0x0dcf, 0x0dd4}, {0x0dd6, 0x0dd6},
    {0x0dd8, 0x0ddf}, {0x0df2, 0x0df4}, {0x0e01, 0x0e3a}, {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e84, 0x0e84},
    {0x0e87, 0x0e88}, {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d}, {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3},
    {0x0ea5, 0x0ea5}, {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab}, {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4},
    {0x0ec6, 0x0ec6}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9}, {0x0edc, 0x0edd}, {0x0f00, 0x0f47}, {0x0f49, 0x0f6a},
    {0x0f71, 0x0f8b}, {0x0f90, 0x0f97}, {0x0f99, 0x0fbc}, {0x0fbe, 0x0fcc}, {0x0fcf, 0x0fd1}, {0x1000, 0x1021},
    {0x1023, 0x1027}, {0x1029, 0x102a}, {0x102c, 0x1032}, {0x1036, 0x1039}, {0x1040, 0x1059}, {0x10a0, 0x10c5},
    {0x10d0, 0x10fc}, {0x1100, 0x1159}, {0x115f, 0x11a2}, {0x11a8, 0x11f9}, {0x1200, 0x1248}, {0x124a, 0x124d},
    {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0},
    {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310},
    {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135f, 0x137c}, {0x1380, 0x1399}, {0x13a0, 0x13f4}, {0x1401, 0x1676},
    {0x1680, 0x169c}, {0x16a0, 0x16f0}, {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1736}, {0x1740, 0x1753},
    {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9},
    {0x1800, 0x180e}, {0x1810, 0x1819}, {0x1820, 0x1877}, {0x1880, 0x18a9}, {0x1900, 0x191c}, {0x1920, 0x192b},
    {0x1930, 0x193b}, {0x1940, 0x1940}, {0x1944, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19a9}, {0x19b0, 0x19c9},
    {0x19d0, 0x19d9}, {0x19de, 0x1a1b}, {0x1a1e, 0x1a1f}, {0x1b00, 0x1b4b}, {0x1b50, 0x1b7c}, {0x1d00, 0x1dca},
    {0x1dfe, 0x1e9b}, {0x1ea0, 0x1ef9}, {0x1f00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d},
    {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4},
    {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe},
    {0x2000, 0x2063}, {0x206a, 0x2071}, {0x2074, 0x208e}, {0x2090, 0x2094}, {0x20a0, 0x20b5}, {0x20d0, 0x20ef},
    {0x2100, 0x214e}, {0x2153, 0x2184}, {0x2190, 0x23e7}, {0x2400, 0x2426}, {0x2440, 0x244a}, {0x2460, 0x269c},
    {0x26a0, 0x26b2}, {0x2701, 0x2704}, {0x2706, 0x2709}, {0x270c, 0x2727}, {0x2729, 0x274b}, {0x274d, 0x274d},
    {0x274f, 0x2752}, {0x2756, 0x2756}, {0x2758, 0x275e}, {0x2761, 0x2794}, {0x2798, 0x27af}, {0x27b1, 0x27be},
    {0x27c0, 0x27ca}, {0x27d0, 0x27eb}, {0x27f0, 0x2b1a}, {0x2b20, 0x2b23}, {0x2c00, 0x2c2e}, {0x2c30, 0x2c5e},
    {0x2c60, 0x2c6c}, {0x2c74, 0x2c77}, {0x2c80, 0x2cea}, {0x2cf9, 0x2d25}, {0x2d30, 0x2d65}, {0x2d6f, 0x2d6f},
    {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6},
    {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2e00, 0x2e17}, {0x2e1c, 0x2e1d}, {0x2e80, 0x2e99},
    {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5}, {0x2ff0, 0x2ffb}, {0x3000, 0x303f}, {0x3041, 0x3096}, {0x3099, 0x30ff},
    {0x3105, 0x312c}, {0x3131, 0x318e}, {0x3190, 0x31b7}, {0x31c0, 0x31cf}, {0x31f0, 0x321e}, {0x3220, 0x3243},
    {0x3250, 0x32fe}, {0x3300, 0x33ff},
    {0x3400, 0x4db5}, // CJK Ideograph Extension A
    {0x4dc0, 0x4dff},
    {0x4e00, 0x9fbb}, // CJK Ideograph
    {0xa000, 0xa48c}, {0xa490, 0xa4c6}, {0xa700, 0xa71a}, {0xa720, 0xa721}, {0xa800, 0xa82b}, {0xa840, 0xa877},
    {0xac00, 0xd7a3}, // Hangul Syllable
    //{0xd800, 0xdb7f}, // Non Private Use High Surrogate
    //{0xdb80, 0xdbff}, // Private Use High Surrogate
    //{0xdc00, 0xdfff}, // Low Surrogate
    //{0xe000, 0xf8ff}, // Private Use
    {0xf900, 0xfa2d}, {0xfa30, 0xfa6a}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb36},
    {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3f},
    {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, {0xfe00, 0xfe19}, {0xfe20, 0xfe23}, {0xfe30, 0xfe52},
    {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xffbe},
    {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee},
    {0xfff9, 0xfffd}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
    {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1018a}, {0x10300, 0x1031e},
    {0x10320, 0x10323}, {0x10330, 0x1034a}, {0x10380, 0x1039d}, {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, {0x10400, 0x1049d},
    {0x104a0, 0x104a9}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c},
    {0x1083f, 0x1083f}, {0x10900, 0x10919}, {0x1091f, 0x1091f}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13},
    {0x10a15, 0x10a17}, {0x10a19, 0x10a33}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a47}, {0x10a50, 0x10a58}, {0x12000, 0x1236e},
    {0x12400, 0x12462}, {0x12470, 0x12473}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d12a, 0x1d1dd}, {0x1d200, 0x1d245},
    {0x1d300, 0x1d356}, {0x1d360, 0x1d371}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
    {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505},
    {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544},
    {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff},
    {0x20000, 0x2a6d6}, // CJK Ideograph Extension B
    {0x2f800, 0x2fa1d}, {0xe0001, 0xe0001}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef},
    //{0xf0000, 0xffffd}, // Plane 15 Private Use
    //{0x100000, 0x10fffd}, // Plane 16 Private Use

    {0x0000, 0x0377}, {0x037a, 0x037e}, {0x0384, 0x038a}, {0x038c, 0x038c}, {0x038e, 0x03a1}, {0x03a3, 0x0527},
    {0x0531, 0x0556}, {0x0559, 0x055f}, {0x0561, 0x0587}, {0x0589, 0x058a}, {0x0591, 0x05c7}, {0x05d0, 0x05ea},
    {0x05f0, 0x05f4}, {0x0600, 0x0603}, {0x0606, 0x061b}, {0x061e, 0x070d}, {0x070f, 0x074a}, {0x074d, 0x07b1},
    {0x07c0, 0x07fa}, {0x0800, 0x082d}, {0x0830, 0x083e}, {0x0840, 0x085b}, {0x085e, 0x085e}, {0x0900, 0x0977},
    {0x0979, 0x097f}, {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0},
    {0x09b2, 0x09b2}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09d7, 0x09d7},
    {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fb}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10},
    {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3c, 0x0a3c},
    {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a51, 0x0a51}, {0x0a59, 0x0a5c}, {0x0a5e, 0x0a5e},
    {0x0a66, 0x0a75}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0},
    {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ad0, 0x0ad0},
    {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, {0x0af1, 0x0af1}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10},
    {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, {0x0b47, 0x0b48},
    {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}, {0x0b82, 0x0b83},
    {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c}, {0x0b9e, 0x0b9f},
    {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd},
    {0x0bd0, 0x0bd0}, {0x0bd7, 0x0bd7}, {0x0be6, 0x0bfa}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10},
    {0x0c12, 0x0c28}, {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3d, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d},
    {0x0c55, 0x0c56}, {0x0c58, 0x0c59}, {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c78, 0x0c7f}, {0x0c82, 0x0c83},
    {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4},
    {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cde, 0x0cde}, {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef},
    {0x0cf1, 0x0cf2}, {0x0d02, 0x0d03}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d3d, 0x0d44},
    {0x0d46, 0x0d48}, {0x0d4a, 0x0d4e}, {0x0d57, 0x0d57}, {0x0d60, 0x0d63}, {0x0d66, 0x0d75}, {0x0d79, 0x0d7f},
    {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dbd, 0x0dbd}, {0x0dc0, 0x0dc6},
    {0x0dca, 0x0dca}, {0x0dcf, 0x0dd4}, {0x0dd6, 0x0dd6}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df4}, {0x0e01, 0x0e3a},
    {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e84, 0x0e84}, {0x0e87, 0x0e88}, {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d},
    {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0ea5, 0x0ea5}, {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab},
    {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0ec6, 0x0ec6}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9},
    {0x0edc, 0x0edd}, {0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, {0x0f99, 0x0fbc}, {0x0fbe, 0x0fcc},
    {0x0fce, 0x0fda}, {0x1000, 0x10c5}, {0x10d0, 0x10fc}, {0x1100, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
    {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
    {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315},
    {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, {0x13a0, 0x13f4}, {0x1400, 0x169c}, {0x16a0, 0x16f0},
    {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1736}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770},
    {0x1772, 0x1773}, {0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1800, 0x180e}, {0x1810, 0x1819},
    {0x1820, 0x1877}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191c}, {0x1920, 0x192b}, {0x1930, 0x193b},
    {0x1940, 0x1940}, {0x1944, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da},
    {0x19de, 0x1a1b}, {0x1a1e, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa0, 0x1aad},
    {0x1b00, 0x1b4b}, {0x1b50, 0x1b7c}, {0x1b80, 0x1baa}, {0x1bae, 0x1bb9}, {0x1bc0, 0x1bf3}, {0x1bfc, 0x1c37},
    {0x1c3b, 0x1c49}, {0x1c4d, 0x1c7f}, {0x1cd0, 0x1cf2}, {0x1d00, 0x1de6}, {0x1dfc, 0x1f15}, {0x1f18, 0x1f1d},
    {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d},
    {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef},
    {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x2064}, {0x206a, 0x2071}, {0x2074, 0x208e}, {0x2090, 0x209c},
    {0x20a0, 0x20b9}, {0x20d0, 0x20f0}, {0x2100, 0x2189}, {0x2190, 0x23f3}, {0x2400, 0x2426}, {0x2440, 0x244a},
    {0x2460, 0x26ff}, {0x2701, 0x27ca}, {0x27cc, 0x27cc}, {0x27ce, 0x2b4c}, {0x2b50, 0x2b59}, {0x2c00, 0x2c2e},
    {0x2c30, 0x2c5e}, {0x2c60, 0x2cf1}, {0x2cf9, 0x2d25}, {0x2d30, 0x2d65}, {0x2d6f, 0x2d70}, {0x2d7f, 0x2d96},
    {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
    {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2e31}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5},
    {0x2ff0, 0x2ffb}, {0x3000, 0x303f}, {0x3041, 0x3096}, {0x3099, 0x30ff}, {0x3105, 0x312d}, {0x3131, 0x318e},
    {0x3190, 0x31ba}, {0x31c0, 0x31e3}, {0x31f0, 0x321e}, {0x3220, 0x32fe}, {0x3300, 0x33ff},
    {0x3400, 0x4db5}, // CJK Ideograph Extension A
    {0x4dc0, 0x4dff},
    {0x4e00, 0x9fcb}, // CJK Ideograph
    {0xa000, 0xa48c}, {0xa490, 0xa4c6}, {0xa4d0, 0xa62b}, {0xa640, 0xa673}, {0xa67c, 0xa697}, {0xa6a0, 0xa6f7},
    {0xa700, 0xa78e}, {0xa790, 0xa791}, {0xa7a0, 0xa7a9}, {0xa7fa, 0xa82b}, {0xa830, 0xa839}, {0xa840, 0xa877},
    {0xa880, 0xa8c4}, {0xa8ce, 0xa8d9}, {0xa8e0, 0xa8fb}, {0xa900, 0xa953}, {0xa95f, 0xa97c}, {0xa980, 0xa9cd},
    {0xa9cf, 0xa9d9}, {0xa9de, 0xa9df}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa5c, 0xaa7b},
    {0xaa80, 0xaac2}, {0xaadb, 0xaadf}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26},
    {0xab28, 0xab2e}, {0xabc0, 0xabed}, {0xabf0, 0xabf9},
    {0xac00, 0xd7a3}, // Hangul Syllable
    {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
    //{0xd800, 0xdb7f}, // Non Private Use High Surrogate
    //{0xdb80, 0xdbff}, // Private Use High Surrogate
    //{0xdc00, 0xdfff}, // Low Surrogate
    //{0xe000, 0xf8ff}, // Private Use
    {0xf900, 0xfa2d}, {0xfa30, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb36},
    {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbc1}, {0xfbd3, 0xfd3f},
    {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, {0xfe00, 0xfe19}, {0xfe20, 0xfe26}, {0xfe30, 0xfe52},
    {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xffbe},
    {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee},
    {0xfff9, 0xfffd}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
    {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1018a}, {0x10190, 0x1019b},
    {0x101d0, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031e}, {0x10320, 0x10323}, {0x10330, 0x1034a},
    {0x10380, 0x1039d}, {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x10800, 0x10805},
    {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10857, 0x1085f},
    {0x10900, 0x1091b}, {0x1091f, 0x10939}, {0x1093f, 0x1093f}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13},
    {0x10a15, 0x10a17}, {0x10a19, 0x10a33}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a47}, {0x10a50, 0x10a58}, {0x10a60, 0x10a7f},
    {0x10b00, 0x10b35}, {0x10b39, 0x10b55}, {0x10b58, 0x10b72}, {0x10b78, 0x10b7f}, {0x10c00, 0x10c48}, {0x10e60, 0x10e7e},
    {0x11000, 0x1104d}, {0x11052, 0x1106f}, {0x11080, 0x110c1}, {0x12000, 0x1236e}, {0x12400, 0x12462}, {0x12470, 0x12473},
    {0x13000, 0x1342e}, {0x16800, 0x16a38}, {0x1b000, 0x1b001}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d1dd},
    {0x1d200, 0x1d245}, {0x1d300, 0x1d356}, {0x1d360, 0x1d371}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f},
    {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
    {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e},
    {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff},
    {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0be}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0df},
    {0x1f100, 0x1f10a}, {0x1f110, 0x1f12e}, {0x1f130, 0x1f169}, {0x1f170, 0x1f19a}, {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23a},
    {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f300, 0x1f320}, {0x1f330, 0x1f335}, {0x1f337, 0x1f37c}, {0x1f380, 0x1f393},
    {0x1f3a0, 0x1f3c4}, {0x1f3c6, 0x1f3ca}, {0x1f3e0, 0x1f3f0}, {0x1f400, 0x1f43e}, {0x1f440, 0x1f440}, {0x1f442, 0x1f4f7},
    {0x1f4f9, 0x1f4fc}, {0x1f500, 0x1f53d}, {0x1f550, 0x1f567}, {0x1f5fb, 0x1f5ff}, {0x1f601, 0x1f610}, {0x1f612, 0x1f614},
    {0x1f616, 0x1f616}, {0x1f618, 0x1f618}, {0x1f61a, 0x1f61a}, {0x1f61c, 0x1f61e}, {0x1f620, 0x1f625}, {0x1f628, 0x1f62b},
    {0x1f62d, 0x1f62d}, {0x1f630, 0x1f633}, {0x1f635, 0x1f640}, {0x1f645, 0x1f64f}, {0x1f680, 0x1f6c5}, {0x1f700, 0x1f773},
    {0x20000, 0x2a6d6}, // CJK Ideograph Extension B
    {0x2a700, 0x2b734}, // CJK Ideograph Extension C
    {0x2b740, 0x2b81d}, // CJK Ideograph Extension D
    {0x2f800, 0x2fa1d}, {0xe0001, 0xe0001}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef},
    //{0xf0000, 0xffffd}, // Plane 15 Private Use
    //{0x100000, 0x10fffd}, // Plane 16 Private Use

    {0x0000, 0x0377}, {0x037a, 0x037e}, {0x0384, 0x038a}, {0x038c, 0x038c}, {0x038e, 0x03a1}, {0x03a3, 0x0527},
    {0x0531, 0x0556}, {0x0559, 0x055f}, {0x0561, 0x0587}, {0x0589, 0x058a}, {0x0591, 0x05c7}, {0x05d0, 0x05ea},
    {0x05f0, 0x05f4}, {0x0600, 0x0603}, {0x0606, 0x061b}, {0x061e, 0x070d}, {0x070f, 0x074a}, {0x074d, 0x07b1},
    {0x07c0, 0x07fa}, {0x0800, 0x082d}, {0x0830, 0x083e}, {0x0840, 0x085b}, {0x085e, 0x085e}, {0x0900, 0x0977},
    {0x0979, 0x097f}, {0x0981, 0x0983}, {0x0985, 0x098c}, {0x098f, 0x0990}, {0x0993, 0x09a8}, {0x09aa, 0x09b0},
    {0x09b2, 0x09b2}, {0x09b6, 0x09b9}, {0x09bc, 0x09c4}, {0x09c7, 0x09c8}, {0x09cb, 0x09ce}, {0x09d7, 0x09d7},
    {0x09dc, 0x09dd}, {0x09df, 0x09e3}, {0x09e6, 0x09fb}, {0x0a01, 0x0a03}, {0x0a05, 0x0a0a}, {0x0a0f, 0x0a10},
    {0x0a13, 0x0a28}, {0x0a2a, 0x0a30}, {0x0a32, 0x0a33}, {0x0a35, 0x0a36}, {0x0a38, 0x0a39}, {0x0a3c, 0x0a3c},
    {0x0a3e, 0x0a42}, {0x0a47, 0x0a48}, {0x0a4b, 0x0a4d}, {0x0a51, 0x0a51}, {0x0a59, 0x0a5c}, {0x0a5e, 0x0a5e},
    {0x0a66, 0x0a75}, {0x0a81, 0x0a83}, {0x0a85, 0x0a8d}, {0x0a8f, 0x0a91}, {0x0a93, 0x0aa8}, {0x0aaa, 0x0ab0},
    {0x0ab2, 0x0ab3}, {0x0ab5, 0x0ab9}, {0x0abc, 0x0ac5}, {0x0ac7, 0x0ac9}, {0x0acb, 0x0acd}, {0x0ad0, 0x0ad0},
    {0x0ae0, 0x0ae3}, {0x0ae6, 0x0aef}, {0x0af1, 0x0af1}, {0x0b01, 0x0b03}, {0x0b05, 0x0b0c}, {0x0b0f, 0x0b10},
    {0x0b13, 0x0b28}, {0x0b2a, 0x0b30}, {0x0b32, 0x0b33}, {0x0b35, 0x0b39}, {0x0b3c, 0x0b44}, {0x0b47, 0x0b48},
    {0x0b4b, 0x0b4d}, {0x0b56, 0x0b57}, {0x0b5c, 0x0b5d}, {0x0b5f, 0x0b63}, {0x0b66, 0x0b77}, {0x0b82, 0x0b83},
    {0x0b85, 0x0b8a}, {0x0b8e, 0x0b90}, {0x0b92, 0x0b95}, {0x0b99, 0x0b9a}, {0x0b9c, 0x0b9c}, {0x0b9e, 0x0b9f},
    {0x0ba3, 0x0ba4}, {0x0ba8, 0x0baa}, {0x0bae, 0x0bb9}, {0x0bbe, 0x0bc2}, {0x0bc6, 0x0bc8}, {0x0bca, 0x0bcd},
    {0x0bd0, 0x0bd0}, {0x0bd7, 0x0bd7}, {0x0be6, 0x0bfa}, {0x0c01, 0x0c03}, {0x0c05, 0x0c0c}, {0x0c0e, 0x0c10},
    {0x0c12, 0x0c28}, {0x0c2a, 0x0c33}, {0x0c35, 0x0c39}, {0x0c3d, 0x0c44}, {0x0c46, 0x0c48}, {0x0c4a, 0x0c4d},
    {0x0c55, 0x0c56}, {0x0c58, 0x0c59}, {0x0c60, 0x0c63}, {0x0c66, 0x0c6f}, {0x0c78, 0x0c7f}, {0x0c82, 0x0c83},
    {0x0c85, 0x0c8c}, {0x0c8e, 0x0c90}, {0x0c92, 0x0ca8}, {0x0caa, 0x0cb3}, {0x0cb5, 0x0cb9}, {0x0cbc, 0x0cc4},
    {0x0cc6, 0x0cc8}, {0x0cca, 0x0ccd}, {0x0cd5, 0x0cd6}, {0x0cde, 0x0cde}, {0x0ce0, 0x0ce3}, {0x0ce6, 0x0cef},
    {0x0cf1, 0x0cf2}, {0x0d02, 0x0d03}, {0x0d05, 0x0d0c}, {0x0d0e, 0x0d10}, {0x0d12, 0x0d3a}, {0x0d3d, 0x0d44},
    {0x0d46, 0x0d48}, {0x0d4a, 0x0d4e}, {0x0d57, 0x0d57}, {0x0d60, 0x0d63}, {0x0d66, 0x0d75}, {0x0d79, 0x0d7f},
    {0x0d82, 0x0d83}, {0x0d85, 0x0d96}, {0x0d9a, 0x0db1}, {0x0db3, 0x0dbb}, {0x0dbd, 0x0dbd}, {0x0dc0, 0x0dc6},
    {0x0dca, 0x0dca}, {0x0dcf, 0x0dd4}, {0x0dd6, 0x0dd6}, {0x0dd8, 0x0ddf}, {0x0df2, 0x0df4}, {0x0e01, 0x0e3a},
    {0x0e3f, 0x0e5b}, {0x0e81, 0x0e82}, {0x0e84, 0x0e84}, {0x0e87, 0x0e88}, {0x0e8a, 0x0e8a}, {0x0e8d, 0x0e8d},
    {0x0e94, 0x0e97}, {0x0e99, 0x0e9f}, {0x0ea1, 0x0ea3}, {0x0ea5, 0x0ea5}, {0x0ea7, 0x0ea7}, {0x0eaa, 0x0eab},
    {0x0ead, 0x0eb9}, {0x0ebb, 0x0ebd}, {0x0ec0, 0x0ec4}, {0x0ec6, 0x0ec6}, {0x0ec8, 0x0ecd}, {0x0ed0, 0x0ed9},
    {0x0edc, 0x0edd}, {0x0f00, 0x0f47}, {0x0f49, 0x0f6c}, {0x0f71, 0x0f97}, {0x0f99, 0x0fbc}, {0x0fbe, 0x0fcc},
    {0x0fce, 0x0fda}, {0x1000, 0x10c5}, {0x10d0, 0x10fc}, {0x1100, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
    {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
    {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315},
    {0x1318, 0x135a}, {0x135d, 0x137c}, {0x1380, 0x1399}, {0x13a0, 0x13f4}, {0x1400, 0x169c}, {0x16a0, 0x16f0},
    {0x1700, 0x170c}, {0x170e, 0x1714}, {0x1720, 0x1736}, {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770},
    {0x1772, 0x1773}, {0x1780, 0x17dd}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1800, 0x180e}, {0x1810, 0x1819},
    {0x1820, 0x1877}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191c}, {0x1920, 0x192b}, {0x1930, 0x193b},
    {0x1940, 0x1940}, {0x1944, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da},
    {0x19de, 0x1a1b}, {0x1a1e, 0x1a5e}, {0x1a60, 0x1a7c}, {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa0, 0x1aad},
    {0x1b00, 0x1b4b}, {0x1b50, 0x1b7c}, {0x1b80, 0x1baa}, {0x1bae, 0x1bb9}, {0x1bc0, 0x1bf3}, {0x1bfc, 0x1c37},
    {0x1c3b, 0x1c49}, {0x1c4d, 0x1c7f}, {0x1cd0, 0x1cf2}, {0x1d00, 0x1de6}, {0x1dfc, 0x1f15}, {0x1f18, 0x1f1d},
    {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d},
    {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fc4}, {0x1fc6, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fdd, 0x1fef},
    {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffe}, {0x2000, 0x2064}, {0x206a, 0x2071}, {0x2074, 0x208e}, {0x2090, 0x209c},
    {0x20a0, 0x20b9}, {0x20d0, 0x20f0}, {0x2100, 0x2189}, {0x2190, 0x23f3}, {0x2400, 0x2426}, {0x2440, 0x244a},
    {0x2460, 0x26ff}, {0x2701, 0x27ca}, {0x27cc, 0x27cc}, {0x27ce, 0x2b4c}, {0x2b50, 0x2b59}, {0x2c00, 0x2c2e},
    {0x2c30, 0x2c5e}, {0x2c60, 0x2cf1}, {0x2cf9, 0x2d25}, {0x2d30, 0x2d65}, {0x2d6f, 0x2d70}, {0x2d7f, 0x2d96},
    {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
    {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2e31}, {0x2e80, 0x2e99}, {0x2e9b, 0x2ef3}, {0x2f00, 0x2fd5},
    {0x2ff0, 0x2ffb}, {0x3000, 0x303f}, {0x3041, 0x3096}, {0x3099, 0x30ff}, {0x3105, 0x312d}, {0x3131, 0x318e},
    {0x3190, 0x31ba}, {0x31c0, 0x31e3}, {0x31f0, 0x321e}, {0x3220, 0x32fe}, {0x3300, 0x33ff},
    {0x3400, 0x4db5}, // CJK Ideograph Extension A
    {0x4dc0, 0x4dff},
    {0x4e00, 0x9fcb}, // CJK Ideograph
    {0xa000, 0xa48c}, {0xa490, 0xa4c6}, {0xa4d0, 0xa62b}, {0xa640, 0xa673}, {0xa67c, 0xa697}, {0xa6a0, 0xa6f7},
    {0xa700, 0xa78e}, {0xa790, 0xa791}, {0xa7a0, 0xa7a9}, {0xa7fa, 0xa82b}, {0xa830, 0xa839}, {0xa840, 0xa877},
    {0xa880, 0xa8c4}, {0xa8ce, 0xa8d9}, {0xa8e0, 0xa8fb}, {0xa900, 0xa953}, {0xa95f, 0xa97c}, {0xa980, 0xa9cd},
    {0xa9cf, 0xa9d9}, {0xa9de, 0xa9df}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa5c, 0xaa7b},
    {0xaa80, 0xaac2}, {0xaadb, 0xaadf}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26},
    {0xab28, 0xab2e}, {0xabc0, 0xabed}, {0xabf0, 0xabf9},
    {0xac00, 0xd7a3}, // Hangul Syllable
    {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb},
    //{0xd800, 0xdb7f}, // Non Private Use High Surrogate
    //{0xdb80, 0xdbff}, // Private Use High Surrogate
    //{0xdc00, 0xdfff}, // Low Surrogate
    //{0xe000, 0xf8ff}, // Private Use
    {0xf900, 0xfa2d}, {0xfa30, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb36},
    {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbc1}, {0xfbd3, 0xfd3f},
    {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfd}, {0xfe00, 0xfe19}, {0xfe20, 0xfe26}, {0xfe30, 0xfe52},
    {0xfe54, 0xfe66}, {0xfe68, 0xfe6b}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc}, {0xfeff, 0xfeff}, {0xff01, 0xffbe},
    {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0xffe0, 0xffe6}, {0xffe8, 0xffee},
    {0xfff9, 0xfffd}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
    {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10100, 0x10102}, {0x10107, 0x10133}, {0x10137, 0x1018a}, {0x10190, 0x1019b},
    {0x101d0, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031e}, {0x10320, 0x10323}, {0x10330, 0x1034a},
    {0x10380, 0x1039d}, {0x1039f, 0x103c3}, {0x103c8, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x10800, 0x10805},
    {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10857, 0x1085f},
    {0x10900, 0x1091b}, {0x1091f, 0x10939}, {0x1093f, 0x1093f}, {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13},
    {0x10a15, 0x10a17}, {0x10a19, 0x10a33}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a47}, {0x10a50, 0x10a58}, {0x10a60, 0x10a7f},
    {0x10b00, 0x10b35}, {0x10b39, 0x10b55}, {0x10b58, 0x10b72}, {0x10b78, 0x10b7f}, {0x10c00, 0x10c48}, {0x10e60, 0x10e7e},
    {0x11000, 0x1104d}, {0x11052, 0x1106f}, {0x11080, 0x110c1}, {0x12000, 0x1236e}, {0x12400, 0x12462}, {0x12470, 0x12473},
    {0x13000, 0x1342e}, {0x16800, 0x16a38}, {0x1b000, 0x1b001}, {0x1d000, 0x1d0f5}, {0x1d100, 0x1d126}, {0x1d129, 0x1d1dd},
    {0x1d200, 0x1d245}, {0x1d300, 0x1d356}, {0x1d360, 0x1d371}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f},
    {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
    {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e},
    {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d7cb}, {0x1d7ce, 0x1d7ff},
    {0x1f000, 0x1f02b}, {0x1f030, 0x1f093}, {0x1f0a0, 0x1f0ae}, {0x1f0b1, 0x1f0be}, {0x1f0c1, 0x1f0cf}, {0x1f0d1, 0x1f0df},
    {0x1f100, 0x1f10a}, {0x1f110, 0x1f12e}, {0x1f130, 0x1f169}, {0x1f170, 0x1f19a}, {0x1f1e6, 0x1f202}, {0x1f210, 0x1f23a},
    {0x1f240, 0x1f248}, {0x1f250, 0x1f251}, {0x1f300, 0x1f320}, {0x1f330, 0x1f335}, {0x1f337, 0x1f37c}, {0x1f380, 0x1f393},
    {0x1f3a0, 0x1f3c4}, {0x1f3c6, 0x1f3ca}, {0x1f3e0, 0x1f3f0}, {0x1f400, 0x1f43e}, {0x1f440, 0x1f440}, {0x1f442, 0x1f4f7},
    {0x1f4f9, 0x1f4fc}, {0x1f500, 0x1f53d}, {0x1f550, 0x1f567}, {0x1f5fb, 0x1f5ff}, {0x1f601, 0x1f610}, {0x1f612, 0x1f614},
    {0x1f616, 0x1f616}, {0x1f618, 0x1f618}, {0x1f61a, 0x1f61a}, {0x1f61c, 0x1f61e}, {0x1f620, 0x1f625}, {0x1f628, 0x1f62b},
    {0x1f62d, 0x1f62d}, {0x1f630, 0x1f633}, {0x1f635, 0x1f640}, {0x1f645, 0x1f64f}, {0x1f680, 0x1f6c5}, {0x1f700, 0x1f773},
    {0x20000, 0x2a6d6}, // CJK Ideograph Extension B
    {0x2a700, 0x2b734}, // CJK Ideograph Extension C
    {0x2b740, 0x2b81d}, // CJK Ideograph Extension D
    {0x2f800, 0x2fa1d}, {0xe0001, 0xe0001}, {0xe0020, 0xe007f}, {0xe0100, 0xe01ef},
    //{0xf0000, 0xffffd}, // Plane 15 Private Use
    //{0x100000, 0x10fffd}, // Plane 16 Private Use
};

const CUnicodeBlocks::TUnicodeAllocation CUnicodeBlocks::p_allocation_table[] = {
    {p_global_range_list + 0, 288, "1.1.5"},
    {p_global_range_list + 288, 298, "2.0.14"},
    {p_global_range_list + 586, 355, "3.0.0"},
    {p_global_range_list + 941, 402, "4.0.0"},
    {p_global_range_list + 1343, 430, "5.0.0"},
    {p_global_range_list + 1773, 501, "6.0.0"},
    {p_global_range_list + 2274, 501, "6.1.0d1"},
};

const size_t CUnicodeBlocks::n_allocation_table_size = sizeof(CUnicodeBlocks::p_allocation_table) /
	sizeof(CUnicodeBlocks::p_allocation_table[0]);

size_t CUnicodeBlocks::n_Translate_UnicodeVersion(const char *p_s_unicode_version)
{
	size_t n_version_index = n_allocation_table_size;
	for(size_t i = 0; i < n_allocation_table_size; ++ i) {
		if(!strcasecmp(p_allocation_table[i].p_s_unicode_version, p_s_unicode_version)) {
			n_version_index = i;
			break;
		}
	}
	if(n_version_index == n_allocation_table_size) {
		//fprintf(stderr, "error: unicode version \'%s\' not found\n", p_s_unicode_version);
		return size_t(-1);
	}
	// find unicode version

	return n_version_index;
}

bool CUnicodeBlocks::Codepoints_From_UnicodeNames(std::vector<std::pair<int, int> > &r_range_list,
	size_t &r_n_char_num, size_t n_unicode_block_num, const char **p_unicode_block_list,
	size_t n_unicode_version_index, bool b_errors_to_stderr)
{
	/*r_range_list.clear();
	r_n_char_num = 0;*/
	// don't do this

	std::vector<TCodeRange> in_range_list;
	for(size_t i = 0; i < n_unicode_block_num; ++ i) {
		const char *p_s_block_name = p_unicode_block_list[i];
		// name of the requested block

		bool b_found = false;
		for(size_t j = 0; j < n_unicode_log_block_num; ++ j) {
			if(!strcasecmp(p_unicode_blocks[j].p_s_name, p_s_block_name)) {
				try {
					in_range_list.push_back(p_unicode_blocks[j].t_range);
				} catch(std::bad_alloc&) {
					return false;
				}
				b_found = true;
				break;
			}
		}
		if(!b_found) {
			if(b_errors_to_stderr)
				fprintf(stderr, "error: unicode block \'%s\' not found\n", p_s_block_name);
			return false;
		}
		// find it's first / last codes
	}
	std::sort(in_range_list.begin(), in_range_list.end(), b_Smaller_FirstCode);
	// collect input character ranges, sort them

	for(size_t i = 1, n = in_range_list.size(); i < n; ++ i) {
		TCodeRange &r_prev = in_range_list[i - 1];
		TCodeRange &r_cur = in_range_list[i];
		_ASSERTE(r_prev.n_first_code <= r_cur.n_first_code); // they are sorted
		if(r_prev.n_last_code >= r_cur.n_first_code) {
			r_prev.n_last_code = max(r_prev.n_last_code, r_cur.n_last_code);
			in_range_list.erase(in_range_list.begin() + i);
			-- i;
			-- n;
		}
	}
	// handle repeating / overlapping ranges

	const TCodeRange *p_alloc_range =
		p_allocation_table[n_unicode_version_index].p_code_range;
	const size_t n_alloc_range_num =
		p_allocation_table[n_unicode_version_index].n_range_num;
	const TCodeRange *p_last_alloc_range = p_alloc_range + n_alloc_range_num;
	// get code allocation range and number of ranges

	for(size_t i = 0, n = in_range_list.size(); i < n; ++ i) {
		TCodeRange t_in_range = in_range_list[i];
		// get input range

		while(p_alloc_range < p_last_alloc_range && t_in_range.n_first_code > p_alloc_range->n_last_code) // inclusive ranges!
			++ p_alloc_range;
		// skip to overlapping allocation range

		while(p_alloc_range < p_last_alloc_range && t_in_range.n_last_code >= p_alloc_range->n_first_code) { // inclusive ranges!
			TCodeRange t_isect;
			t_isect.n_first_code = max(t_in_range.n_first_code, p_alloc_range->n_first_code);
			t_isect.n_last_code = min(t_in_range.n_last_code, p_alloc_range->n_last_code);
			// calculate inteersection of the two ranges

			_ASSERTE(t_isect.n_first_code <= t_isect.n_last_code); // should be always true in this loop // inclusive ranges!
			if(t_isect.n_first_code <= t_isect.n_last_code) { // inclusive ranges!
				if(!r_range_list.empty() && r_range_list.back().second + 1 == t_isect.n_first_code) { // inclusive ranges!
					r_range_list.back().second = t_isect.n_last_code;
					r_n_char_num += t_isect.n_last_code - t_isect.n_first_code + 1; // inclusive ranges!
					// connect with the previous range
				} else {
					try {
						r_range_list.push_back(std::make_pair(t_isect.n_first_code, t_isect.n_last_code));
					} catch(std::bad_alloc&) {
						//fprintf(stderr, "error: not enough memory\n");
						return false;
					}
					r_n_char_num += t_isect.n_last_code - t_isect.n_first_code + 1; // inclusive ranges!
					// create a new range
				}
			}
			// process non-empty intersections

			if(t_in_range.n_last_code <= p_alloc_range->n_last_code)
				break;
			// in case the allocation range goes beyond, stop here

			++ p_alloc_range;
		}
		// pass trough all the overlapping allocation ranges
	}

	return true;
}

inline bool CUnicodeBlocks::b_Smaller_FirstCode(const TCodeRange &a, const TCodeRange &b)
{
	return a.n_first_code < b.n_first_code;
}
