#include "NoneReader.h"

NoneReader::NoneReader()
{
	this->init();
}

NoneReader::NoneReader(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
	this->init();
	this->openFile(in_file, width, height, repeat, error);
}

NoneReader::~NoneReader(void)
{
	this->closeFile();
}

void NoneReader::init()
{
	this->open = false;
}

bool NoneReader::isOpen()
	{
		return this->open;
	}

bool NoneReader::openFile(std::string &in_file, int &width, int &height, bool repeat, std::stringstream *error)
{
  this->closeFile();
  this->open = true;
  this->bgra_frame = 0;
  width = 1;
  height = 1;
  return true;
}

bool NoneReader::getFrame(void **bgra_out_frame, std::stringstream *error)
	{
    if(!this->isOpen())
      {
        return false;
      }
    *bgra_out_frame = bgra_frame;
    return true;
	}

bool NoneReader::setFramePos(unsigned int frame_pos)
  {
    return true;
  }

void NoneReader::closeFile()
{
  this->open = false;
}




