#ifndef MAIN_CONFIG_H
#define MAIN_CONFIG_H

#include <vector>
#include <sstream>
#include "WaveletOpenclParamSep.h"
#include "WaveletOpenclParamComb.h"
#include "WaveletOpenmpParamSep.h"
#include "Debug.h"
#include "ParseArg.h"

enum e_output_type
{
  CONF_OUTPUT_TYPE_FULL = 0,
  CONF_OUTPUT_TYPE_CSV
};

/**
 * @brief Class for getting required data such as wald boost classifier file path, settings file path, input video file and optional data from program parameters.
 */
class MainConfig
  {
    public:
      std::string in_file; ///< Required input video file path
      int frame_count; ///< Frame count to process or DET_UNDEF
      bool print_devices; ///< Print devices
      bool in_show; ///< Input image show
      bool out_show; ///< Output image show
      bool cam_use;
      bool benchmark_proc;
      bool memless_exec;
      e_output_type output_type;
      engine_type engine;
      WaveletOpenclParamSep opencl_sep_par; ///< Program options
      WaveletOpenclParamComb opencl_comb_par; ///< Program options
      WaveletOpenmpParamSep openmp_sep_par; ///< Program options
      /**
       * Initialize object data.
       */
      MainConfig();
      /**
       * Delete object data.
       */
      ~MainConfig();
      /**
       * Load configuration from program parameters.
       * @param argc program parameters count
       * @param argv program parameters
       * @param error optional string to write error
       */
      bool loadFromArguments(int argc, char *argv[], std::stringstream *error = NULL);
      /**
       * Print help.
       * @param exec_name program path
       */
      void printHelp(const char *exec_name);
    private:
      ParseArg parser; ///< Arguments parser
  };

#endif
