#include "MainConfig.h"

MainConfig::MainConfig()
  {
    this->in_show = false;
    this->out_show = false;
    this->print_devices = false;
    this->frame_count = DET_UNDEF;
    this->cam_use = false;
    this->output_type = CONF_OUTPUT_TYPE_FULL;
    this->engine = ENGINE_TYPE_OPENCL_COMB;
    this->memless_exec = false;
    this->benchmark_proc = false;
    const opt opts[] = {{(char *)"show-input", 0, false, (char *)"Show input video file while converting"},
                         {(char *)"show-output", 0, false, (char *)"Show output video file while converting"},
                         {(char *)"help", 'h', false, (char *)"Print this help"},
                         {(char *)"input", 'i', true, (char *)"Set path to input image/video file"},
                         {(char *)"device", 'd', true, (char *)"Set device {c,cpu,g,gpu}"},
                         {(char *)"print-devices", 0, false, (char *)"Print devices info"},
						             {(char *)"benchmark-proc", 0, false, (char *)"Benchmark process only execution (virtual data)"},
						             {(char *)"disable-gen-filter-body", 0, false, (char *)"Disable generation of filter body"},
                         {(char *)"frame-count", 0, true, (char *)"Set frame process count"},
                         {(char *)"cam", 0, true, (char *)"Camera number"},
                         {(char *)"hor-pairs", 0, true, (char *)"Pixel pairs to process by thread in horizontal transform"},
                         {(char *)"vert-pairs", 0, true, (char *)"pixel pairs to process by thread in vertical transform"},
                         {(char *)"hor-x", 0, true, (char *)"Width of group in horizontal transform"},
                         {(char *)"hor-y", 0, true, (char *)"Height of group in horizontal transform"},
                         {(char *)"vert-x", 0, true, (char *)"Width of group in vertical transform"},
                         {(char *)"vert-y", 0, true, (char *)"Height of group in vertical transform"},
                         {(char *)"comb-x", 0, true, (char *)"Width of group in combined transform"},
                         {(char *)"comb-y", 0, true, (char *)"Height of group in combined transform"},
                         {(char *)"hor-kernel", 0, true, (char *)"Horizontal pass kernel name"},
                         {(char *)"vert-kernel", 0, true, (char *)"Vertical pass kernel name"},
                         {(char *)"comb-kernel", 0, true, (char *)"Combined pass kernel named"},
                         {(char *)"output-type", 0, true, (char *)"Set output type {full,f,csv,c}"},
                         {(char *)"comb-corn-proc", 0, false, (char *)"Process horizontal corners in comb out kernels"},
                         {(char *)"warp-size", 0, true, (char *)"Size of warp"},
                         {(char *)"non-atomic-warp", 0, false, (char *)"Warp instructions is not executed atomicaly"},
                         {(char *)"hor-proc", 0, true, (char *)"Set type of hor process {blaz_normal,bn,blaz_register,br,laan,l}"},
                         {(char *)"vert-proc", 0, true, (char *)"Set type of vert process {blaz_normal,bn,blaz_register,br,laan,l}"},
                         {(char *)"engine-type", 0, true, (char *)"Set benchmark type {opencl,openmp,openclcomb}"},
                         {(char *)"hor-func", 0, true, (char *)"Horizontal pass function name in OpenMP"},
                         {(char *)"vert-func", 0, true, (char *)"Vertical pass function name in OpenMP"},
                         {(char *)"interlaced", 0, false, (char *)"Wavelet use output interlaced"},
						             {(char *)"max-depth", 0, true, (char *)"Maximum depth of transformation" },
						             {(char *)"wavelet-type", 0, true, (char *)"Type of wavelet {CDF53,CDF97,CDF137}"},
                         {(char *)"resize-x", 0, true, (char *)"Resolution in x axis to resize"},
                         {(char *)"resize-y", 0, true, (char *)"Resolution in y axis to resize"},
                         {(char *)"subdevice-size", 0, true, (char *)"Size of subdevice"},
						             {(char *)"image-mem", 0, true, (char *)"Type of image memory {texture,global}"},
                         {(char *)"disable-double-buffering", 0, false, (char *)"Disable double buffering"},
						             {(char *)"repeat-count", 0, true, (char *)"Wavelet execution repeat count <0,inf) (only for memless-exec)"},
						             {(char *)"memless-exec", 0, false, (char *)"Memoryless execution"}};
		this->parser.addOpts(opts, 40);
  }

MainConfig::~MainConfig()
  {
  }

void MainConfig::printHelp(const char *exec_name)
  {
    std::string header = std::string() + "\nUsage: " + exec_name + " -i=input_video_file [parameters]\n";
    this->parser.printHelp(header);
  }

bool MainConfig::loadFromArguments(int argc, char *argv[], std::stringstream *error)
  {
		std::string opt_value;
		int opt_num;
		int type_count = 0;
    int ival;
		for(int i = 1; i < argc; i++)
			{
				opt_num = parser.getArgOpt(argv[i], opt_value);
				switch(opt_num)
					{
						case 0:
							this->in_show = true;
						break;
						case 1:
							this->out_show = true;
						break;
						case 2:
							this->printHelp(argv[0]);
              exit(0);
						break;
						case 3:
              if(opt_value.length() == 0)
                {
                  if(error != NULL) *error << "Warning: Parameter \"input\" is empty.\n";
                }
              else
                {
							    this->in_file = opt_value;
                  this->cam_use = false;
                }
						break;
						case 4:
              if((opt_value.compare("gpu") == 0) || (opt_value.compare("g") == 0))
                {
                  this->opencl_comb_par.dev_id = 0;
                  this->opencl_sep_par.dev_id = 0;
                  this->opencl_comb_par.dev_type = CL_DEVICE_TYPE_GPU;
                  this->opencl_sep_par.dev_type = CL_DEVICE_TYPE_GPU;
                }
              else if((opt_value.compare("cpu") == 0) || (opt_value.compare("c") == 0))
                {
                  this->opencl_comb_par.dev_id = 0;
                  this->opencl_sep_par.dev_id = 0;
                  this->opencl_comb_par.dev_type = CL_DEVICE_TYPE_CPU;
                  this->opencl_sep_par.dev_type = CL_DEVICE_TYPE_CPU;
                }
              else
                {
                  ival = atoi(opt_value.c_str());
                  if(ival < 0)
                    {
                      if(error != NULL) *error << "Warning: Parameter \"device\" is not correct. Right values are (gpu|g|prefer-gpu) for prefer gpu (cpu|c|prefer-cpu) for prefer cpu (force-gpu) for force gpu (force-cpu) for force cpu or device id.\n";
                    }
                  else
                    {
                      this->opencl_comb_par.dev_id = ival;
                      this->opencl_sep_par.dev_id = ival;
                      this->opencl_comb_par.dev_type = CL_DEVICE_TYPE_ALL;
                      this->opencl_sep_par.dev_type = CL_DEVICE_TYPE_ALL;
                    }
                }
							type_count++;
						break; 
            case 5:
              this->print_devices = true;
            break;
            case 6:
              this->opencl_comb_par.benchmark_proc = true;
              this->opencl_sep_par.benchmark_proc = true;
              this->benchmark_proc = true;
              break;
            case 7:
              this->opencl_comb_par.gen_filter_body = false;
              this->opencl_sep_par.gen_filter_body = false;
              break;
            case 8:
              ival = atoi(opt_value.c_str());
              if(ival < 1)
                {
                  if(error != NULL) *error << "Warning: Parameter \"frame-count\" is out of range. Right range is <1,kernel_count).\n";
                }
              else
                {
                  this->frame_count = ival;
                }
            break;
            case 9:
              ival = atoi(opt_value.c_str());
              if(ival < 0)
              {
                if(error != NULL) *error << "Warning: Parameter \"camera\" is out of range. Right range is <0,inf).\n";
              }
              else
              {
                this->in_file = opt_value;
                this->cam_use = true;
              }
              break;
            case 10:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 8))
              {
                if(error != NULL) *error << "Warning: Parameter \"hor-pairs\" is out of range. Right range is <1,8>.\n";
              }
              else
              {
                this->opencl_sep_par.hor_pairs = ival;
                //this->opencl_comb_par.hor_pairs = ival;
              }
              break;
            case 11:
              ival = atoi(opt_value.c_str());
              if(ival < 1)
              {
                if(error != NULL) *error << "Warning: Parameter \"vert-pairs\" is out of range. Right range is <1,inf).\n";
              }
              else
              {
                this->opencl_sep_par.vert_pairs = ival;
                //this->opencl_comb_par.vert_pairs = ival;
              }
              break;
            case 12:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 1024))
              {
                if(error != NULL) *error << "Warning: Parameter \"hor-x\" is out of range. Right range is <1,1024>.\n";
              }
              else
              {
                this->opencl_sep_par.hor_sizes.x = ival;
              }
              break;
            case 13:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 1024))
              {
                if(error != NULL) *error << "Warning: Parameter \"hor-y\" is out of range. Right range is <1,1024>.\n";
              }
              else
              {
                this->opencl_sep_par.hor_sizes.y = ival;
              }
              break;
            case 14:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 1024))
              {
                if(error != NULL) *error << "Warning: Parameter \"vert-x\" is out of range. Right range is <1,1024>.\n";
              }
              else
              {
                this->opencl_sep_par.vert_sizes.x = ival;
              }
              break;
            case 15:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 1024))
              {
                if(error != NULL) *error << "Warning: Parameter \"vert-y\" is out of range. Right range is <1,1024>.\n";
              }
              else
              {
                this->opencl_sep_par.vert_sizes.y = ival;
              }
              break;
            case 16:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 1024))
              {
                if(error != NULL) *error << "Warning: Parameter \"comb-x\" is out of range. Right range is <1,1024>.\n";
              }
              else
              {
                this->opencl_comb_par.comb_sizes.x = ival;
              }
              break;
            case 17:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 1024))
              {
                if(error != NULL) *error << "Warning: Parameter \"comb-y\" is out of range. Right range is <1,1024>.\n";
              }
              else
              {
                this->opencl_comb_par.comb_sizes.y = ival;
              }
              break;
            case 18:
              this->opencl_sep_par.hor_kernel = opt_value;
              break;
            case 19:
              this->opencl_sep_par.vert_kernel = opt_value;
              break;
            case 20:
              this->opencl_comb_par.comb_kernel = opt_value;
              break;
            case 21:
              if((opt_value.compare("full") == 0) || (opt_value.compare("f") == 0))
                {
                  this->output_type = CONF_OUTPUT_TYPE_FULL;
                }
              else if((opt_value.compare("csv") == 0) || (opt_value.compare("c") == 0))
                {
                  this->output_type = CONF_OUTPUT_TYPE_CSV;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Unknown type of parameter \"output-type\". Supported types are (full|f) for full stdout mode (csv|c) for csv stdout mode.\n";
                }
            break;
            case 22:
              this->opencl_comb_par.comb_hor_corners_proc = 1;
            break;
            case 23:
              ival = atoi(opt_value.c_str());
              if(ival < 1)
              {
                if(error != NULL) *error << "Warning: Parameter \"warp-size\" is out of range. Right range is <1,inf).\n";
              }
              else
              {
                this->opencl_sep_par.warp_size = ival;
                this->opencl_comb_par.warp_size = ival;
              }
              break;
            case 24:
              this->opencl_sep_par.atomic_warp = 0;
              this->opencl_comb_par.atomic_warp = 0;
            break;
            case 25:
              if((opt_value.compare("blaz_normal") == 0) || (opt_value.compare("bn") == 0))
                {
                  this->opencl_sep_par.hor_proc = WAVELET_PROC_TYPE_BLAZ_NORMAL;
                  this->opencl_comb_par.hor_proc = WAVELET_PROC_TYPE_BLAZ_NORMAL;
                }
              else if((opt_value.compare("blaz_register") == 0) || (opt_value.compare("br") == 0))
                {
                  this->opencl_sep_par.hor_proc = WAVELET_PROC_TYPE_BLAZ_REGISTER;
                  this->opencl_comb_par.hor_proc = WAVELET_PROC_TYPE_BLAZ_REGISTER;
                }
              else if((opt_value.compare("laan") == 0) || (opt_value.compare("l") == 0))
                {
                  this->opencl_sep_par.hor_proc = WAVELET_PROC_TYPE_LAAN;
                  this->opencl_comb_par.hor_proc = WAVELET_PROC_TYPE_LAAN;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Wrong value for parameter \"hor-proc\".\n";
                }
            break;
            case 26:
              if((opt_value.compare("blaz_normal") == 0) || (opt_value.compare("bn") == 0))
                {
                  this->opencl_sep_par.vert_proc = WAVELET_PROC_TYPE_BLAZ_NORMAL;
                  this->opencl_comb_par.vert_proc = WAVELET_PROC_TYPE_BLAZ_NORMAL;
                }
              else if((opt_value.compare("blaz_register") == 0) || (opt_value.compare("br") == 0))
                {
                  this->opencl_sep_par.vert_proc = WAVELET_PROC_TYPE_BLAZ_REGISTER;
                  this->opencl_comb_par.vert_proc = WAVELET_PROC_TYPE_BLAZ_REGISTER;
                }
              else if((opt_value.compare("laan") == 0) || (opt_value.compare("l") == 0))
                {
                  this->opencl_sep_par.vert_proc = WAVELET_PROC_TYPE_LAAN;
                  this->opencl_comb_par.vert_proc = WAVELET_PROC_TYPE_LAAN;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Wrong value for parameter \"vert-proc\".\n";
                }
            break;
            case 27:
              if(opt_value.compare("opencl") == 0)
                {
                  this->engine = ENGINE_TYPE_OPENCL_SEP;
                }
              else if(opt_value.compare("openmp") == 0)
                {
                  this->engine = ENGINE_TYPE_OPENMP_SEP;
                }
              else if(opt_value.compare("openclcomb") == 0)
                {
                  this->engine = ENGINE_TYPE_OPENCL_COMB;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Wrong value of parameter \"engine-type\".\n";
                }
            break;
            case 28:
              if(opt_value.compare("transformSepSingle") == 0)
                {
                  this->openmp_sep_par.hor_func = OPENMP_SEP_FUNC_SINGLE;
                }
              else if(opt_value.compare("transformSepOpenmp") == 0)
                {
                  this->openmp_sep_par.hor_func = OPENMP_SEP_FUNC_OPENMP;
                }
              else if(opt_value.compare("transformSepOpenmpCopy") == 0)
                {
                  this->openmp_sep_par.hor_func = OPENMP_SEP_FUNC_OPENMP_COPY;
                }
              else if(opt_value.compare("transformSepOpenmpSimd") == 0)
                {
                  this->openmp_sep_par.hor_func = OPENMP_SEP_FUNC_OPENMP_SIMD;
                }
              else if(opt_value.compare("transformSepOpenmpCopySimd") == 0)
                {
                  this->openmp_sep_par.hor_func = OPENMP_SEP_FUNC_OPENMP_COPY_SIMD;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Wrong value of parameter \"hor-func\".\n";
                }
            break;
            case 29:
              if(opt_value.compare("transformSepSingle") == 0)
                {
                  this->openmp_sep_par.vert_func = OPENMP_SEP_FUNC_SINGLE;
                }
              else if(opt_value.compare("transformSepOpenmp") == 0)
                {
                  this->openmp_sep_par.vert_func = OPENMP_SEP_FUNC_OPENMP;
                }
              else if(opt_value.compare("transformSepOpenmpCopy") == 0)
                {
                  this->openmp_sep_par.vert_func = OPENMP_SEP_FUNC_OPENMP_COPY;
                }
              else if(opt_value.compare("transformSepOpenmpSimd") == 0)
                {
                  this->openmp_sep_par.vert_func = OPENMP_SEP_FUNC_OPENMP_SIMD;
                }
              else if(opt_value.compare("transformSepOpenmpCopySimd") == 0)
                {
                  this->openmp_sep_par.vert_func = OPENMP_SEP_FUNC_OPENMP_COPY_SIMD;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Wrong value of parameter \"vert-func\".\n";
                }
            break;
            case 30:
              this->opencl_comb_par.interlaced = true;
              this->opencl_sep_par.interlaced = true;
			        this->openmp_sep_par.interlaced = true;
            break;
			      case 31:
				      ival = atoi(opt_value.c_str());
				      if(ival < 1)
				        {
					        if(error != NULL) *error << "Warning: Parameter \"depth\" is out of range. Right range is <1,inf>.\n";
				        }
				      else
				        {
					        this->opencl_comb_par.max_depth = ival;
					        this->opencl_sep_par.max_depth = ival;
					        this->openmp_sep_par.max_depth = ival;
				        }
            break;
            case 32:
              if(opt_value.compare("CDF53") == 0)
                {
                  this->opencl_comb_par.wavelet = WAVELET_TYPE_CDF53;
                  this->opencl_sep_par.wavelet = WAVELET_TYPE_CDF53;
                  this->openmp_sep_par.wavelet = WAVELET_TYPE_CDF53;
                }
              else if(opt_value.compare("CDF97") == 0)
                {
                  this->opencl_comb_par.wavelet = WAVELET_TYPE_CDF97;
                  this->opencl_sep_par.wavelet = WAVELET_TYPE_CDF97;
                  this->openmp_sep_par.wavelet = WAVELET_TYPE_CDF97;
                }
              else if(opt_value.compare("CDF137") == 0)
                {
                  this->opencl_comb_par.wavelet = WAVELET_TYPE_CDF137;
                  this->opencl_sep_par.wavelet = WAVELET_TYPE_CDF137;
                  this->openmp_sep_par.wavelet = WAVELET_TYPE_CDF137;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Unknown type of parameter \"wavelet-type\". Supported types are (CDF53|CDF97|CDF137).\n";
                }
			      break;
            case 33:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 50000))
              {
                if(error != NULL) *error << "Warning: Parameter \"resize-x\" is out of range. Right range is <1,50000>.\n";
              }
              else
              {
                this->openmp_sep_par.scaled_image_size.x = ival;
                this->opencl_sep_par.scaled_image_size.x = ival;
                this->opencl_comb_par.scaled_image_size.x = ival;
              }
            break;
            case 34:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 50000))
              {
                if(error != NULL) *error << "Warning: Parameter \"resize-y\" is out of range. Right range is <1,50000>.\n";
              }
              else
              {
                this->openmp_sep_par.scaled_image_size.y = ival;
                this->opencl_sep_par.scaled_image_size.y = ival;
                this->opencl_comb_par.scaled_image_size.y = ival;
              }
              break;
            case 35:
              ival = atoi(opt_value.c_str());
              if((ival < 0) || (ival > 5000))
              {
                if(error != NULL) *error << "Warning: Parameter \"subdevice-size\" is out of range. Right range is <1,inf) and 0 for use of whole device.\n";
              }
              else
              {
                this->opencl_comb_par.subdevice_size = ival;
                this->opencl_sep_par.subdevice_size = ival;
              }
              break;
            case 36:
              if(opt_value.compare("texture") == 0)
                {
                  this->opencl_comb_par.image_mem_type = OPENCL_MEM_TYPE_TEXTURE;
                  this->opencl_sep_par.image_mem_type = OPENCL_MEM_TYPE_TEXTURE;
                }
              else if(opt_value.compare("global") == 0)
                {
                  this->opencl_comb_par.image_mem_type = OPENCL_MEM_TYPE_GLOBAL;
                  this->opencl_sep_par.image_mem_type = OPENCL_MEM_TYPE_GLOBAL;
                }
              else
                {
                  if(error != NULL) *error << "Warning: Unknown type of parameter \"image-mem\". Supported types are (global|texture).\n";
                }
			      break;
            case 37:
              this->opencl_comb_par.double_buffering = false;
              this->opencl_sep_par.double_buffering = false;
			      break;
            case 38:
              ival = atoi(opt_value.c_str());
              if((ival < 1) || (ival > 5000))
              {
                if(error != NULL) *error << "Warning: Parameter \"repeat-count\" is out of range. Right range is <0,inf).\n";
              }
              else
              {
                this->opencl_comb_par.repeat_count = ival;
                this->opencl_sep_par.repeat_count = ival;
              }
            break;
            case 39:
              this->opencl_comb_par.memless_exec = true;
              this->opencl_sep_par.memless_exec = true;
              this->memless_exec = true;
            break;
						case PARSE_ARG_NOT_FOUND:
							if(error != NULL) *error << "Warning: Parameter \"" << argv[i] << "\" not found.\n";
					}
			}
    if(this->memless_exec)
      {
        this->opencl_comb_par.benchmark_proc = true;
        this->opencl_sep_par.benchmark_proc = true;
        this->benchmark_proc = true;
      }
    if(this->benchmark_proc && (!this->opencl_comb_par.scaled_image_size.isValid()))
      {
        if(error != NULL) *error << "Warning: Calculation without input cannot be used without set parameters resize-x and resize-y.\n";
        return false;
      }
		if(type_count > 1)
			{
				if(error != NULL) *error << "Warning: Cannot have more than 1 device type specifiers. Uses last one.\n";
			}
    if((this->in_file.length() == 0) && (!this->cam_use) && (!this->print_devices) && (!this->benchmark_proc))
      {
        if(error != NULL) *error << "Warning: No input file or camera specified. Default camera used.\n";
        this->cam_use = true;
        this->in_file = "0";
      }
    return true;
  }
