#ifndef IMAGE_READER_H
#define IMAGE_READER_H

#include <iostream>
#include <string>
#include <sstream>

#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>

#include "FileReaderInterface.h"
#include "Debug.h"

/**
 * @brief Video getting class
 */
class ImageReader:public FileReaderInterface
{
public:
  /**
   * Initialize object and register ffmpeg codec.
   */
	ImageReader();
  /**
   * Initialize object, register ffmpeg codec and open video file.
   * @param v_file video file path
   * @param width width of loaded video or 0 if fail
   * @param height height of loaded video or 0 if fail
   * @param error optional string to write error
   */
	ImageReader(std::string &v_file, int &width, int &height, bool repeat, std::stringstream *error = NULL);
  /**
   * Close video file if opened.
   */
	~ImageReader();
  /**
   * Return file open state.
   * @return file open state
   */
	bool isOpen();
  bool isReady();
  /**
   * Open video file.
   * @param v_file video file path
   * @param width width of loaded video or 0 if fail
   * @param height height of loaded video or 0 if fail
   * @param error optional string to write error
   * @return success of open file
   */
	bool openFile(std::string &v_file, int &width, int &height, bool repeat, std::stringstream *error = NULL);
  /**
   * Close video file if opened.
   */
	void closeFile();
  /**
   * Get next frame.
   * @param bgra_frame output frame
   * @param error optional string to write error
   * @return true if return regular frame or false if reach end of file
   */
  bool setFramePos(unsigned int frame_pos);
	bool getFrame(void **bgra_out_frame, std::stringstream *error = NULL);
private:
  /**
   * Initialize object and register ffmpeg codec.
   */
  void init();

	std::string v_file; ///< video file path
	bool open; ///< true if opened
  bool first;
  bool repeat;
  cv::Mat bgra_frame;
  cv::Mat bgr_frame;
};

#endif

