#ifndef THREADS_H
#define THREADS_H

#include "transform.h"

/**
 * @brief Get maximum number of threads suitable for and available on given platform.
 */
int threads_get_total_threads();

/**
 * @brief Suggest the maximum number of threads for the transform level.
 */
int threads_suggest_transform_threads(
	struct transform_t *transform
);

/**
 * @brief Get thread's ID.
 *
 * @note Gets zero if no threads are used.
 */
int threads_get_thread_id();

/**
 * @brief Explicit barrier.
 */
void threads_barrier();

#endif
