#include "threads.h"
#include "system.h"
#ifdef _OPENMP
	#include <omp.h>
#endif

int threads_get_total_threads()
{
#ifdef _OPENMP
	return omp_get_max_threads();
#else
	return 1;
#endif
}

// TODO: spin off 'threads = threads_get_total_threads()' as an argument; then, move into 'transform.c'
int threads_suggest_transform_threads(
	struct transform_t *transform
)
{
	assert( transform );

	int threads = threads_get_total_threads();

	while(1)
	{
		const int segment_x = ceil_codeblock(ceil_div(transform->super.x, threads), transform->cb_exp.x);

		const int segment_start_x = transform->tc0_cb.x + (threads-1)*segment_x;

		if( segment_start_x >= transform->tc1_cb.x )
			threads--;
		else
			break;
	}

	assert( threads > 0 );

	return threads;
}

void threads_barrier()
{
#ifdef _OPENMP
	#pragma omp barrier
#endif
}

int threads_get_thread_id()
{
#ifdef _OPENMP
	return omp_get_thread_num();
#else
	return 0;
#endif
}
