#ifndef SYSTEM_H
#define SYSTEM_H

#include <stdio.h>

/**
 * @brief Set debug mode for the purposes of logging or diagnostics.
 */
void system_setup_debug();

/**
 * @brief Crash the application.
 */
void system_crash();

int system_check_bug1();
int system_check_bug2();
int system_check_bug3();

/** like NULL pointer, except the zero */
#define VALID ((void *)1)

/** unused argument */
#define UNUSED(expr) do { (void)(expr); } while (0)

/** unused function */
#ifdef __GNUC__
	#define UNUSED_FUNCTION __attribute__ ((unused))
#else
	#define UNUSED_FUNCTION
#endif

/** debug printf */
#ifndef NDEBUG
	#define dprintf(...) printf("[ DEBUG ] " __VA_ARGS__)
#else
	#define dprintf(...) (void)0
#endif

#endif

#ifdef NDEBUG

#define BARRIER_DEFINE(name) enum { GUPEJIOPSCQLFUNI }
#define BARRIER_INIT(name, threads)
#define BARRIER_WAIT(name)
#define BARRIER_DESTROY(name)

#else /* NDEBUG */

#include <pthread.h>
#include <stdlib.h>

#define BARRIER_DEFINE(name) pthread_barrier_t barrier

#define BARRIER_INIT(name, threads) \
do { \
	if( pthread_barrier_init(&(name), NULL, (threads)) ) \
	{ \
		printf("Could not create a barrier\n"); \
		abort(); \
	} \
} while(0)

#define BARRIER_WAIT(name) \
do { \
	int rc = pthread_barrier_wait(&(name)); \
	if( rc != 0 && rc != PTHREAD_BARRIER_SERIAL_THREAD ) \
	{ \
		printf("Could not wait on barrier\n"); \
		abort(); \
	} \
} while(0)

#define BARRIER_DESTROY(name) \
do { \
	pthread_barrier_destroy(&(name)); \
} while(0)

#endif /* NDEBUG */
