#include "core8x8.h"

/// disable AVX instruction set (if it was available)
// #define CONFIG_CORE_DISABLE_AVX

/// disable SSE instruction set (if it was available)
// #define CONFIG_CORE_DISABLE_SSE

/// disable DWT core, perform only data copy (currently, only affects SSE)
// #define CONFIG_CORE_DISABLE_DWT

#define CDF97_P1_S (-1.586134342059924f)
#define CDF97_U1_S (-0.052980118572961f)
#define CDF97_P2_S (+0.882911075530934f)
#define CDF97_U2_S (+0.443506852043971f)
#define CDF97_S1_S (+1.513328328400963f)
#define CDF97_S2_S (+0.660795136939407f)

#if   defined(__AVX__) && !defined(CONFIG_CORE_DISABLE_AVX)
#	pragma message( "Compiling AVX" )
#	include "core8x8avx.c"
#elif defined(__SSE__) && !defined(CONFIG_CORE_DISABLE_SSE)
#	pragma message( "Compiling SSE" )
#	include "core8x8sse.c"
#else
#	pragma message( "Compiling FPU" )
#	include "core8x8fpu.c"
#endif
