#include "timer.h"
#include "vec2.h"
#include "imageptr.h"
#include "range2.h"
#include "transform.h"
#include "system.h"
#include "plot.h"
#include <stdio.h>
#include <stdlib.h>

int main()
{
	system_setup_debug();

	const int MAX = 1000;

	const int N = 8;

	const struct vec2_t cb_exp = { 6, 6 };

	for(int i = 0; i < MAX; i++)
	{
		const struct vec2_t tc0 = { rand()%256, rand()%256 };
		const struct vec2_t size = { (1<<N)+rand()%4096, (1<<N)+rand()%4096 };
		const struct vec2_t tc1 = vec2_add(tc0, size);

		printf("(allocated) pass %4i/%i: tc0=(%i,%i) size=(%i,%i)\n", i, MAX, tc0.x, tc0.y, size.x, size.y);

		struct imageptr_t *imageptr = imageptr_create_sparse(size);

		imageptr_fill(imageptr, size);

		if( transform_process_tile(tc0, tc1, cb_exp, N, imageptr) )
			return -1;

		imageptr_destroy_sparse(imageptr, size);
	}

	return 0;
}
