#include "timer.h"
#include "vec2.h"
#include "imageptr.h"
#include "range2.h"
#include "transform.h"
#include "system.h"
#include "plot.h"
#include <stdio.h>
#include <math.h>

int main()
{
	system_setup_debug();

	const int MAX = 1000;

	const int N = 8;

	const struct vec2_t cb_exp = { 6, 6 };

	const struct vec2_t tc0 = { 5, 128 };
// 	const struct vec2_t size = { 1920, 1080 };
// 	const struct vec2_t size = { 4096, 2160 };
	const struct vec2_t size = { 7680, 4320 };
// 	const struct vec2_t size = { 1<<16, 1<<16 };
// 	const struct vec2_t size = { 1000000, 1000000 };
// 	const struct vec2_t size = { 4920, 12840 };
	const struct vec2_t tc1 = vec2_add(tc0, size);

	double min_time = +INFINITY;

	for(int i = 0; i < MAX; i++)
	{
		struct imageptr_t *imageptr = imageptr_create_sparse(size);

		imageptr_fill(imageptr, size);

		int64_t clocks = -timer_get_clock();

		if( transform_process_tile(tc0, tc1, cb_exp, N, imageptr) )
			return -1;

		clocks += timer_get_clock();

		double time = timer_clock_to_nsec_pel(clocks, size.x*size.y);

		if( time < min_time )
			min_time = time;

		printf("(allocated) pass %4i/%i: elapsed %f nsecs/pel (minimum %f nsecs/pel)\n", i, MAX, time, min_time);

		imageptr_destroy_sparse(imageptr, size);
	}

	return 0;
}
