#include "timer.h"
#include "vec2.h"
#include "imageptr.h"
#include "range2.h"
#include "transform.h"
#include "system.h"
#include "plot.h"
#include <stdio.h>

void callback_save_pgm(void *params, const struct codeblock_t *codeblock)
{
	UNUSED(params);

#ifdef CONFIG_CODEBLOCK_PARAMETERS
	if( 0 == codeblock->r )
#endif
	{
		// NOTE: codeblock->llband of size cb_size1
		const struct vec2_t c0 = convert_tc_to_next_tb_ll(codeblock->local_c0);
		const struct vec2_t c1 = convert_tc_to_next_tb_ll(codeblock->local_c1);
		const struct vec2_t size = vec2_sub(c1, c0);

		if( size.x > 0 && size.y > 0 )
		{
			imageptr_log_dump_viewport_fmt(
				codeblock->llband,
				c0,
				size,
				"codeblocks/cb_n%i_x%i_y%i_LL_viewport.pgm",
				codeblock->n,
				codeblock->tr.x,
				codeblock->tr.y
			);
		}
	}

	{
		// NOTE: codeblock->hlband of size cb_size1
		const struct vec2_t c0 = convert_tc_to_next_tb_hl(codeblock->local_c0);
		const struct vec2_t c1 = convert_tc_to_next_tb_hl(codeblock->local_c1);
		const struct vec2_t size = vec2_sub(c1, c0);

		if( size.x > 0 && size.y > 0 )
		{
			imageptr_log_dump_viewport_fmt(
				codeblock->hlband,
				c0,
				size,
				"codeblocks/cb_n%i_x%i_y%i_HL_viewport.pgm",
				codeblock->n,
				codeblock->tr.x,
				codeblock->tr.y
			);
		}
	}

	{
		// NOTE: codeblock->lhband of size cb_size1
		const struct vec2_t c0 = convert_tc_to_next_tb_lh(codeblock->local_c0);
		const struct vec2_t c1 = convert_tc_to_next_tb_lh(codeblock->local_c1);
		const struct vec2_t size = vec2_sub(c1, c0);

		if( size.x > 0 && size.y > 0 )
		{
			imageptr_log_dump_viewport_fmt(
				codeblock->lhband,
				c0,
				size,
				"codeblocks/cb_n%i_x%i_y%i_LH_viewport.pgm",
				codeblock->n,
				codeblock->tr.x,
				codeblock->tr.y
			);
		}
	}

	{
		// NOTE: codeblock->hhband of size cb_size1
		const struct vec2_t c0 =  convert_tc_to_next_tb_hh(codeblock->local_c0);
		const struct vec2_t c1 =  convert_tc_to_next_tb_hh(codeblock->local_c1);
		const struct vec2_t size = vec2_sub(c1, c0);

		if( size.x > 0 && size.y > 0 )
		{
			imageptr_log_dump_viewport_fmt(
				codeblock->hhband,
				c0,
				size,
				"codeblocks/cb_n%i_x%i_y%i_HH_viewport.pgm",
				codeblock->n,
				codeblock->tr.x,
				codeblock->tr.y
			);
		}
	}
}

int main()
{
	system_setup_debug();

	dprintf("coordinate format is (x,y)\n");

	const int N = 8;

	// code-blocks of the size of (2^6, 2^6)
	const struct vec2_t cb_exp = { 6, 6 };

	const struct vec2_t tc0 = { 512+5, 512+0 };
	const struct vec2_t size = { 492, 1284 };
	const struct vec2_t tc1 = vec2_add(tc0, size);

	struct imageptr_t *imageptr = imageptr_create_sparse(size);

	imageptr_fill(
		imageptr,
		size
	);

	struct transform_t *transform = transform_create(
		tc0,
		tc1,
		cb_exp,
		1,
		N,
#if 0
		 NULL,
#else
		callback_save_pgm,
#endif
		NULL
	);

	if( !transform )
		return -1;

	while( !transform_finished(transform) )
	{
		transform_prepare_strip(transform);

		transform_process_strip(
			transform,
			imageptr,
			vec2_zero
		);
	}

	transform_dump(transform);

	transform_destroy(transform);

	imageptr_destroy_sparse(imageptr, size);

	return 0;
}
