function [x,lut,ofs] = quantize(x, maxVal, b)
% Quantize values x in range (-maxVal, maxVal> to b bits.

g = (x / maxVal);
m0 = -1+1/2^(b-1); m1=1;
x(x<m0)=m0; x(x>m1)=m1;
x = int32(fix(x*(2^(b-1))));
lut = linspace(m0, m1, 2^b) * maxVal;
ofs = -2^(b-1)+1;