function dt = loadDets(fileName, zerobased)
% loadDets loads a cell array with detections stored by lbpDetect function.
%
%   dt = loadDets(filename, [zerobased])
%
% If zerobased is set to 1, image id is corrected to be 1-based.

if nargin==1, zerobased=0; end;
dt1=load(fileName,'-ascii');
if numel(dt1)==0
    dt=zeros(0,6);
    return;
end;
n = size(dt1,1); ofs = zeros(n,1);
is = find(dt1(2:end,1)-dt1(1:end-1,1) < 0);
ofs(is+1) = dt1(is)+1; ofs = cumsum(ofs);
dt1(:,1) = dt1(:,1)+ofs;
if zerobased, dt1(:,1) = dt1(:,1)+1; end;
ids=dt1(:,1); n=max(ids); dt=cell(1,n);
for i=1:n, dt{i}=dt1(ids==i,2:6); end;