function [detector,Ps,Ps1] = lbpTrainPoseRegressor(detector, varargin)

dfs = {'posVptDir','REQ','V','REQ','T',128,'gamma',0.2,'alpha',0.5,'nPos',detector.opts.nPos};
[detector.opts.posVptDir,pm.V,T,pm.gamma,pm.alpha,nPos] = getPrmDflt(varargin,dfs,1);

% Sample training data
detector.opts.nPos = nPos;
[Is,~,Ps] = sampleWins(detector,0,1); X = chnsCompute1(Is,detector.opts); inds = int32(lbp(X,detector.clf.ftr))+1;
clear Is X;

% Calc maps v from V and Ps
v = cell(1,size(Ps,2));
for i = 1:numel(v), v{i} = probMap(Ps(:,i), pm.V, pm.gamma); end; v = [v{:}];

% Sample to make mean map approx. uniform

% Init pose model

pm.p0 = mean(v,2); d = size(pm.V,1);
pm.p = cell(1,T);
v = bsxfun(@minus, v, pm.p0);

TD = length(detector.clf.thr);

for t = 1:T
    pt = zeros(d,256,'single');
    for i = 1:256
        j = find(inds(:,TD-T+t)==i);
        map = pm.alpha * bsxfun(@rdivide, sum(v(:,j),2), length(j)+1);
        v(:,j) = bsxfun(@minus, v(:,j), map);
        pt(:,i) = map;
    end
    pm.p{t} = pt;
    pm.loss(t) = mean(v(:).^2);
end

detector.pm = pm;

% Calc training err
maps = repmat(pm.p0, 1, size(inds,1));
for t = 1:T
    is = inds(:,TD-T+t);
    maps = maps+pm.p{t}(:,is);
end
[~,is] = max(maps);
Ps1 = pm.V(is,:)';

end

function p = probMap(v, S, A)
K = @(x)exp(-0.5*(x./A).^2); % gaussian kernel
sim = S * v;
[~,i] = max(sim);
v = S(i,:);
p = K(real(acos(S * v')));
end


function chns = chnsCompute1( Is, opts )
% Compute single scale channels of dimensions modelDsPad.
if(isempty(Is)), chns=[]; return; end
fprintf('Extracting features... '); start=clock; fs=opts.filters;
pChns=opts.pPyramid.pChns; smooth=opts.pPyramid.smooth;
dsTar=opts.modelDsPad/pChns.shrink; ds=size(Is); ds(1:end-1)=1;
Is=squeeze(mat2cell2(Is,ds)); n=length(Is); chns=cell(1,n);
parfor i=1:n
  C=chnsCompute(Is{i},pChns); C=convTri(cat(3,C.data{:}),smooth);
  if(~isempty(fs)), C=repmat(C,[1 1 size(fs,4)]);
    for j=1:size(C,3), C(:,:,j)=conv2(C(:,:,j),fs(:,:,j),'same'); end; end
  if(~isempty(fs)), C=imResample(C,.5); shr=2; else shr=1; end
  ds=size(C); cr=ds(1:2)-dsTar/shr; s=floor(cr/2)+1; e=ceil(cr/2);
  C=C(s(1):end-e(1),s(2):end-e(2),:); chns{i}=C;
end; chns=cat(4,chns{:});
fprintf('done (time=%.0fs).\n',etime(clock,start));
end