//
// $Id: nms.cpp 96 2014-12-15 15:29:23Z ijuranek $
//

#include <vector>
#include <tuple>
#include <opencv2/opencv.hpp>
#include "nms.h"

using namespace std;
using namespace cv;

// Overlap of two rectangles
float rectOverlap(const Rect & a, const Rect & b, bool useMin = false)
{
    int x0 = max(a.x, b.x);
    int x1 = min(a.x+a.width, b.x+b.width);
    int y0 = max(a.y, b.y);
    int y1 = min(a.y+a.height, b.y+b.height);
    if (x0 >= x1 || y0 >= y1) return 0.f;
    float area = (x1 - x0) * (y1 - y0);
    float u;
    if (useMin)
        u = min((a.width * a.height),(b.width * b.height));
    else
        u = (a.width * a.height) + (b.width * b.height) - area;
    return area / u;
}

// Non-Maxima suppression of rectangles
void nmsMax(vector<Rect> & rects, vector<float> & hs, float ovr, int minGroup)
{
    int N = rects.size();
    vector<bool> suppress(N, false);
    vector<int> gsize(N, 1);

    // Sort hs and get order
    vector<int> index(N);
    for (int i = 0; i < N; ++i) index[i] = i;
    // Sorting index vector but comparing values in hs
    sort(begin(index), end(index), [&hs](int u, int v)->bool {return hs[u]>hs[v];});

    // Suppress (add to group i) each j>i which was not already suppressed, and overlap(i,j)>ovr
    for (int _i = 0; _i < N-1; ++_i)
    {
        int i = index[_i];
        for (int _j = _i+1; _j < N; ++_j)
        {
            int j = index[_j];
            if (suppress[j]) continue;
            if (rectOverlap(rects[i], rects[j]) > ovr)
            {
                suppress[j] = true;
                gsize[i]++;
            }
        }
    }

    vector<Rect> nmsRects;
    vector<float> nmsHs;

    for (int i = 0; i < N; ++i)
        if (!suppress[i] && gsize[i] >= minGroup)
        {
            nmsRects.push_back(rects[i]);
            nmsHs.push_back(hs[i]);
        }

    rects = nmsRects;
    hs = nmsHs;
}
