/*
 * This demo show minimal code for detecting objects in image
 * with LBPDetector API in single scale without non-maxima suppression.
 */

#include <iostream>
#include "common.h"
#include "lbpdetector.h"

// Hardcoded detector
const int len = 10; 
const int sz[2] = {24, 24};
unsigned char ftrs[5*len] = {};
float thrs[len] = {};
float hs[256*len] = {};

// Hardcoded image
const int imsz[2] = {32, 32};
float imgdata[32*32] = {};

using namespace std;
using namespace LBPDetector;

int main()
{
    // Initialize detector from constants
    Detector * D = createDetector(sz[0], sz[1], len, ftrs, hs, -1);
    
    // Initialize image - we have hardcoded array in imgdata
    Image im(imgdata, imsz[0], imsz[1]);

    // Scan image with detector
    ScalarResult res = scalarScanImage(im, 0, 0, im.dims[0]-D->wdim0, im.dims[1]-D->wdim1, 1, *D, 1, false);

    // res contains list of detected objects
    for (size_t i = 0; i < res.bbs.size(); ++i)
    {
        // Access results and print
        BB & b = res.bbs[i]; float h = res.hs[i];
        cout << '[' << b.x << ',' << b.y << ',' << b.width << ',' << b.height << ',' << h << ']' << endl;
    }

    return 0;
}