#include <memory>
#include "lbpdetector_cv.h"
#include "detector.h"
#include "opencv2/opencv.hpp"
#include <json/json.h>
#include <iostream>
#include <chrono>
#include <thread>

using namespace std;
using namespace cv;
using namespace LBPDetector;

int main(int argc, char** argv)
{
    // TODO: process options
    //using namespace std::literals;
    VideoCapture cap(argv[1]);
    if(!cap.isOpened()) return -1;


    LBPDetector::Detector * D = loadDetectorFromFile(argv[2]);
    LBPDetector::ChnsParams C = loadChnsParamsFromFile(argv[2]);
    
    Json::FastWriter writer;

    int f = 0;
    for(;;++f)
    {
        Mat frame;
        cap >> frame; // get a new frame
        if (!frame.data) break;
        
        double timestamp = cap.get(CV_CAP_PROP_POS_MSEC);

        Detections dets = lbpDetectImage(frame, D, C, 10, 2, 2); // TODO: pass params

        Json::Value lst;
        lst["nFtrs"] = dets.nf;
        lst["nWins"] = dets.ns;
        lst["frame"] = f;
        lst["timestamp"] = timestamp;
        Json::Value objs(Json::arrayValue);
        for (size_t j = 0; j < dets.bbs.size(); ++j)
        {
            cv::Rect & bb = dets.bbs[j]; float h = dets.hs[j];
            Json::Value bb1(Json::arrayValue);
            bb1.append(bb.x);
            bb1.append(bb.y);
            bb1.append(bb.width);
            bb1.append(bb.height);
            bb1.append(h);
            objs.append(bb1);
        }
        lst["bbs"] = objs;
        cout << writer.write(lst);

/*
        for (auto bb:dets.bbs)
        {

            rectangle(frame, Point(bb.x,bb.y), Point((bb.x+bb.width), (bb.y+bb.height)),Scalar(0,255,0),3);
            rectangle(frame, Point(bb.x,bb.y), Point((bb.x+bb.width), (bb.y+bb.height)),0,2);
        }      
        //imshow("im", frame); waitKey(1);
        */

        this_thread::sleep_for(std::chrono::seconds(1)); 
        
    }

    return 0;
}