LBPDetector is built upon Piotr's Toolbox and shares its codebase. Here is what I think is missing the toolbox. Those are not actual TODOs but more like wishlist.

## Load samples form mat-file

Currently, `lbpTrain` and `acfTrain` loads positive samples by cropping training images using ground truth annotations. This is very time consuming when large number of samples need to be loaded. When we want to train several detectors with the same data, the same operation (image cropping) must be repeated multiple times.

The `sampleWins` function can load already cropped images from `opts.posWinDir` or `pos.negWinDir`, however this requires all the images to be stored in separate files which can cause high load of filesystem (espetially when we load data from network). More effecient way would be to store the cropped images in one mat-file like the one created when `opts.winsSave` option is enabled.

But, when I think about it now, this is not as important as I thought it was.

## Discrete (quantized) weak hypotheses

While floating point responses are good for PC, some architectures (ARM, FPGA) implementing detection can benefit from integer responses. With only slight loss of accuracy this can be implemented by scaling and quantization of hs to a given number of bits. Also `cascCal` and `cascThr` values must be quantized.

## HOG+LUV channels are not always the best choice

Although HOG+LUV (+LDCF) can provide state of the art results, it may not be the best choice because of speed etc. LDCF calculates several NxNx1 filters over each shrinked channel and additionaly shrinks the result by factor of 2. For HOG+LUV and 4 filters this makes resulting image with *40* channels!

I think that NxNxC filters calculated over all channels (or directly from RGB?) _prior_ to shrinking would be better. However, it is not clear now how to train the filters. This somehow resemples simple convolutional network.