# Version 1.00

* First release
* Training, testing code derived from [Piotr's Toolbox](https://github.com/pdollar/toolbox)
* LBP features
* Detector app that can run without MATLAB

# Version 1.01

* Mostly changes in cpp code
* Detector binary structure changed to [Protocol Buffers](https://github.com/google/protobuf)
  * Actually it is very similar to previous .bin format except that it is easily extensible now.
  * [`binwrite`](cpp/mexBinWrite.cpp) implemented as mex
* Detectors support smoothink and shrinking (but still only grayscale channel)
* Video detection app ['detect_lbp_video'](cpp/detect_lbp_video.cpp) works
* [Minimal demo](cpp/minimal.cpp) - detection without dependencies on external libs
* [`detect_lbp`](cpp/detect_lbp.cpp):
  * Output uses [jsoncpp](https://github.com/open-source-parsers/jsoncpp) library instead of ad-hoc pritnting.
  * `--nocache` option to disable LBP caching
  * `-l` option fo specifying file list
  * Removed some options (which are now embedded in the detector structure)
* LBP rewritten to mex - great speedup!
* [`lbpTrain`](lbpTrain.m):
  * `opts.pBoost.pLBP.fracFtrs` - fraction of LBPs to optimize in each round.
  * `opts.pBoost.pLBP.nThreads` - threads used to accumulate LBP weights
* [`jsontool`](cpp/jsontool.cpp) for conversion of JSON output to CSV
* Number of fixes in core and matlab code

# Version 1.02

* Thresholds are now constant (same as in ACF)
* Dropped support of legacy detectors (xmlread). Still can write xmls.
* Added Profiler module
* ThreadPool is now submodule (use -recursive when cloning!)

# master branch

* 