function xmlwrite(detector, fileName)
% Write detector in legacy XML format (compatible with BUT WaldBoost training tool).
%
% TODO:
% * Add a section with supplementary information - about shrinking, model size, etc...

% Check detector if it is compatible
if ~lbpdetector.iscompatible(detector), error('The detector is not compatible!'); end;
% Transform parameters to correct format
detector = transpose(detector,0); % private version of transpose
% Build XML structure
doc = com.mathworks.xml.XMLUtils.createDocument('ROOT');
root = doc.getDocumentElement;
root.appendChild(doc.createComment('Exported by LBPDetector Toolbox'));
cls = doc.createElement('WaldBoostClassifier');
cls.setAttribute('imageSizeX', num2str(detector.clf.size(2)));
cls.setAttribute('imageSizeY', num2str(detector.clf.size(1)));
for t = 1:length(detector.clf.thr)
    stage = doc.createElement('stage');
    stage.setAttribute('negT', num2str(detector.opts.cascThr));
    stage.setAttribute('posT', num2str(inf));
    wh = doc.createElement('HistogramWeakHypothesis');
    wh.setAttribute('predictionValues', num2str(detector.clf.hs(:,t)','%.6f '));
    ftr = doc.createElement('LBPFeature');
    ftr.setAttribute('positionX', num2str(detector.clf.ftr(1,t)));
    ftr.setAttribute('positionY', num2str(detector.clf.ftr(2,t)));
    ftr.setAttribute('blockWidth', num2str(detector.clf.ftr(3,t)));
    ftr.setAttribute('blockHeight', num2str(detector.clf.ftr(4,t))); 
    wh.appendChild(ftr);
    stage.appendChild(wh);
    cls.appendChild(stage);
end
root.appendChild(cls);
% Serialize and write XML file
xmlwrite(fileName, doc);
