function sz = size(detector)
% Get size of detector sliding window from detector structure or training options.
%
% 	sz = size(detector);
%

if isfield(detector,'opts'), opts=detector.opts; else opts=detector; end
sz = opts.modelDsPad / opts.pPyramid.pChns.shrink;
C = chnsCompute([],opts.pPyramid.pChns); cs = sum([C.info.nChns]);
if ~isempty(opts.filters)
    sz = sz/2;
    if isvector(opts.filters), cs = cs*opts.filters(2);
    else cs = cs*size(opts.filters,4); end;
end;
sz = uint32([sz cs]);
