function F = feature_params(sz,M,N,M1,N1,K)
% Generate parameters of LBP features
%
%   F = LBPFEATURES(sz, [M], [N], [M1], [N1], [K]);
%
% By default, the function generates exhaustive set of
% features in the given window size;
%
% Input:
%   sz      [1x3] vector with window size [height, width, channels]
%   M,N     Rows, cols
%   M1,N1   Sizes along rows and cols
%   K       Channels
%
% Output:
%   F   [5xK] matrix with feature parameters [m,n,m1,n1,k]'
sz = double(sz);
if ~exist('M','var') || isempty(M), M=0:sz(1)-1; end;
if ~exist('N','var') || isempty(N), N=0:sz(2)-1; end;
if ~exist('M1','var') || isempty(M1), M1=M; end;
if ~exist('N1','var') || isempty(N1), N1=N; end;
if ~exist('K','var') || isempty(K), K=0:sz(3)-1; end;

% ndgrid of parameters
[m,n,m1,n1,k] = ndgrid(M,N,M1,N1,K);
F = [m(:),n(:),m1(:),n1(:),k(:)]';
% Check for invalid ftrs outisde the window size
m2=m+(3*m1-1); n2=n+(3*n1-1);
F(:,m2>=sz(1) | n2>=sz(2) | k >= sz(3)) = [];
F = uint8(F);