function c = iscompatible(detector, silent)
% ISCOMPATIBLE returns true when the detector can be used in C++ API.
%
%   valid = iscompatible(detector, [silent])
%
% Check basic parameters of the detector and returns true is it can be
% exported to .bin file and used by C++ detector API. See comments in code
% for details.

struct_ok = lbpdetector.check(detector);
sz = lbpdetector.size(detector);
opts = detector.opts;
P = opts.pPyramid;
detector_features = ...
    [isempty(detector.opts.filters), ...   % Must not contain filters
    sz(3) == 1, ...                       % Only one channel in features
    P.pChns.pColor.enabled, strcmpi(P.pChns.pColor.colorSpace, 'gray'), ... % The only channel is grascale
    P.pChns.pGradMag.enabled == 0, P.pChns.pGradHist.enabled == 0, isempty(P.pChns.pCustom)]; % HOG and custom channels are not supported
c = struct_ok && all(detector_features);
if nargin == 1, silent = 0; end;
if ~c && ~silent
    fs = {'Detector contains filters',...
          'Features indexes more than one channel',...
          'Color channel is not enabled',...
          'Colorspace is not gray',...
          'Gradient channel is enabled',...
          'HOG channels are enabled',...
          'There are custom channels'
          };
    for i = find(~detector_features), disp(fs{i}); end;
end

