function I = coverage(detector)
% Get detector attention matrix.
% 
%	I = coverage(detector)
%
% Each feature occupy a rectangle in the detector scanning window.
% The function accumulates rectangles defined by the features in detector.
%
% Output:
% 	I 	[MxNxC] matrix with accumulated LBP areas.

I = zeros(lbpdetector.size(detector));
f = detector.clf.ftr;
for i = 1:size(f,2);
    g = f(:,i);
    I(g(1)+1:g(1)+3*g(3),g(2)+1:g(2)+3*g(4),g(5)+1) = I(g(1)+1:g(1)+3*g(3),g(2)+1:g(2)+3*g(4),g(5)+1) + 1;
end