function compile
% Compile internal functions of LBPDetector.
disp('Compiling LBPDetector Toolbox...');
% Determine installation of LBPDetector
[path] = fileparts(which('lbpDetect'));
srcpath = fullfile(path,'cpp');
incpath = ['-I ' fullfile(path,'cpp') ' -I ' fullfile(path,'external/ThreadPool') ' -I ' fullfile(path,'external/Pofiler/include') ' -I /usr/local/include'];
% GO!
CXXFLAGS = ['CXXFLAGS=$CXXFLAGS -funroll-loops -std=c++11 -pthread ' incpath];
OPTFLAGS = 'CXXOPTIMFLAGS=-O3 -DNDEBUG';
DBGFLAGS = 'CXXDEBUGFLAGS=';
LIBFLAGS = 'CXXLIBS=$CXXLIBS -L /usr/local/lib -lprotobuf -lpthread';

mex('-silent', ...
    fullfile(srcpath,'mexLBPDetect.cpp'), ...
    fullfile(srcpath,'lbpdetector.cpp'), ...
    '-compatibleArrayDims', CXXFLAGS, OPTFLAGS, DBGFLAGS, '-outdir', fullfile(path, 'private'));

mex('-v', ...
    fullfile(srcpath,'mexBinWrite.cpp'), ...
    fullfile(srcpath,'detector.pb.cc'), ...
    '-compatibleArrayDims', CXXFLAGS, OPTFLAGS, DBGFLAGS, LIBFLAGS, '-outdir', fullfile(path, '+lbpdetector', 'private'));

mex('-v', ...
    fullfile(srcpath,'mexAccumWeights.cpp'), ...
    '-compatibleArrayDims', CXXFLAGS, OPTFLAGS, DBGFLAGS, LIBFLAGS, '-outdir', fullfile(path,'private'));

mex('-v', ...
    fullfile(srcpath,'mexLBP.cpp'), ...
    fullfile(srcpath,'lbpdetector.cpp'), ...
    '-compatibleArrayDims', CXXFLAGS, OPTFLAGS, DBGFLAGS, LIBFLAGS, '-outdir', fullfile(path,'private'));

disp('Done');