function binwrite(fileName, detector, label)
% BINWRITE exports a valid LBP detector to a binary file compatible with C++ API.
%
%   binwrite(fileName, detector, [label]);

if nargin<3, label=''; end;

if ~lbpdetector.iscompatible(detector,false), error('Invalid detector'); end;

detector = lbpdetector.transpose(detector);

colorSmooth = detector.opts.pPyramid.pChns.pColor.smooth;
shrink = detector.opts.pPyramid.pChns.shrink;
pyrSmooth = detector.opts.pPyramid.smooth;
cascThr = detector.opts.cascThr;

mexBinWrite(detector.clf, shrink, colorSmooth, pyrSmooth, cascThr, label, fileName);
