from mininet.topo import Topo

class ProbeDown(Topo):
    def __init__(self):
        "Create P2P topology."

        # Initialize topology
        Topo.__init__(self)

        # Add hosts and switches
        h1 = self.addHost('h1', ip='10.0.0.1/24')
        h2 = self.addHost('h2', ip='10.0.0.2/24')
        h3 = self.addHost('h3', ip='10.0.0.3/24')
        h4 = self.addHost('h4', ip='10.0.0.4/24')
        h5 = self.addHost('h5', ip='10.0.0.5/24')
        h6 = self.addHost('h6', ip='10.0.0.6/24')
        
        h52 = self.addHost('h52', ip='10.0.0.52/24')
        h62 = self.addHost('h62', ip='10.0.0.62/24')
        
        s1 = self.addSwitch('s1')
        s2 = self.addSwitch('s2')
        s3 = self.addSwitch('s3')
        s4 = self.addSwitch('s4')
        s5 = self.addSwitch('s5')
        s6 = self.addSwitch('s6')
        

        # Add links
        self.addLink(h1, s1)
        self.addLink(h2, s1)
        self.addLink(h3, s1)
        self.addLink(h4, s2)
        self.addLink(h5, s2)
        self.addLink(h6, s2)
        
        self.addLink(s1, s2)
        self.addLink(s1, s3)
        self.addLink(s1, s4)
        self.addLink(s2, s3)
        self.addLink(s2, s4)
        self.addLink(s3, s4)
        
        self.addLink(s3, s5)
        self.addLink(s3, s6)
        #self.addLink(s4, s5)
        self.addLink(s4, s6)
        
        self.addLink(h52, s5)
        self.addLink(h62, s6)
        
topos = {
        'probedown': (lambda: ProbeDown())
}
