from mininet.topo import Topo

class FullMeshTopo(Topo):
    def __init__(self):
        "Create P2P topology."

        # Initialize topology
        Topo.__init__(self)

        # Add hosts and switches
        h1 = self.addHost('h1', ip='10.0.0.11/24')
        #h2 = self.addHost('h2', ip='192.168.1.92/24')
        h3 = self.addHost('h3', ip='10.0.0.13/24')
        #h4 = self.addHost('h4', ip='192.168.1.94/24')
        h5 = self.addHost('h5', ip='10.0.0.15/24')
        #h6 = self.addHost('h6', ip='192.168.1.96/24')
        h7 = self.addHost('h7', ip='10.0.0.17/24')
        #h8 = self.addHost('h8', ip='192.168.1.98/24')
        h9 = self.addHost('h9', ip='10.0.0.19/24')
        
        h36 = self.addHost('h36', ip='10.0.0.36/24')
        h46 = self.addHost('h46', ip='10.0.0.46/24')
        
        s1 = self.addSwitch('s1')
        s2 = self.addSwitch('s2')
        s3 = self.addSwitch('s3')
        s4 = self.addSwitch('s4')
        s5 = self.addSwitch('s5')
        s6 = self.addSwitch('s6')
        

        # Add links
        self.addLink(h1, s1)
        #self.addLink(h2, s1)
        self.addLink(h3, s2)
        #self.addLink(h4, s2)
        self.addLink(h5, s3)
        #self.addLink(h6, s3)
        self.addLink(h7, s4)
        #self.addLink(h8, s4)
        self.addLink(h9, s6)
        
        self.addLink(s1, s2)
        self.addLink(s2, s3)
        self.addLink(s3, s4)
        self.addLink(s4, s1)
        self.addLink(s1, s3)
        self.addLink(s2, s4)
        self.addLink(s5, s6)
        self.addLink(s1, s5)
        self.addLink(s2, s5)
        
        self.addLink(h36, s3)
        self.addLink(h46, s4)
        
topos = {
        'fullmesh': (lambda: FullMeshTopo())
}
